<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition de la classe ResultatQsrc.
 * Cet objet est requis par la mthode endCurrentEtape() de la
 * classe DoQsrc
 * Dfini les valeurs ncessaires  la fin de l'Evaluation et fourni des mthodes
 * de d'initialisation et de vrification de ces valeurs.
 * 
 * @package qsrc
 */
class ResultatQsrc extends ResultatQuestionReponse{
	
	
	/**
	 * Constructeur.
	 * Initialise les attributs de la classe.
	 */	
	function ResultatQsrc(){
		parent::ResultatQuestionReponse();
	}
	
	/**
	 * Affecter les valeurs des attributs de l'objet.
	 * @param $question integer Identifiant de la Question
	 * @param $choix integer Identifiant du Choix
	 * @param $valeur integer Valeur de la rponse
	 */	
	function init($question, $choix, $valeur){
		if(!in_array($question,$this->questions))$this->questions[]=$question;
		if(!in_array($choix,$this->reponses))$this->reponses[]=$choix;
		$this->valeurs[]=$valeur;
	}
	
	/**
	 * Vrifie les valeurs des attributs.
	 * @param object Qsrc $qsrc Evaluation associe au Resultat.
	 * @return boolean true si les valeurs sont correctes, false sinon.
	 */		
	function verify($qsrc){
	
		if( ($qsrc->getNbQuestions()==count($this->questions) ) && ($qsrc->getNbReponses()==count($this->reponses)) ){
			return ( count($this->questions)*count($this->reponses) )==count($this->valeurs);
		}else{
			return false;
		}
	}
}
?>
