<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package qsrc 
 * @modulegroup plpgsql
 * @module plpgsql_qsrc
 */

/**
 * Enregistre un qsrc en base de donnes.(OLD)
 * @param varchar le libelle du qsrc. //inutile pour la OLD
 * @param integer le type de qsrc (qrc ou src) //inutile pour la OLD
 * @param varchar la question commune
 * @return integer l'identifiant du qsrc ainsi cr
 */
function set_qsrc_old($libelle, $type,  $question_commune) {
	$sql = "UPDATE test SET question_commune='$question_commune'
			WHERE id_test=$positionnement";
	//echo $sql."<br>";
	return pg_query($sql);
}

/**
 * Enregistre un qsrc en base de donnes.
 * @param varchar le libelle du qsrc.
 * @param integer le type de qsrc (qrc ou src)
 * @param varchar la question commune
 * @return integer l'identifiant du qsrc ainsi cr
 */
function set_qsrc($libelle, $type,  $question_commune,$radio, $theme) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_qsrc('$libelle', $type, '$question_commune', $radio) ";
		//echo $sql."<br>";
		$res= pg_fetch_result(pg_query($sql),0,0);
		set_categorie_element_theme(23, $theme, $res);
		return $res;
	} else {
		return set_qsrc_old($libelle, $type, $question_commune);
	}
}

/**
 * Met  jour un qsrc en base de donnes. (OLD)
 * @param varchar le libelle du qsrc
 * @param integer le numro du qsrc  mettre a jour
 * @param varchar la question commune
 * @param bool 'TRUE' pour afficher un radio, 'FALSE' pour afficher un checkbox
 * @return bool true ou false selon que la mise a jour ai t effectue ou non.
 */
function maj_qsrc_old($qsrc,$libelle, $question_commune,$radio) {
	if($radio=='TRUE')$v_radio='r';
	else $v_radio='c';
	$sql1 = "UPDATE test SET question_commune='$question_commune', type_reponse='$v_radio'
			WHERE id_test=$qsrc";
			
	$sql2 = "UPDATE serie_exo SET titre='$libelle'
			WHERE id=$qsrc";			
	//echo $sql1."<br>";
	//echo $sql2."<br>";
	return (pg_affected_rows(pg_query($sql1))==1 ||pg_affected_rows(pg_query($sql2))==1);
}

/**
 * Met  jour un qsrc en base de donnes.
 * @param varchar le libelle du qsrc
 * @param integer le numro du qsrc  mettre a jour
 * @param varchar la question commune
 * @param bool 'TRUE' pour afficher un radio, 'FALSE' pour afficher un checkbox
 * @return bool true ou false selon que la mise a jour ai t effectue ou non.
 */
function maj_qsrc($qsrc,$libelle, $question_commune, $radio) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_qsrc($qsrc,'$libelle', '$question_commune',$radio) ";
//		echo $sql."<br>";
		return (pg_fetch_result(pg_query($sql),0,0)=='t');
	} else {
		return maj_qsrc_old($qsrc,$libelle, $question_commune,$radio);
	}
}

/**
 * Obtenir les informations propres  un qsrc.(OLD)
 * 
 * @param integer le numro du qsrc
 * @return integer le resultat de la requete : (id int4, libelle varchar, positionnement int4, question_commune varchar, type int4, date_creation timestamp)
 */
function get_qsrc_old($qsrc){
	$sql = "SELECT id_test, titre, id_test, question_commune, type_test, CAST(NULL AS timestamp), CASE WHEN type_reponse LIKE 'r' THEN TRUE ELSE FALSE END FROM test, serie_exo WHERE id_test=$qsrc
			AND id=id_test";
	//echo $sql."<br>";
	return pg_query($sql);
}

/**
 * Obtenir les informations propres  un qsrc.
 * 
 * @param integer le numro du qsrc
 * @return integer le resultat de la requete : (id int4, libelle varchar,  question_commune varchar, type int4, date_creation timestamp, is_radio bool)
 */
function get_qsrc($qsrc){
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_qsrc($qsrc) AS (id int4, libelle varchar,  question_commune varchar, type int4, date_creation timestamp, is_radio bool)";
//		echo $sql."<br>";
		return pg_query($sql);
	} else {
		return get_qsrc_old($qsrc);
	}	
}

function del_qsrc_old($tab_qsrcs){
	$nb_to_delete=count($tab_qsrcs);
	$i=0;
	foreach($tab_qsrcs as $key=>$value){
		$sql1 = "delete from serie_exo where id=$value ";
		//echo $sql1."<br>";
		$res1=pg_query($sql1);
		$sql2 = "delete from test_quest_rep where id_test=$value ";
		//echo $sql2."<br>";
		$res2=pg_query($sql2);
		$sql3 = "delete from asso_test_reponse where id_test=$value ";
		//echo $sql3."<br>";
		$res3=pg_query($sql3);
		$sql4 = "delete from test_rep_nbexogen where id_test=$value ";
		//echo $sql4."<br>";
		$res4=pg_query($sql4);
		$sql5 = "delete from test where id_test=$value ";
		//echo $sql5."<br>";
		$res5=pg_query($sql5);
		if($res5)$i++;
	}
	return $nb_to_delete==$i;
}

function del_qsrc($tab_qsrcs){
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_evaluations(".int_array_to_plpgsql_array($tab_qsrcs).") ";
		//echo $sql."<br>";
		return pg_fetch_result(pg_query($sql),0,0)=='t';
	} else {
		return del_qsrc_old($tab_qsrcs);
	}	
}

/**
 * Obtenir le numero de la derniere rponses d'un qsrc
 * @param integer : le numero de qsrc
 * @return integer : le numero du question_reponse_element qui est la derniere reponse
 */
function get_qsrc_last_reponse($qsrc) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_gen_get_last_element('contraintes.choix', 'id',' AND question_reponse=$qsrc') ";
//		echo $sql."<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction get_qsrc_last_reponse($qsrc) n'existe pas pour la version " .
		VERSION);
	if(pg_num_rows($res)==1)
		return pg_fetch_result($res, 0, 0);
	else return null;
}

/**
    Creer une question de qsrc  

    @param integer : le numero de qsrc
    @param string  : le libelle de la question
    @param integer : le theme de la question
   	@param bool : interpretation HTML
   	@param integer : le type de question (qcm ou sondage)
    @param integer : le numero du media
    @param integer : la largeur du media
    @param integer : la hauteur du media
    @param integer : le numero de la question pere
    @return integer : le numero de la question ainsi cre
*/
function set_qsrc_question($qsrc, $libelle, $theme, $inter_html, $type, $media, $largeur, $hauteur, $pere) {
	if(empty($theme)||!is_numeric($theme)){
		die(" set_qsrc_question($qsrc, $libelle, $theme, $inter_html, $type, $media, $largeur, $hauteur, $pere): parametre \$theme manquant.");
	}

	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_qsrc_question($qsrc,  '$libelle',  '$inter_html', $media, $largeur, $hauteur ,$pere)";
//		echo "$sql<br>";
		$ins = pg_fetch_result(pg_query($sql), 0, 0);
		set_categorie_element_theme(17,$theme,$ins);
		return $ins;
	} else
		$res = set_qsrc_question_old($qsrc, $libelle, $theme, $inter_html, $type, $media, $largeur, $hauteur, $pere);
	return $res;
}

/**
    Mettre  jour une question de qsrc  
	@param integer : le numero de qsrc
    @param integer : le numero de question
    @param string  : le libelle de la question
    @param integer : le numero du media
    @param integer : la largeur du media
    @param integer : la hauteur du media
    @param bool : interpretation HTML
    @param char: (facultatif) pour la fonction old, le type de question de positionnement (q ou s)
    @return bool : TRUE ou FALSE selon que la mise a jour se soit bien passe ou non
*/
function maj_qsrc_question($qsrc, $question, $libelle, $media, $largeur, $hauteur, $inter_html, $type="") {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_qsrc_question($qsrc,$question,'$libelle',$media,$largeur,$hauteur, '$inter_html')";
//		echo "$sql<br>";
		return pg_fetch_result(pg_query($sql),0,0);
	} else
		$res = maj_qsrc_question_old($qsrc, $question, $libelle, $media, $largeur, $hauteur, $inter_html,$type);
	return $res;
}

/**
 * Supprime une question d'un qsrc
 * @param integer : le numero du qsrc
 * @param integer : le numero de la question
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_qsrc_question($qsrc, $question) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_qsrc_question($qsrc, $question) ";
		//echo $sql . "<br>";
		$result = pg_query($sql);
	} else
		$result = del_positionnement_question_positionnement_old($qsrc, $question);
	return $result;
}

/**
 * Obtenir les questions d'un qsrc.
 * @param integer : le numero du qsrc
 * @param char : (facultatif) le type de questions (pour la fonction old)
 * @return integer : l'entier resultat (id int4, libelle varchar, interpretationHTML bool, question bool) 
 */
function get_qsrc_questions($qsrc, $type="") {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_qsrc_questions($qsrc) AS (id int4, libelle varchar, interpretationHTML bool, question bool, indice integer) ";
//		echo $sql."<br>";
		return pg_query($sql);
	} else
		return get_positionnement_questions_old($qsrc, $type); 
}

?>
