<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de dfinition de la classe Question

La connexion  la base de donnes doit tre $db

@package question
*/
class Question extends QuestionReponseElement{

    /**
    * Constructeur de la classe Question
    * @param integer $id identifiant de l'enregistrement en BD
    * @param string $libelle Libell
    * @param integer $theme identifiant du thme en base de donnes
    * @param object Media  $media Media de la question
    * @param integer $interpretationHTML Interprtation html
    * @param integer $type Type de la Question
    */
    function Question($id=0, $libelle="Question", $type=0, $interpretationHTML=true, $media=null){
    	messageDebug("Question::Question($id, $libelle, $type, $interpretationHTML, $media)");
    	
    	if(func_num_args()==1){
    		$res=get_question_reponse_element($id);
    		$row=pg_fetch_row($res);
    		$libelle=$row[1];
    		$interpretationHTML=sql2Bool($row[2]);
    		$type=$row[3];
    	}
    	
    	parent::QuestionReponseElement($id, $libelle, $type, $interpretationHTML, $media);
    }

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=Question::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate($message);
		$verif=Question::verify($message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Ne vrifie aucun attribut.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes (toujours), false si non (jamais).
	 */
	function verify(&$message){
		return true;
	}


	/**
	* Fonction qui insre la Question en base.
	* Affecte l'identifiant de la Question.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre la Question
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant de la Question cr ou false
	*/
	function insertToDB($theme, &$message) {
//		if ((!empty ($this->libelle)) && (!empty ($this->type))) {
//			//traitement des variables
//			$lib = addslashes($this->libelle);
//			$html = "FALSE";
//	
//			//insertion
//			if (VERSION_BASE > VERSION) {
//				$insertion = set_question_reponse_element($lib, $html,'FALSE', $this->num_theme);
//			} else {
//	
//				if ($this->type == get_evaluation_type_old_new('q')||$this->type == get_evaluation_type_old_new('m')) {
//					$insertion = set_reponse_qcm($lib, $html, $this->num_theme);
//				} else
//					if ($this->type == get_evaluation_type_old_new('s')||$this->type == get_evaluation_type_old_new('o')) {
//						$insertion = set_proposition_sondage($lib, $html, $this->num_theme);
//					}
//	
//			}
//			if(empty($insertion)){
//				die("Erreur lors de l'insertion de la Question<br>");
//			}
//			$this->id=$insertion;
//			return $insertion;
//	
//		} else {
//			echo "Insertion Question impossible : mauvais attributs d'objet:".$this->libelle.",".$this->type."<br>";
//			return false;
//		}
		if(Question::verifyInsert(&$message)){
			//if (VERSION_BASE > VERSION) {
				$this->id = set_question(set_ams_libelle($this->libelle), bool2Sql($this->interpretationHTML), $this->type, $theme);
				return $this->id;
//			}else{
//				if ($this->type == get_evaluation_type_old_new_r('q')||$this->type == get_evaluation_type_old_new_r('m')) {
//					$insertion = set_reponse_qcm(addslashes($this->libelle), bool2Sql($this->interpretationHTML), $theme);
//				} else
//					if ($this->type == get_evaluation_type_old_new_r('s')||$this->type == get_evaluation_type_old_new_r('o')) {
//						$insertion = set_proposition_sondage(addslashes($this->libelle), bool2Sql($this->interpretationHTML), $theme);
//					}else{
//						die("Question::insertToDB: Type inconnu (".$this->type.")<br>");
//					}
//				if(empty($insertion)){
//					die("Erreur lors de l'insertion de la Question(OLD)<br>$message");
//				}
//				$this->id=$insertion;
//				return $insertion;
//			}
		}
		else{
			return false;
		}	
	}

	/**
	* Fonction qui met  jour l'enregistrement en table
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	*/
	function updateToDB(&$message) {
		if(Question::verifyUpdate(&$message)){

			if (VERSION_BASE > VERSION) {
				$maj = maj_question_reponse_element($this->id, set_ams_libelle($this->libelle), bool2Sql($this->interpretationHTML));
				return $maj;
			}else{
				if ($this->type == get_evaluation_type_old_new_r('q')||$this->type == get_evaluation_type_old_new_r('m')) {
					$insertion = maj_reponse_qcm($this->id,addslashes($this->libelle), bool2Sql($this->interpretationHTML));
				}elseif ($this->type == get_evaluation_type_old_new_r('s')||$this->type == get_evaluation_type_old_new_r('o')) {
						$insertion = maj_proposition_sondage($this->id,addslashes($this->libelle), bool2Sql($this->interpretationHTML));
				}else{
					die("Question::updateToDB: Type inconnu (".$this->type.")<br>");
				}
				if(empty($insertion)){
					die("Question::updateToDB: Erreur lors de la MAJ de la Question(OLD)<br>");
				}
				$this->id=$insertion;
				return $insertion;
			}
			
		} else {
			return false;
		}
	}
	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_question", "interpretationHTML_question", "theme_question");
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "interpretationHTML_question":
				return Array(true, false);
			default:
				return null;
		}
	}
	
//-----------------------------------------------------
//			METHODES DEPRECIES
//-----------------------------------------------------
	
    /**
    * Donne les informations media pour l'insertion en base de donnes (bon format : NULL ou la valeur)
    * @deprecated
    */
    function getFormatBD()
    {
            $tab = array();

            // Media
            if($this->media_question)
                    $tab["media"] = $this->media_question->getId() ;
            else
                    $tab["media"] = "NULL" ;

            // Longueur
            if($this->media_question->hauteur)
                    $tab["longueur"] = $this->media_question->hauteur ;
            else
                    $tab["longueur"] = "NULL" ;

            // Largeur
            if($this->media_question->largeur)
                    $tab["largeur"] = $this->media_question->largeur ;
            else
                    $tab["largeur"] = "NULL" ;

            return $tab ;
    }

    /**
    * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
    *
    * Si on ne passe aucun paramtre, la chane retourne contient le nom. Par contre, si le paramtre est dfini,
    * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
    * @deprecated
    * @param string $format le paramtre determine ce qu'on retourne. Les informations disponibles sont :
    * [id_test] (gal  [id_serie]) & [type_test]
    * @return string  On retourne la chane de caractres cre  partir du format
    */		
    function toString($format="")
    {
            // Aucun paramtre, on retourne le titre de la srie
            if($format=="")
                    return $this->libelle ;

            // Ce tableau contient tous les pattern et les nouvelles valeurs
            $tab_replace = array("\[libelle\]"=>"$this->libelle","\[id\]"=>"$this->id","\[num_theme\]"=>"$this->num_theme") ;

            while($tab=each($tab_replace))
                    $format = ereg_replace($tab[0],$tab[1],$format) ;

            return $format ;
    }


//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

  
    
}
?>