<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

 Fichier de fonctions pour les questions.
 Une question est un question_reponse_element, et les fonctions de ce fichier
 doivent dont toutes appeler des fonctions de la librairie question_reponse_element.
 
 NB:Les questions sont communes aux qcm et aux sondage

	@package question
	@modulegroup plpgsql
	@module plpgsql_question
*/

/**
 * Fichier de fonctions dprcies
 */
//include ("$chemin_bo/lib/question/plpgsql_deprecated_question.inc");

/**
    Obtenir les infos d'une question (OLD)

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm_old($question) {
	$sql = "select num_question, libelle_question, inter_html, 'q' , 'FALSE' from question where num_question=$question";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les infos d'une question

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm($question) {
	if (VERSION_BASE > VERSION) {
		$res = get_question_reponse_element($question);
	} else
		$res = get_question_qcm_old($question);
	return $res;
}

/**
    Enregistre une nouvelle question (OLD)

    @param string : le libelle de la question
    @param bool: intepretation html? 
    @param int4 : le type de question (qcm, sondage, ...)
    @param integer : le numro du theme
    @return integer : le numro de la nouvelle question
*/
function set_question_qcm_old($libelle, $html, $theme) {
	//$existe_deja=check_question($theme,$libelle);
	//if(!$existe_deja){
	$sql = "insert into question (libelle_question,theme, inter_html) values('$libelle','$theme', $html);";
	//echo "$sql<br>";
	$ins = pg_query($sql);
	$oid = pg_getlastoid($ins);
	$sql = "select num_question from question where oid=$oid";
	$res = pg_query($sql);
	$row = pg_fetch_row($res, 0);
	return $row[0];
	//}
	//return 0;
}

/**
    Enregistre une nouvelle question
	et l'enregistre dans la categorie associe
    @param string : le libelle de la question
    @param bool: intepretation html? 
    @param integer : le numro du theme
    @return integer : le numro de la nouvelle question
*/
function set_question_qcm($libelle, $html, $theme) {
	if (VERSION_BASE > VERSION) {
		$num = set_question_reponse_element($libelle, $html, 1, 'FALSE');
		$res = set_categorie_element_theme(17,$theme,$num);
		return $num;
	} else
		return set_question_qcm_old($libelle, $html, $theme);
}

/**
 * Enregistre une nouvelle question
 * et l'enregistre dans la categorie associe
 * @param string $libelle le libelle de la question
 * @param bool $html intepretation html?
 * @param integer $type identifiant du type de question
 * @param integer $theme le numro du theme
 * @return integer Le numro de la nouvelle question
 */
function set_question($libelle, $html, $type, $theme) {
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_set_question('$libelle', $html, $type)";
//        echo "sql=$sql<br>";
        $res=pg_query($sql);
        $num=pg_fetch_result($res,0,0);
		$res = set_categorie_element_theme(17,$theme,$num);
		return $num;
	} else
		if($type=='q' || $type==1)
			return set_question_qcm_old($libelle, $html, $theme);
		else
			return set_question_sondage_old($libelle, $theme,'null','null','null','r',$html );
			
}

/**
    Mettre  jour une question(OLD)
    
    @param integer : le numero de question
    @param string  : le libelle de la question
    @param bool: intepretation html? 
    @return bool: t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_question_qcm_old($question, $libelle, $interpretation_html) {
	$sql = "update question set libelle_question='$libelle', inter_html='$interpretation_html' where num_question=$question";
	$maj = pg_query($sql);
	return $maj;
}

/**
    Mettre  jour une de question
    
    @param integer : le numero de question
    @param string  : le libelle de la question
    @param bool: intepretation html? 
    @return bool: t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_question_qcm($question, $libelle, $interpretation_html) {
	if (VERSION_BASE > VERSION) {
		$res = maj_question_reponse_element($question, $libelle, $interpretation_html);
	} else
		$res = maj_question_qcm_old($question, $libelle, $interpretation_html);
	return $res;
}

/**
 * Met a jour le libell d'une valuation
 * @param integer: le numero de la question
 * @param string : le libelle de l'evaluation
 * @return integer : l'identifiant de la nouvelle evaluation
 */
function maj_question_qcm_evaluation($question, $libelle){
	if(VERSION_BASE>VERSION){
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);
        $sql="select * from contraintes.af_maj_evaluation($evaluation, '$libelle')";
        //echo "sql=$sql<br>";
        $res=pg_query($sql);
    }
    else
       print("La fonction maj_question_qcm_evaluation($evaluation, $libelle) n'existe pas pour la version ".VERSION);
    return pg_fetch_result($res,0,0) ;
}

/**
    Obtenir les rponses d'une question de QCM et savoir si elles sont juste ou fausses (OLD)
    @param integer : le numero de question de qcm
    @return integer : le resultat de la requete :question_reponse int4, question int4,reponse int4 ,juste bool )
*/
function get_question_qcm_solutions_old($question) {
	$sql="SELECT DISTINCT qr_num_question, qr_num_question, qr_num_rep, juste FROM quest_rep WHERE qr_num_question=$question";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les rponses d'une question de QCM et savoir si elles sont juste ou fausses
    @param integer : le numero de question de qcm
    @return integer : le resultat de la requete :question_reponse int4, question int4,reponse int4 ,juste bool )
*/
function get_question_qcm_solutions($question) {
	if (VERSION_BASE > VERSION) {
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");

		$evaluation = pg_fetch_result($evaluations, 0, 0);
		$res = get_qcm_solutions($evaluation);
	} else
		$res = get_question_qcm_solutions_old($question);
	return $res;
}


/**
    Obtenir les rponses d'une question de QCM (OLD)
    @param integer : le numero de question de qcm
    @return integer : le resultat de la requete :question_reponse int4, question int4, reponse int4, odre int4
*/
function get_question_qcm_associations_old($question) {
	$sql="SELECT qr_num_question, qr_num_question, qr_num_rep, ordre FROM quest_rep WHERE qr_num_question=$question";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les rponses d'une question de QCM 
    @param integer : le numero de question de qcm
    @return integer : le resultat de la requete :question_reponse int4, question int4, reponse int4, pere int4
*/
function get_question_qcm_associations($question) {
	if (VERSION_BASE > VERSION) {
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");

		$evaluation = pg_fetch_result($evaluations, 0, 0);
		$res = get_qcm_reponses($evaluation);
	} else
		$res = get_question_qcm_associations_old($question);
	return $res;
}

/**
 * Obtenir une rponse  une question de  QCM et savoir si elle est juste ou fausse(OLD)
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @return integer :(question_reponse int4, question int4,reponse int4 ,juste bool )
 */
function get_question_qcm_solution_old($question, $reponse) {
	$sql = "SELECT qr_num_question, qr_num_question, qr_num_rep, juste FROM quest_rep WHERE  qr_num_question=$question AND qr_num_rep=$reponse";
	$res = pg_query($sql);
	return $res;
}

/**
 * Obtenir une rponse  une question de  QCM et savoir si elle est juste ou fausse
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @return integer :(question_reponse int4, question int4,reponse int4 ,juste bool )
 */
function get_question_qcm_solution($question, $reponse) {
	if (VERSION_BASE > VERSION) {
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");

		$evaluation = pg_fetch_result($evaluations, 0, 0);
		$res = get_qcm_solution($evaluation,$reponse);
	} else
		$res = get_question_qcm_solution_old($question, $reponse);
	return $res;
}

/**
 * Obtenir le mdia d'une question de QCM (OLD)
 *  @param integer : le numero de question de qcm
 *  @return integer : le resultat de la requete : (question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4)
 */
function get_question_qcm_media_old($question) {
	$sql = "select DISTINCT qr_num_question, qr_num_question ,qmedia, flash,hauteur_qmedia, largeur_qmedia  from quest_rep where qr_num_question=$question ";
	 //echo "sql=$sql<br>";
	$res = pg_query($sql);

	return $res;
}

 /**
 * Obtenir le mdia d'une question de QCM
 * @param integer: un numro de question de qcm
 * @return integer: le resultat de la requete :(question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4)
 */
function get_question_qcm_media($question) {
	if (VERSION_BASE > VERSION) {
		return get_question_reponse_element_media($question);
	} else
		$res = get_question_qcm_media_old($question);
	return $res;

}

/**
 * Mettre  jour le mdia d'une question de QCM(OLD)
 * @param integer  le numero de question de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @return bool  true si l'update s'est bien pass, false sinon
 */
function maj_question_qcm_media_old($question, $media, $largeur, $hauteur) {
	$sql = "update quest_rep set qmedia=$media,largeur_qmedia=$largeur,hauteur_qmedia=$hauteur where qr_num_question=$question";
	// echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
 * Mettre  jour le mdia d'une question de QCM
 * @param integer  le numero de question de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @return bool  t si l'update s'est bien pass, f sinon
 */
function maj_question_qcm_media($question, $media, $largeur, $hauteur) {
	if (VERSION_BASE > VERSION) {

		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");

		$evaluation = pg_fetch_result($evaluations, 0, 0);

		$res = maj_question_reponse_element_media($evaluation, $question, $media, $largeur, $hauteur);
	} else
		$res = maj_question_qcm_media_old($question, $media, $largeur, $hauteur);
	return $res;

}

/**
 * Supprimer le mdia d'une question de QCM (OLD)
 * @param integer  le numero d'une question
 * @return bool  t si la suppression s'est bien pass, f sinon
 */
function del_question_qcm_media_old($question) {
	$sql = "UPDATE quest_rep set qmedia=NULL,largeur_qmedia=NULL,hauteur_qmedia=NULL where qr_num_question=$question";
	// echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
 * Supprimer le mdia d'une question de QCM
 * @param integer  le numero d'une question
 * @return bool  t si la suppression s'est bien pass, f sinon
 */
function del_question_qcm_media($question) {
	if (VERSION_BASE > VERSION) {
		 $evaluations=get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if(pg_num_rows($evaluations)>1)print("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation= pg_fetch_result($evaluations, 0, 0);	
	
		return del_question_reponse_element_media($evaluation,$question);
	} else
		return del_question_qcm_media_old($question);
}

/**
 * Affecter un mdia  une question de QCM
 * @param integer  le numero de question de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @return bool  t si l'update s'est bien pass, f sinon
 */
function set_question_qcm_media_old($question, $media, $largeur, $hauteur) {
	//1er cas: il y a deja un enregistrement pour ce couple question/reponse
	$sql1 = "UPDATE quest_rep SET qmedia=$media,largeur_qmedia=$largeur,hauteur_qmedia=$hauteur WHERE qr_num_question=$question";
	//echo "sql=$sql1<br>";
	$res = pg_query($sql1);
	if(!$res){
		print("ERREUR(set_question_qcm_media_old):<br>Il n'est pas possible d'affecter un media a une question de qcm avant de l'associer a une reponse.<br>");
	//2eme cas: il n'y a pas d'enregistrement pour cette question
	//.... pas utile a priori
	}
	return $res;
}

/**
 * Affecter un mdia  une question de QCM
 * @param integer  le numero de question de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @return bool  t si l'update s'est bien pass, f sinon
 */
function set_question_qcm_media($question, $media, $largeur, $hauteur) {
	if (VERSION_BASE > VERSION) {
		 $evaluations=get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if(pg_num_rows($evaluations)>1)print("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation= pg_fetch_result($evaluations, 0, 0);	
	
		return set_question_reponse_element_media($evaluation,$question, $media, $largeur, $hauteur);
	} else
		$res = set_question_qcm_media_old($question, $media, $largeur, $hauteur);
	return $res;
}

/**
 * Crer une reponse de qcm et l'associer  une question. (OLD)
 * @param integer: le numero de question de qcm
 * @param string : le libelle de la reponse
 * @param bool: intepretation html? 
 * @param integer : le theme
 * @param integer : l'indice pour l'ordre de la rponse
 * @param bool: true si la reponse est juste, false sinon
 * @return integer: le numero du nouvel enregistrement
 */
function set_question_qcm_reponse_old($question, $libelle, $html, $theme, $ordre, $juste) {
		//cree la reponse
		$reponse = set_reponse_qcm($libelle, $html, $theme);
		
		//enregistre l'association et la reponse  la question
		$sql = "INSERT INTO quest_rep (qr_num_question, qr_num_rep, ordre, juste) 
				VALUES ($question, $reponse, $ordre, '$juste')";
		$res = pg_query($sql);
			
		return $reponse;
}

/**
 * Crer une reponse de qcm et l'associer  une question.
 * @param integer: le numero de question de qcm
 * @param string : le libelle de la reponse
 * @param bool: intepretation html? 
 * @param integer : le theme
 * @param integer : le numero de la reponse pere
 * @param bool: true si la reponse est juste, false sinon
 * @return integer: le numero du nouvel enregistrement
 */
function set_question_qcm_reponse($question, $libelle, $html, $theme, $pere, $juste) {
	if (VERSION_BASE > VERSION) {
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");

		$evaluation = pg_fetch_result($evaluations, 0, 0);

		//cree la reponse
		$id = set_reponse_qcm($libelle, $html,  $theme);

		//enregistre l'association
		//set_question_reponse_association_element($evaluation, $question, $id, $pere);
		set_question_reponse_association_element($evaluation,$id, $pere);

		//enregistre la reponse  la question
		set_qcm_solution($evaluation, $question, $id, $juste);
		return $id;
	} else {
		return set_question_qcm_reponse_old($question, $libelle, $html, $theme, $pere, $juste);
	}
}

/**
 * Associe une reponse  une question de qcm
 * @param integer: le numero de question de qcm
 * @param integer: le numero de reponse de qcm
 * @param integer: l'indice pour l'ordre de la rponse
 * @param  bool: true si la reponse est juste, false sinon
 * @return bool: t si l'association s'est bien pass, f sinon
 */
function set_question_qcm_association_reponse_old($question, $reponse, $ordre, $juste) {
		//enregistre l'association et la reponse  la question
		$sql = "INSERT INTO quest_rep (qr_num_question, qr_num_rep, ordre, juste) 
				VALUES ($question, $reponse, $ordre, '$juste')";
		return pg_query($sql);
}

/**
 * Associe une reponse  une question de qcm
 * @param integer: le numero de question de qcm
 * @param integer: le numero de reponse de qcm
 * @param integer: la question de qcm pere (pour l'ordre)
 * @param  bool: true si la reponse est juste, false sinon
 * @return bool: t si l'association s'est bien pass, f sinon
 */
function set_question_qcm_association_reponse($question, $reponse, $pere, $juste) {
	if (VERSION_BASE > VERSION) {
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");

		$evaluation = pg_fetch_result($evaluations, 0, 0);

		//enregistre l'association
		set_question_reponse_association_element($evaluation,$reponse, $pere);

		//enregistre la reponse  la question
		return set_qcm_solution($evaluation, $question, $reponse, $juste);
	} else {
		return set_question_qcm_association_reponse_old($question, $reponse, $pere, $juste);
	}
}

/**
 * Obtenir l'indice de la derniere rponses d'une question de qcm(OLD)
 * Cette fonction est spcifique  l'ancienne version de la base.
 * @param integer : le numero de question
 * @return integer : le numero du question_reponse_element qui est la derniere reponse
 */
function get_question_qcm_last_reponse_old($question) {
	$sql="select max(ordre) from quest_rep where qr_num_question=$question";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0);
}

/**
 * Obtenir le numero de la derniere rponses d'une question de qcm
 * Cette fonction est spcifique  la nouvelle version de la base.
 * @param integer : le numero de question
 * @return integer : le numero du question_reponse_element qui est la derniere reponse
 */
function get_question_qcm_last_reponse($question) {
	if (VERSION_BASE > VERSION) {
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);
		return get_question_reponse_last_reponse($evaluation);
	} else{
		$res=get_question_qcm_last_reponse_old($question);
	}
		
	return $res;
}

/**
 * Obtenir les sries qui utilisent une question de QCM (OLD)
 *  @param integer : le numero de question de qcm
 */
function get_question_qcm_series_old($question) {
	$res = get_evaluation_series($question, 'q');
	return $res;
}

/**
 * Obtenir les sries qui utilisent une question de QCM
 * @param integer : le numero de question de qcm
 * @param integer:(id_serie int4,id_eval int4)
 */
function get_question_qcm_series($question) {
	if (VERSION_BASE > VERSION) {
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);
		$res = get_evaluation_series($evaluation);
	} else
		$res = get_question_qcm_series_old($question);
		
	return $res;

}

/**
 * Mettre a jour la rponse  une question de qcm  pour dire si elle est juste ou fausse (OLD)
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @param bool: t si reponse juste, f si fausse
 * @return integer: le resultat de la requete, a false si erreur
 */
function maj_question_qcm_association_reponse_old($question, $reponse, $juste) {
		$sql = "UPDATE quest_rep SET juste='$juste' WHERE qr_num_question=$question AND qr_num_rep=$reponse"; 
		//echo "$sql<br>";
		$res = pg_query($sql);
		return $reponse;
}

/**
 * Mettre a jour la rponse  une question de qcm  pour dire si elle est juste ou fausse
 * @param integer: le numero de question
 * @param integer: le numero de reponse
 * @param bool: t si reponse juste, f si fausse
 * @return bool: t si la mise a jour  s'est bien effectue, f sinon
 */
function maj_question_qcm_association_reponse($question, $reponse, $juste) {
	if (VERSION_BASE > VERSION) {
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");

		$evaluation = pg_fetch_result($evaluations, 0, 0);
		return maj_qcm_solution($evaluation, $question, $reponse, $juste);

	} else {
		return maj_question_qcm_association_reponse_old($question, $reponse, $juste);
	}
}

/**
    Obtenir les infos des reponses d'un qcm

    @param integer : le numro de la question de qcm
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm_reponses_infos_old($question) {
	$sql = "SELECT DISTINCT  R.num_rep, R.libelle_rep, R.inter_html, 'q', 'TRUE' FROM quest_rep QR, reponse R 
			WHERE QR.qr_num_question=$question
			AND QR.qr_num_rep=R.num_rep"; 
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}


/**
    Obtenir les infos des reponses d'un qcm

    @param integer : le numro du qcm
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm_reponses_infos($question) {
	if (VERSION_BASE > VERSION) {
		//recupere le numero d'evaluation
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);
			
		return get_qcm_reponses_infos($evaluation);
	} else
		$res = get_question_qcm_reponses_infos_old($question);
	return $res;
}

/**
    Obtenir les themes d'un qcm(OLD)

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm_qcm_themes_old($question) {
	$sql = "select theme from question where num_question=$question";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les themes d'un qcm

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm_qcm_themes($question) {
	if (VERSION_BASE > VERSION) {
		$res = get_categorie_element_themes(17,$question);
	} else
		$res = get_question_qcm_qcm_theme_old($question);
	return $res;
}

/**
    Obtenir les themes d'une question de qcm(OLD)

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm_themes_old($question) {
	$sql = "select theme, theme from question where num_question=$question";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les themes d'une question de qcm

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_qcm_themes($question) {
	if (VERSION_BASE > VERSION) {
		$res = get_categorie_element_themes(17,$question);
	} else
		$res = get_question_qcm_themes_old($question);
	return $res;
}
?>