<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de dfinition de la classe QuestionPositionnement
La connexion  la base de donnes doit tre $db

@author COCQUET Rmi
@package question_positionnement
*/
class QuestionPositionnement extends Question {

	var $positionnement;
	var $pere;
	/**
	* Constructeur de la classe QuestionPositionnement
	* 
	* @param integer : identifiant de l'enregistrement en BD
	* @param integer : identifiant du positionnement
	* @param integer : identifiant du type de question
	* @param string : Libell
	* @param integer : identifiant du thme en base de donnes
	* @param integer : l'objet du media
	* @param bool : interpretation HTML?
	*/
	function QuestionPositionnement($id = "", $positionnement = "", $type = "", $lib = "", $theme = "", $media = "", $interpretationHTML = false, $pere="") {
		// On rcupre les informations en base de donnes si on a l'id
		if (!empty ($id) && !empty ($positionnement)) {
			if (VERSION_BASE > VERSION) {

				$result = get_question_positionnement($id);
				$result1 = get_question_positionnement_media($id, $positionnement);
				//le theme de la question
				$res_theme =get_question_positionnement_themes($id);
			} else {

				switch ($type) {
					case 'q' :
					case 1 :
					case 'm' :
					case 4 :
						$result = get_question_qcm($id);
						$result1 = get_question_qcm_media($id, $positionnement);
						$res_theme = get_question_qcm_themes($id);
						break;
					case 's' :
					case 2 :
					case 'o' :
					case 5 :
						$result = get_question_sondage_infos($id);
						$result1 = get_question_sondage_question_sondage_media($id, $positionnement);
						$res_theme = get_question_sondage_themes($id);
						break;
					default :
						echo "Erreur QuestionPositionnement(...):<br> le type '$type' n'est pas gere par la fonction.";
						$probleme = true;
				}
			}
			//les infos de la question
			if (empty ($lib)) {
				$row = pg_fetch_array($result);
				$id = $row[0];
				$lib = $row[1];
				if (empty ($interpretationHTML)) {
					$interpretationHTML = $row[2];
				}
				if (empty ($type)) {
					$type = $row[3];
				}
			}
			//le media
			if (empty ($media)) {
				if (pg_num_rows($result1) > 0) {
					$row1 = pg_fetch_array($result1);
					// Construction du media
					$media = new Media_exo($row1[2], $row1[4], $row1[5]);
				}
			}
			if (empty ($theme))
				$theme = pg_fetch_result($res_theme, 0, 0);

		}else{
			$this->pere=$pere;
		}
		
		$this->positionnement = $positionnement;
		// On appel le constructeur de la classe mre avec les paramtres
		parent :: Question($id, $lib, $type, $interpretationHTML,  $media);
	}

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=QuestionPositionnement::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate($message);
		$verif=QuestionPositionnement::verify($message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Ne vrifie aucun attribut.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes (toujours), false si non (jamais).
	 */
	function verify(&$message){
		return true;
	}
	
	/**
	* Fonction qui insre un enregistrement en table
	* On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
	* @return integer : identifiant de l'enregistrement cr (ou rcupr)
	*/
	function insertToDB($theme,&$message,$tab_vrai_faux="") {
//		if (!empty ($this->libelle) && !empty ($this->positionnement) && !empty($theme)) {
//
//			//if (VERSION_BASE > VERSION) {
//
//			if (empty ($this->media_question->id))
//				$media = 'NULL';
//			else
//				$media = $this->media_question->id;
//
//			if (empty ($this->media_question->largeur))
//				$largeur = 'NULL';
//			else
//				$largeur = $this->media_question->largeur;
//
//			if (empty ($this->media_question->hauteur))
//				$hauteur = 'NULL';
//			else
//				$hauteur = $this->media_question->hauteur;
//
//			if (empty ($this->pere)) {
//				$ordre = get_positionnement_last_question($this->positionnement);
//				if (empty ($ordre))
//					$ordre = 'NULL';
//			} else
//				$ordre = $this->pere;
//				
////			print("I $media, $largeur, $longueur<br>");
////			print_r($tab_vrai_faux);
////			print("a<br>");
//			if($this->inter_html)$int='TRUE';
//			else $int='FALSE';
//			$set = set_qsrc_question($this->positionnement, addslashes($this->libelle), $theme, $int, $this->type, $media, $largeur, $hauteur, $ordre);
//			if (!empty ($tab_vrai_faux))
//				set_qrc_question_solution($this->positionnement, $set, $tab_vrai_faux);
//			
//			$this->id=$set;				
//			return $set;
//		} else {
//			echo "Insertion question de positionnement impossible : mauvais attributs d'objet : $this->libelle / $theme/  $this->positionnement<br>";
//			return false;
//		}
		if(QuestionPositionnement::verifyInsert(&$message)){
			if (empty ($this->media_question->id))
				$media = 'NULL';
			else
				$media = $this->media_question->id;

			if (empty ($this->media_question->largeur))
				$largeur = 'NULL';
			else
				$largeur = $this->media_question->largeur;

			if (empty ($this->media_question->hauteur))
				$hauteur = 'NULL';
			else
				$hauteur = $this->media_question->hauteur;

			if (empty ($this->pere)) {
				$ordre = get_positionnement_last_question($this->positionnement);
				if (empty ($ordre))
					$ordre = 'NULL';
			} else
				$ordre = $this->pere;

			$this->id = set_qsrc_question($this->positionnement, addslashes($this->libelle), $theme, bool2Sql($this->interpretationHTML), $this->type, $media, $largeur, $hauteur, $ordre);
			if (!empty ($tab_vrai_faux))
				set_qrc_question_solution($this->positionnement, $this->id, $tab_vrai_faux);
			
			return $this->id;
		}
		else{
			return false;
		}	

	}

	/**
	* Fonction qui met  jour l'enregistrement en table
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
	*/
	function updateToDB(&$message, $tab_vrai_faux = "") {
		if(QuestionPositionnement::verifyUpdate(&$message)){

			//if (VERSION_BASE > VERSION) {
			if (empty ($this->media_question->id))
				$media = 'NULL';
			else
				$media = $this->media_question->id;

			if (empty ($this->media_question->largeur))
				$largeur = 'NULL';
			else
				$largeur = $this->media_question->largeur;

			if (empty ($this->media_question->hauteur))
				$longueur = 'NULL';
			else
				$longueur = $this->media_question->hauteur;

//			print("U $media, $largeur, $longueur<br>");
//			print_r($tab_vrai_faux);
//			print("b<br>");
			$maj = maj_qsrc_question($this->positionnement, $this->id, addslashes($this->libelle), $media, $largeur, $longueur, bool2Sql($this->interpretationHTML), get_evaluation_type_new_old($this->type));
			if ($maj != "t" && ($maj != true))
				print ("Erreur: la mise a jour de la question de positionnement n'a pas t effectue.");

			if (!empty ($tab_vrai_faux))
				$res_maj=$this->modifReponseSolution($tab_vrai_faux);
				if($res_maj!='t'){
					print_r($tab_vrai_faux);
					//die("Erreur mise a jour solution <br>");
				}
		} else {
			return false;
		}
	}

	function ajoutReponseSolution($tab_solutions) {
		if (!empty ($this->id)) {

			set_positionnement_question_positionnement_reponse_solution($this->positionnement, $this->id, $tab_solutions);
		}
	}

	function modifReponseSolution($tab_solutions) {
		if (!empty ($this->id)) {

			return maj_qrc_question_solution($this->positionnement, $this->id, $tab_solutions);
		}
	}
}
?>