<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
  
@package question_positionnement
@modulegroup plpgsql
@module plpgsql_question_positionnement
*/

/**
	Obtenir les propositions d'une question de positionnement (old)
	@param integer : le numero de la question
	@return integer : le resultat de la requete (question_reponse int4,question int4,reponse int4,pere int4)
*/
function get_question_positionnement_positionnement_associations_old($question){
	$sql="select distinct num_positionnement,num_positionnement,num_proposition,ordre from proposition_sondage where num_positionnement=$question";
	return pg_query($sql);

}

/**
	Obtenir les propositions d'une question de positionnement 
	@param integer : le numero de la question
	@return integer : le resultat de la requete (question_reponse int4,question int4,reponse int4,pere int4)
*/
function get_question_positionnement_positionnement_associations($question){
	if(VERSION_BASE>VERSION){
		// recup le numero d'valuation
		$evaluations=get_question_reponse_element_evaluations($question);
		// On teste si une association question / positionnement est unique
		//  l'avenir ,une question pourra ter utilise par plusieurs positionnements
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs positionnements,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		$res=get_positionnement_propositions($evaluation);
	}
	else{
		$res=get_question_positionnement_positionnement_associations_old($question);
		//$res=get_positionnement_propositions($question);
	}
	return $res;
}


/**
	Obtenir l'indice de la derniere proposition d'une question de positionnement (OLD)
	@note : cette fonction est spcifique  l'ancienne version de la base
	@param integer : le numero de la question
	@return integer : le numero du question_reponse_element qui est la derniere reponse
*/
function get_question_positionnement_positionnement_last_proposition_old($question){
	$sql="select max(ordre) from proposition_sondage where num_positionnement=$question";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0);
}
/**
	Obtenir l'indice de la derniere proposition d'une question de positionnement 
	@note : cette fonction est spcifique  l'ancienne version de la base
	@param integer : le numero de la question
	@return integer : le numero du question_reponse_element qui est la derniere reponse
*/
function get_question_positionnement_positionnement_last_proposition($question){
	if(VERSION_BASE>VERSION){
		// recup le numero d'valuation
		$evaluations=get_question_reponse_element_evaluations($question);
		// On teste si une association question / positionnement est unique
		//  l'avenir ,une question pourra ter utilise par plusieurs positionnements
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs positionnements,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return get_question_reponse_last_reponse($evaluation);
	}
	else
		$res=get_question_positionnement_positionnement_last_proposition_old($question);
	return $res;
}

/**
	Affecter un media  une question de positionnement (OLD)
	@param integer : le numero de la question
	@param integer : le numero du media
	@param integer : la largeur en pixel du media
	@param integer : la hauteur en pixel du media
	@return bool : t si maj ok, f sinon
*/
function set_question_positionnement_question_positionnement_media_old($question,$media,$largeur,$hauteur){
	$sql="update question_sondage set qmedia=$media,largeur=$largeur,hauteur=$hauteur where num_sondage=$question";
	$res=pg_query($sql);
	return $res;
}

/**
	Obtenir les infos d'une question de positionnement 
	@param integer : numero de question
	@return integer: le resultat de la requete :(id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_positionnement($question){
	if(VERSION_BASE>VERSION){
		return get_question_reponse_element($question);
	}
	else
		print("La fonction get_question_positionnement($question) n'existe pas pour la version ".VERSION);
}

/**
	Obtenir le media d'une question de positionnement pour un positionnement donn. 
	@param integer : numero de question de positionnement
	@param integer : numero de positionnement
	@return integer: le resultat de la requete :(question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4)
*/
function get_question_positionnement_media($question, $positionnement){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_question_positionnement_media($question, $positionnement) AS (question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur  int4)";
//		echo "$sql<br>";
		return pg_query($sql);
	}
	else
		print("La fonction get_question_positionnement($question) n'existe pas pour la version ".VERSION);
}

/**
    Obtenir les themes d'une question de positionnement(OLD)

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_positionnement_themes_old($question) {
	$sql = "select theme,theme from question_sondage where num_question=$question";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les themes d'une question de positionnement

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_positionnement_themes($question) {
	if (VERSION_BASE > VERSION) {
		$res = get_categorie_element_themes(17,$question);
	} else
		$res = get_question_positionnement_themes_old($question);
	return $res;
}


?>