<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoQuestionReponse.
 * Un DoQuestionReponse sert � g�rer l'avancement des Evaluations de type QuestionReponse.
 * 
 * @package question_reponse
 */
class DoQuestionReponse extends DoEvaluation{
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * 
	 * @param integer $resultat identifiant r�sultat associ� au QuestionReponse (identifiant r�sultat de la S�rie par exemple)
	 * @param integer $evaluation identifiant du QuestionReponse
	 * @param integer $type type de QuestionReponse
	 * @param integer $indice Indice de l'�valuation.
	 * @param object EvaluationFactory &$obj_EvaluationFactory Fabrique servant � la cr�ation des objets associ�s � l'avancement
	 */		
	function DoQuestionReponse($resultat,$evaluation,$type,$indice,&$obj_EvaluationFactory){
		parent::DoEvaluation($resultat,$evaluation,$type,$indice,$obj_EvaluationFactory);
	}
	
//-----------------------------------------------------
//			METHODES
//-----------------------------------------------------
	/**
	 * Termine le QuestionReponse
	 * Enregistre la date de fin de l'�valuation et detruit les attributs de l'objet inutiles.
	 * @param object ResultatQuestionReponse $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succ�s ou non de la m�thode.
	 */	
	function end($obj_resultat){
		messageDebug("DoQuestionReponse::end(\$obj_resultat)");
		pg_query('begin');
		$fin_parent=parent::end($obj_resultat);
		if($fin_parent){
				
			$fin=set_resultat_serie_question_reponse($this->getResultat(), $this->node,$obj_resultat->questions,$obj_resultat->reponses,$obj_resultat->valeurs);
			if(!$fin){
				pg_query('rollback');
				die("Erreur DoQuestionReponse::end(): L'�valuation n'a pas �t� termin�e. ()<br>");
			}else{
				pg_query('commit');
			}
		}else{
			pg_query('rollback');
		}
		return $fin&&$fin_parent;
	}	

//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	/**
	 * Obtenir le QuestionReponse associ� � l'objet d'avancement
	 * @return object QuestionReponse  Le QuestionReponse
	 */	
	function &getQuestionReponse(){
		return parent::getObjEvaluation();
	}
	
}
?>