<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe QuestionReponse.
 *	Un QuestionReponse est un objet driv d'Evaluation.
 *  Il correspond  l'association de question(s) et de rponses.
 * 
 *	@package question_reponse
 */
class QuestionReponse extends Evaluation{

	/**
	 * @var bool Indique la forme du question reponse: true->radio; false->checkbox 
	 */		
	var $radio;
	
	/**
	 * @var array Identifiants, dans l'ordre, des questions. 
	 */	
	var $questions;

	/**
	 * @var array Identifiants, dans l'ordre, des rponses. 
	 */		
	var $reponses;
	
	/**
	 * Construit un QuestionReponse.
	 * Le QuestionReponse peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du ParcoursOriente
	 * @param string $libelle Libell
	 * @param integer $type Type de QuestionReponse (QCM, Sondage, QSRC, ....)
	 * @param string $date_creation date de cration (format SQL)
	 * @param boolean $radio Indique la forme du question reponse: true->radio; false->checkbox 
	 */	
	function QuestionReponse($id, $libelle="Question Rponse", $type=0, $date_creation="27.12.03",$radio=false){
		messageDebug("QuestionReponse::QuestionReponse($id, $libelle, $type, $date_creation,$radio)");
		if(func_num_args()==1){
			$res_evaluation = get_question_reponse($id);
			$row_evaluation=pg_fetch_row($res_evaluation,0);
			$libelle=$row_evaluation[1];
			$type=$row_evaluation[2];
			$date_creation=$row_evaluation[3];
			$radio=sql2Bool($row_evaluation[4]);
		}else{

		}
		$this->reponses=Array();
		$this->questions=Array();
		$this->obj_reponses=Array();
		$this->obj_questions=Array();
		parent::Evaluation($id, $libelle, $type, $date_creation);
		$this->loadObjects();
		$this->initQuestionReponse($radio);
	}

//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------

	/**
	 * Initialise les attributs propres au QuestionReponse.
	 * @param bool $radio Indique la forme du question reponse: true->radio; false->checkbox 
	 */		
	function initQuestionReponse($radio){
		if(is_bool($radio)){
			$this->radio=$radio;
		}else{
			die("Erreur initQuestionReponse($radio): L'objet ne peut etre initialis.");
		}	
	}

	/**
	 * Initalise les attributs de type Objets.
	 */
	function loadObjects(){
		
		if(count($this->obj_questions)>0||count($this->obj_reponses)>0){
			//die("QuestionReponse::loadObjects(): Les objets contiennent dj des valeurs, elles ne peuvent tre initialiss.");
			$this->obj_reponses=Array();
			$this->obj_questions=Array();
		}
		$rows_quest=pg_super_fetch_array($this->getQuestions());
		foreach($rows_quest as $i=>$row){
			
			$result = get_question_reponse_element_media($this->id,$row[0]);
			$obj_media=null;
			if ($result&&pg_num_rows($result) ==1) {
				$row_media=pg_fetch_row($result);
				if(!empty($row_media[0]))$obj_media=new MediaQuestionReponseElement($row_media[0],$row_media[1],$row_media[2],$row_media[4],$row_media[5],$row_media[3]);
			}
//			print_rr($row);
			$this->obj_questions[]=new Question($row[0],$row[1],$row[3],$row[2],$obj_media);
			
		}
		$rows_rep=pg_super_fetch_array($this->getReponses());
		foreach($rows_rep as $i=>$row){
			$result = get_question_reponse_element_media($this->id,$row[0]);
			$obj_media=null;
			if ($result&&pg_num_rows($result) ==1) {
				$row_media=pg_fetch_row($result);
				if(!empty($row_media[0]))$obj_media=new MediaQuestionReponseElement($row_media[0],$row_media[1],$row_media[2],$row_media[4],$row_media[5],$row_media[3]);
			}
			$this->obj_reponses[]=new Reponse($row[0],$row[1],$row[3],$row[2],$obj_media);
		}
		
	}
	
	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * L'attribut 'radio' doit tre un boolen SQL, le nombre de questions
	 * suprieur  1 strictement et le nombre de rponses suprieur  2 strictement.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		$attributs_ok=true;
		if(!is_bool($this->radio)){
			$message.="[radio]";
			$attributs_ok=false;
		}
		if(count($this->questions)<1 && count($this->obj_questions)<1){
			$message.="[questions]";
			$attributs_ok=false;
		}
		if(count($this->reponses)<2 && count($this->obj_reponses)<2){
			$message.="[reponses]".count($this->reponses)."/".count($this->obj_reponses);
			$attributs_ok=false;
		}
		
		return $attributs_ok;
	}
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		$res_parent=parent::verifyInsert($message);
		$verif=QuestionReponse::verify($message);
		return $verif && $res_parent && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate(&$message);
		$verif=QuestionReponse::verify(&$message);
		
		return $res_parent && $verif && true;
	}
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Ajouter un identifiant de Question au question rponse.
	 * @return boolean true si l'ajout  t ffectu, false si la question tait dj prsente.
	 */
	function &setQuestion($question){
		if(!in_array($question, $this->questions)){
			$this->questions[]=$question;
			return true;	
		}else{
			return false;
		}
	}

	/**
	 * Ajouter un Objet de question au question rponse.
	 * @return boolean true si l'ajout  t ffectu, false si la question tait dj prsente.
	 */
	function &setObjQuestion($obj_question, $indice=0){
		
		$trouve=false;
		foreach($this->obj_questions as $k => $o){
			if($obj_question->getId()==$o->getId()){
				$this->obj_questions[$k]=$obj_question;
				$trouve=true;
			}					
		}
		if(!$trouve){
			if(func_num_args()==1||$indice==0){
				
				$this->obj_questions[]=$obj_question;
			}
			else{
				if($indice>count($this->obj_questions)){
					die("QuestionReponse::setObjQuestion($obj_question, $indice=0): L'indice $indice doit tre infrieur  ".count($this->obj_questions)."<br>");
				}
				$tmp=Array();
				foreach($this->obj_questions as $k => $o){
					if($k<$indice-1){
						$tmp[]=$this->obj_questions[$k];
					}		
					if($k==$indice-1){
						$tmp[]=$obj_question;
						$tmp[]=$this->obj_questions[$k];
					}
					if($k>$indice-1){
						$tmp[]=$this->obj_questions[$k];
					}			
				}
				$this->obj_questions=$tmp;
			}
		}
		return true;	
	}
	
	function &delObjQuestion($indice){
		if($indice>count($this->obj_questions)){
			die("QuestionReponse::delObjQuestion($indice): L'indice $indice doit tre infrieur  ".count($this->obj_questions)."<br>");
		}
	
		$tmp=Array();
		foreach($this->obj_questions as $k => $o){
			if($k==$indice-1){
				del_question_reponse_association_element($this->id, $o->getId());
			}else{
				$tmp[]=$o;
			}			
		}
		$this->obj_questions=$tmp;
	}
	
	function &delObjReponse($indice){
		if($indice>count($this->obj_reponses)){
			die("QuestionReponse::delObjReponse($indice): L'indice $indice doit tre infrieur  ".count($this->obj_reponses)."<br>");
		}
	
		$tmp=Array();
		foreach($this->obj_reponses as $k => $o){
			if($k==$indice-1){
				del_question_reponse_association_element($this->id, $o->getId());
			}else{
				$tmp[]=$o;
			}			
		}
		$this->obj_reponses=$tmp;
	}	
	
	/**
	 * Affecter l'ensemble des identifiants de questions du question rponse.
	 * @return boolean true si l'affectation  t ffectu, false si des questions taient dj affectes.
	 */	
	function &setQuestions($questions){
		if(count($this->questions)==0&&is_array($questions)){
			$this->questions=$questions;
			return true;	
		}else{
			return false;
		}
	}

	/**
	 * Ajouter un identifiant de rponse au question rponse.
	 * @return boolean true si l'ajout  t ffectu, false si la rponse tait dj prsente.
	 */
	function &setReponse($reponse){
		if(!in_array($reponse, $this->reponses)){
			$this->reponses[]=$reponse;
			return true;	
		}else{
			return false;
		}
	}
	
	/**
	 * Ajouter un Objet de rponse au question rponse.
	 * @return boolean true si l'ajout  t ffectu, false si la rponse tait dj prsente.
	 */
	function &setObjReponse(&$obj_reponse){
		$trouve=false;
		
		foreach($this->obj_reponses as $k => $o){
			if($obj_reponse->getId()==$o->getId()){
				$this->obj_reponses[$k]=$obj_reponse;
				$trouve=true;
			}					
		}
		if(!$trouve){
			$this->obj_reponses[]=$obj_reponse;
		}
		return true;	
	}	

	/**
	 * Affecter l'ensemble des identifiants de rponses du question rponse.
	 * @return boolean true si l'affectation  t ffectu, false si des rponses taient dj affectes.
	 */	
	function &setReponses($reponses){
		if(count($this->reponses)==0&&is_array($reponses)){
			$this->reponses=$reponses;
			return true;	
		}else{
			return false;
		}
	}

	/**
	 * Obtenir le nombre de Questions associes en BD pour ce QuestionReponse.
	 * @return integer Nombre de Questions rellement associes
	 */	
	function getNbQuestions(){
		return pg_num_rows(get_question_reponse_elements($this->getId(), bool2Sql(false),$this->getType()));
	}

	/**
	 * Obtenir le nombre de Questions configures pour ce QuestionReponse.
	 * @return integer Nombre de Questions 
	 */	
	function getNbConfiguredQuestions(){
		return count($this->questions);
	}	
	
	/**
	 * Obtenir le nombre de Questions configures pour ce QuestionReponse.
	 * @return integer Nombre de Questions 
	 */	
	function getNbConfiguredObjQuestions(){
		return count($this->obj_questions);
	}	
	
	/**
	 * Obtenir les questions associes au QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement les proprit de cette Question.
	 * @return mixed Identifiant rsultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool) ou Array, la ligne rsultat si indice.
	 */
	function getQuestions($indice=0){
		$res=get_question_reponse_elements($this->getId(), bool2Sql(false),$this->getType());
		if(func_num_args()==1){
			return pg_fetch_row($res,$indice);			
		}
		else{
			return $res;
		}
	}

	/**
	 * Obtenir les objets questions associes au QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement les proprit de cette Question.
	 * @return mixed Identifiant rsultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool) ou Array, la ligne rsultat si indice.
	 */
	function &getObjQuestions($indice=0){
		if(func_num_args()==1 && $indice){
			return $this->obj_questions[$indice-1];			
		}
		else{
			return $this->obj_questions;	
		}
	}
	
	/**
	 * Obtenir les Questions configures pour ce  QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement l'identifiant de cette Questions.
	 * @return mixed Identifiant de la Questions ou array contenant tous les identifiants 
	 */	
	function getConfiguredQuestions($indice=0){
	
		if(!empty($indice)){
			return $this->questions[$indice-1];			
		}
		else{
			return  $this->questions;	
		}
	}		

	/**
	 * Obtenir les reponses associes au QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement les proprit de cette Rponse.
	 * @return integer : l'entier resultat (id int4, libelle varchar, interpretationHTML bool, question bool) ou Array, la ligne rsultat si indice.
	 */	
	function getReponses($indice=0){
		$res=get_question_reponse_elements($this->getId(), bool2Sql(true),$this->getType());
	
		if(!empty($indice)){
			
			//echo "\$indice=$indice";
			return pg_fetch_row($res,$indice-1);			
		}
		else{
			return  $res;	
		}
	}


	/**
	 * Obtenir les objets reponses associes au QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement les proprit de cette Rponse.
	 * @return integer : l'entier resultat (id int4, libelle varchar, interpretationHTML bool, question bool) ou Array, la ligne rsultat si indice.
	 */	
	function getObjReponses($indice=0){
		if(!empty($indice)){
			return $this->obj_reponses[$indice-1];			
		}
		else{
			return  $this->obj_reponses;	
		}
	}
		
	/**
	 * Obtenir les reponses configures pour ce  QuestionReponse.
	 * Si un indice est fourni en parametre, retourne uniquement l'identifiant de cette Rponse.
	 * @return mixed Identifiant de la Rponse ou array contenant tous les identifiants 
	 */	
	function getConfiguredReponses($indice=0){
	
		if(!empty($indice)){
			return $this->reponses[$indice-1];			
		}
		else{
			return  $this->reponses;	
		}
	}	
	

	/**
	 * Obtenir le nombre de Reponses associes en BD pour ce QuestionReponse.
	 * @return integer Nombre de Reponses
	 */	
	function getNbReponses(){
		return pg_num_rows(get_question_reponse_elements($this->getId(), bool2Sql(true),$this->getType()));
	}

	/**
	 * Obtenir le nombre de Reponses configures pour ce QuestionReponse.
	 * @return integer Nombre de Reponses 
	 */	
	function getNbConfiguredReponses(){
		return count($this->reponses);
	}	

	/**
	 * Obtenir le nombre de Reponses configures pour ce QuestionReponse.
	 * @return integer Nombre de Reponses 
	 */	
	function getNbConfiguredObjReponses(){
		return count($this->obj_reponses);
	}	
				
	/**
	 * Obtenir le Mdia associ  un lment du QuestionReponse.
	 * 
	 * @param integer $element Identifiant d'une question ou d'une rponse du QuestionReponse.
	 * @return integer: le resultat de la requete :(question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4)
	 */
	function getElementMedia($element){
		if(!empty($this->id)){
			return get_question_reponse_element_media($this->id, $element);
		}
		else{
			die("QuestionReponse::getElementMedia($element): Impossible d'obtenir un mdia pour un QuestionReponse sans indentifiant.");
			return null;
		}
	}

	/**
	 * Obtenir l'objet  Mdia associ  un lment du QuestionReponse.
	 * 
	 * @param integer $element Identifiant d'une question ou d'une rponse du QuestionReponse.
	 * @return object Media L'objet Media initialis selon le  QuestionReponse et l'lment spcifi.
	 */	
	function &getObjElementMedia($element){
		$res_media=	$this->getElementMedia($element);
		if( pg_num_rows($res_media)>0){
			$row=pg_fetch_row($res_media);
			if(!empty($row[0]))return new MediaQuestionReponseElement($row[0],$row[1],$row[2],$row[4],$row[5],$row[3]);
		}
		else{
			return null;
		}
	}

	/**
	 * Obtenir le Mdia associ au QuestionReponse.
	 * 
	 * @return integer Le resultat de la requete: question_reponse integer, id int4, re_id int4, hauteur integer,largeur integer
	 */	
	function getMedia(){
		return get_question_reponse_media($this->id);
	}

	/**
	 * Obtenir l'objet Mdia associ au QuestionReponse.
	 * 
	 * @return object Media L'objet Media initialis selon le  QuestionReponse.
	 */		
	function &getObjMedia(){
		$res_media=get_question_reponse_media($this->id);
		if(pg_num_rows($res_media)>0){
			$row=pg_fetch_row($res_media);
			if(!empty($row[0]))return new Media($row[1],$row[2],$row[3],$row[4]);
		}
		else{
			return null;
		}
	}
	
//	/**
//	 * Savoir si le QuestionReponse est sous forme de radio ou de checkbox
//	 * @return bool true indique un QuestionReponse radio, false un QuestionReponse checkbox
//	 */
//	function isRadio(){
//		return $this->radio=='t';
//	}
	/**
	 * Savoir si le QuestionReponse doit etre affich sous la forme de radio ou de checkbox
	 * @return boolean true indique que le QuestionReponse doit etre affich sous la forme , false sous forme de checkbox 
	 */
	 function isRadio(){
		return (bool)$this->radio;
	}
//	function isRadio(){
//		return pg_fetch_result(get_question_reponse($this->id),0,4)=='t';
//	}
	
	function setRadio($radio){
		return $this->radio=(bool)$radio;
	}
}
?>