<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition de la classe ResultatExotlcPlateforme.
 * Cet objet est requis par la mthode endCurrentEtape() de la
 * classe DoExotlcPlateforme.
 * Dfini les valeurs ncessaires  la fin de l'Etape et fourni des mthodes
 * de d'initialisation et de vrification de ces valeurs.
 * 
 * @package question_reponse
 */
class ResultatQuestionReponse extends ResultatSerie{
	
	/**
	 * @var integer[] Identifiant des Questions
	 */
	var $questions;
	
	/**
	 * @var integer[] Identifiant des Reponses
	 */	
	var $reponses;
	
	/**
	 * @var boolean[] Valeurs choisies par les stagiaires
	 */	
	var $valeurs;

	/**
	 * Constructeur.
	 * Initialise les attributs de la classe.
	 */		
	function ResultatQuestionReponse(){
		$this->questions=array();
		$this->reponses=array();
		$this->valeurs=array();
	}
	
	/**
	 * Affecter les valeurs des attributs de l'objet.
	 * @param $question integer Identifiant de la Question
	 * @param $reponse integer Identifiant de la Reponse
	 * @param $valeur integer Valeur de la rponse
	 */	
	function init($question, $reponse, $valeur){
		$this->questions[]=$question;
		$this->reponses[]=$reponse;
		$this->valeurs[]=$valeur;
	}
	
	/**
	 * Vrifie les valeurs des attributs.
	 * Cette mthode doit tre surcharge et jamais appelle.
	 * @param object QuestionReponse $question_reponse Evaluation associe au Resultat.
	 * @return boolean Retourne toujours false. 
	 */
	function verify($question_reponse){
		return false;
	}
}
?>