<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
 Fichier de fonctions plpgsql pour les question_reponse.
 Un question_reponse est un sous type d'evaluation.
 Un question_reponse est caractris par:
 	- type : integer (qcm, sondage....)
	- radio : bool (radio ou checkbox)
 Il est compos d'association de question_reponse_element
 
 @package question_reponse
 @modulegroup plpgsql
 @module plpgsql_question_reponse
*/

/**
 * Crer un question_reponse
 * @param string $libelle Le libelle du qcm
 * @param array $questions Les identifiants des questions
 * @param array $reponses Les identifiants des reponses
 * @param array $justes Les identifiants des reponses justes           
 * @param integer $theme Identifiant du theme
 * @return integer Le numero du nouveau question_reponse 
 */
function set_question_reponse($libelle, $type, $radio, $questions, $reponses,  $theme) {

	if (VERSION_BASE > VERSION) {
		$sql_questions=int_array_to_plpgsql_array($questions);
		$sql_reponses=int_array_to_plpgsql_array($reponses);
		$sql = "select * from contraintes.af_set_question_reponse('$libelle', $type, $radio, $sql_questions, $sql_reponses) ";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction set_question_reponse($libelle, $type, $radio, $questions, $reponses,  $theme) n'existe pas pour la version " .
		VERSION);

	return $res;
}

/**
 * Crer un question_reponse
 */
function set_question_reponse_deprecated($evaluation, $type, $radio) {
	//set_question_reponse(addslashes($this->libelle), $this->type, bool2Sql($this->radio), $this->questions, $this->reponses, $this->justes, $theme);

	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_set_question_reponse($evaluation, $type, $radio) ";
		$res = pg_query($sql);
	} else
		print ("La fonction set_question_reponse_deprecated($evaluation, $type, $radio) n'existe pas pour la version " .
		VERSION);

	return $res;
}

/**  
 * Obtenir les informations d'un question_reponse
 * @param integer: un numro de question_reponse
 * @return integer: le resultat de la requete :(id int4, libelle varchar, type int4, date_creation timestamp, radio bool)
 */
function get_question_reponse($question_reponse) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_question_reponse($question_reponse) as (id int4, libelle varchar, type int4, date_creation timestamp, radio bool)";
//		echo "$sql<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction get_question_reponse($question_reponse) n'existe pas pour la version " .VERSION);
	return $res;
}

/**  
 * Obtenir les questions correspondant  un question_reponse
 * @param integer: un numro de question_reponse
 * @return integer: le resultat de la requete :id int4 
 */
function get_question_reponse_questions($question_reponse) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_question_reponse_questions($question_reponse) ";
		//echo $sql."<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction get_question_reponse_question($question_reponse,$type) n'existe pas pour la version " .
		VERSION);
	return $res;
}

/**
 * Obtenir le mdia d'un question_reponse
 * @param integer: un numro de question_reponse
 * @return integer: le resultat de la requete: (question_reponse integer, id int4, re_id int4, hauteur integer,largeur integer)
 */
function get_question_reponse_media($question_reponse) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_question_reponse_media($question_reponse) as (question_reponse integer, id int4, re_id int4, hauteur integer,largeur integer)";
		$res = pg_query($sql);
	} else
		print ("La fonction get_question_reponse_media($question_reponse) n'existe pas pour la version " .
		VERSION);
	return $res;
}

/**
 * Supprime l'association d'un question_reponse_element avec un question_reponse
 * @param integer: un numro de question_reponse
 * @param integer: un numro de question_reponse_element
 * @return bool : t si la suppression s'est bien effectue, f sinon
 */
function del_question_reponse_association_element($question_reponse, $elt) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_del_question_reponse_association_element($question_reponse,$elt) ";
		//echo $sql."<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction del_question_reponse_association_element($question_reponse,$elt) n'existe pas pour la version " .
		VERSION);
	return pg_fetch_result($res, 0, 0);
}

/**
 * Ajoute une association d'un question_reponse_element avec un question_reponse
 * @param integer: un numro de question_reponse
 * @param integer: un numro de question
 * @param integer: un numro de reponse
 * @param integer: le numero de la reponse pre
 * @return bool: t si l'association  s'est bien effectue, f sinon
 */
function set_question_reponse_association_element($question_reponse, $question_reponse_element, $pere) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_set_question_reponse_association_element($question_reponse,$question_reponse_element,$pere) ";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction set_question_reponse_association_element($question_reponse,$elt) n'existe pas pour la version " .
		VERSION);
	return $res;
}

/**
    Obtenir les question_reponse_element  associs a un question_reponse
    @param integer : le numero de question_reponse
    @return integer : le resultat de la requete :(question_reponse int4, question int4, reponse int4, pere int4)
*/
function get_question_reponse_association_elements($question_reponse) {
	if (VERSION_BASE > VERSION) {
		//$sql = "select * from contraintes.af_get_question_reponse_association_elements($question_reponse) as (question_reponse int4, question int4, reponse int4, pere int4)";
		$sql = "select * from contraintes.af_get_question_reponse_association_elements($question_reponse) as (question_reponse int4, question_reponse_element int4, pere int4)";
		//echo "sql=$sql<br>";
		$res = pg_query($sql);
	} else
		print ("La fonction get_question_reponse_association_elements($question_reponse) n'existe pas pour la version " .
		VERSION);

	return $res;
}

/**
 * Obtenir le numero de la derniere rponses d'un question rponse
 * @param integer : le numero de question_reponse
 * @return integer : le numero du question_reponse_element qui est la derniere reponse
 */
function get_question_reponse_last_reponse($question_reponse) {
	if (VERSION_BASE > VERSION) {
		//$sql = "select * from contraintes.af_gen_get_last_element('contraintes.question_reponse_elements', 'reponse',' AND question_reponse=$question_reponse') ";
		//$sql = "select * from contraintes.af_gen_get_last_element('contraintes.question_reponse_elements', 'question_reponse_element',' AND question_reponse=$question_reponse and question_reponse_element in (select id from contraintes.question_reponse_element where reponse is true)') ";
		//echo $sql."<br>";
		$sql="select * from contraintes.af_get_question_reponse_last_reponse($question_reponse) as (id integer,pere integer,ind integer)";
		$res = pg_query($sql);
	} else
		print ("La fonction get_question_reponse_last_element($question_reponse, $reponse) n'existe pas pour la version " .
		VERSION);
	if(pg_num_rows($res)==1)
		return pg_fetch_result($res, 0, 0);
	else return null;
}

/**
 * Obtenir les informations des lments d'un question_reponse
 * @param integer: un numro d' lment de question_reponse
 * @param integer: le type de question_reponse
 * @param bool : question ou rponse?
 * @return integer: le resultat de la requete :(id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
 */
function get_question_reponse_elements_infos($question_reponse, $type, $is_reponse){
	if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_question_reponse_elements_infos($question_reponse, $type, $is_reponse) as (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)";
   		 //echo "$sql<br>";
   		 $res=pg_query($sql);
    }
    else
        print("La fonction  get_question_reponse_elements_infos_old($question_reponse, $type, $is_reponse) n'existe pas pour la version ".VERSION);
    return $res;	
}

function get_question_reponse_elements_old($question_reponse,  $is_reponse,$type){
	if($is_reponse=='TRUE'){
		return get_positionnement_choix($question_reponse,$type);
	}else{
		return get_positionnement_questions($question_reponse,$type);
	}
}
/**
 * Obtenir les informations des lments d'un question_reponse.
 * NB: L'indice est toujours null pour les rponses.
 * @param integer $question_reponse un numro d' lment de question_reponse
 * @param bool $is_reponse question ou rponse?
 * @return integer: le resultat de la requete :(id int4,libelle varchar,interpretation_html bool,type int4, reponse bool, indice integer)
 */
function get_question_reponse_elements($question_reponse,  $is_reponse,$type=0){
	
	//echo "$question_reponse,  $is_reponse,$type<br>";
	if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_question_reponse_elements($question_reponse,$is_reponse) AS (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool, indice integer)";
//   		 echo "$sql<br>";
   		 $res=pg_query($sql);
    }
    else{
        $res=get_question_reponse_elements_old($question_reponse,  $is_reponse,$type);
    }
    return $res;	
}

/**
 * Obtenir les informations des choix d'un question_reponse
 * @param integer: un numro d' lment de question_reponse
 * @return integer: le resultat de la requete :(id int4,libelle varchar, interpretation_html bool, question_reponse int4, bareme int4, pere int4, media int4, hauteur int4, largeur int4)
 */
function get_question_reponse_choixx($question_reponse){
	if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_question_reponse_choix($question_reponse) as (id integer,libelle varchar, interpretation_html bool, question_reponse integer, bareme integer, pere integer, media integer, hauteur integer, largeur integer)";
//   		 echo "$sql<br>";
   		 $res=pg_query($sql);
    }
    else
        print("La fonction  get_question_reponse_choixx($question_reponse) n'existe pas pour la version ".VERSION);
    return $res;	
}

/**
 * Associer un nouveau choix  un question_reponse.
 * @param integer : le numero du question_reponse
 * @param integer : le numero du choix
 * @param integer : le numero d'ordre du choix
 * @param integer : le numero du bareme
 * @param integer : le numero du media
 * @param integer : la hauteur du media
 * @param integer : la largeur du media
 * @return bool : TRUE ou FALSE selon que l'association se soit bien passe ou non 
 */
function set_question_reponse_choix($question_reponse, $choix, $ordre, $bareme, $media, $hauteur, $largeur) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_question_reponse_choix($question_reponse,  $choix,  $ordre, $bareme, $media, $hauteur, $largeur)";
//		echo $sql."<br>";
		return pg_fetch_result(pg_query($sql),0,0)=='t';
	} else
		return set_question_reponse_choix_old($question_reponse, $choix, $ordre, $bareme, $media, $hauteur, $largeur);
}

/**
 * Mettre a jour l'association d'un choix d'un question_reponse.
 * @param integer $question_reponse le numero du question_reponse
 * @param integer $choix le numero du choix a modifier
 * @param integer $new_choix le numero du nouveau choix
 * @param integer $bareme le numero du bareme
 * @param integer $media le numero du media
 * @param integer $hauteur la hauteur du media
 * @param integer $largeur la largeur du media
 * @return boolean  true ou false selon que la modification se soit bien passe ou non 
 */
function maj_question_reponse_choix($question_reponse, $choix, $new_choix, $bareme, $media, $hauteur, $largeur) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_question_reponse_choix($question_reponse, $choix,  $new_choix, $bareme, $media, $hauteur, $largeur)";
		//echo $sql."<br>";
		return pg_fetch_result(pg_query($sql),0,0)=='t';
	} else
		return maj_question_reponse_choix_old($question_reponse, $choix, $new_choix, $bareme, $media, $hauteur, $largeur);
}


/**
 * Supprime un choix d'un question_reponse.
 * @param integer : le numero du question_reponse
 * @param integer : le numero du choix
 * @return bool: TRUE ou FALSE selon que la suppression se soit bien pass ou non
 */
function del_question_reponse_choix($question_reponse, $choix) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_question_reponse_choix($question_reponse, $choix) ";
//		echo $sql . "<br>";
		$result = pg_fetch_result(pg_query($sql),0,0)=='t';
	} else
		$result = del_question_reponse_choix_old($question_reponse, $choix);
	return $result;
}

/**
 * Obtenir les rponses d'un question_reponse et savoir si elles sont justes ou fausses
 * @see get_question_qcm_solution($question, $reponse).
 * @param integer: le numero de qcm
 * @return integer :(question_reponse int4, question int4,reponse int4 ,juste bool )
 */
function get_question_reponse_solutions($question_reponse) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_question_reponse_solutions($question_reponse) AS (question_reponse int4, question int4,reponse int4 ,juste bool ) ";
//		echo "sql=$sql<br>";
		$res = pg_query($sql);
		return $res;
	} else
		print ("La fonction get_question_reponse_solutions($question_reponse) n'existe pas pour la version ".VERSION );
}
?>