<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de d�finition de la classe Question

La connexion � la base de donn�es doit �tre $db

@package question_reponse_element
*/
class QuestionReponseElement extends Element{

    /**
    * @var object Media : le m�dia associ� au QuestionReponseElement
    */
    var $media ;

    /**
    * @var boolean  interpr�tation html
    * 1 pour oui et 0 pour non
    */
    var $interpretationHTML;
    
    /**
     * @var integer Type de la Question
     */
    var $type;

    /**
    * Constructeur de la classe QuestionReponseElement
    * @param integer $id identifiant de l'enregistrement en BD
    * @param string $libelle Libell�
    * @param integer $type Type du QuestionReponseElement
    * @param integer $interpretationHTML Interpr�tation html
    * @param object Media  $media Media du QuestionReponseElement
    */
    function QuestionReponseElement($id=0, $libelle="QuestionReponseElement", $type=0, $interpretationHTML=true,$media=null){
    	messageDebug("QuestionReponseElement::QuestionReponseElement($id, $libelle, $type, $interpretationHTML, \$media)");
    	if(func_num_args()==1){
    		$res=get_question_reponse_element($id);
    		$row=pg_fetch_row($res);
    		$libelle=$row[1];
    		
    		$interpretationHTML=sql2Bool($row[2]);
    		$type=$row[3];
    	}
    	
    	parent::Element($id,$libelle);
		$this->initQuestionReponseElement($interpretationHTML,$type, $media);
    }

	/**
	 * @param integer $interpretationHTML Interpr�tation html
	 * @param integer $type Type du QuestionReponseElement
     * @param object Media  $media Media du QuestionReponseElement
     */
 	function initQuestionReponseElement($interpretationHTML,$type,  $media){
 	
		$this->interpretationHTML=(bool)$interpretationHTML;
		$this->type=$type;
		$this->media=$media ;	
 	}

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * V�rifie la validit� des donn�es avant une insertion en base.
	 * Appel de la m�thode verify() et v�rifie les attributs propres aux classes h�rit�s.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est compl�t�e avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donn�es sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=QuestionReponseElement::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * V�rifie la validit� des donn�es avant une mise � jour de la base.
	 * Appel la m�thode verify() et v�rifie les attributs propres aux classes h�rit�s.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est compl�t�e avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donn�es sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate($message);
		$verif=QuestionReponseElement::verify($message);
		
		return $res_parent && $verif && true;
	}
	
	/**
	 * V�rifie la validit� des donn�es propres � l'objet.
	 * La date de cr�ation doit �tre nulle et le type non null.
	 * @param string &$message En cas d'erreur, cette variable est compl�t�e avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donn�es sont correctes, false si non.
	 */
	function verify(&$message){
		$attributs_ok=true;
//		if(!empty($this->date_creation)){
//			$message.="[date_creation]";
//			$attributs_ok=false;	
//		}
		if(!(is_numeric($this->type))||empty($this->type)){
			$message.="[type]";
			$attributs_ok=false;	
		}
		if(!is_bool($this->interpretationHTML)){
			$message.="[interpretationHTML]";
			$attributs_ok=false;	
		}
//		if(!is_int($this->media)){
//			$message.="[media]";
//			$attributs_ok=false;	
//		}	
		return $attributs_ok;
	}

	/**
	* Fonction qui ins�re la Question en base.
	* Affecte l'identifiant de la Question.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre la Question
	* @param string &$message En cas d'erreur, cette variable est compl�t�e avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant de la Question cr�� ou false
	*/
	function insertToDB($theme, &$message) {
//		if ((!empty ($this->libelle)) && (!empty ($this->type))) {
//			//traitement des variables
//			$lib = addslashes($this->libelle);
//			$html = "FALSE";
//	
//			//insertion
//			if (VERSION_BASE > VERSION) {
//				$insertion = set_question_reponse_element($lib, $html,'FALSE', $this->num_theme);
//			} else {
//	
//				if ($this->type == get_evaluation_type_old_new('q')||$this->type == get_evaluation_type_old_new('m')) {
//					$insertion = set_reponse_qcm($lib, $html, $this->num_theme);
//				} else
//					if ($this->type == get_evaluation_type_old_new('s')||$this->type == get_evaluation_type_old_new('o')) {
//						$insertion = set_proposition_sondage($lib, $html, $this->num_theme);
//					}
//	
//			}
//			if(empty($insertion)){
//				die("Erreur lors de l'insertion de la Question<br>");
//			}
//			$this->id=$insertion;
//			return $insertion;
//	
//		} else {
//			echo "Insertion Question impossible : mauvais attributs d'objet:".$this->libelle.",".$this->type."<br>";
//			return false;
//		}
		if(QuestionReponseElement::verifyInsert(&$message)){
			$this->id = set_question_reponse_element(addslashes($this->libelle), bool2Sql($this->interpretationHTML),$this->type, bool2Sql(false), $this->num_theme);
			return $this->id;
		}
		else{
			return false;
		}		
	}


	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle", "interpretationHTML");
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "interpretationHTML":
				return Array(true, false);
			default:
				return null;
		}
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

    function isInterpretationHTML() { return $this->interpretationHTML ; }
    function setInterpretationHTML($interpretationHTML) { $this->interpretationHTML=(bool)$interpretationHTML ; }
    function getMedia() { return $this->media ; }
    function &setMedia($obj_media) { $this->media=$obj_media ; }
    //-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	function getType(){
		return $this->type;
	}
}
?>