<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 Fichier de fonctions plpgsql pour les question_reponse_element.
 Un question_reponse_element compose les question_reponse
 Un question_reponse_element peut etre une question ou une rponse.
 
 @package question_reponse_element
 @modulegroup plpgsql
 @module plpgsql_question_reponse_element
*/

/**
 * Crer un lment de question_reponse
 * @param string $libelle le libelle de l'lment de question_reponse
 * @param bool: interpretation html sur le libell ?
 * @param integer $interpretation_html type de question_reponse_element (qcm, sondage...)
 * @param bool $reponse le question_reponse_element est-il une rponse?
 * @param integer $theme Identifiant du Thme.
 * @return integer Le numero du nouvel enregistrement
 */
function set_question_reponse_element($libelle, $interpretation_html ,$type , $reponse, $theme=""){
	if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_set_question_reponse_element('$libelle', $interpretation_html ,$type , $reponse)";
   		//echo "sql=$sql<br>";
   		$res=pg_query($sql);
   		$id=pg_fetch_result($res, 0,0);
   		if(!empty($theme))set_categorie_element_theme(17, $theme, $id);
    }
    else
        print("La fonction set_question_reponse_element($libelle, $interpretation_html ,$type , $reponse) n'existe pas pour la version ".VERSION);
    return $id;	
}

/**
 * Obtenir les informations d'un lment de question_reponse
 * @param integer $elt un numro d' lment de question_reponse
 * @return integer: le resultat de la requete :(id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
 */
function get_question_reponse_element($elt){
	if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_question_reponse_element($elt) as (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)";
  		 //echo "$sql<br>";
   		 $res=pg_query($sql);
    }
    else
        print("La fonction get_question_reponse_element($elt) n'existe pas pour la version ".VERSION);
    return $res;	
}

/**
 * Supprimer un lment de question_reponse
 * @param integer $elt le numero de l'lment de question_reponse
 * @return bool  true si la mise a jour a t correctement effectu, false sinon.
 */
function del_question_reponse_element($elt) {
	if (VERSION_BASE > VERSION) {
        $sql="select * from contraintes.af_del_question_reponse_element($elt)";
       	//echo "$sql<br>";
        $res=pg_query($sql);
	} else
		print("La fonction del_question_reponse_element($question_reponse, $elt) n'existe pas pour la version ".VERSION);
		
	return pg_fetch_result($res,0,0);
}

/**
 * Obtenir le mdia d'un lment de question_reponse
 * @param integer $qr un numro de question_reponse
 * @param integer $elt un numro d' lment de question_reponse (facultatif)
 * @return integer le resultat de la requete :(question_reponse int4, question_reponse_element int4, media int4, libelle varchar, hauteur int4, largeur int4)
 */
function get_question_reponse_element_media($qr, $elt=0){
	if(VERSION_BASE>VERSION){
        if(func_num_args() == 2){
        	$sql="select * from contraintes.af_get_question_reponse_element_media($qr,$elt) AS (question_reponse int4, question_reponse_element int4, media int4, libelle varchar, hauteur int4, largeur int4)";
        }
        else{
        	$sql="select * from contraintes.af_get_question_reponse_element_media($qr) AS (question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4)";
        }
   		//echo "$sql<br>";
   		$res=pg_query($sql);
    }
    else
        print("La fonction get_question_reponse_element_media($qr,$elt) n'existe pas pour la version ".VERSION);
    return $res;	
}

/**
    Mettre  jour un lment de question_reponse

    @param integer : le numero de l' lment de question_reponse
    @param string  : le libelle de l' lment de question_reponse
    @param bool: interpretation html sur le libell ?
    @return bool : t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_question_reponse_element($elt,$libelle, $interpretation_html){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_maj_question_reponse_element($elt, '$libelle', $interpretation_html)";
        //echo "$sql<br>";
        $res=pg_query($sql);
    }
    else
        print("La fonction maj_question_reponse_element($elt,$libelle, $interpretation_html) n'existe pas pour la version ".VERSION);
   
    return pg_fetch_result($res,0,0)=='t';
}


/**
    Mettre  jour le media d'un lment de question_reponse
    @param integer : le numero de question_reponse
    @param integer : le numero de l' lment de question_reponse
    @param integer : le numero de mdia 
    @param integer : largeur media 
    @param integer : hauteur media 
    @return bool : true si la mise a jour a t correctement effectu, false sinon.
*/
function maj_question_reponse_element_media($question_reponse,$elt, $media, $largeur, $hauteur) {
	if (VERSION_BASE > VERSION) {
        $sql="select * from contraintes.af_maj_question_reponse_element_media($question_reponse,$elt, $media, $largeur, $hauteur)";
//      	echo "$sql<br>";
        $res=pg_query($sql);
	} else
		print("La fonction maj_question_reponse_element_media($elt, $media, $largeur, $hauteur) n'existe pas pour la version ".VERSION);
		
	return pg_fetch_result($res,0,0);
}

/**
    Supprimer le media d'un lment de question_reponse
    @param integer : le numero de l' lment de question_reponse
    @param integer : le numero de question_reponse
    @return bool : true si la mise a jour a t correctement effectu, false sinon.
*/
function del_question_reponse_element_media($question_reponse,$elt) {
	if (VERSION_BASE > VERSION) {
        $sql="select * from contraintes.af_del_question_reponse_element_media($question_reponse,$elt)";
       	//echo "$sql<br>";
        $res=pg_query($sql);
	} else
		print("La fonction del_question_reponse_element_media($question_reponse, $elt) n'existe pas pour la version ".VERSION);
		
	return pg_fetch_result($res,0,0);
}

/**
    Associer un media  un lment de question_reponse
    @param integer $question_reponse le numero de question_reponse
    @param integer $elt le numero de l' lment de question_reponse
    @param integer $media le numero de mdia 
    @param integer $hauteur hauteur media 
    @param integer $largeur largeur media 
    @return bool true si le traitement est un succs, false sinon.
*/
function set_question_reponse_element_media($question_reponse, $elt, $media, $hauteur, $largeur) {
	if (VERSION_BASE > VERSION) {
        $sql="select * from contraintes.af_set_media_question_reponse_element($question_reponse, $elt, $media, $hauteur,$largeur)";
       	//echo "$sql<br>";
        $res=pg_query($sql);
	} else
		print("La fonction set_question_reponse_element_media($elt, $media, $largeur, $hauteur) n'existe pas pour la version ".VERSION);
		
	return pg_fetch_result($res,0,0)=='t';
}

/**
    Obtenir les valuations (question_reponse) qui utilisent un question_reponse_element
    @param integer : le numero de l' lment de question_reponse
    @return integer: le resultat de la requete :(evaluation int4)
*/
function get_question_reponse_element_evaluations($elt){
	if (VERSION_BASE > VERSION) {
	    $sql="select * from contraintes.af_get_question_reponse_element_evaluations($elt) AS (evaluation int4, libelle varchar, type int4)";
        //echo "$sql<br>";
        $res=pg_query($sql);
	} else
		print("La fonction get_question_reponse_element_evaluations($elt) n'existe pas pour la version ".VERSION);
	return $res;
}

?>