<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

@package question_sondage
@modulegroup plpgsql
@module plpgsql_question_sondage
*/

/**
    Vrifie qu'une question de sondage est unique pour un thme donn (OLD)

    @param integer : le numro du thme
    @param string : le libelle de la question
    @return integer : 1 existe, 0 sinon
*/
function check_question_sondage_old($theme,$libelle){
    $sql="select * from question_sondage where theme=$theme and libelle_question='$libelle'";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    return 1;
}
/**
    Vrifie qu'une question de sondage est unique pour un thme donn

    @param integer : le numro du thme
    @param string : le libelle de la question
    @return integer : 1 existe, 0 sinon
*/
function check_question_sondage($theme,$libelle){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_question_sondage_old($theme,$libelle);
    return $res;
}

/**
    Obtenir les infos d'une question (OLD)

    @param integer : le numro de la question
    @return integer : le rsultat de la requte
*/
function get_question_sondage_infos_old($question){
    $sql="select * from question_sondage where num_sondage=$question";
    //echo "$sql";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'une rponse

    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte :(id int4,libelle varchar,inter_html bool)
*/
function get_question_sondage_infos($question){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_question($question) as (id int4,libelle varchar,inter_html bool)";
        $res=pg_query($sql);
    }
    else
        $res=get_question_sondage_infos_old($question);
    return $res;
}

/**
    Obtenir les infos et media d'une question de sondage(OLD)

    @param integer : le numro de la question
    @return integer : le rsultat de la requte
*/
function get_question_sondage_infos_media_old($question){
    $sql="select * from question_sondage,ficmediaqcm  where num_sondage=$question and qmedia=num_fic";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos et media d'une question de sondage

    @param integer : le numro de la question
    @return integer : le rsultat de la requte
*/
function get_question_sondage_infos_media($question){
    if(VERSION_BASE>VERSION){

    }
    else
        $res=get_question_sondage_infos_media_old($question);
    return $res;
}

/**
    Enregistre une nouvelle question de sondage (OLD)

    @param string : le libelle de la question
    
    @param integer : le numro du theme
    @param integr : le numero de media
    @param integer : la largeur
    @param integer ; la hauteur
    @param char : le type de sondage
    @param bool : interpretation html
    @return integer : le numro de la nouvelle question
*/
function set_question_sondage_old($libelle, $theme,$media,$largeur,$hauteur,$typesondage,$inter_html){
    //$existe_deja=check_question($theme,$libelle);
    //if(!$existe_deja){
        $sql="insert into question_sondage (question,theme,qmedia,largeur,hauteur,type_sondage,inter_html)
                values('$libelle',$theme,$media,$largeur,$hauteur,'$typesondage',$inter_html);";
        //echo "$sql<br>";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $sql="select num_sondage from question_sondage where oid=$oid";
        $res=pg_query($sql);
        $row=pg_fetch_row($res,0);
        return $row[0];
    //}
    //return 0;
}
/**
    Enregistre une nouvelle question de sondage

    @param string : le libelle de la question
    
    @param integer : le numro du theme
    @param integr : le numero de media
    @param integer : la largeur
    @param integer ; la hauteur
    @param char : le type de sondage
    @param bool : interpretation html
    @return integer : le numro de la nouvelle question
*/
function set_question_sondage($libelle, $theme,$media,$largeur,$hauteur,$typesondage,$inter_html){
    if(VERSION_BASE>VERSION){
		$num=set_question_reponse_element($libelle,$inter_html,2,'FALSE');
        $sql="select contraintes.af_set_categorie_element_theme(17,$theme,$num)";
		$res=pg_query($sql);
        return $num;
    }
    else
        $res=set_question_sondage_old($libelle,$theme,$media,$largeur,$hauteur,$typesondage,$inter_html);
    return $res;
}

/**
    Obtenir le numero d'une rponse (OLD)
	@deprecated cette fonction est inutile, les doublons sont possibles
    @param string : le libelle de la question
    @param integer : le numro du theme
    @param integer : le resultat de la requete
*/
/*
function get_question_numero_old($libelle,$theme){
    $sql="select num_question from question where theme='$theme' and libelle_question='$libelle'";
    $res=pg_query($sql);
    return $res;
}
*/
/**
    Obtenir le numero d'une rponse
@deprecated cette fonction est inutile, les doublons sont possibles
    @param string : le libelle de la question
    @param integer : le numro du theme
    @param integer : le resultat de la requete
*/
/*
function get_question_numero($libelle,$theme){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_question_numero_old($libelle,$theme);
    return $res;
}
*/
/**
    Mettre  jour une question de sondage  (OLD)

    @param integer : le numero de question
    @param string  : le libelle de la question
    @return integer : 1
*/
function maj_question_sondage_old($question,$libelle,$media,$largeur,$hauteur,$inter_html){
    $sql="update question_sondage set question='$libelle',qmedia='$qphoto',largeur='$largeur',hauteur='$hauteur',inter_html='$inter_html' where num_sondage=$question";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre  jour un libelle de question

    @param integer : le numero de question
    @param string  : le libelle de la question
    @return integer : 1
*/
function maj_question_sondage($question,$libelle,$media,$largeur,$hauteur){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_question_sondage_old($question,$libelle,$media,$largeur,$hauteur);
    return $res;
}

/**
	Mettre  jour le libelle d'une question de sondage (OLD)
	
	@param integer  : le numero de question
    @param string  : le libelle de la question
    @return integer : le resultat de la requete
*/
function maj_question_sondage_libelle_old($question,$libelle){
	$sql="update question_sondage set question='$libelle' where num_sondage=$question";
	return pg_query($sql);
}
/**
	Mettre  jour le libelle d'une question de sondage 
	
	@param integer  : le numero de question
    @param string  : le libelle de la question
    @return integer : le resultat de la requete
*/
function maj_question_sondage_libelle($question,$libelle){
	 if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_question_sondage_libelle_old($question,$libelle);
    return $res;
}

/**
	Obtenir les infos d'une question de sondage (OLD)
	
	@param integer : le numero de la question
	@return integer : le resultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4,reponse bool)
*/
function get_question_sondage_question_sondage_old($question){
	$sql="select num_sondage,question,inter_html,type_sondage,'FALSE' from question_sondage where num_sondage=$question";
	return pg_query($sql);
}
/**
	Obtenir les infos d'une question de sondage 
	
	@param integer : le numero de la question
	@return integer : le resultat de la requete (id int4,libelle varchar,interpretation_html bool,type int4,reponse bool)
*/
function get_question_sondage_question_sondage($question){
		if(VERSION_BASE>VERSION){
			 $res=get_question_reponse_element($question);
		}
		else
			$res=get_question_sondage_question_sondage_old($question);
		return $res;
}

/**
	Obtenir les serie qui utilisent une question de sondage
	
	@param integer : le numero de question de sondage
	@return integer : le resultat de la requete (id_serie int4,id_eval int4) 
*/
function get_question_sondage_sondage_series_old($question){
	$res=get_evaluation_series($question,'s');
	return $res;
}
 /**
	Obtenir les serie qui utilisent une question de sondage
	
	@param integer : le numero de question de sondage
	@return integer : le resultat de la requete (id_serie int4,id_eval int4) 
*/
function get_question_sondage_sondage_series($question){
	if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		// On test si une association question / sondage est unique
		//  l'avenir une question pourra tre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondages, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		$res=get_evaluation_series($evaluation);
	
	}
	else
		$res=get_question_sondage_sondage_series_old($question);
	return $res;
}

/**
	Obtenir les propositions d'une question de sondage (old)
	@param integer : le numero de la question
	@return integer : le resultat de la requete (question_reponse int4,question int4,reponse int4,pere int4)
*/
function get_question_sondage_sondage_associations_old($question){
	$sql="select distinct num_sondage,num_sondage,num_proposition,ordre from proposition_sondage where num_sondage=$question";
	return pg_query($sql);

}
/**
	Obtenir les propositions d'une question de sondage 
	@param integer : le numero de la question
	@return integer : le resultat de la requete (question_reponse int4,question int4,reponse int4,pere int4)
*/
function get_question_sondage_sondage_associations($question){
	if(VERSION_BASE>VERSION){
		// recup le numero d'valuation
		$evaluations=get_question_reponse_element_evaluations($question);
		// On teste si une association question / sondage est unique
		//  l'avenir ,une question pourra ter utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondages,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
//		echo "eval=$evaluation<br>";
		$res=get_sondage_propositions($question);
	}
	else{
		$res=get_question_sondage_sondage_associations_old($question);
		//$res=get_sondage_propositions($question);
	}
	return $res;
}

/**
    Obtenir les infos des propositions d'une question de sondage (OLD)

    @param integer : le numro de la question de sondage
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_sondage_propositions_infos_old($question){
		$sql = "SELECT P.num_prop, P.libelle_prop, P.inter_html, 's', 'TRUE' 
			FROM proposition_sondage PS, proposition P 
			WHERE PS.num_sondage=$question
			AND P.num_prop=PS.num_proposition"; 
	return pg_query($sql);

}

/**
    Obtenir les infos des propositions d'une question de sondage 

    @param integer : le numro de la question de sondage
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_sondage_propositions_infos($question){
	if(VERSION_BASE>VERSION){
		// recup le numero d'valuation
		$evaluations=get_question_reponse_element_evaluations($question);
		// On teste si une association question / sondage est unique
		//  l'avenir ,une question pourra ter utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondages,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		$res=get_sondage_propositions_infos($evaluation);
	}
	else{
		$res=get_question_sondage_propositions_infos_old($question);
		//$res=get_sondage_propositions($question);
	}
	return $res;
}
/**
	Obtenir l'indice de la derniere proposition d'une question de sondage (OLD)
	@note : cette fonction est spcifique  l'ancienne version de la base
	@param integer : le numero de la question
	@return integer : le numero du question_reponse_element qui est la derniere reponse
*/
function get_question_sondage_sondage_last_proposition_old($question){
	$sql="select max(ordre) from proposition_sondage where num_sondage=$question";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0);
}
/**
	Obtenir l'indice de la derniere proposition d'une question de sondage 
	@note : cette fonction est spcifique  l'ancienne version de la base
	@param integer : le numero de la question
	@return integer : le numero du question_reponse_element qui est la derniere reponse
*/
function get_question_sondage_sondage_last_proposition($question){
	if(VERSION_BASE>VERSION){
		// recup le numero d'valuation
		$evaluations=get_question_reponse_element_evaluations($question);
		// On teste si une association question / sondage est unique
		//  l'avenir ,une question pourra ter utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondages,ce qui n'est pas permis dans la version actuelle de la plateforme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return get_question_reponse_last_reponse($evaluation);
	}
	else
		$res=get_question_sondage_sondage_last_proposition_old($question);
	return $res;
}

/**
	Crer une proposition de sondage et l'associer  une question (OLD)
	@param integer : le numero de la question
	@param string : le libelle de la proposition
	@param bool : interprtation html ?
	@param integer : le theme
	@param integer : l'indice pour l'ordre de la proposition
	@return integer : le numero du nouvel enregistrement
*/
function set_question_sondage_sondage_proposition_old($question,$libelle,$html,$theme,$ordre){
	// cration proposition
	$proposition=set_proposition_sondage($libelle,$html,$theme);
	// enregistre l'association et la proposition  la question
	$sql="insert into proposition_sondage(num_sondage,num_proposition,ordre) values($question,$proposition,$ordre)";
	$res=pg_query($sql);
	return $proposition;
}
 /**
	Crer une proposition de sondage et l'associer  une question 
	@param integer : le numero de la question
	@param string : le libelle de la proposition
	@param bool : interprtation html ?
	@param integer : le theme
	@param integer : l'indice pour l'ordre de la proposition
	@return integer : le numero du nouvel enregistrement
*/
function set_question_sondage_sondage_proposition($question,$libelle,$html,$theme,$pere){
	if(VERSION_BASE>VERSION){
		$evaluations=get_question_reponse_element_evaluations($question);
		// on test si une association question / sondage est unique
		//  l'avenir ,un question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		// cre la proposition
		$id=set_proposition_sondage($libelle,$html,$theme);
		// enregistre l'association
		set_question_reponse_association_element($evaluation,$id,$pere);
		return $id;
	
	}
	else
		return set_question_sondage_sondage_proposition_old($question,$libelle,$html,$theme,$pere);
}

/**
	Associe une proposition  une question de sondage (OLD)
	@param integer : le numero de la question
	@param integer : le numero de la proposition
	@param integer : la question de sondage pere pour l'ordre
	@return bool : t si association OK,f sinon
*/
function set_question_sondage_sondage_association_proposition_old($question,$proposition,$pere){
	$sql="insert into proposition_sondage (num_sondage,num_proposition,ordre) values($question,$proposition,$pere)";
	return pg_query($sql);

}
/**
	Associe une proposition  une question de sondage 
	@param integer : le numero de la question
	@param integer : le numero de la proposition
	@param integer : la question de sondage pere pour l'ordre
	@return bool : t si association OK,f sinon
*/
function set_question_sondage_sondage_association_proposition($question,$proposition,$pere){
	if(VERSION_BASE>VERSION){
		// recup du numero d'evaluation
		$evaluations=get_question_reponse_element_evaluations($question);
		// on test si une association question / sondage est unique
		//  l'avenir ,un question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		// enregistre l'association
		
		return set_question_reponse_association_element($evaluation,$proposition,$pere);
	}
	else
		return set_question_sondage_sondage_association_proposition_old($question,$proposition,$pere);
}

/**
	Supprime le media d'une question de sondage (OLD)
	@param integer : le numero de la question
	@return bool : t si suppression ok, f sinon
*/
function del_question_sondage_question_sondage_media_old($question){
	$sql="update question_sondage set qmedia=NULL,largeur=NULL,hauteur=NULL where num_sondage=$question";
	$res=pg_query($sql);
	return $res;
}
 /**
	Supprime le media d'une question de sondage
	@param integer : le numero de la question
	@return bool : t si suppression ok, f sinon
*/
function del_question_sondage_question_sondage_media($question){
	if(VERSION_BASE>VERSION){
		// recup du numero d'evaluation
		$evaluations=get_question_reponse_element_evaluations($question);
		// on test si une association question / sondage est unique
		//  l'avenir ,un question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return del_question_reponse_element_media($evaluation,$question);
	}
	else
		return del_question_sondage_question_sondage_media_old($question);
}

/**
	Mettre  jour le media d'une question de sondage (OLD)
	@param integer : le numero de la question
	@param integer : le numero du media
	@param integer : la largeur en pixel du media
	@param integer : la hauteur en pixel du media
	@return bool : t si maj ok, f sinon
*/
function maj_question_sondage_question_sondage_media_old($question,$media,$largeur,$hauteur){
	$sql="update question_sondage set qmedia=$media,largeur=$largeur,hauteur=$hauteur where num_sondage=$question";
	//echo "$sql<br>";
	return pg_query($sql);
}
/**
	Mettre  jour le media d'une question de sondage
	@param integer : le numero de la question
	@param integer : le numero du media
	@param integer : la largeur en pixel du media
	@param integer : la hauteur en pixel du media
	@return bool : t si maj ok, f sinon
*/
function maj_question_sondage_question_sondage_media($question,$media,$largeur,$hauteur){
	if(VERSION_BASE>VERSION){
		// recup du numero d'evaluation
		$evaluations=get_question_reponse_element_evaluations($question);
		// on test si une association question / sondage est unique
		//  l'avenir ,un question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		$res=maj_question_reponse_element_media($evaluation,$question,$media,$largeur,$hauteur);
	}
	else
		$res=maj_question_sondage_question_sondage_media_old($question,$media,$largeur,$hauteur);
	return $res;
}

/**
	Affecter un media  une question de sondage (OLD)
	@param integer : le numero de la question
	@param integer : le numero du media
	@param integer : la largeur en pixel du media
	@param integer : la hauteur en pixel du media
	@return bool : t si maj ok, f sinon
*/
function set_question_sondage_question_sondage_media_old($question,$media,$largeur,$hauteur){
	$sql="update question_sondage set qmedia=$media,largeur=$largeur,hauteur=$hauteur where num_sondage=$question";
	$res=pg_query($sql);
	return $res;
}
/**
	Affecter un media  une question de sondage 
	@param integer : le numero de la question
	@param integer : le numero du media
	@param integer : la largeur en pixel du media
	@param integer : la hauteur en pixel du media
	@return bool : t si maj ok, f sinon
*/
function set_question_sondage_question_sondage_media($question,$media,$largeur,$hauteur){
	 if(VERSION_BASE>VERSION){
		// recup du numero d'evaluation
		$evaluations=get_question_reponse_element_evaluations($question);
		// on test si une association question / sondage est unique
		//  l'avenir ,un question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return set_question_reponse_element_media($evaluation,$question,$media,$largeur,$hauteur);
	 }
	 else
		$res=set_question_sondage_question_sondage_media_old($question,$media,$largeur,$hauteur);
	 return $res;
}

/**
	Mettre  jour une question de sondage (OLD)
	@param integer : le numero de la question
	@param string : le lebelle de la question
	@param bool : interprtation html ?
	@return bool : t si maj ok, f sinon
*/
function maj_question_sondage_question_sondage_old($question,$libelle,$inter_html){
	$sql="update question_sondage set question='$libelle',inter_html='$inter_html' where num_sondage=$question";
	$maj=pg_query($sql);
	return $maj;

}
/**
	Mettre  jour une question de sondage (OLD)
	@param integer : le numero de la question
	@param string : le libelle de la question
	@param bool : interprtation html ?
	@return bool : t si maj ok, f sinon
*/
function maj_question_sondage_question_sondage($question,$libelle,$inter_html){
	if(VERSION_BASE>VERSION){
		$res=maj_question_reponse_element($question,$libelle,$inter_html);
	}
	else
		$res=maj_question_sondage_question_sondage_old($question,$libelle,$inter_html);
	return $res;
}

/**
	Obtenir le media d'une question de sondage (OLD)
	@param integer : numero question
	@return integer : resultat requete (question_reponse int4,question_reponse-element int4,media int4,flash int4,largeur int4,hauteur int4)
*/
function get_question_sondage_question_sondage_media_old($question){
	$sql="select num_sondage,num_sondage,  qmedia,NULL,largeur,hauteur from question_sondage 
				where num_sondage=$question";
	return pg_query($sql);
}
/**
	Obtenir le media d'une question de sondage 
	@param integer : numero question
	@return integer : resultat requete (question_reponse int4,question_reponse-element int4,media int4,flash int4, largeur int4,hauteur int4)
*/
function get_question_sondage_question_sondage_media($question){
	if(VERSION_BASE>VERSION){
		return get_question_reponse_element_media($question);
	}
	else
		$res=get_question_sondage_question_sondage_media_old($question);
	return $res;
}

/**
	Obtenir les infos d'une question de sondage (OLD)
	@param integer : numero de question
	@return integer : resultat requete (id int4,type int4 radio bool)
*/
function get_question_sondage_sondage_old($question){
	$sql="select num_sondage,2,TRUE from question_sondage where num_sondage=$question and 
			type_sondage='r' union  select num_sondage,2,FALSE from question_sondage where num_sondage=$question and 
			type_sondage='c' or type_sondage is NULL";
	return pg_query($sql);
}
/**
	Obtenir les infos d'une question de sondage 
	@param integer : numero de question
	@return integer : resultat requete (id int4,type int4 radio bool)
*/
function get_question_sondage_sondage($question){
	if(VERSION_BASE>VERSION){
		// recup du numero d'evaluation
		$evaluations=get_question_reponse_element_evaluations($question);
		// on test si une association question / sondage est unique
		//  l'avenir ,un question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		return get_sondage($evaluation);
	}
	else
		$res=get_question_sondage_sondage_old($question);
	return $res;
}

/**
	Mettre  jour le libelle d'une valuation 
	@param integer : numero question
	@param string : libelle
	@return integer : l'identifiant de la nouvelle evaluation
*/
function maj_question_sondage_evaluation($question,$libelle){
	if(VERSION_BASE>VERSION){
		// recup du numero d'evaluation
		$evaluations=get_question_reponse_element_evaluations($question);
		// on test si une association question / sondage est unique
		//  l'avenir ,un question pourra etre utilise par plusieurs sondages
		if(pg_num_rows($evaluations)>1)
			print("Erreur : Une question est utilise par plusieurs sondage,ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation=pg_fetch_result($evaluations,0,0);
		$sql="select * from contraintes.af_maj_evaluation($evaluation,'$libelle')";
		$res=pg_query($sql);
	}
	else
		print("La fonction maj_question_sondage_evaluation($evaluation,$libelle) n'existe pas pour la version ".VERSION);
	return pg_fetch_result($res,0,0);
}

/**
    Obtenir les themes d'une question de sondage(OLD)

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_sondage_themes_old($question) {
	$sql = "select theme from question_sondage where num_sondage=$question";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les themes d'une question de sondage

    @param integer : le numro de la question
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_question_sondage_themes($question) {
	if (VERSION_BASE > VERSION) {
		$res = get_categorie_element_themes(17,$question);
	} else
		$res = get_question_sondage_themes_old($question);
	return $res;
}
?>