<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier de dfinition de la classe Reponse
 *
 * @package reponse
 */
class Reponse extends QuestionReponseElement{


    /**
    * Constructeur de la classe Reponse
    * @param integer $reponse identifiant de l'enregistrement en BD
    * @param string $lib Libell
    * @param integer $theme identifiant du thme en base de donnes
    * @param integer $media identifiant du Media associ
    * @param integer $type Type de la Rponse
    */
    function Reponse($id=0, $libelle="", $type=0, $interpretationHTML=true, $media=0){
		messageDebug("Reponse::Reponse($id, $libelle, $type, $interpretationHTML, $media)");
		if(func_num_args()==1){
			if (VERSION_BASE > VERSION) {
				$result = get_reponse($id);
			} else {

				// On rcupre les informations en base de donnes
				if ($type == get_evaluation_type_old_new('q')||$type == get_evaluation_type_old_new('m')) {
					$result = get_reponse_qcm($id);
					// recup du theme
					$res_th = get_reponse_qcm_theme($id);
				} else
					if ($type == get_evaluation_type_old_new('s')||$type == get_evaluation_type_old_new('o')) {
						$result = get_proposition_sondage($id);
						// recup du theme
						$res_th = get_proposition_sondage_theme($id);
					}
					else{
						print("Erreur Choix(...):<br> Le type '".$type."' n'est pas support par la fonction.");
					}
			}
			$row = pg_fetch_array($result);
			$id=$row[0];
			$libelle=$row[1];
			$interpretationHTML=sql2Bool($row[2]);
			$type=$row[3];
		}else{
    		parent::QuestionReponseElement($id, $libelle, $type, $interpretationHTML, $media);
		}

    }
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------

	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=Reponse::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate($message);
		$verif=Reponse::verify($message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Ne vrifie aucun attribut.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes (toujours), false si non (jamais).
	 */
	function verify(&$message){
		return true;
	}


	/**
	* Fonction qui insre la Question en base.
	* Affecte l'identifiant de la Question.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre la Question
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant de la Question cr ou false
	*/
	function insertToDB($theme, &$message) {
		if(Reponse::verifyInsert(&$message)){
			//$this->id = set_reponse(addslashes($this->libelle), bool2Sql($this->interpretationHTML), $this->type, $theme);
			$this->id = set_reponse(set_ams_libelle($this->libelle), bool2Sql($this->interpretationHTML), $this->type, $theme);
//			print_rr($this);
			return $this->id;
		}
		else{
			return false;
		}	
	}

	/**
	* Fonction qui met  jour l'enregistrement en base.
	* Cette fonction ne peut tre utilise que si l'objet possde un identifiant, un libelle, un theme et un type.
	* @return bool: true ou false selon que la mise a jour ai t ffectue ou non.
	*/
	function updateToDB(&$message) {
		
		if(Reponse::verifyUpdate(&$message)){
			
			if (VERSION_BASE > VERSION) {
				//$update = maj_reponse($this->id, addslashes($this->libelle), bool2Sql($this->interpretationHTML));
				$update = maj_reponse($this->id, set_ams_libelle($this->libelle), bool2Sql($this->interpretationHTML));
			}
			return $update;
		} else {
			
			print_rr($this);
			return false;
		}
	}
		
	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_reponse", "interpretationHTML_reponse", "theme_reponse");
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "interpretationHTML_reponse":
				return Array(true, false);
			default:
				return null;
		}
	}
//-----------------------------------------------------
//			METHODES DEPRECIES
//-----------------------------------------------------

    /**
    * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
    *
    * Si on ne passe aucun paramtre, la chane retourne contient le nom. Par contre, si le paramtre est dfini,
    * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
    * @deprecated
    * @param string $format le paramtre determine ce qu'on retourne. Les informations disponibles sont :
    * [id_test] (gal  [id_serie]) & [type_test]
    * @return string  On retourne la chane de caractres cre  partir du format
    */	
    function toString($format="")
    {
            // Aucun paramtre, on retourne le titre de la srie
            if($format=="")
                    return $this->libelle ;

            // Ce tableau contient tous les pattern et les nouvelles valeurs
            $tab_replace = array("\[libelle_reponse\]"=>"$this->libelle_reponse","\[id_reponse\]"=>"$this->id_reponse","\[num_theme\]"=>"$this->num_theme") ;

            while($tab=each($tab_replace))
                    $format = ereg_replace($tab[0],$tab[1],$format) ;

            return $format ;
    }

//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
}
?>