<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
 * Created on June 29, 2007
 *
 * @author Said Ladjani
 * @package reponse
 * @modulegroup fonctions
 */



/**
	Savoir si une reponse a des resultats
	* @param integer idendifiant de la reponse
	* @return integer: vrai si resultat, faux sinon
*/
function is_reponse_resultats($reponse){
	$res=get_reponse_question_reponse_resultats($reponse);
	if(pg_num_rows($res)>0)
		return true;
	return false;
}


/**
 * Savoir si une reponse est modifiable ou supprimable.
 * 2: la reponse est supprimable
 * 1: elle n'est que modifible 
 * 0: elle n'est ni modifiable ni supprimable
 *  
 * @param integer idendifiant de la reponse
 * @return integer: 0,1,ou 2
 */
function get_reponse_qcm_actions($reponse){
    
    $action=2;
	// aucune action si l'evaluation est enregistre (il y a des resultats)
	if(is_reponse_resultats($reponse))
		return 0;
    // test si la reponse est dans une evaluation (A suivre ...)
	/*
    $res_series=get_evaluation_series($evaluation, $type);
    $nb_series=pg_num_rows($res_series);
    if($nb_series>0&&pg_fetch_result($res_series,0,0)!='NULL'){
    	$action=1;
    	//on  rcupere les actions pour chacunes des sries
    	for($i=0; $i<$nb_series;$i++){
    		$action_serie=get_serie_actions(pg_fetch_result($res_series,0,0));
    		if($action_serie==0){
    			$action=0;
				return $action;
    		}
			
    	}
    }
	*/
    return $action;
}
?>
