<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package reponse
 * @modulegroup plpgsql
 */
/**
    Obtenir les infos d'une rponse (OLD)
	@deprecated utiliser get_question_reponse_element($elt)
    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte
*/
function get_reponse_infos_old($reponse){
    $sql="select * from reponse where num_rep=$reponse";
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les infos d'une rponse
	@deprecated utiliser get_question_reponse_element($elt)
    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte
*/
function get_reponse_infos($reponse){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_reponse_infos_old($reponse);
    return $res;
}



/**
    Vrifie qu'une rponse est unique pour un thme donn (OLD)

    @param integer : le numro du thme
    @param string : le libelle de la rponse
    @return integer : 1 existe, 0 sinon
*/
function check_reponse_old($theme,$libelle){
    $sql="select * from reponse where theme=$theme and libelle_rep='$libelle'";
    $res=pg_query($sql);
    if(pg_numrows($res)==0)
        return 0;
    return 1;
}
/**
    Vrifie qu'une rponse est unique pour un thme donn

    @param integer : le numro du thme
    @param string : le libelle de la rponse
    @return integer : 1 existe, 0 sinon
*/
function check_reponse($theme,$libelle){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_reponse_old($theme,$libelle);
    return $res;
}

/**
    Obtenir le numero d'une rponse (OLD)

    @param string : le libelle de la reponse
    @param integer : le numro du theme
    @param integer : le resultat de la requete
*/
function get_reponse_numero_old($libelle,$theme){
    $sql="select num_rep from reponse where theme='$theme' and libelle_rep='$libelle'";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir le numero d'une rponse

    @param string : le libelle de la reponse
    @param integer : le numro du theme
    @param integer : le resultat de la requete
*/
function get_reponse_numero($libelle,$theme){
    if(VERSION_BASE>VERSION){
        //$sql="select * from contraintes.af_get_reponse_numero($libelle,$theme) as (id_reponse int4)";
        //$res=pg_query($sql);
    }
    else
        $res=get_reponse_numero_old($libelle,$theme);
    return $res;
}

/**
    Obtenir le pre pour l'ajout d'une reponse de qcm

    @param varchar: le nom de la table
    @param varchar : le nom du champ
    @param text : la cnodition
    @return integer : le nouveau pre
*/
function get_reponse_qcm_pere($table,$champ,$condition){
    $sql="select  * from contraintes.af_gen_last_element($table,$champ,$condition) as (id_pere int4)";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les infos d'une rponse (OLD)
    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte
*/
function get_reponse_old($reponse){
    $sql="select num_rep, libelle_rep, inter_html, 'q', 'TRUE' from reponse where num_rep=$reponse";
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les infos d'une reponse
    @param integer : le numero de la reponse
    @return integer : le resultat de la requete :(id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_reponse($reponse){
    if(VERSION_BASE>VERSION){
   		 $res=get_question_reponse_element($reponse);
    }
    else
        $res=get_reponse_old($reponse);
    return $res;
}


/**
    Mettre  jour une reponse (OLD)

    @param integer : le numero de la reponse
    @param string : le libelle
    @param bool: interpretation html?
    @return bool : t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_reponse_old($reponse,$libelle,$interpretation_html){
    $sql="update reponse set libelle_rep='$libelle' where num_rep=$reponse";
    $maj=pg_query($sql);
    return $maj;
}

/**
    Mettre  jour une reponse (OLD)

    @param integer : le numero de la reponse
    @param string : le libelle
    @param bool: interpretation html?
    @return bool : t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_reponse($reponse,$libelle, $interpretation_html=""){
    if(VERSION_BASE>VERSION){
       return maj_question_reponse_element($reponse,$libelle, $interpretation_html);
    }
    else
        $res=maj_reponse_old($reponse,$libelle,$interpretation_html);
    return pg_fetch_result($res,0,0);
}

/**
    Obtenir les numeros de question pour une reponse donne (OLD)
    @deprecated voir get_reponse_qcm_evaluations
    @param integer : le numero de la reponse
    @return integer : le resultat de la requete
*/
function get_reponse_qcms_old($reponse){
    $sql="select qr_num_question from quest_rep where qr_num_rep=$reponse";
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les numeros de question pour une reponse donne 
    @deprecated voir get_reponse_qcm_evaluations
    @param integer : le numero de la reponse
    @return integer : le resultat de la requete (evaluation int4)
*/
function get_reponse_qcms($reponse){
    if(VERSION_BASE>VERSION){
        $res=get_question_reponse_element_evaluations($reponse);
    }
    else
        $res=get_reponse_qcms_old($reponse);
    return $res;
}
?>