<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**

 Fichier de fonctions pour les rponses.
 Une rponse est un question_reponse_element, et les fonctions de ce fichier
 doivent dont toutes appeler des fonctions de la librairie question_reponse_element.
 
 NB:Les rponses sont communes aux qcm et aux sondage

	@package reponse
	@modulegroup plpgsql
	@module plpgsql_reponse
*/

/**
 * Fichier de fonctions dprcies
 */
//include("$chemin_bo/lib/reponse/plpgsql_deprecated_reponse.inc");

/**
    Obtenir les infos d'une rponse (OLD)
    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte
*/
function get_reponse_qcm_old($reponse) {
	$sql = "SELECT num_rep, libelle_rep, inter_html, 'q', 'TRUE' FROM reponse WHERE num_rep=$reponse";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les infos d'une reponse
    @param integer : le numero de la reponse
    @return integer : le resultat de la requete :(id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_reponse_qcm($reponse) {
	if (VERSION_BASE > VERSION) {
		return get_question_reponse_element($reponse);

	} else
		return get_reponse_qcm_old($reponse);
}

/**
    Mettre  jour une reponse (OLD)

    @param integer : le numero de la reponse
    @param string : le libelle
    @param bool: interpretation html?
    @return bool : t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_reponse_qcm_old($reponse, $libelle, $interpretation_html) {
	$sql = "UPDATE reponse SET libelle_rep='$libelle', inter_html=$interpretation_html WHERE num_rep=$reponse";
	//echo "sql=$sql<br>";
	$maj = pg_query($sql);
	return $maj;
}

/**
    Mettre  jour une reponse (OLD)

    @param integer : le numero de la reponse
    @param string : le libelle
    @param bool: interpretation html?
    @return bool : t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_reponse_qcm($reponse, $libelle, $interpretation_html) {
	if (VERSION_BASE > VERSION) {
		return maj_question_reponse_element($reponse, $libelle, $interpretation_html);
	} else
		$res = maj_reponse_qcm_old($reponse, $libelle, $interpretation_html);
	return $res;
}

/**
 * Obtenir le mdia d'une reponse de QCM (OLD)
 *  @param integer : le numero de question de qcm
 *  @param integer : le numero de reponse de qcm
 *  @return integer : le resultat de la requete :  question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4
 */
function get_reponse_qcm_media_old($question, $reponse) {
	$sql = "SELECT qr_num_question, qr_num_rep, rmedia, flash, hauteur_rmedia, largeur_rmedia 
				FROM quest_rep WHERE qr_num_rep=$reponse AND qr_num_question=$question";
	// echo "sql=$sql<br>";
	$res = pg_query($sql);

	return $res;
}

/**
 * Obtenir le mdia d'une reponse de QCM 
 *  @param integer : le numero de question de qcm
 *  @param integer : le numero de reponse de qcm
 *  @return integer : le resultat de la requete :  question_reponse int4, question_reponse_element int4, media int4, flash int4, hauteur int4, largeur int4
 */
function get_reponse_qcm_media($question, $reponse) {
	if (VERSION_BASE > VERSION) {
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("<br>Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);
		return get_question_reponse_element_media($evaluation, $reponse);
	} else
		$res = get_reponse_qcm_media_old($question, $reponse);
	return $res;

}

/**
 * Mettre  jour le mdia d'une reponse de QCM (OLD)
 * @param integer : le numero de question de qcm
 * @param integer  le numero de reponse de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @return bool  true si l'update s'est bien pass, false sinon
 */
function maj_reponse_qcm_media_old($question, $reponse, $media, $largeur, $hauteur) {
	$sql = "UPDATE quest_rep
		    	SET rmedia=$media,largeur_rmedia=$largeur,hauteur_rmedia=$hauteur 
				WHERE qr_num_rep=$reponse AND qr_num_question=$question";
	//echo $sql;
	$maj = pg_query($sql);
	return $maj;
}

/**
 * Mettre  jour le mdia d'une reponse de QCM
 * @param integer : le numero de question de qcm
 * @param integer  le numero de reponse de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @return bool  true si l'update s'est bien pass, false sinon
 */
function maj_reponse_qcm_media($question, $reponse, $media, $largeur, $hauteur) {
	if (VERSION_BASE > VERSION) {

		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);

		return maj_question_reponse_element_media($evaluation, $reponse, $media, $largeur, $hauteur);
	} else
		$res = maj_reponse_qcm_media_old($question, $reponse, $media, $largeur, $hauteur);
	return $res;
}

/**
 * Supprimer le mdia d'une reponse de QCM (OLD)
 * @param integer : le numero de question de qcm
 * @param integer  le numero de reponse de qcm
 * @return bool  true si la suppression s'est bien pass, false sinon
 */
function del_reponse_qcm_media_old($question, $reponse) {
	$sql = "UPDATE quest_rep SET rmedia=NULL, largeur_rmedia=NULL, hauteur_rmedia=NULL WHERE qr_num_question=$question AND qr_num_rep=$reponse";
	// echo "sql=$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
 * Supprimer le mdia d'une reponse de QCM
 * @param integer : le numero de question de qcm
 * @param integer  le numero de reponse de qcm
 * @return bool  true si la suppression s'est bien pass, false sinon
 */
function del_reponse_qcm_media($question, $reponse) {
	if (VERSION_BASE > VERSION) {
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);

		return del_question_reponse_element_media($evaluation, $reponse);
	} else
		return  del_reponse_qcm_media_old($question, $reponse);
}

/**
    Enregistre une nouvelle reponse de qcm (OLD)
    @param string : le libelle de la reponse
    @param bool: intepretation html? 
    @param integer : le numro du theme
    @return integer : le numro de la nouvelle reponse
*/
function set_reponse_qcm_old($libelle, $html, $theme) {
	//$existe_deja=check_reponse($theme,$libelle);
	//if(!$existe_deja){
	$sql = "INSERT INTO reponse (libelle_rep,theme, inter_html) VALUES('$libelle',$theme, '$html' );";
//	echo $sql;
	$ins = pg_query($sql);
	if ($ins) {
		$oid = pg_getlastoid($ins);
		$sql = "SELECT num_rep FROM reponse WHERE oid=$oid";
		$res = pg_query($sql);
		$row = pg_fetch_row($res, 0);
		return $row[0];
	} else
		return null;
	//}
	//return 0;
}

/**
    Enregistre une nouvelle reponse de qcm
    et l'enregistre dans la categorie associe
    @param string : le libelle de la reponse
    @param bool: intepretation html? 
    @param integer : le numro du theme
    @return integer : le numro de la nouvelle reponse
*/
function set_reponse_qcm($libelle, $html, $theme) {
	if (VERSION_BASE > VERSION) {
		$num = set_question_reponse_element($libelle, $html, 1, 'TRUE');

		$res = set_categorie_element_theme(17, $theme, $num);
		return $num;
	} else
		return set_reponse_qcm_old($libelle, $html, $theme);
}

/**
 * Enregistre une nouvelle rponse
 * et l'enregistre dans la categorie associe
 * @param string $libelle le libelle de la rponse
 * @param bool $html intepretation html?
 * @param integer $type identifiant du type de rponse
 * @param integer $theme le numro du theme
 * @return integer Le numro de la nouvelle rponse
 */
function set_reponse($libelle, $html, $type, $theme) {
	if(empty($theme))die("set_reponse($libelle, $html, $type, $theme): theme manquant.");
	
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_set_reponse('$libelle', $html, $type)";
//        echo "sql=$sql<br>";
        $res=pg_query($sql);
        $num=pg_fetch_result($res,0,0);
		$res = set_categorie_element_theme(17,$theme,$num);
		return $num;
	} else
		if($type=='q' || $type==1)
			return set_reponse_qcm_old($libelle, $html, $theme);
		else
			return set_proposition_sondage_old($libelle,$html,$theme);
		//return set_reponse_qcm_old($libelle, $html, $theme);
}

/**
    Obtenir les valuations utilisant une reponse de qcm donne (OLD)
    Ici, on retourne un numero et un type.
    'q' pour les numeros de questions(= qcms) qui utilisent la rponse
    et 'm' pour les numros de test de positionnement. 
    @param integer : le numero de la reponse
    @return integer : le resultat de la requete
*/
function get_reponse_qcm_evaluations_old($reponse) {

	$sql = "	SELECT DISTINCT qr_num_question, 'q' FROM quest_rep WHERE qr_num_rep=$reponse
					UNION
				SELECT DISTINCT id_test , 'm' FROM test_quest_rep WHERE id_reponse=$reponse";
	$res = pg_query($sql);
	return $res;
}

/**
   Obtenir les valuations utilisant une reponse de qcm donne
    @param integer : le numero de la reponse
    @return integer : le resultat de la requete (evaluation int4)
*/
function get_reponse_qcm_evaluations($reponse) {
	if (VERSION_BASE > VERSION) {
		$res = get_question_reponse_element_evaluations($reponse);
	} else
		$res = get_reponse_qcm_evaluations_old($reponse);
	return $res;
}

/**
 * Mettre  jour le mdia d'une reponse de QCM
 * @param integer  le numero de question de qcm
 * @param integer  le numero de reponse de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @param integer ordre de la rponse
 * @return bool  t si l'update s'est bien pass, f sinon
 */
function set_reponse_qcm_media_old($question, $reponse, $media, $largeur, $hauteur, $ordre) {
	//1er cas: il y a deja un enregistrement pour ce couple question/reponse
	$sql1 = "UPDATE quest_rep SET rmedia=$media, largeur_rmedia=$largeur, hauteur_rmedia=$hauteur WHERE qr_num_question=$question AND qr_num_rep=$reponse";
	//echo "sql=$sql1<br>";
	$res = pg_query($sql1);
	if (!$res) {
		//2eme cas: il n'y a pas d'enregistrement pour ce couple question/rponse
		$sql2 = "INSERT INTO quest_rep (qr_num_question, qr_num_rep, rmedia, largeur_rmedia, hauteur_rmedia, ordre) VALUES ($question, $reponse, $media, $largeur, $hauteur, $ordre)";
		//echo "sql=$sql2<br>";
		$res = pg_query($sql2);
	}
	return $res;
}

/**
 * Mettre  jour le mdia d'une reponse de QCM
 * @param integer  le numero de question de qcm
 * @param integer  le numero de reponse de qcm
 * @param integer le numero du media
 * @param integer la largeur en pixel du media
 * @param integer la hauteur en pixel du media
 * @param integer ordre (facultatif) pour la fonction old
 * @return bool  t si l'update s'est bien pass, f sinon
 */
function set_reponse_qcm_media($question, $reponse, $media, $largeur, $hauteur, $ordre="") {
	if (VERSION_BASE > VERSION) {
		$evaluations = get_question_reponse_element_evaluations($question);
		//on test si une association question/ qcm est unique
		//  l'avenir, une question pourra etre utilise par plusieurs QCM
		if (pg_num_rows($evaluations) > 1)
			print ("Erreur: Une question est utilise par plusieurs qcm, ce qui n'est pas permis dans la version actuelle de la plate-forme");
		$evaluation = pg_fetch_result($evaluations, 0, 0);

		return set_question_reponse_element_media($evaluation, $reponse, $media, $largeur, $hauteur);
	} else
		return set_reponse_qcm_media_old($question,$reponse, $media, $largeur, $hauteur, $ordre);
}

/**
    Obtenir les themes d'une reponse de qcm(OLD)

    @param integer : le numro de la reponse
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_reponse_qcm_theme_old($reponse) {
	$sql = "select theme from reponse where num_rep=$reponse";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
    Obtenir les themes d'une reponse de qcm

    @param integer : le numro de la reponse
    @return integer : le rsultat de la requte (id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_reponse_qcm_theme($reponse) {
	if (VERSION_BASE > VERSION) {
		$res = get_categorie_element_themes(17,$reponse);
	} else
		$res = get_reponse_qcm_theme_old($reponse);
	return $res;
}

/**
    Obtenir les infos d'une rponse (OLD)
    @param integer : le numro de la rponse
    @return integer : le rsultat de la requte
*/
function get_reponse_old($reponse){
    $sql="select num_rep, libelle_rep, inter_html, 'q', 'TRUE' from reponse where num_rep=$reponse";
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les infos d'une reponse
    @param integer : le numero de la reponse
    @return integer : le resultat de la requete :(id int4,libelle varchar,interpretation_html bool,type int4, reponse bool)
*/
function get_reponse($reponse){
    if(VERSION_BASE>VERSION){
   		 $res=get_question_reponse_element($reponse);
    }
    else
        $res=get_reponse_old($reponse);
    return $res;
}

/**
    Mettre  jour une reponse (OLD)

    @param integer : le numero de la reponse
    @param string : le libelle
    @param bool: interpretation html?
    @return bool : t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_reponse_old($reponse,$libelle,$interpretation_html){
    $sql="update reponse set libelle_rep='$libelle' where num_rep=$reponse";
    $maj=pg_query($sql);
    return $maj;
}

/**
    Mettre  jour une reponse (OLD)

    @param integer : le numero de la reponse
    @param string : le libelle
    @param bool: interpretation html?
    @return bool : t si la mise a jour a t correctement effectu, f sinon.
*/
function maj_reponse($reponse,$libelle, $interpretation_html='FALSE'){
    if(VERSION_BASE>VERSION){
       return maj_question_reponse_element($reponse,$libelle, $interpretation_html);
    }
    else
        $res=maj_reponse_old($reponse,$libelle,$interpretation_html);
    return pg_fetch_result($res,0,0);
}

/**
   Obtenir les resultat pour une reponse de question_reponse
   @param integer : le numero de la reponse
   @return res req
*/
function get_reponse_question_reponse_resultats($reponse){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_reponse_question_reponse_resultats($reponse) 
		as (id int8,question_reponse int4,question int4,reponse int4,coche bool)";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	}
	else
		return get_reponse_question_reponse_resultats_old($reponse);
}
?>