<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier de dfinition de la classe ReponseQcm
 * Une RponseQcm tends la Classe Rponse spcifiquement au Qcm.
 * 
 * @package reponse_qcm
 */
class ReponseQcm extends Reponse{

	var $juste;
	
    /**
    * Constructeur de la classe ReponseQcm
    * @param integer $id identifiant de l'enregistrement en BD
    * @param string $libelle Libell
    * @param integer $theme identifiant du thme en base de donnes
    * @param object Media  $media Media de la rponse
    * @param integer $interpretationHTML Interprtation html
    * @param integer $type Type de la ReponseQcm
    */
    function ReponseQcm($id=0, $libelle="", $type=0, $interpretationHTML=true, $juste=false, $media=0){
    	messageDebug("ReponseQcm::ReponseQcm($id, $libelle, $type, $interpretationHTML,$juste, $media)");
    	parent::Reponse($id, $libelle, $type, $interpretationHTML, $media);
    	$this->juste=$juste;
    }

//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		
		$res_parent=parent::verifyInsert($message);
		$verif=ReponseQcm::verify($message);
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes avant une mise  jour de la base.
	 * Appel la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify()
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		
		$res_parent=parent::verifyUpdate($message);
		$verif=ReponseQcm::verify($message);
		
		return $res_parent && $verif && true;
	}

	/**
	 * Vrifie la validit des donnes propres  l'objet.
	 * Vrifie que $juste est bien un bolen.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non .
	 */
	function verify(&$message){
		$attributs_ok=true;		
		if(!is_bool($this->juste)){
			$message.="[juste]";
			$attributs_ok=false;
		}
		return $attributs_ok;
	}


	/**
	* Fonction qui insre la ReponseQcm en base.
	* Affecte l'identifiant de la ReponseQcm.
	* @param integer $theme Identifiant du Theme dans lequel on enregistre la ReponseQcm
	* @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	* @return integer Identifiant de la ReponseQcm cr ou false
	*/
	function insertToDB($theme, &$message) {
		if(ReponseQcm::verifyInsert(&$message)){
			$this->id = set_reponse(set_ams_libelle($this->libelle), bool2Sql($this->interpretationHTML), $this->type, $theme);
//			$this->id = set_reponse_qcm(addslashes($this->libelle), bool2Sql($this->interpretationHTML), $this->type, bool2Sql($this->juste),$theme);
			return $this->id;
		}
		else{
			return false;
		}	
	}

	/**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle_reponse_qcm", "interpretationHTML_reponse_qcm", "theme_reponse_qcm");
	}
    
    /**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			case "interpretationHTML_reponse_qcm":
				return Array(true, false);
			default:
				return null;
		}
	}
}
?>