<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de dfinition de la classe Ressource

La connexion  la base de donnes doit tre $db

@author LADJANI said <sladjani@afide.fr>
@since 18/04/2005

@package ressource
*/
class Ressource
{

        /**
        * @var integer : Identifiant en base de donnes
        */
        var $id ;

        /**
        * @var string : Libell de la ressource
        */
        var $libelle ;

        /**
        * @var integer : numro d'espace
        */
        var $id_espace ;

        /**
        * @var integer : numro de section
        */
        var $id_section ;

        /**
        * @var integer : numro de fichier
        */
        var $id_fichier ;

        /**
        * @var integer : numro de formation
        */
        var $id_formation ;

        /**
        * @var date : debut de la ressource
        */
        var $debut ;

        /**
        * @var date : fin de la ressource
        */
        var $fin;

        /**
        * @var integer : dure pdt laquelle la ressource est nouvelle
        */
        var $duree_nouvelle;

        /**
        * @var integer : mots cles
        */
        var $mot;

        /**
        * @var char : type de ressource (texte ou fichier)
        */
        var $type_ressource;




        /**
        * Constructeur de la classe Ressource
        * On peut construire de deux faons. Soit on utilise le paramtre identifiant l'enregistrement en base de donnes, soit on passe
        * toutes les informations ncssaires.
        * @param integer $ressource identifiant de l'enregistrement en BD
        * @param string $titre Libell
        * @param integer $espace identifiant de l'espace en base de donnes
        * @param integer $section identifiant de la section en base de donnes
        * @param integer $fichier identifiant du fichier en base de donnes
        * @param integer $formation identifiant de la formation en base de donnes
        * @param string $debut date debut en base de donnes
        * @param string $fin date fin en base de donnes
        * @param integer $nouveau duree pdt laquelle la ressource est nouvelle en base de donnes
        * @param string $motcle les mots cles en base de donnes
        * @param char $type type de la ressource en base de donnes (t=texte, f=fichier)
        */
        function Ressource($ressource=0,$titre="",$espace=0,$section=0,$fichier=0,$formation=0,$debut="",$fin="",$nouveau=0,$motcle="",$type=0)
        {
                 // constructeur  partir d'un identifiant d'enregistrement en base de donnes (seul le numero doit tre pass)
                if(func_num_args()==1){
                    // Requete sur base de donnes
                    /*
                    $sql="select * from ressource_gest where num_gest_res=$ressource";
                    $res=pg_query($sql);
                    */
                    $res=get_ressource_infos($ressource);
                    $row=pg_fetch_array($res);

                    // Affectations aux attributs de l'objet
                    $this->id=$ressource;
                    $this->libelle=$row["libelle"];
                    $this->id_espace=$row["num_espace"];
                    $this->id_section=$row["num_section"];
                    $this->id_fichier=$row["num_fic"];
                    $this->id_formation=$row["num_cal"];
                    $this->debut=$row["datedeb"];
                    $this->fin=$row["datefin"];
                    $this->duree_nouvelle=$row["nouveau"];
                    $this->mot=$row["motcle"];
                    $this->type_ressource=$row["type"];

                }
                else{
                        // constructeur avec des paramtres pour l'affectation des attributs
                        // Faut-il verifier la cohrence des donnes envoyes ?
                        $this->id = $ressource ;
                        $this->libelle = $titre ;
                        $this->id_espace = $espace ;
                        $this->id_section = $section ;
                        $this->id_fichier = $fichier ;
                        $this->id_formation=$formation;
                        $this->debut=$debut;
                        $this->fin=$fin;
                        $this->duree_nouvelle=$nouveau;
                        $this->mot=$motcle;
                        $this->type_ressource=$type;


                }


        }
        // ------------------------------------------------------------------------------------------------------------------- fin Ressource()

        /**
        * Fonction qui insre un enregistrement en table grille et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                if($this->fin<$this->debut)
                    $this->fin=$this->debut;
                /*
                $sql="insert into ressource_gest(num_fic,num_section,num_espace,libelle,num_cal,datedeb,datefin,nouveau,motcle,type)
                          values('$this->id_fichier','$this->id_section','$this->id_espace','$this->libelle','$this->id_formation','$this->debut','$this->fin','$this->duree_nouvelle','$this->mot','$this->type_ressource')" ;
                // On retourne un boolen
                //echo "sql=$sql<br>";
                */
                $libelle=addslashes($this->libelle);
                //$res = pg_query($sql);
                $res=set_ressource_formation($this->id_fichier,$this->id_section,$this->id_espace,$libelle,$this->id_formation,$this->debut,$this->fin,$this->duree_nouvelle,$this->mot,$this->type_ressource);
                $oid = pg_last_oid($res) ;
                $result = pg_query("SELECT num_gest_res FROM ressource_gest WHERE oid=$oid");
                $this->id = pg_result($result,0,0) ;
                return($this->id) ;

        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table ressource_gest
        *
        
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->id != 0){
                    if($this->fin<$this->debut)
                        $this->fin=$this->debut;
                        /*
                        $update = "UPDATE ressource_gest SET
                                            num_fic='$this->id_fichier',
                                            num_section='$this->id_section',
                                            num_espace='$this->id_espace',
                                            libelle = '$this->libelle',
                                            num_cal='$this->id_formation',
                                            datedeb='$this->debut',
                                            datefin='$this->fin',
                                            nouveau='$this->duree_nouvelle',
                                            type='$this->type_ressource' ,
                                            motcle='$this->mot' WHERE num_gest_res=$this->id" ;

                        // echo "Class Grille : updateToDB. Requete =<br>$update<br>" ;
                        */
                        $libelle=addslashes($this->libelle);
                        $update=maj_ressource_formation($this->id,$this->id_fichier,$this->id_section,$this->id_espace,$libelle,$this->id_formation,$this->debut,$this->fin,$this->duree_nouvelle,$this->mot,$this->type_ressource);
                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }


        /**
        * Procdure qui supprime l'enregistrement en base
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */
        function deleteToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){

                // suppression de la grille
                if(del_ressource($this->id)){
                    return true;
                }
                else
                    return -1;  // erreur base de donnes
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }



        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Si on ne passe aucun paramtre, la chane retourne contient le nom. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        * @param string : le paramtre determine ce qu'on retourne. Les informations disponibles sont :
        * [id_test] (gal  [id_serie]) & [type_test]
        * @return string : On retourne la chane de caractres cre  partir du format
        */
        function toString($format="")
        {
                // Aucun paramtre, on retourne le titre de la srie
                if($format=="")
                        return $this->libelle ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[libelle\]"=>"$this->libelle","\[num_gest_res\]"=>"$this->id");
                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }



        function getId() { return $this->id ; }
        function getId_espace() { return $this->id_espace ; }
        function getId_section() { return $this->id_section  ; }
        function getTypeRessource() { return $this->type_ressource ; }
        function getId_formation() { return $this->id_formation ; }
        function getDebutRessource() { return $this->debut ; }
        function getFinRessource() {return $this->fin ; }
        function getNouveau() { return $this->duree_nouvelle ; }
        function getMotCle() { return $this->mot ; }
       

}
?>