<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fonctions d'appel au fonctions PL/PGSQL pour les ressources.
 * 
 * @package ressource
 * @modulegroup plpgsql
 * @module plpgsql_ressource
 */



/**
*   Supprimer une ressource.  (OLD)
*
*   Supprime la ressource
*
*   @param integer : numero de la ressource  supprimer
*   @return integer : 1
*/
function del_ressource_old($ressource){
    // suppression de la ressource
    $del=pg_query("delete from ressource_gest where num_gest_res=$ressource;");

    return 1;
}

/**
*   Supprimer une ressource.
*
*   Supprime la ressource
*
*   @param integer : numero de la ressource  supprimer
*   @return integer : 1
*/
function del_ressource($ressource){

            if(VERSION_BASE>VERSION)
            {
                print("A IMPLEMENTER");
            }
            else
                $res=del_ressource_old($ressource);

            return ($res);
}


/**
*   Obtenir le nom du fichier associ  une ressource  (OLD)
*   Retourne le nom du fichier de la ressource
*   @param integer : le numero de la ressource
*   @param char : le type de la ressource (t=texte et f=fichier)
*   @return string : le nom du fichier
*/
function get_ressource_nom_fichier_old($ressource,$type){
    if($type=='f'){
        $nomtable="ressource_fic";
        $selection="nom_fic";
        $nomchamp="num_fic";
    }
    else{
        $nomtable="ressource_txt";
        $selection="nom";
        $nomchamp="num_text";
    }
    $sql="select $selection from $nomtable where $nomchamp in (select num_fic from ressource_gest where num_gest_res=$ressource)";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Obtenir le nom du fichier  associ  une ressource
*   Retourne le nom du fichier de la ressource
*   @param integer : le numero de la ressource
*   @param char : le type de la ressource (t=texte et f=fichier)
*   @return string : le nom du fichier
*/
function get_ressource_nom_fichier($ressource,$type){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=get_ressource_nom_fichier_old($ressource,$type);
    return ($res);
}

/**
*   Vrifie qu'une ressource est unique  (OLD)

*   @param integer : le numro de fichier ou de texte
*   @param integer : le numro de section
*   @param integer : le numro d'espace
*   @param integer : le numro de formation
*   @param char : le type de ressource (t=texte, f=fichier)
*   @return integer : 1 si existe, 0 sinon
*/
function check_ressource_old($num_fic,$num_section,$num_espace,$num_cal,$type){
    $sql="select * from ressource_gest where num_fic=$num_fic and num_section=$num_section and num_espace=$num_espace and num_cal=$num_cal and type='$type'";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return (pg_numrows($res));
}
/**
*   Vrifie qu'une ressource est unique

*   @param integer : le numro de fichier ou de texte
*   @param integer : le numro de section
*   @param integer : le numro d'espace
*   @param integer : le numro de formation
*   @param char : le type de ressource (t=texte, f=fichier)
*   @return integer : 1 si existe, 0 sinon
*/
function check_ressource($num_fic,$num_section,$num_espace,$num_cal,$type){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=check_ressource_old($num_fic,$num_section,$num_espace,$num_cal,$type);
    return ($res);
}

/**
*   Enregistrer une nouvelle ressource avec formation(OLD)
* 
* 
*   @param integer : le numro de fichier ou de texte
*   @param integer : le numro de section
*   @param integer : le numro d'espace
*   @param string : le libelle
*   @param integer : le numro de formation
*   @param date : la date de dbut
*   @param date : la date de fin
*   @param integer : la dure de nouveaut
*   @param string : les mot-cles
*   @param char : le type de la ressource (t=texte, f=fichier)
*   @return integer : le numro de la ressource, 0 si erreur
*/
function set_ressource_formation_old($fichier,$section,$espace,$libelle,$formation,$debut,$fin,$nouveaute,$motcles,$type){
    //if(!check_ressource($num_fic,$num_section,$num_espace,$num_cal,$type)){
        $sql="insert into ressource_gest(num_fic,num_section,num_espace,libelle,num_cal,datedeb,datefin,nouveau,motcle,type)
                values('$fichier','$num_section','$espace','$libelle','$formation','$debut','$fin','$nouveaute','$motcles','$type')";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_gest_res from ressource_gest where oid=$oid;");
        $numres=pg_result($res, 0, 0);
        return $numres;

    //}
    //else
      //  return 0;
}
/**
*   Enregistrer une nouvelle ressource avec formation
* 
* 
*   @param integer : le numro de fichier ou de texte
*   @param integer : le nmro de section
*   @param integer : le numro d'espace
*   @param string : le libelle
*   @param integer : le numro de formation
*   @param date : la date de dbut
*   @param date : la date de fin
*   @param integer : la dure de nouveaut
*   @param string : les mot-cles
*   @param char : le type de la ressource (t=texte, f=fichier)
*   @return integer : le numro de la ressource, 0 si erreur
*/
function set_ressource_formation($fichier,$section,$espace,$libelle,$formation,$debut,$fin,$nouveaute,$motcles,$type){
     if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=set_ressource_formation_old($fichier,$section,$espace,$libelle,$formation,$debut,$fin,$nouveaute,$motcles,$type);
    return ($res);
}

/**
*   Obtenir le numero d'une ressource (OLD)
*
*   @param integer : le numero de formation
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero de fichier ou texte
*   @return integer : le resultat de la requte
*/
function get_ressource_numero_old($formation,$espace,$section,$fichier,$type){
    if(empty($section))
        $section='NULL';
    $sql="select num_gest_res from ressource_gest where num_cal=$formation and num_espace=$espace and num_section=$section and num_fic=$fichier
                and type='$type'";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir le numero d'une ressource
*
*   @param integer : le numero de formation
*   @param integer : le numero d'espace
*   @param integer : le numero de section
*   @param integer : le numero de fichier ou texte
*   @return integer : le resultat de la requte
*/
function get_ressource_numero($formation,$espace,$section,$fichier,$type){
     if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=get_ressource_numero_old($formation,$espace,$section,$fichier,$type);
    return ($res);
}

/**
*   Obtenir les infos d'une ressource (OLD)
*
*   @param integer : le numero de la ressource
*   @return integer : le resultat de la requte
*/
function get_ressource_infos_old($ressource){
    $sql="select * from ressource_gest where num_gest_res=$ressource";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les infos d'une ressource
*
*   @param integer : le numero de la ressource
*   @return integer : le resultat de la requte
*/
function get_ressource_infos($ressource){
     if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=get_ressource_infos_old($ressource);
    return ($res);
}

/**
*   Mettre  jour les dates des ressources pour une formation (OLD)
*
*   @param integer : le numero de la formation
*   @param date : la date de debut
*   @param date : la date de fin
*   @param integer : (nouveau pendant)
*/
function maj_ressources_dates_old($num_cal,$datedeb,$datefin,$nouveau){
    $sql="update ressource_gest set datedeb='$datedeb',datefin='$datefin',nouveau=$nouveau where num_cal=$num_cal";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour les dates des ressources pour une formation
*
*   @param integer : le numero de la formation
*   @param date : la date de debut
*   @param date : la date de fin
*   @param integer : (nouveau pendant)
*/
function maj_ressources_dates($num_cal,$datedeb,$datefin,$nouveau){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=maj_ressources_dates_old($num_cal,$datedeb,$datefin,$nouveau);
    return $res;
}

/**
    Mettre  jour une ressource (OLD)

    @param integer : le numero de la ressource
    @param integer : le numro de fichier ou de texte
*   @param integer : le nmro de section
*   @param integer : le numro d'espace
*   @param string : le libelle
*   @param integer : le numro de formation
*   @param date : la date de dbut
*   @param date : la date de fin
*   @param integer : la dure de nouveaut
*   @param string : les mot-cles
*   @param char : le type de la ressource (t=texte, f=fichier)
*   @return integer : le resultat de la requete
*/
function maj_ressource_formation_old($ressource,$fic,$section,$espace,$libelle,$formation,$datedeb,$datefin,$nouveau,$motcle,$type){
    $sql="UPDATE ressource_gest SET num_fic=$fic,num_section=$section,num_espace=$espace,libelle = '$libelle',
            num_cal=$formation,datedeb='$datedeb',datefin='$datefin',nouveau=$nouveau,type='$type',motcle='$motcle'
            WHERE num_gest_res=$ressource" ;
    return pg_query($sql);
}
/**
    Mettre  jour une ressource

    @param integer : le numero de la ressource
    @param integer : le numro de fichier ou de texte
*   @param integer : le nmro de section
*   @param integer : le numro d'espace
*   @param string : le libelle
*   @param integer : le numro de formation
*   @param date : la date de dbut
*   @param date : la date de fin
*   @param integer : la dure de nouveaut
*   @param string : les mot-cles
*   @param char : le type de la ressource (t=texte, f=fichier)
*   @return integer : le resultat de la requete
*/
function maj_ressource_formation($ressource,$fic,$section,$espace,$libelle,$formation,$datedeb,$datefin,$nouveau,$motcle,$type){
     if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=maj_ressource_formation_old($ressource,$fic,$section,$espace,$libelle,$formation,$datedeb,$datefin,$nouveau,$motcle,$type);
    return ($res);
}

/*
   Partie reserve aux contraintes (Gestion des ressources)
*/

/**
	Enregistre une ressource
	@param integer : fichier
	@param text : mots cles
	@return integer : l'identifiant de la ressource cre
*/
function set_ressource($fichier,$motscles){
	$sql = "SELECT * FROM contraintes.af_set_ressource($fichier,'$motscles')";
	//echo "sql=$sql<br>";
	$res = pg_query($sql);
	$id=pg_fetch_result($res, 0, 0);
	return $id;
}

/**
	Obtenir les infos d'une ressource
	@param integer : le numero de la ressource
	@return integer : res req
*/
function get_ressource($ressource){
	$sql="select * from contraintes.af_get_ressource($ressource) as (id int4,libelle varchar,fichier int4,mots_cles text,etape int4)";
	return pg_query($sql);
}

/**
	Modifier une ressource
	@param integer : le numero de la ressource
	@param integer : fichier
	@param text : mots cles
	@return integer : res req
*/
function maj_ressource($ressource,$fichier,$motscles){
	$sql="select * from contraintes.af_maj_ressource($ressource,$fichier,'$motscles')";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Verifier si l'icone d'une ressource est (OLD)
	@param string : libelle icone
	@return integer : res req
*/
/*
function get_ressource_icone_old($icone){

}
*/


?>