<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier de dfinition de la classe RessourceTexte
 * 
 * @package ressource_texte
 */
class RessourceTexte{

    /**
    * @var integer : Identifiant en base de donnes
    */
    var $id ;

    /**
    * @var string : Libell de la ressource
    */
    var $libelle ;

    /**
    * @var string : lien html
    */
    var $adresse ;

    /**
    * @var string : titre lien html
    */
    var $description ;

    /**
    * @var string: texte
    */
    var $texte;


    /**
    * Constructeur de la classe RessourceTexte
    * On peut construire de deux faons. Soit on utilise le paramtre identifiant l'enregistrement en base de donnes, soit on passe
    * toutes les informations ncssaires.
    * @param integer $ressource identifiant de l'enregistrement en BD
    * @param string $Libell
    * @param string $
    * @param integer $section identifiant de la section en base de donnes
    * @param integer $fichier identifiant du fichier en base de donnes
    * @param integer $formation identifiant de la formation en base de donnes
    * @param string $debut date debut en base de donnes
    * @param string $fin date fin en base de donnes
    * @param integer $nouveau duree pdt laquelle la ressource est nouvelle en base de donnes
    * @param string $motcle les mots cles en base de donnes
    * @param char $type type de la ressource en base de donnes (t=texte, f=fichier)
    */
    function RessourceTexte($id=0,$libelle="",$lien="",$titreLien="",$texte="",$date_creation="27.11.2006"){
    	
             // constructeur  partir d'un identifiant d'enregistrement en base de donnes (seul le numero doit tre pass)
            if(func_num_args()==1){
                // Requete sur base de donnes
                /*
                $sql="select * from ressource_gest where num_gest_res=$ressource";
                $res=pg_query($sql);
                */
                $res=get_ressource_texte($id);
                $row=pg_fetch_array($res);

                // Affectations aux attributs de l'objet
                $this->id=$id;
                $this->libelle=$row[1];
                $this->adresse=$row[5];
                $this->description=$row[4];
                $this->texte=$row[6];
                

            }
            else{
                    // constructeur avec des paramtres pour l'affectation des attributs
                    // Faut-il verifier la cohrence des donnes envoyes ?
                    $this->id = $id ;
                    $this->libelle = $libelle ;
                    $this->adresse = $lien ;
                    $this->description = $titreLien ;
                    $this->texte = $texte ;
			
            }
	}
	
    /**
	 * Vrifie la validit des donnes propres  l'objet.
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verify(&$message){
		
		$attributs_ok=true;
		if(empty($this->libelle)){
			$message.="[libelle]";
			$attributs_ok=false;
		}
		
		//il faut ici une adresse et description non nuls et/ou un texte non null 
		
		if(empty($this->adresse)&&!empty($this->description)){
			$message.="[adresse]";
			$attributs_ok=false;
		}
		
		if(empty($this->description)&&!empty($this->adresse)){
			$message.="[description]";
			$attributs_ok=false;
		}
		
		if(empty($this->texte)&&(empty($this->description)||empty($this->adresse))){
			$message.="[texte]";
			$attributs_ok=false;
		}	

			
		return $attributs_ok;
	}
	
	/**
	 * Vrifie la validit des donnes avant une insertion en base.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyInsert(&$message){
		$verif=RessourceTexte::verify($message);
		return $verif && true;
	}
	
	/**
	 * Vrifie la validit des donnes avant une mise  jour des donnes.
	 * Appel de la mthode verify() et vrifie les attributs propres aux classes hrits.
	 * @see verify() 
	 * @param string &$message En cas d'erreur, cette variable est complte avec le nom de l'attribut incorrect, au format [nom_attribut].
	 * @return boolean true si les donnes sont correctes, false si non.
	 */
	function verifyUpdate(&$message){
		$attributs_ok=true;
	
		if(empty($this->id)){
			$message.="[id]";
			$attributs_ok=false;
		}	
		$verif=RessourceTexte::verify($message);
		return $attributs_ok && $verif && true;
	}	
	
    /**
    * Fonction qui insre un enregistrement en table grille et qui retourne l'identifiant de la ligne cre
    * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
    * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
    */
    function insertToDB($theme, &$message){
		 //vrifie la prsence du theme
		if(empty($theme)){
			die("Erreur RessourceTexte::insertToDB($theme, &$message=\"\"): Le thme est manquant.");
		}
        //vrification donnes et insertion
		if(RessourceTexte::verifyInsert(&$message)){
			//$this->id=set_ressource_texte(addslashes($this->libelle), addslashes($this->adresse),addslashes($this->description), addslashes($this->texte),"FALSE",$theme,26);
			// Modif said du 20/01/09
			$this->id=set_ressource_texte($this->libelle,$this->adresse,$this->description,$this->texte,"FALSE",$theme,26);
			
			return $this->id;
		}
		else{
			return false;
		}
    }

        
     /**
	 * Obtenir le nom des attributs requis pour la creation d'un QCM.
	 * @return array Noms des attributs.
	 */
	function getRequiredVars(){
		return Array("libelle", "adresse","description", "texte", "theme_ressource_texte"); 
	}
	
	/**
	 * Obtenir les valeurs possibles pour un attribut.
	 * Retourne null si un attibut peu avoir n'importe quelle valeur.
	 * 
	 * @param string $var_name Nom de l'attribut.
	 * @return array Valeurs que peut avoir l'attribut. Si null, toutes les valeurs sont possibles.
	 */
	function getVarValues($var_name){
		switch($var_name){
			default:
				return null;
		}
	}
}
?>