<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fonctions d'appel au fonctions PL/PGSQL pour les ressources texte.
 * 
 * @package ressource_texte
 * @modulegroup plpgsql
 * @module plpgsql_ressource
 */

/**
*  Obtenir les donnes d'une ressource texte (OLD)
*  @param integer : identifiant en base
*  @return integer : resultat requete
*/
function get_ressource_texte_old($id){

}
/**
*  Obtenir les donnes d'une ressource texte 
*  @param integer : identifiant en base
*  @return integer : resultat requete
*/
function get_ressource_texte($id){
	if(VERSION_BASE>VERSION){
		$req = "select * from contraintes.af_get_fichier_texte($id) AS ( id int4, libelle varchar, \"type\" int4, connecte bool, titre varchar, lien varchar, description varchar, mise_en_forme text, date_modification text)";
		//echo "$req<br>";
		$res = pg_query($req);
	}
	else
		$res=get_ressource_texte_old($id);
	return $res;
}


/**
 * Cre une ressource texte  (OLD).
 * @param string $libelle Nouveau libll du Fichier Texte
 * @param string $titre Nouveau titre du Fichier Texte
 * @param string $adresse Nouveau lien du Fichier Texte
 * @param string $description Nouvelle description du Fichier Texte
 * @param string $mise_en_forme Nouvelle mise en forme du Fichier Texte
 * @param string $connecte  Nouvel tat de connection du Fichier Texte('TRUE' ou 'FALSE')
 * @param integer $theme le numero du theme
 * @param integer $categorie le numero de la categorie
 * 
 * @return integer Identifiant du nouveau fichier texte.
 */
function set_ressource_texte_old($libelle, $adresse, $description, $mise_en_forme, $connecte, $theme, $categorie) {
	if(empty($mise_en_forme)){
		if(!empty($adresse)&&!empty($description)){
			$text="<b><u>$libelle</u> :</b><br><br><a href=\"$adresse\">$adresse</a><br><br><i>$description</i>";	
		}
		else{
			$text="donnes manquantes ($libelle, $adresse, $description, $mise_en_forme)";	
		}
	}else{
		$text=$mise_en_forme;	
	}
	$sql="INSERT INTO ressource_txt (nom,num_themedir,text) values ('" . addslashes($libelle)."', $theme, '" . addslashes($text)."')";
	//echo "sql=$sql<br>";
	$ins=pg_query($sql);
	if ($ins) {
		$oid = pg_getlastoid($ins);
		$sql = "SELECT num_text FROM ressource_txt WHERE oid=$oid";
		$res = pg_query($sql);
		$row = pg_fetch_row($res, 0);
		//return $row[0];
		return $res;
	} 
	else
		return null;
}
/**
 * Cre une ressource texte  .
 * @param string $libelle Nouveau libll du Fichier Texte
 * @param string $titre Nouveau titre du Fichier Texte
 * @param string $adresse Nouveau lien du Fichier Texte
 * @param string $description Nouvelle description du Fichier Texte
 * @param string $mise_en_forme Nouvelle mise en forme du Fichier Texte
 * @param string $connecte  Nouvel tat de connection du Fichier Texte('TRUE' ou 'FALSE')
 * @param integer $theme le numero du theme
 * @param integer $categorie le numero de la categorie
 * 
 * @return integer Identifiant du nouveau fichier texte.
 */
function set_ressource_texte($libelle,  $adresse, $description, $mise_en_forme, $connecte, $theme, $categorie) {

	if (VERSION_BASE > VERSION) {
		$req = "select * from contraintes.af_set_categorie_fichier_texte_theme( varchar '$libelle',  varchar '$libelle',  varchar '$adresse',  varchar '$description',  text '$mise_en_forme', boolean '$connecte', integer '$theme', integer '$categorie')";
		//echo "req=$req<br>";
		//echo htmlentities($req);
		$res = pg_query($req);

	}
	else {
		$res=set_ressource_texte_old($libelle, $adresse, $description, $mise_en_forme, $connecte, $theme, $categorie);
	}

	return pg_result($res, 0, 0);
}



?>