<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package resultat
 * @modulegroup plpgsql
 * @module plpgsql_resultat
 */

function set_resultat_debut($formation, $individu, $parcours,$etape ){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_set_resultat_debut($formation, $individu, $parcours,$etape)";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("set_resultat_debut:A impl�menter...");
    }
    return pg_fetch_result($res,0,0);
} 

function maj_resultat_debut($resultat){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_maj_resultat_debut($resultat)";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("maj_resultat_debut:A impl�menter...");
    }
    return pg_fetch_result($res,0,0);
} 

function set_resultat_fin($resultat){
	if(VERSION_BASE>VERSION){
		
        $req="SELECT * FROM contraintes.af_set_resultat_fin($resultat)";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("set_resultat_fin:A impl�menter...");
    }
    return pg_fetch_result($res,0,0);
} 

function maj_resultat_fin($resultat){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_maj_resultat_fin($resultat)";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("maj_resultat_fin:A impl�menter...");
    }
    return pg_fetch_result($res,0,0)=='t';
} 

function del_resultat_fin($resultat){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_del_resultat_fin($resultat)";
        echo "$req<br>";
        $res=pg_query($req);
//        exit;
    }
    else{
       print("af_del_resultat_fin:A impl�menter...");
    }
    return pg_fetch_result($res,0,0)=='t';
} 

/**
 * 
 * @return le resultat de la requete :(id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval)
 */
function get_resultat($resultat){
	if(VERSION_BASE>VERSION){//serie_evaluation, id_evaluation, type_evaluation, commentaire_evaluation, bareme_evaluation, chrono_evaluation, points_evaluation, NULL AS score 
        $req="SELECT * FROM contraintes.af_get_resultat($resultat) AS (id int8,  formation int4, stagiaire int4,parcours int4, etape int4,  date_debut timestamp, duree interval)";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat:A impl�menter...");
    }
    if(pg_num_rows($res)==1){
    	 return pg_fetch_row($res);
    }
   	else return null;
}

/**
 * @return integer Resultat requete (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval)
 */
function get_resultat_etape($formation, $individu, $parcours,$etape ){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_resultat($formation, $individu, $parcours,$etape) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval)";
//		echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat_etape:A impl�menter...");
    }
    return $res;
}

/** 
	Obtenir l'avancement d'un individu pour une formation 
	@param integer : formation
	@param integer : individu
	@return integer :   resultat requete (parcours int4, etape int4,type int4, formation int4,individu int4, date_debut timestamp, duree interval)
*/
function get_resultat_formation($formation, $individu){
	 if (VERSION_BASE > VERSION) { 
		$sql="select * from contraintes.af_get_resultat_formation($formation, $individu, NULL) 
					as (parcours int4, etape int4,type int4, formation int4,individu int4, date_debut timestamp, duree interval)";
//		echo "$sql<br>";					
		return pg_query($sql);
	 }
	 else
		die("get_resultat_formation() � implementer.");
}
/**
 * Obtenir l'evaluation � faire d'une serie. 
 * 
 * @param integer $resultat l'identifiant de resultat
 * @return integer  le resultat de la requete (resultat int8, formation int4, stagiaire int4,parcours int4, etape int4, evaluation int4, type int4, indice integer ,duree_totale interval )
 */
function get_resultat_serie_avancement_max($resultat){
	if(empty($resultat))die("Erreur: get_resultat_serie_avancement_max: Parametre manquant<br>");
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_resultat_serie_avancement_max($resultat) as (resultat int8, formation int4, stagiaire int4,parcours int4, etape int4, evaluation int4, type int4, indice integer ,duree_totale interval)";
//		echo $sql;
		$res=pg_query($sql); 
    }
      else{
       print("get_resultat_serie_avancement_max:A impl�menter...");
    }
    return $res ;	
}


function get_resultat_serie_evaluations_duree_totale($resultat){
	if(empty($resultat))die("Erreur: get_resultat_serie_evaluations_duree_totale: Parametre manquant<br>");
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_resultat_serie_evaluations_duree_totale($resultat) ";
		//echo $sql;
		$res=pg_query($sql); 
    }
      else{
       print("get_resultat_serie_avancement_max:A impl�menter...");
    }
    return $res ;	
}

/**
 * Obtenir l'evaluation � faire d'une serie aleatoire. 
 * 
 * @param integer $resultat l'identifiant de resultat
 * @return integer  le resultat de la requete (resultat int8, formation int4, stagiaire int4,parcours int4, etape int4, evaluation int4, type int4, indice integer  )
 */
function get_resultat_serie_aleatoire_avancement_max($resultat){
	if(empty($resultat))die("Erreur: get_resultat_serie_aleatoire_avancement_max: Parametre manquant<br>");
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_resultat_serie_aleatoire_avancement_max($resultat) as (resultat int8, formation int4, stagiaire int4,parcours int4, etape int4, evaluation int4, type int4, indice integer, duree_totale interval)";
		//echo $sql;
		$res=pg_query($sql); 
    }
      else{
       print("get_resultat_serie_aleatoire_avancement_max:A impl�menter...");
    }
    return $res ;	
}

/**
* Obtenir l'evaluation � faire d'une serie aleatoire configuree. 
 * 
 * @param integer $resultat l'identifiant de resultat
 * @return integer  le resultat de la requete (resultat int8, formation int4, stagiaire int4,parcours int4, etape int4, evaluation int4, type int4, indice integer  )
*/
function get_resultat_serie_melangee_avancement_max($resultat){
	if(empty($resultat))die("Erreur: get_resultat_serie_melangee_avancement_max: Parametre manquant<br>");
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_resultat_serie_melangee_avancement_max($resultat) as (resultat int8, formation int4, stagiaire int4,parcours int4, etape int4, evaluation int4, type int4, indice integer)";
//		echo $sql;
		$res=pg_query($sql); 
    }
      else{
       print("get_resultat_serie_melangee_avancement_max:A impl�menter...");
    }
    return $res ;	
}

/**
*   Obtenir les scores des evaluations d'une serie � partir d'un identifiant resultat.
*
*   @param integer $resultat l'identifiant resultat
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
*/
function old_get_resultat_serie_evaluations_scores($resultat) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_resultat_serie_evaluations_scores($resultat) AS (id int8, etape integer, evaluation integer, type_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, score integer )";
		//echo "$sql<br>";
		return pg_query($sql);
	} else
		die("get_resultat_serie_evaluations_scores($serie) n'existe pas pour la version ".VERSION);
}

/**
*   Obtenir les scores des evaluations d'une serie � partir d'un identifiant resultat.
*   @NOTE test resultats qcm (pour debuggage)
*   @param integer $resultat l'identifiant resultat
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
*/
function get_resultat_serie_evaluations_scores($resultat) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_resultat_serie_evaluations_scores($resultat) AS (id int8, etape integer, evaluation integer, type_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, score real )";
		//echo "$sql<br>";
		return pg_query($sql);
	} else
		die("get_resultat_serie_evaluations_scores($serie) n'existe pas pour la version ".VERSION);
}
   
/**
*   Obtenir les scores des evaluations d'une serie aleatoire � partir d'un identifiant resultat.
*   @NOTE test resultats qcm (pour debuggage)
*   @param integer $resultat l'identifiant resultat
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
*/
function get_resultat_serie_aleatoire_evaluations_scores($resultat) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_resultat_serie_aleatoire_evaluations_scores($resultat) AS 
		(id int8, etape integer, evaluation integer, type_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, score real )";
		
		//echo "$sql<br>";
		return pg_query($sql);
	} else
		die("get_resultat_serie_evaluations_scores($serie) n'existe pas pour la version ".VERSION);
}

function set_resultat_serie_debut($resultat, $evaluation){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_set_resultat_serie_debut($resultat, $evaluation) ";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("set_resultat_serie:A impl�menter...");
    }
    return pg_fetch_result($res,0,0);
}

function set_resultat_serie_fin($resultat, $evaluation){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_set_resultat_serie_fin($resultat, $evaluation) ";
        //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("set_resultat_serie:A impl�menter...");
    }
    return pg_fetch_result($res,0,0);
}

/**
 * @return integer Resultat de la requete :(id int8, evaluation int4, date_debut timestamp, date_fin timestamp)
 */
function get_resultat_serie_evaluation($resultat, $evaluation){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_resultat_serie_evaluation($resultat, $evaluation) AS (id int8, evaluation int4, date_debut timestamp, date_fin timestamp)";//(id int8, evaluation int4, date_creation timestamp, commentaire varchar, bareme integer, chrono integer, points integer) ";
        //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat_serie_ftb:A impl�menter...");
    }
    return $res;
}

/**
 * @return integer Resultat de la requete :(id int8, evaluation int4, date_creation timestamp, commentaire varchar, bareme integer, chrono integer, points integer)
 */
function get_resultat_serie_aleatoire_evaluation($resultat, $evaluation){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_resultat_serie_aleatoire_evaluation($resultat, $evaluation) AS (id int8, evaluation int4, date_creation timestamp,bareme int4,chrono int4) ";
        //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat_serie_ftb:A impl�menter...");
    }
    return $res;
}

function set_resultat_serie_ftb($resultat, $ftb, $reponse){
	global $s_langue;
	if(VERSION_BASE>VERSION){
		//print_rr($reponse);
		//$reponse=string_array_to_plpgsql_array($reponse);
		$chaine_reponse=implode(",",$reponse);
		/*
		$chaine_reponse='';
		while(list($cle,$val)=each($reponse)){
			$chaine_reponse.="'".$val."',";
			
		}
		$chaine_reponse=substr($chaine_reponse,0,-1);
		*/
		//print_rr($reponse);
		$ams_string = '##AMS'.$s_langue.'##{"'.addslashes($chaine_reponse).'"}';
		$req="SELECT * FROM contraintes.af_set_resultat_serie_ftb($resultat,$ftb,'$ams_string') ";
        //$req="SELECT * FROM contraintes.af_set_resultat_serie_ftb($resultat,$ftb,'".set_ams_libelle($reponse)."') ";
       //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("set_resultat_serie_ftb:A impl�menter...");
    }
    return pg_fetch_result($res,0,0);
}

function set_resultat_serie_question_reponse($resultat, $question_reponse, $questions,$reponses, $valeurs){
	if(VERSION_BASE>VERSION){
		$v_questions=int_array_to_plpgsql_array($questions);
		$v_reponses=int_array_to_plpgsql_array($reponses);
		$v_valeurs=int_array_to_plpgsql_array($valeurs);
        $req="SELECT * FROM contraintes.af_set_resultat_serie_question_reponse($resultat,$question_reponse, $v_questions,$v_reponses,$v_valeurs) ";
        //echo "$req<br>";die();
        $res=pg_query($req);
    }
    else{
       print("set_resultat_serie_question_reponse:A impl�menter...");
    }
    return pg_fetch_result($res,0,0)=='t';
}


/**
 * @return integer Resultat de la requete :(id int8, question_reponse integer, question integer, reponse integer,  date_creation timestamp, coche boolean, juste boolean)
 */
function get_resultat_serie_question_reponse($resultat, $question_reponse){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_resultat_serie_question_reponse($resultat, $question_reponse) AS (id int8, question_reponse integer, question integer, reponse integer,  date_creation timestamp, coche boolean, juste integer) ";
      //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat_serie_question_reponse:A impl�menter...");
    }
    return $res;
}

/**
 * @return integer Resultat de la requete :(id int8, question_reponse integer, question integer, reponse integer,  date_creation timestamp, coche boolean, juste boolean)
 */
function get_resultat_serie_aleatoire_question_reponse($resultat, $question_reponse){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_resultat_serie_aleatoire_question_reponse($resultat, $question_reponse) AS (id int8, question_reponse integer, question integer, reponse integer,  date_creation timestamp, coche boolean, juste integer) ";
        //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat_serie_aleatoire_question_reponse:A impl�menter...");
    }
    return $res;
}

/**
 * @return integer Resultat de la requete :(id int8, ftb integer, reponse text,  date_creation timestamp)
 */
function get_resultat_serie_ftb($resultat, $ftb){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_resultat_serie_ftb($resultat, $ftb) AS (id int8, ftb integer, reponse text[],  date_creation timestamp,langue int4) ";
        //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat_serie_ftb:A impl�menter...");
    }
    return $res;
}

function set_resultat_serie_qsrc($resultat, $question_reponse, $questions,$reponses, $valeurs){
	if(VERSION_BASE>VERSION){
		$v_questions=int_array_to_plpgsql_array($questions);
		$v_reponses=int_array_to_plpgsql_array($reponses);
		$v_valeurs=int_array_to_plpgsql_array($valeurs);
        $req="SELECT * FROM contraintes.af_set_resultat_serie_qsrc($resultat,$question_reponse, $v_questions,$v_reponses,$v_valeurs) ";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("set_resultat_serie_question_reponse:A impl�menter...");
    }
    return pg_fetch_result($res,0,0)=='t';
}

function set_resultat_exotlc_plateforme($resultat, $fichier_rendu){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_set_resultat_exotlc_plateforme($resultat, $fichier_rendu) ";
//        echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("set_resultat_exotlc_plateforme:A impl�menter...");
    }
    return pg_fetch_result($res,0,0);
}

function maj_resultat_exotlc_plateforme($resultat, $fichier_rendu){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_maj_resultat_exotlc_plateforme($resultat, $fichier_rendu) ";
        //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("maj_resultat_exotlc_plateforme:A impl�menter...");
    }
     return pg_fetch_result($res,0,0);
}

/**
 * 
 * @return integer : resultat de la requete :(id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval, commentaire varchar, correction bool, fichier_rendu integer, date_correction timestamp)
 */
function get_resultat_exotlc($resultat){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_resultat_exotlc($resultat) AS (id int8,formation int4, stagiaire int4, parcours int4, etape int4, date_debut timestamp, duree interval, commentaire text, correction bool, fichier_rendu integer, date_correction timestamp) ";
        //echo "$req<br>";
        $res=pg_query($req);
    }
    else{
       print("get_resultat_exotlc:A impl�menter...");
    }
    return $res;
}

/**
	Obtenir les resultats des criteres d'un exotlc
	@param integer : id resultat
	@return integer : res req (id_resultat int8,critere int4,libelle varchar,note int4,note_max int4,commentaire text)
*/
function get_resultat_exotlc_criteres($resultat){
	$sql="select * from contraintes.af_get_resultat_exotlc_criteres($resultat) as (id int8,critere int4,libelle varchar,note int4,note_max int4,commentaire text)";
//	echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir les resultats des souscriteres d'un exotlc
	@param integer : id resultat
	@return integer : res req (id_resultat int8,sous_critere int4,note int4,note_max int4)
*/
function get_resultat_exotlc_sous_criteres($resultat){
	$sql="select * from contraintes.af_get_resultat_exotlc_sous_criteres($resultat) as (id int8,sous_critere int4,libelle varchar,note int4,note_max int4)";
	return pg_query($sql);
}

/**
	Obtenir les resultats des souscriteres d'un exotlc pour un critere
	@param integer : id resultat
	@param integer : critere
	@return integer : res req (id_resultat int8,sous_critere int4,libelle varchar,note int4,note_max int4,commentaire text)
*/
function get_resultat_exotlc_critere_sous_criteres($resultat,$critere){
	$sql="select * from contraintes.af_get_resultat_exotlc_critere_sous_criteres($resultat,$critere)  as (id int8,critere int4,sous_critere int4,libelle varchar,note int4,note_max int4)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir les resultats d'un critere d'un exotlc
	@param integer : id resultat
	@return integer : res req (id_resultat int8,critere int4,note int4,note_max int4,commentaire text)
*/
function get_resultat_exotlc_critere($resultat,$critere){
	$sql="select * from contraintes.af_get_resultat_exotlc_critere($resultat,$critere) as (id int8,critere int4,note int4,note_max int4,commentaire text)";
	return pg_query($sql);
}

/**
	Obtenir les resultat d'un sous critere d'un exotlc
	@param integer : id resultat
	@param integer : sous critere
	@return integer : res req (id_resultat int8,sous_critere int4,note int4,note_max int4)
*/
function get_resultat_exotlc_sous_crirere($resultat,$sous_critere){
	$sql="select * from contraintes.af_get_resultat_exotlc_sous_critere($resultat,$sous_critere) as (id int8,sous_critere int4, libelle varchar, note int4,note_max int4)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Enregistre l'identifiant de resultat dans la table resultat_exotlc
	@param integer : id resultat
	@return integer : res req
*/
function set_resultat_exotlc($resultat){
	$sql="select * from contraintes.af_set_resultat_exotlc($resultat)";
//	echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Verifie si un critere existe pour un id resultat
	@param integer : id resultat
	@param integer : critere
	@return integer : res req
*/
function is_resultat_exotlc_critere($resultat,$critere){
	$sql="select * from contraintes.af_is_resultat_exotlc_critere($resultat,$critere)";
//	echo "sql=$sql<br>";
	return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
}

/**
	Verifie si un sous critere existe pour un id resultat
	@param integer : id resultat
	@param integer : critere
	@return integer : res req
*/
function is_resultat_exotlc_sous_critere($resultat,$sous_critere){
	$sql="select * from contraintes.af_is_resultat_exotlc_sous_critere($resultat,$sous_critere)";
	return pg_fetch_result(pg_query($sql),0,0)=='t';
}

/**
	Enregistre les resultats d'un critere pour un id resultat
	@param integer : id resultat
	@param integer : critere
	@param integer : note
	@param integer : notesur
	@param string : commentaire
	@return integer : res req
*/
function set_resultat_exotlc_critere($resultat,$critere,$note,$notesur,$commentaire){
	$sql="select * from contraintes.af_set_resultat_exotlc_critere($resultat,$critere,$note,$notesur,'$commentaire')";
//	echo "sql=$sql<br>";
	return pg_query($sql);
}

 /**
	Mettre � jour les resultats d'un critere pour un id resultat
	@param integer : id resultat
	@param integer : critere
	@param integer : note
	@param integer : notesur
	@param string : commentaire
	@return integer : res req
*/
function maj_resultat_exotlc_critere($resultat,$critere,$note,$notesur,$commentaire){
	$sql="select * from contraintes.af_maj_resultat_exotlc_critere($resultat,$critere,$note,$notesur,'$commentaire')";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Met � jour les resultat pour un identifiant de resultat
	@param integer : id resultat
	@param string : commentaire
	@param bool : correction
	@return integer : res req
*/
function maj_resultat_exotlc($resultat,$commentaire,$correction){
	$sql="select * from contraintes.af_maj_resultat_exotlc($resultat,'$commentaire','$correction')";
	//echo "sql=$sql<br>";
	//die();
	return pg_query($sql);
}

/**
   Supprime les resultats pour un identifiant de resultat
   @param integer : id resultat
   @return integer : res req
*/
function del_resultat_exotlc($resultat){
	$sql="select * from contraintes.af_del_resultat_exotlc($resultat)";
	return pg_query($sql);
}

/**
   Supprime le fichier rendu pour un identifiant de resultat
   @param integer : id resultat
   @return bool 
*/
function del_resultat_exotlc_fichier_rendu($resultat){
	$sql="select * from contraintes.af_del_resultat_exotlc_fichier_rendu($resultat)";
	return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
}

/**
	Enregistre les resultats d'un sous-critere pour un id resultat
	@param integer : id resultat
	@param integer : sous-critere
	@param integer : note
	@param integer : notesur
	@return integer : res req
*/
function set_resultat_exotlc_sous_critere($resultat,$sous_critere,$note,$notesur){
	$sql="select * from contraintes.af_set_resultat_exotlc_sous_critere($resultat,$sous_critere,$note,$notesur)";
//	echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Modifie les resultats d'un sous-critere pour un id resultat
	@param integer : id resultat
	@param integer : sous-critere
	@param integer : note
	@param integer : notesur
	@return integer : res req
*/
function maj_resultat_exotlc_sous_critere($resultat,$sous_critere,$note,$notesur){
	$sql="select * from contraintes.af_maj_resultat_exotlc_sous_critere($resultat,$sous_critere,$note,$notesur)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir la note general (20) pour un identifiant de resultat
	@param integer : id resultat
	@return integer : res req
*/
function get_resultat_exotlc_moyenne($resultat){
	$sql="select * from contraintes.af_get_resultat_exotlc_moyenne($resultat) ";
	return pg_query($sql);
}

/**
   Obtenir le score d'une serie  (OLD)
   @param integer : id resultat
   @return integer : res req
*/
function get_resultat_serie_score_old($resultat){

}
/**
   Obtenir le score d'une serie  
   @param integer : id resultat
   @return integer : res req
*/
function get_resultat_serie_score($resultat){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_resultat_serie_score($resultat)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else{
	
	}
	return pg_fetch_result($res,0,0);		
}

/**
   Obtenir le score d'une serie (tentative)  
   @param integer : id resultat
   @return integer : res req
*/
function get_resultat_serie_score_tentative($resultat){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_resultat_serie_score_tentative($resultat)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else{
	
	}
	return pg_fetch_result($res,0,0);		
}

/**
   Obtenir la note d'un qcm de serie
   @param integer : id resultat
   @param integer : evaluation
   @return integer : la note
*/
function get_resultat_serie_questionreponses_scores($resultat,$evaluation){
	$sql="select * from contraintes.af_get_resultat_serie_questionreponses_scores($resultat,$evaluation)";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	if($res)
		return pg_fetch_result($res,0,0);
	else 
		return null;
}

/**
   Obtenir la note d'un qcm de serie aleatoire
   @param integer : id resultat
   @param integer : evaluation
   @return integer : la note
*/
function get_resultat_serie_aleatoire_questionreponses_scores($resultat,$evaluation){
	$sql="select * from contraintes.af_get_resultat_serie_aleatoire_questionreponses_scores($resultat,$evaluation)";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0);
}


/**
   Obtenir la note d'un ftb de serie
   @param integer : id resultat
   @param integer : evaluation
   @return integer : la note
*/
function get_resultat_serie_ftb_scores($resultat,$evaluation){
	// NOTE Said (01/07/08)
	// recup de la liste des mots en fonction le la langue de la reponse
	/*
	$sql="select * from contraintes.af_get_resultat_serie_ftb($resultat,$evaluation) as (id int8, ftb integer, reponse text[],  date_creation timestamp,langue int4) ";
	$res=pg_query($sql);
	$langue_ams=pg_fetch_result($res,0,4);
	
	$sql="select * from contraintes.af_get_ftb($evaluation) as (id int4, libelle varchar,text text,voir_mots bool,interpretation_html bool, date_creation timestamp)";
	$res=pg_query($sql);
	$texte=get_ftb_libelle($langue_ams,pg_fetch_result($res,0,2));
	//echo "texte=$texte<br>";
	$liste_mots=getBlanks($texte);
	$liste_mots=string_array_to_plpgsql_array($liste_mots);
	*/
	
	$sql="select * from contraintes.af_get_resultat_serie_ftb_scores($resultat,$evaluation)";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0);
}

/**
	Obtenir les stagiaires ayant repondu � une evaluation de type question reponse
	@param integer : id resultat
	@param integer : evaluation
	@return integer : res req 
*/
function get_resultat_serie_questionreponses_stagiaires($resultat,$evaluation){
	$sql="select * from contraintes.af_get_resultat_serie_questionreponses_stagiaires($resultat,$evaluation) as (individu int4,nom varchar,prenom varchar)";
	return pg_query($sql);
}

/**
	Obtenir les evaluation de serie effecut�es par l'individu
	@param integer : id resultat
	@return integer : res req 
*/
function get_resultat_serie_evaluations($resultat){
	$sql="select * from contraintes.af_get_resultat_serie_evaluations($resultat) as 
			(id int8,evaluation int4,date_debut timestamp,date_fin timestamp)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir les evaluation de serie effecut�es par l'individu (tentative)
	@param integer : id resultat
	@return integer : res req 
*/
function get_resultat_serie_evaluations_tentative($resultat){
	$sql="select * from contraintes.af_get_resultat_serie_evaluations_tentative($resultat) as 
			(id int8,evaluation int4,date_creation timestamp)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir le nb de tentative effectu�e pour un identifiant de resultat
	@param integer : id resultat
	@return integer : le nb de tentative
*/
function get_resultat_etape_tentative($resultat){
	$sql="select * from contraintes.af_get_resultat_etape_tentative($resultat) as (id int8,formation int4,stagiaire int4,parcours int4,etape int4,date_debut timestamp,duree interval,tentative int4)";
//	echo $sql;
	return pg_query($sql); 
}

/**
	Insertion des resultat d'une tentative
	L'insertion consiste a recopier les donnes d'un resultat dans les tables de tentatives (pas de suppression) et
	 remettre a zero la date de fin de resultat.
	
	@param integer : id resultat
	@return boolean
*/
function set_resultat_tentative($resultat){
	$sql="select * from contraintes.af_set_resultat_tentative($resultat)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
	Obtenir l'identifiant resultat tentative
	@param integer :  formation
	@param integer :  individu
	@param integer : parcours
	@param integer : etape
	@param integer : numero tentative
	@return integer : res req
*/
function get_resultat_tentative($formation,$individu,$parcours,$etape,$tentative){
	$sql="select * from contraintes.af_get_resultat_tentative($formation,$individu,$parcours,$etape,$tentative) as (id int8,formation int4,stagiaire int4,parcours int4,etape int4,date_debut timestamp,duree interval,tentative int4)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
*   Obtenir les scores des evaluations d'une serie � partir d'un identifiant resultat. (tentative)

*   @param integer $resultat l'identifiant resultat
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
*/
function get_resultat_serie_evaluations_scores_tentative($resultat) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_resultat_serie_evaluations_scores_tentative($resultat) AS (id int8, etape integer, evaluation integer, type_evaluation integer, commentaire_evaluation varchar, bareme_evaluation integer, chrono_evaluation integer, points_evaluation integer, score real )";
		//echo "$sql<br>";
		return pg_query($sql);
	} else
		die("get_resultat_serie_evaluations_scores_tentative($serie) n'existe pas pour la version ".VERSION);
}

/**
	Enregistre la meilleure tentative d'une serie bloquante
	*   @param integer $resultat l'identifiant resultat
*/
function set_resultat_meilleure_tentative($resultat){
	$sql="select * from contraintes.af_set_resultat_meilleure_tentative($resultat)";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
   Retourne le sous parcours issu de la configuration d'une etape parcours oriente et des resultat de l'individu
   *   @param integer $resultat l'identifiant resultat
	*  @return integer : numero sous parcours
   
*/
function get_resultat_parcours_parcours_oriente($resultat){
	$sql="select * from contraintes.af_get_resultat_parcours_parcours_oriente($resultat)";
	return pg_query($sql);
}

/**
   Obtenir le score d'une serie aleatoire  
   @param integer : id resultat
   @return integer : res req
*/
function get_resultat_serie_aleatoire_score($resultat){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_resultat_serie_aleatoire_score($resultat)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
	}
	else{
	
	}
	return pg_fetch_result($res,0,0);		
}

/**
   Savoir s'il y a un resultat pour une formation,un parcours et une etape
   @param integer : formation
   @param integer : parcours
   @param integer : etape
   @return bool : vrai si resultat,faux sinon
*/
function is_resultat_formation_parcours_etape($formation,$parcours,$etape){
	$sql="select * from contraintes.af_is_resultat_formation_parcours_etape($formation,$parcours,$etape)";
	$res=pg_query($sql);
	 return pg_fetch_result($res,0,0);
	
}



?>