<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Dfinition de la classe salle  (num_salle, nom_salle)

@author LADJANI said <sladjani@afide.fr>
@since 29/03/2005

@package salle
*/
class Salle
{
        /**
        * @var integer : Identifiant en base de donnes
        */
        var $num_salle ;

        /**
        * @var string : Nom de la salle
        */
        var $nom_salle ;

        /**
        * Constructeur
        * Ce constructeur permet de crer un objet Salle de deux faon diffrentes. Soit il va chercher un nom dans
        * la base de donnes et dans ce cas il faut lui donner l'identifiant. Autrement, on lui passe une chane de caractre
        * qui sera affecte au nom.
        * @param string : Peut-tre ou bien un identifiant de ligne en base de donnes (c'est donc un entier), ou une chane soit une
        * nouvelle salle
        */
        function Salle($num_ou_lib)
        {

                // On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine)
                {
                        $this->num_salle = $num_ou_lib ;
                        // echo "Class Salle : constructeur avec identifiant<br>" ;
                        /*
                        $requete="SELECT * FROM salle WHERE num_salle=$num_ou_lib" ;
                        $result=pg_query($requete) ;
                        */
                        $result=get_salle($num_ou_lib);
                        $row=pg_fetch_row($result) ;
                        $this->nom_salle = $row[1] ;

                }
                // Construction  partir d'un nom
                else
                {
                       $this->nom_salle = $num_ou_lib ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin Organisme($num_ou_lib)


        /**
        * Fonction qui insre un enregistrement en table salle et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si la salle n'existe pas dj
                if($this->nom_salle=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        //$lib=addslashes($this->nom_salle) ;
                        $lib=$this->nom_salle ;
                        // Cet organisme existe-il dj ?
                        //if(pg_num_rows(pg_query("SELECT num_salle FROM salle WHERE nom_salle='$lib'"))>0)
						
                        if(check_salle($lib))
                        {
                                return (-111);  // salle existe dj
                        }
                        else
                        {
						
                                //$insertion = "INSERT INTO salle (nom_salle) VALUES ('$lib')" ;
                                $insertion=set_salle(set_ams_libelle($lib));

                                // On retourne un boolen
                                //if($res = pg_query($insertion))
                                if($insertion)
                                {
                                        /*
                                        $tmp = pg_result(pg_query("SELECT num_salle FROM salle WHERE nom_salle='$lib'"),0,0) ;
                                        // on retourne l'identifiant de la ligne cre
                                        return($tmp);
                                        */
                                        return $insertion;
                                }
                                else
                                        return (-1) ; // Problme requte
                        }
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table salle
        *
        * Fonction qui met  jour l'enregistrement en table salle
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->num_salle != 0)
                {
                        //$update = "UPDATE salle SET nom_salle = '".addslashes($this->nom_salle)."' WHERE num_salle=$this->num_salle" ;
                        //$lib=addslashes($this->nom_salle) ;
                        $lib=$this->nom_salle ;
                        $update=maj_salle($this->num_salle,set_ams_libelle($lib));

                         //echo "Class Salle : updateToDB. Requete =<br>$update<br>" ;

                        // On retourne un boolen
                        //if(pg_query($update))
                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()

        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet.
        * Si on ne passe aucun paramtre, la chane retourne contient le libell de l'organisme. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        *
        * @param string : le paramtre determine ce qu'on retourne.
        * [num_org] - [libelle_org]
        * @return string : On retourne la chane de caractres cre  partir du format
        */

        function toString($format="")
        {
                // Aucun paramtre, on retourne le libell
                if($format=="")
                        return $this->nom_salle ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[num_salle\]"=>$this->num_salle,"\[nom_salle\]"=>$this->nom_salle) ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)

       
}

?>