<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**

       @package salle
       @modulegroup plpgsql
       @module plpgsql_salle
*/

/**
*   Test si la salle donne est supprimable (OLD)
*
*   Retourne 0 si non supprimable et >0 sinon
*
*    @param  integer : numro de salle
*
*   @return integer : entier 0 ou >0
*/
function check_salle_supprimable_old($salle){
    $sql="select num_salle from gest_cal where num_salle=$salle";
    return(pg_query($sql));
   }
/**
*   Test si la salle donne est supprimable
*
*   Retourne 0 si non supprimable et >0 sinon
*
*    @param  integer : numro de salle
*
*   @return integer : entier 0 ou >0
*/
function check_salle_supprimable($salle){
     if(VERSION_BASE>VERSION){
		$res=!fk_finder('salle','id',$salle);
     }
     else
        $res=check_salle_supprimable_old($salle);

     return $res;
}

/**
*   Supprimer une salle.  (OLD)
*
*   Supprime la salle

*
*   @param integer : numero de la salle  supprimer
*   @return integer : 1
*/

/**
   Obtenir le nom de la salle (OLD)
*
    @deprecated : utiliser get_salle($salle)
*   @param integer : le numero de la salle
*   @return integer : le resultat de la requete
*/
function get_salle_nom_old($salle){
    $sql="select nom_salle from salle where num_salle=$salle";
    $res=pg_query($sql);
    return $res;
}
/**
   Obtenir le nom de la salle
*
    @deprecated : utiliser get_salle($salle)
*   @param integer : le numero de la salle
*   @return integer : le resultat de la requete
*/
function get_salle_nom($salle){
    if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
    }
    else
        $res=get_salle_nom_old($salle);
    return ($res);
}

/**
   Obtenir le nom de la salle (OLD)
*
*   @param integer : le numero de la salle
*   @return integer : le resultat de la requete
*/
function get_salle_old($salle){
    $sql="select num_salle,nom_salle from salle where num_salle=$salle";
    $res=pg_query($sql);
    return $res;
}
/**
   Obtenir le nom de la salle
*
*   @param integer : le numero de la salle
*   @return integer : le resultat de la requete
*/
function get_salle($salle){
    if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_salle($salle) as (id int4,libelle varchar)";
		$res=pg_query($sql);
    }
    else
        $res=get_salle_old($salle);
    return ($res);
}

function del_salle_old($salle){

    //suppression
    $del=pg_query("delete from salle where num_salle=$salle;");

    return 1;
}

/**
*   Supprimer une salle.
*
*   Supprime la salle
*
*   @param integer : numero de la salle  supprimer
*   @return integer : 1
*/
function del_salle($salle){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_del_salle($salle)";
		$res=pg_query($sql);
    }
    else
		$res=del_salle_old($salle);
	return ($res);
}

/**
    Vrification des heures de cours pour une salle pour une date de formation (OLD)
*
*   @param integer : le numero de la salle
*   @param date : le jour du cours
*   @param varchar : l'heure de debut
*   @param varchar : l'heure de fin
*   @param integer : le numero de formation
*   @param varchar : debut du cours (mode edition)
*   @return integer : le resultat de la requete
*/
function get_salle_heures_cours_formation_old($salle,$date,$heure_debut,$heure_fin,$formation,$heure_cours=""){
    $sql="SELECT COUNT(*) FROM  dates D, gest_cal G
                WHERE D.num_date=G.num_date
                AND D.jour='$date'
                AND ( ( G.hdeb >= '$heure_debut' AND G.hdeb <= '$heure_fin')  OR ( G.hdeb <= '$heure_debut' AND G.hfin>='$heure_debut') )
                AND G.num_salle=$salle
                AND NOT (G.hdeb = '$heure_cours' AND G.gnum_cal =$formation)";
    $res=pg_query($sql);
    return $res;
}
/**
    Vrification des heures de cours pour une salle pour une date de formation
*
*   @param integer : le numero de la salle
*   @param date : le jour du cours
*   @param varchar : l'heure de debut
*   @param varchar : l'heure de fin
*   @param integer : le numero de formation
*   @param varchar : debut du cours (mode edition)
*   @return integer : le resultat de la requete
*/
function get_salle_heures_cours_formation($salle,$date,$heure_debut,$heure_fin,$formation,$heure_cours=""){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=get_salle_heures_cours_formation_old($salle,$date,$heure_debut,$heure_fin,$formation,$heure_cours);
    return $res;
}

/**
    Obtenir les heures de cours d'une salle pour un jour de formation (OLD)
*
*   @param integer : le numero de la salle
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_salle_cours_formation_old($salle,$date){
    $sql="SELECT C.num_cal, nom_cal, hdeb, hfin,libelle FROM gest_cal G, calendrier C, dates D
                WHERE G.gnum_cal=C.num_cal
                AND D.num_date=G.num_date
                AND G.num_salle=$salle
                AND jour='$date'";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les heures de cours d'une salle pour un jour de formation
*
*   @param integer : le numero de la salle
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_salle_cours_formation($salle,$date){
    if(VERSION_BASE > VERSION){

    }
    else
        $res=get_salle_cours_formation_old($salle,$date);
    return $res;
}

/**
    Verifie si une salle existe (OLD)

    @param le nom de la salle
    @return bool : true si existe ,false sinon
*/
function check_salle_old($libelle){
    $sql="SELECT num_salle FROM salle WHERE nom_salle='$libelle'";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    return true;
}
/**
    Verifie si une salle existe

    @param le nom de la salle
    @return bool : true si existe ,false sinon
*/
function check_salle($libelle){
     if(VERSION_BASE > VERSION){
	     return false;
    }
    else
        $res=check_salle_old($salle);
    return $res;
}

/**
    Enregistre une salle (OLD)

    @param string : le nom de la salle
    @return integer : le numero de la salle ,0 si erreur
*/
function set_salle_old($libelle){
    $sql= "INSERT INTO salle (nom_salle) VALUES ('$libelle')" ;
    $ins=pg_query($sql);
    if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_salle from salle where oid=$oid");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregistre une salle

    @param string : le nom de la salle
    @return integer : le numero de la salle ,0 si erreur
*/
function set_salle($libelle){
     if(VERSION_BASE > VERSION){
		$sql="select * from contraintes.af_set_salle('$libelle')";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
		return pg_fetch_result($res,0,0);
    }
    else
        $res=set_salle_old($libelle);
    //return $res;
}

/**
    Mettre  jour une salle  (OLD)

    @param integer : le numero de la salle
    @param string : le nom de la salle
    @return integer : le resultat de la requete
*/
function maj_salle_old($salle,$libelle){
    $sql="update salle set nom_salle='$libelle' where num_salle=$salle";
    return pg_query($sql);
}
/**
    Mettre  jour une salle

    @param integer : le numero de la salle
    @param string : le nom de la salle
    @return integer : le resultat de la requete
*/
function maj_salle($salle,$libelle){
    if(VERSION_BASE > VERSION){
	    $sql="select * from contraintes.af_maj_salle($salle,'$libelle')";
	    
		$res=pg_query($sql);
    }
    else
        $res=maj_salle_old($salle,$libelle);
    return $res;
}

/**
    Obtenir lesevenements d'une salle pour un jour de formation (OLD)
*
*   @param integer : le numero de la salle
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_salle_evenements_old($salle,$date){
    $sql="SELECT gnum_cal,libelle,
				 cast(D.jour as timestamp)+cast(hdeb as time),
				cast(hfin as time)-cast(hdeb as time),
				numtype,type,num_intervenant,num_salle
				FROM dates D,gest_cal G 
				where num_salle=$salle and D.num_date=G.num_date and D.jour='$date' ";
	
	
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les evenements d'une salle pour un jour de formation
*
*   @param integer : le numero de la salle
*   @param date : le jour de formation
*   @return integer : le resultat de la requete
*/
function get_salle_evenements($salle,$date){
    if(VERSION_BASE > VERSION){
	    $sql="select * from contraintes.af_get_salle_evenements($salle,'$date') 
				as (formation int4,libelle varchar,date timestamp,duree interval,modalite int4,intervention int4,intervenant int4,salle int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=get_salle_evenements_old($salle,$date);
    return $res;
}

?>
