<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoScenario.
 * Un DoScenario est l'objet servant  gerer l'avancement des
 * Etapes de type Scenario d'un parcours.
 * 
 * @package scenario
 */
class DoScenario extends DoEtapeRenewable{

	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant du Scenario
	 */
	function DoScenario($formation,$individu,$parcours,$etape){
		messageDebug("DoScenario::DoScenario($formation,$individu,$parcours,$etape)");
		parent::DoEtapeRenewable($formation,$individu);
		$this->initDoScenario($parcours,$etape);
	}

	/**
	 * Initialisation.
	 * Initialise les attributs propres a l'objet.
	 * 
	 * @param integer $parcours le parcours courant 
	 * @param integer $etape l'identifiant du Scenario
	 */			
	function initDoScenario($parcours,$etape){
		messageDebug("DoScenario::initDoScenario($parcours,$etape)");
		parent::initDoEtapeRenewable($parcours,$etape, TYPE_ETAPE_SCENARIO);
	}


//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	/**
	 * Obtenir l'objet correspondant  l'tape 
	 * @return object Scenario l'objet correspondant  l'tape
	 */		
	function getScenario(){
		return parent::getObjEtape();
	}
}
?>
