<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de d�finition de la classe Scenario.
 *	Un Scenario est un objet d�riv� d'Etape.
 *
 *	@package scenario
 */
class Scenario extends Etape{

	/**
	 * @var integer Identifiant du Fichier Associ� au Sc�nario 
	 */	
	var $fichier;

	/**
	 * @var integer Libell� du  Fichier Associ� au Sc�nario 
	 */	
	var $libelle_fichier;
	
	/**
	 * @var bool Indique si le fichier du Scenario est connect� ou non 
	 */	
	var $connecte;

	/**
	 * Construit un Scenario.
	 * Le Scenario peut �tre construit � partir d'un identifiant (1 seul parametre), auquel cas les donn�es sont r�cup�r�es en base de donn�es,
	 * ou � partir de l'ensemble des donn�es (tous les parametres), pour ensuite �tre enregistr� en base.
	 *  
	 * @param integer $id identifiant du Sc�nario
	 * @param string $libelle Libell�
	 * @param string $date_creation date de cr�ation (format SQL)
	 */	
	function Scenario($id, $libelle="Etape Scenario", $date_creation="27.11.2006"){
		if(func_num_args()==1){
			$res_etape=get_scenario($id);
			$row_etape=pg_fetch_row($res_etape);
			$libelle=$row_etape[1];
			$date_creation=$row_etape[6];
		}else{
			
		}
		parent::Etape($id, $libelle,$date_creation, TYPE_ETAPE_SCENARIO);
		$this->initScenario($row_etape[3],$row_etape[4],$row_etape[5]);
	}
	
	/**
	 * Initialise les attributs propres au Sc�nario.
	 * 
	 * @param integer Identifiant du Fichier associ� au Sc�nario 
	 * @param string Libell� du Fichier
	 * @param bool Indique si le fichier du Scenario est connect� ou non 
	 */
	function initScenario($fichier, $libelle_fichier, $connecte){
		parent::initEtape();
		if(!sql2Bool($connecte)){
			die("Scenario::initScenario($fichier, $libelle_fichier, $connecte): Le fichier du Scenario est d�connect�.");			
		}
		$this->fichier=$fichier;
		$this->libelle_fichier=$libelle_fichier;
		$this->connecte=$connecte;
	}
	
//-----------------------------
//			ACCESSEURS
//-----------------------------

	/**
	 * Obtenir l'identifiant de Fichier associ� au Sc�nario
	 * @return integer Identifiant
	 */
	function getFichier(){
		return $this->fichier;
	}
	
	/**
	 * Obtenir le lib�ll� de Fichier associ� au Sc�nario
	 * @return string Libell� du Fichier
	 */	
	function getFichierLibelle(){
		return $this->libelle_fichier;
	}
	
	
	function getFichierExtension(){
		//extension
		return get_fichier_extension( $this->libelle_fichier);
	}
	
	function getFichierDiskName(){
		return $this->fichier.".".$this->getFichierExtension();
	}
	/**
	 * Obtenir le chemin relatif du Fichier associ� au Sc�nario
	 * @param string $racine Racine � partir de laquelle le chemin chemin relati est calcul�. 
	 * @return string Le chemin relatif du Fichier
	 */
	function getFichierChemin($racine){
		//$chemin=get_fichier_chemin_relatif($this->fichier, pg_fetch_result(get_categorie_element_themes(1,$this->fichier),0,0), 1);
		$chemin=get_fo_fichier_chemin_relatif($this->fichier, pg_fetch_result(get_categorie_element_themes(1,$this->fichier),0,0), 1);
		
		if(file_exists($racine.$chemin))
			return $racine.$chemin;
		else 
			return false;
	}
	
	/**
	 * Parse les tags <img> du fichier source Html.
	 * Retourne le source html avec les chemins d'images replacés par ceux des médias du thème correspondants.
	 * Une image par défaut remplace les images n'ayant pas de correspondance dans les médias du thème.
	 * La correspondance entre les images du source html et celles des médias du thème se fait uniquement sur le nom du fichier.
	 * @param string  $destination Le chemin du fichier scénario (ex: "$chemin_fo/data/contenus/$id_theme/".TYPE_CATEGORIE_FICHIER_SCENARIO."/".$s_langue )
	 * @param object Theme Le theme du Scénario
	 * 
	 * @return string le source html modifié
	 */
	function parseImages($destination,$obj_theme){
		
		//parse le fichier scénario (construction de l'arbre)
		$p=new HtmlParser("$destination/".$this->getFichierDiskName(),unserialize(Read_File("$root/lib/contrib/htmlparser-1.3/htmlgrammar.cmp")),"$destination/".$this->getFichierDiskName(),1);
		$p->Parse();
//		print_rr($p->content);
		
		//récupération d'un tableau contenant toutes les valeurs de l'attribut src du tag <img>
//		$tab_images=array();
//		$this->getImgSrc(&$p->content,&$tab_images);
//		print_rr($tab_images);
		
		//récupération d'un tableau contenant toutes les valeurs de l'attribut src du tag <img>
//		$tab_flash=array();
//		$this->getFlashSrc(&$p->content,&$tab_flash);
//		print_rr($tab_flash);

		//nombre d'images trouvées
//		$nb_img=count($tab_images);
		
		//récupération des médias de scénario du thème
		$media_scenario_categorie= new Categorie(TYPE_CATEGORIE_MEDIA_SCENARIO);
		$files = $media_scenario_categorie->getFichiersTheme($obj_theme->getId());
//		print_rr($files);

		//modification de l'arbre avec les médias du thème
		$this->ChangeImgSrc(&$p->content,$files,$obj_theme->getId(),$media_scenario_categorie->getId());
		$this->ChangeFlashSrc(&$p->content,$files,$obj_theme->getId(),$media_scenario_categorie->getId());

		//récupération d'un tableau contenant toutes les NOUVELLES valeurs de l'attribut src du tag <img>		
//		$tab_images=array();
//		$this->getImgSrc(&$p->content,&$tab_images);
		
		//récupération du nouveau source html 
		$src="";
		GetPageSrc(&$p->content,&$src);
		return $src;
	}
	
	/**
	 * Obtenir l'icone associ�e � l'Etape.
	 * @return string Le nom du fichier icone
	 */
	function getIcone(){
		return "ico_scenario.png";
	}
	
	
	/**
	 * Obtenir les chemins des images à partir d'un arbre de source html
	 * @param object $c HtmlParser-> content
	 * @param string[] &$tab_img_src tableau de destination des chemins des images
	 */
	function getImgSrc($c,&$tab_img_src) {
	
	//print_rr($c);
	  if (!is_array($c)) return;
	  for ($i=0;$i<=$c["contentpos"];$i++) {
	    if ($c[$i]["type"]=="tag") {
	    	
	//    echo "tag";
	      if($c[$i]["data"]["type"]=="open") {
	// we are scaning img tag
	        if ($c[$i]["data"]["name"]=="img") {
	        	
	//        echo "I";
	// we are scaning src parameter
	          if (isset($c[$i]["pars"]["src"])) {
	            $tab_img_src[]=$c[$i]["pars"]["src"]["value"];
	//              echo "S";
	          }
	        }
	      }
	    }
	    if (isset($c[$i]["content"])) $this->getImgSrc(&$c[$i]["content"],&$tab_img_src);
	  }
	}

	/**
	 * Obtenir les chemins des Flash à partir d'un arbre de source html
	 * @param object $c HtmlParser-> content
	 * @param string[] &$tab_img_src tableau de destination des chemins des Flash
	 */
	function getFlashSrc($c,&$tab_flash_src) {
	
//	print_rr($c);
	  if (!is_array($c)) return;
	  for ($i=0;$i<=$c["contentpos"];$i++) {
	    if ($c[$i]["type"]=="tag") {
	    	
	//    echo "tag";
	      if($c[$i]["data"]["type"]=="open") {
			// we are scaning param tag
	        if ($c[$i]["data"]["name"]=="param") {
	        	// we are scaning src parameter
	          if ($c[$i]["pars"]["name"]["value"]=='movie') {
	            $tab_flash_src[]=$c[$i]["pars"]["value"]["value"];
	          }
	        }
	        // we are scaning param embed
	        if ($c[$i]["data"]["name"]=="embed") {
			// we are scaning src parameter
	          if (isset($c[$i]["pars"]["src"])) {
	            $tab_flash_src[]=$c[$i]["pars"]["src"]["value"];
	          }
	        }
	      }
	    }
	    if (isset($c[$i]["content"])) $this->getFlashSrc(&$c[$i]["content"],&$tab_flash_src);
	  }
	}

	/**
	 * Retourne l'identifiant du média du theme correspondant au chemin d'image.
	 * @param string le chemin de l'image (ex: /img/test.png)
	 * @param object[] Tableau des Fichier Média
	 * 
	 * @return integer  identifiant du média
	 */
	function inFiles($neddle, $array_search){
		$img_name=explode('/',$neddle);
		$img_name=$img_name[count($img_name)-1];
		$found=false;
		$i=0;
		while($i<count($array_search)){
			
			//libelle img 
			if($img_name==$array_search[$i][1]){
				return $array_search[$i][0];
			}
			$i++;
		}
	}
	
	/**
	 * Changer les chemins des images d'un arbre de source html
	 * @param object $c HtmlParser-> content
	 * @param string[] &$tab_img_src tableau de destination des chemins des images
	 * @param integer $theme identifiant du theme
	 * @param integer $categorie identifiant de la catégorie
	 */
	function ChangeImgSrc($c,$tab_img_src,$theme,$categorie) {
	 global $serverfront;
	  if (!is_array($c)) return;
	  for ($i=0;$i<=$c["contentpos"];$i++) {
	    if ($c[$i]["type"]=="tag") {
	      if($c[$i]["data"]["type"]=="open") {
			// we are scaning img tag
	        if ($c[$i]["data"]["name"]=="img") {
			// we are scaning src parameter
	          if (isset($c[$i]["pars"]["src"])) {
	          	$img_id=$this->inFiles($c[$i]["pars"]["src"]["value"],$tab_img_src);
	          	if ($img_id) {
	//          			echo "trouve!<br>";
	          		//extension
					$extension=get_fichier_extension($c[$i]["pars"]["src"]["value"]);
	            	$c[$i]["pars"]["src"]["value"]=get_fichier_chemin($img_id,$theme,$categorie);
	          	}else{
	          		$c[$i]["pars"]["src"]["value"]="http://$serverfront/fo/data/images/test.gif";
	          	}
	          }
	        }
	      }
	    }
	    if (isset($c[$i]["content"])) $this->ChangeImgSrc(&$c[$i]["content"],$tab_img_src,$theme,$categorie);
	  }
	}
	
	/**
	 * Changer les chemins des Flash d'un arbre de source html
	 * @param object $c HtmlParser-> content
	 * @param string[] &$tab_img_src tableau de destination des chemins des Flash
	 * @param integer $theme identifiant du theme
	 * @param integer $categorie identifiant de la catégorie
	 */
	function ChangeFlashSrc($c,$tab_flash_src,$theme,$categorie) {
	 global $serverfront;
	 //	print_rr($c);
	  if (!is_array($c)) return;
	  for ($i=0;$i<=$c["contentpos"];$i++) {
	    if ($c[$i]["type"]=="tag") {
	    	
	//    echo "tag";
	      if($c[$i]["data"]["type"]=="open") {
			// we are scaning param tag
	        if ($c[$i]["data"]["name"]=="param") {
	        	// we are scaning src parameter
	          if ($c[$i]["pars"]["name"]["value"]=='movie') {
	            $img_id=$this->inFiles($c[$i]["pars"]["value"]["value"],$tab_flash_src);
	          	if ($img_id) {
	//          			echo "trouve!<br>";
	          		//extension
					$extension=get_fichier_extension($c[$i]["pars"]["value"]["value"]);
	            	$c[$i]["pars"]["value"]["value"]=get_fichier_chemin($img_id,$theme,$categorie);
	          	}else{
	          		$c[$i]["pars"]["value"]["value"]="http://$serverfront/fo/data/images/test.swf";
	          	}
	          }
	        }
	        // we are scaning param embed
	        if ($c[$i]["data"]["name"]=="embed") {
			// we are scaning src parameter
	          if (isset($c[$i]["pars"]["src"])) {
	             $img_id=$this->inFiles($c[$i]["pars"]["src"]["value"],$tab_flash_src);
	          	if ($img_id) {
	//          			echo "trouve!<br>";
	          		//extension
					$extension=get_fichier_extension($c[$i]["pars"]["src"]["value"]);
	            	$c[$i]["pars"]["src"]["value"]=get_fichier_chemin($img_id,$theme,$categorie);
	          	}else{
	          		$c[$i]["pars"]["src"]["value"]="http://$serverfront/fo/data/images/test.swf";
	          	}
	          }
	        }
	      }
	    }
	    if (isset($c[$i]["content"])) $this->ChangeFlashSrc(&$c[$i]["content"],&$tab_flash_src,$theme,$categorie);
	  }
	}
}
?>
