<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Created on 29 mars 2006
 * @package scenario
 * @modulegroup plpgsql
 * @module plpgsql_scenario
 */
 
/**
	Obtenir le numero du scenario correspondant  un fichier

	@param integer : le numero du fichier
    @return integer : le numero du scenario correspondant
*/
function get_scenario_fichier($fichier){
	
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_scenario_fichier($fichier)";
        $res=pg_query($req);
    }
    else
      print("La fonction get_scenario_fichier($fichier) n'existe pas pour la version ".VERSION);
    return pg_fetch_result($res,0,0);
}

/**
 * Obtenir les informations d'un scenario.
 * 
 * @param integer : le numero du scenario
 * @return integer : resultat de la requete (id int4, libelle varchar, type int4, fichier int4, libelle_fichier varchar, connecte bool)
 */
function get_scenario_old($scenario){
		//on recupere les infos du scenario avec l'alias
        $req1="SELECT * FROM '$scenario',allias , 'S', '$scenario','$scenario', TRUE  FROM alias_fichier WHERE libelle LIKE '$scenario' ";
        $res=pg_query($req1);
        //si pas de resultat, c'est certainement qu'il n'y a pas d'alias, donc on retourne les infos de base.
        if(pg_num_rows($res)==0){
        	$req2="SELECT  '$scenario', NULL , 'S', '$scenario','$scenario', TRUE  ";
        	$res=pg_query($req2);	
        }
        return $res;
}

/**
 * Obtenir les informations d'un scenario.
 * 
 * @param integer : le numero du scenario
 * @return integer : resultat de la requete (id int4, libelle varchar, type int4, fichier int4, libelle_fichier varchar, connecte bool, date_creation timestamp)
 */
function get_scenario($scenario){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_scenario($scenario) AS (id int4, libelle varchar, type int4, fichier int4, libelle_fichier varchar, connecte bool, date_creation timestamp)";
		//echo "$req<br>";
        return @pg_query($req);
    }
    else
       return get_scenario_old($scenario);
}

/**
 *	Obtenir les thmes d'un scenario.
 *	
 *	ATTENTION!!!
 *	Les thmes retourns sont retourns  partir des scnarios dans un parcours.
 *	En effet, il est impossible pour cette version de la base, de rcuprer les thmes d'un scnario d'une autre manire.
 *	Un Scnario peut donc etre dans des themes qui n'aparaissent pas dans le retour de cette fonction.
 *	
 * @param integer : le numero du scenario
 * @return integer : resultat de la requete (id int4, libelle varchar)
 */
function get_scenario_themes_old($scenario){
	$req="SELECT DISTINCT num_thematik, nom_theme FROM gestparcours, themedir WHERE attach_fic LIKE '$scenario' AND type_etape='S' AND num_thematik=num_themedir";
    return pg_query($req);
} 

/**
 * Obtenir les thmes d'un scenario.
 * 
 * @param integer : le numero du scenario
 * @return integer : resultat de la requete (id int4, libelle varchar)
 */
function get_scenario_themes($scenario){
	if(VERSION_BASE>VERSION){
		return get_categorie_element_themes(35, $scenario);
	}
	else{
		return get_scenario_themes_old($scenario);
	}
} 
?>
