<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**$nb_elements
 *	Fichier de d�finition de la classe Scenario.
 *	Un Scenario est un objet d�riv� d'Etape.
 *
 *	@package scenario
 */
class FichierScenarioDynamique extends Element{

	var $id;
	
	var $libelle;
	
	var $type;
	
	var $date_modification;
	
	/**
	 * @var bool Indique si le fichier du Scenario est connect� ou non 
	 */	
	var $connecte;
	
	var $style;
	
	var $obj_ScenarioEditorComponentsFactory;

var $current_bloc;

	/**
	 * Construit un Scenario.
	 * Le Scenario peut �tre construit � partir d'un identifiant (1 seul parametre), auquel cas les donn�es sont r�cup�r�es en base de donn�es,
	 * ou � partir de l'ensemble des donn�es (tous les parametres), pour ensuite �tre enregistr� en base.
	 *  
	 * @param integer $id identifiant du Sc�nario
	 * @param string $libelle Libell�
	 * @param string $date_creation date de cr�ation (format SQL)
	 */	
	function FichierScenarioDynamique($id,$libelle="",$style=null,$obj_ScenarioEditorComponentsFactory= null){
		
		//if(func_num_args()==1){
		if( (func_num_args()==1)||( $libelle=="" && $style==null)){
			$res_fic=get_fichier_scenario_dynamique($id);
			$row=pg_fetch_row($res_fic);
			$libelle=$row[1];
			$connecte=sql2Bool($row[3]);
			$style=$row[4];
			$date_modification=$row[5];
		}else{
			
		}
		$this->current_bloc=0;
		parent::Element($id,$libelle);
		
		
		//initialise la factory par défaut
		if(!is_object($obj_ScenarioEditorComponentsFactory)){
			$type_fichiers_blocs=$this->getBlocsFichierType();
			$obj_ScenarioEditorFactoryBuilder=new  ScenarioEditorFactoryBuilder();
			$this->obj_ScenarioEditorComponentsFactory=$obj_ScenarioEditorFactoryBuilder->createFactoryByFileType($type_fichiers_blocs);
			//print_rr($obj_ScenarioEditorComponentsFactory);
			//die("FichierScenarioDynamique::FichierScenarioDynamique Erreur, fabrique de composants manquant");
//			if($this->isSlides()){
//				$this->obj_ScenarioEditorComponentsFactory=new ScenarioEditorSlideBlocComponentsFactory();
//			}else{
//				$this->obj_ScenarioEditorComponentsFactory=new ScenarioEditorBlocComponentsFactory();
//			}
		}else{
			$this->obj_ScenarioEditorComponentsFactory=$obj_ScenarioEditorComponentsFactory;
		}


		$this->initFichierScenarioDynamique(TYPE_FICHIER_SCENARIO_DYNAMIQUE,$connecte,$style,$date_modification);
	}
	
	/**
	 * Initialise les attributs propres au Sc�nario.
	 * 
	 * @param integer Identifiant du Fichier associ� au Sc�nario 
	 * @param string Libell� du Fichier
	 * @param bool Indique si le fichier du Scenario est connect� ou non 
	 */
	function initFichierScenarioDynamique($type,$connecte,$style,$date_modification){
		$this->type=$type;
		$this->connecte=$connecte;
		$this->style=$style;
		$this->date_modification=$date_modification;
	}
	
	function getThemes($i){
		$res=get_categorie_element_themes(TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE,$this->id);
		if(func_num_args()==1){
			return pg_fetch_row($res,$i);
		}
		else{
			return pg_super_fetch_array($res);
		}

	}
	
	function validate(){
		if(!empty($this->libelle)&&!empty($this->style)){
			return true;
		}else{
			return false;
		}
	}
	
	function insertToDB($theme){
		if($this->validate()&&!empty($theme)){
			//$this->id=set_fichier_scenario_dynamique($this->libelle,$this->style,$theme);
			$this->id=set_fichier_scenario_dynamique(set_ams_libelle($this->libelle),$this->style,$theme);
			return true;
		}else{
			return false;
		}
	}
	
	function updateToDB(){
		if(!empty($this->id)&&$this->validate()){
			//return maj_fichier_scenario_dynamique($this->id,$this->libelle,$this->style);
			// prise en compte de l'AMS
			return maj_fichier_scenario_dynamique($this->id,set_ams_libelle($this->libelle),$this->style);
		}else{
			return false;
		}
	}
//-----------------------------
//			ACCESSEURS
//-----------------------------

	/**
	 * Obtenir l'identifiant de style associé au scénario
	 * @return integer Identifiant
	 */
	function getStyle(){
		return $this->style;
	}
	
	function getRenderer(){
		return $this->obj_ScenarioEditorComponentsFactory;
	}

	function getBlocsFichierType(){
		return get_fichier_scenario_dynamique_blocs_type($this->id);
	}
	
	
	function isSound() {
		return true;
	}
	
	function getStylePath(){
		$res_themes=get_categorie_element_themes(TYPE_CATEGORIE_FICHIER_CSS,$this->style);
		if(pg_num_rows($res_themes)>0){
			$theme=pg_fetch_result($res_themes,0,0);
			//print_rr($this);
			return $varvalue=get_fichier_chemin($this->style,$theme,TYPE_CATEGORIE_FICHIER_CSS);	
		}
		else{
			return null;
		}
	}	
	
	/**
	 *
	 */
	function setBloc($bloc,$ordre,$post){
//		print_rr($post);
		global $_FILES,$chemin_fo;
		$bloc_vars=array();
		
		foreach($post as $var => $varvalue){
			
			$bloc_var_base_tmp=preg_split("/_\d/", $var,-1, PREG_SPLIT_NO_EMPTY);
			$bloc_var_base=$bloc_var_base_tmp[0];
			
//			echo "\$var=$var<br>";
			if(in_array(strtoupper($bloc_var_base),$this->obj_ScenarioEditorComponentsFactory->getStaticVars())||stristr($bloc_var_base,'id_theme')){
//				secho "\$varvalue=$varvalue";
				//cas sp�cial des fichiers
				//if((strtoupper($bloc_var_base)==FLASH_SRC||strtoupper($bloc_var_base)==IMG_SRC)){
				if($this->obj_ScenarioEditorComponentsFactory->isFileVar(strtoupper($bloc_var_base))){	
					
					//si le nom du thme (id_theme) contient un suffixe, on le r�cup�re afin de l'ajouter aux autres selects du media
					$bloc_var_indice_tmp=preg_split('/_(\d)$/', $var,-1, PREG_SPLIT_DELIM_CAPTURE);
					$bloc_var_indice=$bloc_var_indice_tmp[1];
					
					if(!empty($bloc_var_indice)){
						$suffixe="_$bloc_var_indice";
					}else{
						$suffixe=null;
					}
					//theme du fichier obligatoire
					$id_theme=$post['id_theme_'.$var];//$suffixe
				
					if(empty($id_theme)){
						AstairsTemplate::setPageMessage(ERROR_68,MSG_ERROR);
						return false;
					}
					//selection d'un fichier
					if(!empty($varvalue)){
						
						$res_fic=get_fichier($varvalue);
						$fic_name=pg_fetch_result($res_fic,0,1);
						//verification de l'extention pour le flash
						if(stristr($bloc_var_base, FLASH_SRC)){
							if(!is_fichier_type_mime_type_valid($fic_name,'application/x-shockwave-flash')&&!is_fichier_type_mime_type_valid($fic_name,'video/x-flv')){
//									echo "fichier$id_theme";
								AstairsTemplate::setPageMessage(ERROR_140.'('.ERROR_141.')',MSG_ERROR);
								return false;
							}
							else{
//								echo "fichier flash inconu:$bloc_var_base";
							}
							//echo "ok:$bloc_var_base";
						}
						//pour les images
						else{
							if(stristr($bloc_var_base, IMG_SRC)){
								if(!is_fichier_type_mime_type_valid($fic_name,'image/*')){
									AstairsTemplate::setPageMessage(ERROR_140.'('.ERROR_142.')',MSG_ERROR);
									return false;
								}
							//pour les sous titress
							}else{
								if(!is_fichier_type_mime_type_valid($fic_name,'text/*')){
									AstairsTemplate::setPageMessage(ERROR_140.'('.ERROR_143.')',MSG_ERROR);
									return false;
								}else{
									
								}
							}
						}
						$id_file=$varvalue;
						
					}
					//upload d'un fichier
					else{
//							print_rr($_FILES);
							//verification de l'extention pour le flash
							//if(strtoupper($bloc_var_base)==FLASH_SRC){
							if(stristr($bloc_var_base, FLASH_SRC)){
								
//								echo "\$bloc_var_base=$bloc_var_base";
								if(!is_fichier_type_mime_type_valid($_FILES['media_data_'.$var.$suffixe]['name'],'application/x-shockwave-flash')&&!is_fichier_type_mime_type_valid($_FILES['media_data_'.$var.$suffixe]['name'],'video/x-flv')){
									AstairsTemplate::setPageMessage(ERROR_140.'('.ERROR_141.')',MSG_ERROR);
//									echo "erreur";	
									return false;
								}else{
//									echo "UP fichier flash :$varvalue";
								}
								
							}
							//pour les images
							else{
								if(stristr($bloc_var_base, IMG_SRC)){
									if(!is_fichier_type_mime_type_valid($_FILES['media_data_'.$var.$suffixe]['name'],'image/*')){
										AstairsTemplate::setPageMessage(ERROR_140.'('.ERROR_142.')',MSG_ERROR);
//										echo "erreur";
										return false;
									}else{
//										echo "UP fichier image :$varvalue";
									}
								//pour les autres fichiers
								}else{
									
									if(!is_fichier_type_mime_type_valid($_FILES['media_data_'.$var.$suffixe]['name'],'text/*')){
										AstairsTemplate::setPageMessage(ERROR_140.'('.ERROR_143.')',MSG_ERROR);
										return false;
									}else{
										
									}
//										echo "jjjjjjjjjj=".$bloc_var_base;
								}
							}
							
							$id_file=$this->uploadFile($id_theme,$_FILES['media_data_'.$var.$suffixe]['tmp_name'],$_FILES['media_data_'.$var.$suffixe]['name'],$_FILES['media_data_'.$var.$suffixe]['size']);
							
					}
					if($id_file){
						$varvalue=$id_file;//get_fichier_chemin($id_file,$id_theme,TYPE_CATEGORIE_MEDIA_SCENARIO);//"/fo/data/contenus/".$post['id_theme']."/".TYPE_CATEGORIE_MEDIA_EVALUATION."/".$id_file.".".get_fichier_type($_FILES['media_data']['name']);	
					}
					else{
						return false;
					}
				}
				//chaines de caracteres
				$tmp=trim(nl2br2($varvalue));
			
				
				if(empty($tmp)){
					AstairsTemplate::setPageMessage(ERROR_143,MSG_ERROR);
					return false;
				}
//				$bloc_vars[$var]=addslashes($tmp);
				$bloc_vars[$var]=$tmp;
				
			}
//			else
//				echo "jette=$var<br>";
		}
		//print_rr($bloc_vars);	
		$res=set_fichier_scenario_dynamique_bloc($this->id,int2Sql($bloc),int2Sql($ordre),$bloc_vars);
//		exit;
		//echo "jjjjjjjjjj";
		return $res;
	}
	
	function delBloc($ordre){
		$res=del_fichier_scenario_dynamique_bloc($this->id,int2Sql($ordre));
		
		return $res;
	}
	
	function moveBloc($ordre,$direction){
		$res=maj_fichier_scenario_dynamique_bloc($this->id,int2Sql($ordre),int2Sql($direction));
		
		return $res;
	}	
	
//	function getBlocs(){
//		$res=get_fichier_scenario_dynamique_blocs($this->id);
//		return $res;
//	}
	
//	function isTypeOf($type){
//		
//		switch ($type) {
//			case FICHIER_SCENARIO_DYNAMIQUE_CLASSICAL:
////				$ok=!is_
//				break;
//		
//			case FICHIER_SCENARIO_DYNAMIQUE_SLIDES:
////				$ok=!is_
//				break;
//			default:
//				$ok=false;
//				break;
//		}
//		return $ok;
//	}
	
	function getBloc($ordre){
		if($ordre<=0){
			die("getBloc($ordre): l'ordre du bloc doit etre sup�rieur � 0");
		}
		$res=get_fichier_scenario_dynamique_bloc($this->id,$ordre);
		$row=pg_fetch_row($res,0);
		if(empty($row[0])){
			return null;
		}
		return $row;
	}
	
	function getObjBloc($ordre){
		return new FichierScenarioDynamiqueBloc($this->id,$this->obj_ScenarioEditorComponentsFactory,null,$ordre);
	}
	
	function getBlocs(){
		$res=$this->obj_ScenarioEditorComponentsFactory->getScenarioDynamiqueBlocsFiles($this->id);
//		$res=get_fichier_scenario_dynamique_blocs($this->id);
		return $res;
	}
	function getNbBlocs(){
		$res=$this->obj_ScenarioEditorComponentsFactory->getScenarioDynamiqueBlocsFiles($this->id);
//		$res=get_fichier_scenario_dynamique_blocs($this->id);
		return pg_num_rows($res);
	}
//	
//	/**
//	 * Obtenir le lib�ll� de Fichier associ� au Sc�nario
//	 * @return string Libell� du Fichier
//	 */	
//	function getFichierLibelle(){
//		return $this->libelle_fichier;
//	}
//	
//	/**
//	 * Obtenir le chemin relatif du Fichier associ� au Sc�nario
//	 * @param string $racine Racine � partir de laquelle le chemin chemin relati est calcul�. 
//	 * @return string Le chemin relatif du Fichier
//	 */
//	function getFichierChemin($racine){
//		$chemin=get_fichier_chemin_relatif($this->fichier, pg_fetch_result(get_categorie_element_themes(1,$this->fichier),0,0), 1);
//		if(file_exists($racine.$chemin))return $racine.$chemin;
//		else return false;
//	}
//	
//	/**
//	 * Obtenir l'icone associ�e � l'Etape.
//	 * @return string Le nom du fichier icone
//	 */
//	function getIcone(){
//		return "ico_scenario.png";
//	}

	function uploadFile($theme,$userfile,$userfile_name,$userfile_size){
		
		global $chemin_fo,$ams_langue;
		$racine=$chemin_fo."/data/contenus/";
		$autoconnect_db=true;
		$destination = $racine.$theme."/".TYPE_CATEGORIE_MEDIA_SCENARIO."/".$ams_langue;
		
		$obj_categorie=new Categorie(TYPE_CATEGORIE_MEDIA_SCENARIO);
		$obj_theme=new Theme($theme);
		if(!is_dir($destination)){
			mkdir($destination);
		}
		// On stocke les message d'erreur dans une variable pour
		//faire un rollback en cas d'erreur de copie du fichier
//		ob_start();
//		pg_query("begin");

		//CREATION LIEN EN BASE
		//nouveau fichier
		if (empty ($idfile_to_replace)) {
			//modifie le nom du fichier si besoin
			$userfile_name = $obj_categorie->getFichierUniqueName($userfile_name, $obj_theme->getId());
			$id_fic = $obj_categorie->setFichier($userfile_name, bool2Sql($autoconnect_db), $obj_theme->getId());
		}

		//on recupere les messages d'erreur
//		$message_erreur = ob_get_contents();
		//on vide les messages stockes
//		ob_end_clean();
		
		//on copie le fichier si pas d'erreur de requete
		if (!empty ($id_fic)) {
			
			//extension
			$extension=get_fichier_extension($userfile_name);
			
			//nouveau fichier
			$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $id_fic.".".$extension, $destination);	
			if (!empty($msg_upload)) {
				//erreur copie
				$old_message=AstairsTemplate::getPageMessage();
				$msg=$msg_upload.$old_message['MSG'];
				AstairsTemplate::setPageMessage($msg,MSG_ERROR);
				return false;
			}
		}else{
			$message="Erreur cr�ation fichier en base";
			AstairsTemplate::setPageMessage($message,MSG_ERROR);
			return false;
		}
		
		return $id_fic;
	}


 function getComponentsFactory () {
	return $this->obj_ScenarioEditorComponentsFactory;
}


	function getCurrentObjBloc(){
		$obj=new FichierScenarioDynamiqueBloc($this->id,$this->obj_ScenarioEditorComponentsFactory,null,$this->current_bloc+1);
		if($obj->getId()>0){
			return $obj;
		}else{
			return null;
		}
	}
	
	function getCurrentBloc(){
		return $this->current_bloc;
	}
	
	function nextObjBloc(){
		$this->current_bloc++;
	}
}
?>
