<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


class FichierScenarioDynamiqueBloc{

	var $id;
	var $ordre;
	var $current_bloc_ams;
	var $component_factory;
	
	function FichierScenarioDynamiqueBloc($scenario_dynamique,$component_factory,$id=null, $ordre=null,$libelle="", $var_keys=null,$var_vals=null, $ams_langue_bloc=null){
		messageDebug("FichierScenarioDynamiqueBloc($scenario_dynamique,\$component_factory,$id, $ordre,$libelle, $var_keys,$var_vals)");
		$this->component_factory=$component_factory;
		if(func_num_args()==4){
			$row=$component_factory->getBlocFile($scenario_dynamique,int2Sql($ordre));
			$id=$row[0];
			$libelle=$row[1];
			$var_keys=plpgsql_array_to_text_array($row[3]);
			
			$var_vals=plpgsql_text_ams_to_text_array($row[4],&$langue_trouve);
			$this->current_bloc_ams=$langue_trouve;
		}
		if(empty($this->current_bloc_ams)){
			$this->current_bloc_ams=$ams_langue_bloc;
		}
		$this->id=$id;
		$this->libelle=$libelle;
		$this->ordre=$ordre;
		$this->var_keys=$var_keys;
		$this->var_vals=$var_vals;

		$this->scenario_dynamique=$scenario_dynamique;
		
	}
	
	function getLibelle(){
		return $this->libelle;
	}
	function isVar($var_key){
		
		$positions_keys=array_keys($this->var_keys,strtolower($var_key));	
		if(count($positions_keys)!=1){
			return false;
		}else{
			return true;
		}
		
	}
	function getVar($var_key){
		if(!is_array($this->var_keys))return null;
		$positions_keys=array_keys($this->var_keys,strtolower($var_key));	
		$var_val=$this->var_vals[$positions_keys[0]];
		
		$f_var_val= stripslashes($var_val);
		if(in_array($var_key,array(TEXT,TEXTAREA))){
			$f_var_val=$this->parseWithKeyWords($f_var_val);
		}
		
		return $f_var_val;
	}
	
	function parseWithKeyWords($text_var){
		$res=get_fichier_metadata($this->scenario_dynamique);
		$mots_cles=pg_fetch_result($res,0,3);
		$tab_mots_cles=explode(';',$mots_cles);
		foreach($tab_mots_cles as $i => $mot_cle){
			$mot_cle=get_fo_libelle($mot_cle);
			$nb_matches=preg_match_all('/##G(\w+)##(\w+)##\((\w+)\)/',$mot_cle,$matches);
			$replacement = '<a href="#" class="glossaire_link">'.$matches[3][0].'</a>';//'XXX';
			$parsed_text_var= preg_replace('/'.$matches[3][0].'/', $replacement, $text_var);
		}
		return $parsed_text_var;
	}
	
	function getId(){
		return $this->id;
	}
	
	function setId($id){
		$this->id=$id;
	}
	
	function getOrdre(){
		return $this->ordre;
	}
	
	function setOrdre($ordre){
		$this->ordre=$ordre;
	}
	
	function getTemplatesPath(){
		global $chemin_fo,$ams_libelle,$s_langue;
		if(!empty($ams_libelle))$tmp_langue=$ams_libelle;
		else $tmp_langue=$s_langue;
		// M�thode R�mi : pas de langue de contenu pour les tpl bloc
		return "$chemin_fo/data/contenus/".$this->getThemes(0)."/".$this->component_factory->getTypeCategorieFichier()."/";
		
	}
	
	
	
	function getThemes($indice=0){
		
		//pas de th�me si pas d'id (bloc vide en cours de cr�ation)
		if(empty($this->id))return null;
		
		//recup�ration du theme pour le chemin du tpl
		$res_themes=get_categorie_element_themes($this->component_factory->getTypeCategorieFichier(),$this->id);
		if(func_num_args()!=0){
			return pg_fetch_result($res_themes,$indice,0);
		}else{
			return $res_themes;
		}
	}
	
	function isEmpty(){
		//on considere que le bloc est vide s'il n'a pas de cl�s de variables
		if(count($this->var_keys)==0)
			return true;
		else
			return false;
	}
	
	function getCurrentAms(){
		return $this->current_bloc_ams;
	}
}
?>
