<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 *	Fichier de dfinition de la classe ScenarioDynamique.
 *	Un Scenario est un objet driv d'Etape.
 *
 *	@package scenario
 */
class ScenarioDynamique extends Etape{

	/**
	 * @var integer Identifiant du Fichier Associ au Scnario 
	 */	
	var $fichier;

	/**
	 * @var integer Libell du  Fichier Associ au Scnario 
	 */	
	var $libelle_fichier;
	
	/**
	 * @var bool Indique si le fichier du Scenario est connect ou non 
	 */	
	var $connecte;

	/**
	 * Construit un ScenarioDynamique.
	 * Le ScenarioDynamique peut tre construit  partir d'un identifiant (1 seul parametre), auquel cas les donnes sont rcupres en base de donnes,
	 * ou  partir de l'ensemble des donnes (tous les parametres), pour ensuite tre enregistr en base.
	 *  
	 * @param integer $id identifiant du Scnario
	 * @param string $libelle Libell
	 * @param string $date_creation date de cration (format SQL)
	 */	
	function ScenarioDynamique($id, $libelle="Etape ScenarioDynamique", $date_creation="27.11.2006"){
		if(func_num_args()==1){
			$res_etape=get_scenario_dynamique($id);
			if($res_etape){
				$row_etape=pg_fetch_row($res_etape);
				$libelle=$row_etape[1];
				$date_creation=$row_etape[6];
			}else{
				return null;
			}
		}else{
			
		}
		parent::Etape($id, $libelle,$date_creation, TYPE_ETAPE_SCENARIO_DYNAMIQUE);
		$this->initScenarioDynamique($row_etape[3],$row_etape[4],$row_etape[5]);
	}
	
	/**
	 * Initialise les attributs propres au Scnario.
	 * 
	 * @param integer Identifiant du Fichier associ au Scnario 
	 * @param string Libell du Fichier
	 * @param bool Indique si le fichier du Scenario est connect ou non 
	 */
	function initScenarioDynamique($fichier, $libelle_fichier, $connecte){
		parent::initEtape();
		if(!sql2Bool($connecte)){
			die("ScenarioDynamique::initScenarioDynamique($fichier, $libelle_fichier, $connecte): Le fichier du ScenarioDynamique est dconnect.");			
		}
		$this->fichier=$fichier;
		$this->libelle_fichier=$libelle_fichier;
		$this->connecte=$connecte;
	}
	
//-----------------------------
//			ACCESSEURS
//-----------------------------

	/**
	 * Obtenir l'identifiant de Fichier associ au Scnario
	 * @return integer Identifiant
	 */
	function getFichier(){
		return $this->fichier;
	}
	
	/**
	 * Obtenir l'identifiant de Fichier associ au Scnario
	 * @return integer Identifiant
	 */
	function getObjFichierScenarioDynamique(){
		$obj_ScenarioEditorFactoryBuilder=new  ScenarioEditorFactoryBuilder();
		return new FichierScenarioDynamique($this->fichier);
	}
//	/**
//	 * Obtenir le libll de Fichier associ au Scnario
//	 * @return string Libell du Fichier
//	 */	
//	function getFichierLibelle(){
//		return $this->libelle_fichier;
//	}
//	
//	/**
//	 * Obtenir le chemin relatif du Fichier associ au Scnario
//	 * @param string $racine Racine  partir de laquelle le chemin chemin relati est calcul. 
//	 * @return string Le chemin relatif du Fichier
//	 */
//	function getFichierChemin($racine){
//		$chemin=get_fichier_chemin_relatif($this->fichier, pg_fetch_result(get_categorie_element_themes(1,$this->fichier),0,0), 1);
//		if(file_exists($racine.$chemin))return $racine.$chemin;
//		else return false;
//	}
//	
//	/**
//	 * Obtenir l'icone associe  l'Etape.
//	 * @return string Le nom du fichier icone
//	 */
//	function getIcone(){
//		return "ico_scenario.png";
//	}
}
?>
