<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on 3 févr. 08
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
define("TEXT",    "TEXT");
define("TEXTAREA", "TEXTAREA");
define("FLASH_SRC", "FLASH_SRC");
define("FLASH_HEIGHT",    "FLASH_HEIGHT");
define("FLASH_WIDTH", "FLASH_WIDTH");
define("IMG_TITLE",    "IMG_TITLE");
define("IMG_ALT", "IMG_ALT");
define("IMG_SRC", "IMG_SRC");
define("ID_THEME_IMG_SRC", "ID_THEME_IMG_SRC");

define("TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE_BLOC","58");
define("TYPE_FICHIER_SCENARIO_DYNAMIQUE_BLOC","14");
class ScenarioEditorBlocComponentsFactory extends ScenarioEditorFactory {
	
	function ScenarioEditorBlocComponentsFactory(){ 
		parent::ScenarioEditorFactory("Page","PAGE_RENDERER","guiBoScenarioDynamique","gui_bo_scenario_dynamique.tpl","guiScenarioDynamique","gui_scenario_dynamique.tpl");
	}
	
	function getBlocInputComponent($bloc_var,$var_value=null,$id_theme=null){
		
		messageDebug("ScenarioEditorBlocComponentsFactory::getBlocInputComponent($bloc_var,$var_value);");
//		echo "var_value=$var_value<br>";
		global $chemin_bo;
		$bloc_var_base_tmp=preg_split("/_\d/", $bloc_var,-1, PREG_SPLIT_NO_EMPTY);
		$bloc_var_base=$bloc_var_base_tmp[0];
//		print("\$bloc_var_base=$bloc_var_base<br>");
//		print("\$bloc_var=$bloc_var<br>");
		switch ($bloc_var_base) {
			//ZONES TEXTES			
			case TEXT:
					return new guiBoScenarioEditorBlocInputComponentText(strtolower($bloc_var),"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) => 'gui_bo_scenario_editor_bloc_input_component_text.tpl'),strtolower($bloc_var),$var_value);			
			case TEXTAREA:
					return new guiBoScenarioEditorBlocInputComponentTextarea(strtolower($bloc_var),"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) => 'gui_bo_scenario_editor_bloc_input_component_textarea.tpl'),strtolower($bloc_var),$var_value);
				break;
			//FLASHS
			case FLASH_SRC:
				$tpl_file='gui_bo_scenario_editor_bloc_input_component_flash_src.tpl';
				return new guiBoScenarioEditorBlocInputComponentFileSrc(strtolower($bloc_var),MSG_2700,"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) => $tpl_file),strtolower($bloc_var),'application/x-shockwave-flash',$var_value,false,$id_theme);
				
			case FLASH_WIDTH:
				$tpl_file='gui_bo_scenario_editor_bloc_input_component_flash_width.tpl';
				return new guiBoScenarioEditorBlocInputComponentFlashSize(strtolower($bloc_var),"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) => $tpl_file),strtolower($bloc_var),$var_value);
			case FLASH_HEIGHT:
				$tpl_file='gui_bo_scenario_editor_bloc_input_component_flash_height.tpl';
				return new guiBoScenarioEditorBlocInputComponentFlashSize(strtolower($bloc_var),"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) => $tpl_file),strtolower($bloc_var),$var_value);
		
			//IMGS				
			case IMG_TITLE:
					return new guiBoScenarioEditorBlocInputComponentImgTitle(strtolower($bloc_var),"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) => 'gui_bo_scenario_editor_bloc_input_component_img_title.tpl'),strtolower($bloc_var),$var_value);
			case IMG_ALT:
					return new guiBoScenarioEditorBlocInputComponentImgAlt(strtolower($bloc_var),"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) => 'gui_bo_scenario_editor_bloc_input_component_img_alt.tpl'),strtolower($bloc_var),$var_value);
			case IMG_SRC:
					$tpl_file='gui_bo_scenario_editor_bloc_input_component_img_src.tpl';
					return new guiBoScenarioEditorBlocInputComponentFileSrc(strtolower($bloc_var),MSG_2701,"$chemin_bo/scenario_editor/templates/tpl/",array(strtolower($bloc_var) =>$tpl_file ),strtolower($bloc_var),'image/*',$var_value,false,$id_theme);
			//THEME	
			case ID_THEME_IMG_SRC:
				return $var_value;
				break;
			default:
				die("Erreur, balise inconue dans le bloc ($bloc_var => $bloc_var_base)");
				break;
		}
	}
	
	function getStaticVars(){
		return array(
		TEXT,
		TEXTAREA,
		FLASH_SRC,
		FLASH_HEIGHT,
		FLASH_WIDTH,
		IMG_TITLE,
		IMG_ALT,
		IMG_SRC
		);
	}
	
	function getFileVars(){
		return array(
		FLASH_SRC,
		IMG_SRC
		);
	}
	
	function prepare(){
		//nothing to do :)
 	} 	
 	
 	function isPrepared(){
 		//always true! :)
		return true;
 	} 
	
	 	
 	function getBlocsFiles($theme){
 		return get_theme_fichiers_blocs_scenarios($theme);
 	}
 	
 	function getBlocFile($scenario_dynamique,$ordre){
 		return get_fichier_scenario_dynamique_bloc($scenario_dynamique,int2Sql($ordre));
 	}
 	
 	
 	function getTypeCategorieFichier(){
		return TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE_BLOC;
	}
	
	function getScenarioDynamiqueBlocsFiles($scenario_dynamique){
 		return get_fichier_scenario_dynamique_blocs($scenario_dynamique);
 	}
}
?>
