<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on 21 juin 08
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
 class ScenarioEditorFactoryBuilder {
 	
 	var $factories;
 	
 	function ScenarioEditorFactoryBuilder(){
 		$this->factories=array('SLIDE_RENDERER'=>"ScenarioEditorSlideBlocComponentsFactory",'PAGE_RENDERER'=>"ScenarioEditorBlocComponentsFactory");
 	}
 	
 	function createFactory($type){
 		if(in_array($type,array_keys($this->factories))){
 			return new $this->factories[$type];
 		}else{
 			die("ScenarioEditorFactoryBuilder::createFactory(): type inconnu".$type);
 		}
 	}
 	//TODO ou la que c'est moche et du vite fait!
 	function createFactoryByFileType($file_type){
 		if($file_type==TYPE_FICHIER_SCENARIO_DYNAMIQUE_BLOC){
 			$type='PAGE_RENDERER';
 		}elseif($file_type==TYPE_FICHIER_SCENARIO_DYNAMIQUE_SLIDE){
 			$type='SLIDE_RENDERER';
 		}else{
 			$type='PAGE_RENDERER'; //par dfaut
 			//die('ScenarioEditorFactoryBuilder::createFactoryByFileType: type inconnu');
 		}
 	
 		return $this->createFactory($type);
 	}
 	
 }
 
 
/**
 * @abstract
 */  
 class ScenarioEditorFactory {
 	
 	var $libelle;
 	var $type;
 	var $guiBoRendererClass;
 	var $guiBoRendererTpl;
 	var $guiFoRendererClass;
 	var $guiFoRendererTpl;
 	
 	function ScenarioEditorFactory($libelle,$type,$guiBoRendererClass,$guiBoRendererTpl,$guiFoRendererClass,$guiFoRendererTpl){
 		$this->type=$type;
 		$this->libelle=$libelle;
 		$this->guiBoRendererClass=$guiBoRendererClass;
 		$this->guiBoRendererTpl=$guiBoRendererTpl;
 		
 		$this->guiFoRendererClass=$guiFoRendererClass;
 		$this->guiFoRendererTpl=$guiFoRendererTpl;
 		$this->init();
 		
 	}
 	
 	function getGuiRendererClass(){
 		return $this->guiBoRendererClass;
 	}
 	
 	function getGuiRendererTpl(){
 		return $this->guiBoRendererTpl;
 	}
 	
 	
 	 function getGuiFoRendererClass(){
 		return $this->guiFoRendererClass;
 	}
 	
 	function getGuiFoRendererTpl(){
 		return $this->guiFoRendererTpl;
 	}
 	
 	function getBlocInputComponent($bloc_var,$var_value=null){
 		die("ScenarioEditorFactory::getBlocInputComponent() Erreur: methode abstraite davant etre surchargee");
 	}

 	function init(){
		if(!$this->isPrepared()){
			$this->prepare();
		}
 	} 	


 	function prepare(){
		die("ScenarioEditorFactory::prepare() Erreur: methode abstraite davant etre surchargee");

 	} 	
 	
 	function isPrepared(){
		die("ScenarioEditorFactory::isPrepared() Erreur: methode abstraite davant etre surchargee");

 	} 
 	
 	function getBlocsFiles($theme){
 		die("ScenarioEditorFactory::getBlocFiles() Erreur: methode abstraite davant etre surchargee");
 	}	
 	
 	function getBlocFile($scenario_dynamique,$ordre){
 		die("ScenarioEditorFactory::getBlocFile() Erreur: methode abstraite davant etre surchargee");
 	}
 	
 	function getTypeCategorieFichier(){
		die("ScenarioEditorFactory::getTypeCategorieFichier() Erreur: methode abstraite davant etre surchargee");
	}

  	function getScenarioDynamiqueBlocsFiles($scenario_dynamique){
 			die("ScenarioEditorFactory::getScenarioDynamiqueBlocsFiles() Erreur: methode abstraite davant etre surchargee");
 	}
 	 	
 	function isFileVar($static_var){
		return in_array($static_var,$this->getFileVars());
	}
	
 	function getType(){
 		return $this->type;
 	}
 	
 	function getLibelle(){
 		return $this->libelle;
 	}
 	

 }
?>
