<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Created on 29 mars 2006
 * @package scenario_dynamique
 * @modulegroup plpgsql
 * @module plpgsql_scenario_dynamique
 */
 
///**
//	Obtenir le numero du scenario correspondant � un fichier
//
//	@param integer : le numero du fichier
//    @return integer : le numero du scenario correspondant
//*/
//function get_scenario_fichier($fichier){
//	
//	if(VERSION_BASE>VERSION){
//        $req="SELECT * FROM contraintes.af_get_scenario_fichier($fichier)";
//        $res=pg_query($req);
//    }
//    else
//      print("La fonction get_scenario_fichier($fichier) n'existe pas pour la version ".VERSION);
//    return pg_fetch_result($res,0,0);
//}

/**
 * Obtenir les informations d'un fichier de scenario dynamique.
 * 
 * @param integer : le numero du fichier du scenario
 * @return integer : resultat de la requete (id int4, libelle varchar, type int4, fichier int4, libelle_fichier varchar, connecte bool, date_creation timestamp)
 */
function get_fichier_scenario_dynamique($fichier_scenario){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_fichier_scenario_dynamique($fichier_scenario) AS (id int4, libelle varchar, type int4, connecte bool, style integer,date_creation date)";
//		echo "$req<br>";
        return pg_query($req);
    }
    else
       return get_scenario_old($fichier_scenario);
}

/**
 * enregistrer les informations d'un scenario dynamique.
 * 
 * @param integer : 
 * @return integer l'identifiant du scenario: 
 */
function set_fichier_scenario_dynamique($libelle,$style,$theme){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_set_fichier_scenario_dynamique('$libelle',$style) ";
//        echo "$req<br>";
		$res=pg_query($req);
		if($res){
			$id=pg_fetch_result($res, 0, 0);
			set_categorie_element_theme(59, $theme,$id);
        	return $id;
		}else
			return null;
    }
}

/**
 * Met � jour les informations d'un scenario dynamique.
 * 
 * @param integer : 
 * @return integer l'identifiant du scenario: 
 */
function maj_fichier_scenario_dynamique($id, $libelle,$style){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_maj_fichier_scenario_dynamique($id,'$libelle',$style) ";
        //echo "$req<br>";
		$res=pg_query($req);
		return sql2Bool(pg_fetch_result($res, 0, 0));
    }
}

function get_theme_fichiers_blocs_scenarios($theme){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_theme_fichiers_blocs_scenarios($theme) as (id integer, libelle varchar, type integer , connecte bool, date_modification date, categorie integer,theme integer) ";
//		echo "$req<br>";
		return pg_query($req);
		
	}
}

function get_theme_fichiers_slides_scenarios($theme){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_theme_fichiers_slides_scenarios($theme) as (id integer, libelle varchar, type integer , connecte bool, date_modification date, categorie integer,theme integer) ";
//		echo "$req<br>";
		return pg_query($req);
		
	}
}

function get_theme_fichiers_scenarios_dynamiques($theme,$message){
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_theme_fichiers_scenarios_dynamiques($theme,$message) as (id int4, libelle varchar, type int4, connecte bool, style integer,date_creation date, theme integer)";
		//echo "$req<br>";
		return pg_query($req);
		
	}
}

function set_fichier_scenario_dynamique_bloc($fichier_scenario, $bloc,$ordre,$bloc_vars){
	if(VERSION_BASE>VERSION){
//		print_rr($bloc_vars);		
		$sql_bloc_vars_keys=text_array_to_plpgsql_array(array_keys($bloc_vars));
		//$sql_bloc_vars_values=text_array_to_plpgsql_text(array_values($bloc_vars));
		$sql_bloc_vars_values=text_array_to_plpgsql_text(array_values($bloc_vars));
        $req="SELECT * FROM contraintes.af_set_fichier_scenario_dynamique_bloc($fichier_scenario, $bloc,$ordre,$sql_bloc_vars_keys,'".(addslashes(set_ams_libelle($sql_bloc_vars_values)))."')";
//		echo "<br>$req<br>";
		//die();
		$res=pg_query($req);
		return $res&&(sql2Bool(pg_fetch_result($res,0,0)));
	}
}

function get_fichier_scenario_dynamique_blocs($fichier_scenario){
	$req="SELECT * FROM contraintes.af_get_fichier_scenario_dynamique_blocs($fichier_scenario) AS (id integer,libelle varchar, ordre integer, var_keys text[], var_values text, scenario integer)";
	//echo "$req<br>";
	return pg_query($req);
}

function get_fichier_scenario_dynamique_blocs_type($fichier_scenario){
	$req="SELECT * FROM contraintes.af_get_fichier_scenario_dynamique_blocs_type($fichier_scenario) ";
//	echo "$req<br>";
	return pg_fetch_result(pg_query($req),0,0);
}
function get_fichier_scenario_dynamique_slides($fichier_scenario){
	$req="SELECT * FROM contraintes.af_get_fichier_scenario_dynamique_slides($fichier_scenario) AS (id integer,libelle varchar, ordre integer, var_keys text[], var_values text, scenario integer)";
//	echo "$req<br>";
	return pg_query($req);
}

function get_fichier_scenario_dynamique_bloc($fichier_scenario, $ordre){
	$req="SELECT * FROM contraintes.af_get_fichier_scenario_dynamique_bloc($fichier_scenario,$ordre) AS (id integer,libelle varchar, ordre integer, var_keys text[], var_values text, scenario integer)";
//	echo "$req<br>";
	$res=pg_query($req);
	return pg_fetch_row($res,0);
}

function get_fichier_scenario_dynamique_slide($fichier_scenario, $ordre){
	$req="SELECT * FROM contraintes.af_get_fichier_scenario_dynamique_slide($fichier_scenario,$ordre) AS (id integer,libelle varchar, ordre integer, var_keys text[], var_values text, scenario integer)";
//	echo "$req<br>";
	$res=pg_query($req);
	return pg_fetch_row($res,0);
}

function maj_fichier_scenario_dynamique_bloc($fichier_scenario,$ordre,$direction){
	$req="SELECT * FROM contraintes.af_maj_fichier_scenario_dynamique_bloc($fichier_scenario,$ordre,$direction)";
//	echo "$req<br>";
	$res=pg_query($req);
	return $res && sql2Bool(pg_fetch_result($res,0,0));
}

/**
 * Obtenir les th�mes contenant des scenarios.
 * 
 * @return integer : resultat de la requete (id int4, libelle varchar)
 */
function get_fichiers_scenarios_dynamiques_themes($scenario){
	if(VERSION_BASE>VERSION){
		$req="SELECT * FROM contraintes.af_get_categorie_themes(".TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE.")AS (id integer, libelle varchar)";
//		echo "$req<br>";
		$res=pg_query($req);
	}
	return $res;
} 

 /**
 * Obtenir les libelles des langues pour un type donn�
 * @param array : tableau de langues
 * @param integer : type
 * @param integer : limit
 * @param string : message � rechercher
 * @param integer : numero champ pour order by
 * @param string : classement (asc ou desc)
  * @param integer : offset
 */
 function get_theme_scenarios_dynamiques_colonnes_libelles($theme,$message=null,$limit=1000,$orderby=0,$classement='desc',$offset=0){
 	//print_rr($tab_langue);
 	$message=string2Sql($message);	
 	$sql="select * from contraintes.af_get_theme_scenarios_dynamiques_colonnes_libelles($theme,$message,$orderby,'$classement',$limit,$offset) as (id integer, libelle varchar, date_creation date)";
 	
// 	echo "<br>sql=$sql<br>";
 	return pg_query($sql);
 }
 
 function  maj_fichiers_scenarios_dynamiques_libelles($tab_id,$tab_libelle){
  	$sql_tabid=int_array_to_plpgsql_array($tab_id);	
 	$sql_tablib=text_array_to_plpgsql_array($tab_libelle);
  	$sql="select * from contraintes.af_maj_fichiers_scenarios_dynamiques_libelles($sql_tabid,$sql_tablib)";	
  	return pg_query($sql);
  } 
 
  function  del_fichiers_scenarios_dynamiques($tab_id){
  	$sql_tabid=int_array_to_plpgsql_array($tab_id);	
  	$sql="select * from contraintes.af_del_fichiers_scenarios_dynamiques($sql_tabid)";	
  	return sql2Bool(pg_fetch_result(pg_query($sql),0,0));
  }  
  
   function  del_fichier_scenario_dynamique_bloc($scenario,$bloc_ordre){
  	$sql="select * from contraintes.af_del_fichier_scenario_dynamique_bloc($scenario,$bloc_ordre)";	
  	$res=pg_query($sql);
  	return $res&&(sql2Bool(pg_fetch_result($res,0,0)));
  }
  
  function is_fichier_scenario_dynamique_used($bloc_id){
  	$sql="select * from contraintes.af_is_fichier_scenario_dynamique_used($bloc_id)";	
  	//echo "<br>sql=$sql<br>";
  	$res=pg_query($sql);
  	return $res&&(sql2Bool(pg_fetch_result($res,0,0)));
  }
  
  function is_fichier_scenario_dynamique_slides ($scenario) {
	 $sql="select * from contraintes.af_is_fichier_scenario_dynamique_slides($scenario)";	
//  	echo "<br>sql=$sql<br>";
  	$res=pg_query($sql);
  	return $res&&(sql2Bool(pg_fetch_result($res,0,0)));
}

function is_fichier_scenario_dynamique_supprimable($fichier_scenario){
	$sql="select * from contraintes.af_is_fichier_scenario_dynamique_supprimable($fichier_scenario)";
	//echo "sql=$sql<br>";
	$res=pg_query($sql);
	return pg_fetch_result($res, 0, 0);
}
?>