<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Fichier cr le 6 avr. 2006
 *
 * Ce fichier regroupe toutes les fonctions permettant de
 * manipuler les ficher SCORM (zip).
 *
 * @author Rmi Cocquet
 * @package scorm
 * @modulegroup fonctions
 */

//inclusion des librairies
require_once("lib.php");

/**
* Fonction  qui verifie la presence du manifeste SCORM et sa validit.
* @param string : nom du fichier manifeste
* @return boolean :true si le manifeste est prsent et au format valide, false
* sinon
*/
function scorm_is_with_manifeste($manifeste) {
	if (file_exists($manifeste)) {
		// test validit  suivre ....
		return true;

	} else
		return false;

}
/**
 * Fonction  qui dezippe, test (manifeste) et insere en bd un fichier SCORM.
 * Le dzippage s'effectue dans le repertoire ou se trouve le fichier SCORM
 * @param string: le repertoire ou se trouve le fichier SCORM
 * @param string: le nom du fichier SCORM
 * @return boolean: true si l'opration s'est bien effectue, false sinon
 */
function scorm_install($rep, $name, $theme) {
	global $chemin_fo ;
	
	//pour la compatibilit des 2 versions de base
	if (VERSION_BASE > VERSION) {
		$shema="contraintes.";
	}
	// emplacement pour le dzippage
	// le nom
	$lenom = substr($name, 0, -4);
	$dezip = $rep."/$lenom";
	//test si le rep existe deja
	if (is_dir($dezip))
		del_repertoire($dezip);
	else
		mkdir($dezip, 0775);
	$scormdir = $dezip;

	//echo "rep=$rep<br>name=$name et lenom=$lenom<br>";
	// on copie l'archive dans le repertoire scorm  la racine
	copy($rep."/".$name, $scormdir."/".$name);

	// creation d'une archive
	$archive = new PclZip($scormdir."/".$name);
	if (!$list = $archive->extract($scormdir)) {
		return false;
	}
	// on detruit le paquet zip
	unlink($scormdir."/".$name);
	// test si existe manifeste
	if (scorm_is_with_manifeste($scormdir."/imsmanifest.xml")) {
		// insertion en base de donnes
		// le nom
		$lenom = substr($name, 0, -4);
		// la reference
		$ref = "scorm_data";
		// le grade
		$grade = 100;
		$grademethod = 0;
		$datadir = "scorm_data";
		// calcul du launch (c'est le max + 1 du champ id de la table scorm_scoes)
		$req = "select max(id) from $shema"."scorm_scoes";
		$res = pg_query($req);
		$row = pg_fetch_row($res, 0);
		$launch = $row[0] + 1;

		$sql = "insert into $shema"."scorm (course,name,reference,maxgrade,grademethod,datadir,launch,summary,auto,popup,timemodified,num_theme)
		                        values('1','$lenom','$ref','$grade','$grademethod','$datadir','$launch','$lenom','0','pop','0',$theme)";
		$ins = pg_query($sql);

		// insertion dans la table scorm_scoes
		//fichier manifest
		$fichier_manifest = "/imsmanifest.xml";
		//recuperation du numero de paquet scorm
		$sql = "select max(id) from $shema"."scorm";
		$res = pg_query($sql);
		$row = pg_fetch_row($res, 0);
		$num_paquet = $row[0];
		//parsing du fichier manifest et insertion des SCO en table scorm_scoes
		$launch = scorm_parse($scormdir, $fichier_manifest, $num_paquet);
		// mise  jour de la table scorm
		$sql = "update $shema"."scorm set launch=$launch where id=$num_paquet";
		$maj = pg_query($sql);

		return true;
	} else
		return false;
}
?>