<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package scorm 
 * @modulegroup plpgsql
 * @module plpgsql_scorm
 */

/**
*   obtenir le numero du parcours pour l'utilisateur et le calendrier spcifi
*
*   Retourne le numero du parcours  dont l'utilisateur et le calendrier sont passs en parametre.
*
*    @param  integer  : le numero du user
*    @param  integer  : le numero du calendrier
*
*    @return integer  : le resultat de la requete
*/

/**
*   Obtenir le numro d'un paquet scorm (OLD)
*
*   @param string : le nom du paquet
*   @return integer : le resultat de la requete
*/
function get_scorm_numero_old($theme,$fichier){
    $sql="select id from scorm where name='$fichier' and num_theme=$theme";
    //echo "sql=$sql<br>";
    $res=@pg_query($sql);
    return $res;
}
/**
*   Obtenir le numro d'un paquet scorm
*
*   @param string : le nom du paquet
*   @return integer : le resultat de la requete
*/
function get_scorm_numero($theme,$fichier){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_scorm_numero_old($theme,$fichier);
    return $res;
}

/**
*   Obtenir les infos d'un paquet scorm (OLD)
*
*   @param integer : le numero du scorm
*   @return integer : le resultat de la requete
*/
function get_scorm_infos_old($scorm){
    $sql="select * from scorm where id=$scorm";
    //echo "sql=$sql<br>";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les infos d'un paquet scorm
*
*   @param integer : le numero du scorm
*   @return integer : le resultat de la requete
*/
function get_scorm_infos($scorm){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_scorm_infos_old($scorm);
    return $res;
}

/**
	Obtenir le numero de l'tape SCORM correspondant  un fichier

	@param integer : le numero du fichier
    @return integer : le numero de l'tape SCORM correspondant
*/
function get_etape_scorm_fichier($fichier){
	
	if(VERSION_BASE>VERSION){
        $req="SELECT * FROM contraintes.af_get_etape_scorm_fichier($fichier)";
        $res=pg_query($req);
    }
    else
       print("A implmenter...");
    return pg_fetch_result($res,0,0);
}

function get_etape_scorm_themes($scorm){
	
	if(VERSION_BASE>VERSION){
		return get_categorie_element_themes(8, $scorm);
    }
    else
        return get_etape_scorm_themes_old($scorm);
}