CREATE TABLE log_display (
   module varchar(20) NOT NULL default '',
   action varchar(20) NOT NULL default '',
   mtable varchar(20) NOT NULL default '',
   field varchar(40) NOT NULL default ''
);
GRANT ALL ON "log_display" TO PUBLIC;
GRANT ALL ON "log_display" TO "postgres2";
GRANT ALL ON "log_display" TO "www-data";
GRANT ALL ON "log_display" TO "postgres";


CREATE TABLE scorm (
  id SERIAL PRIMARY KEY,
  course integer NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  reference varchar(255) NOT NULL default '',
  maxgrade real NOT NULL default '0',
  grademethod integer NOT NULL default '0',
  datadir varchar(255) NOT NULL default '',
  launch integer NOT NULL default '0',
  summary text NOT NULL default '',
  auto integer NOT NULL default '0',
  popup varchar(255) NOT NULL default '',
  timemodified integer NOT NULL default '0',
  num_theme integer NOT NULL default '0'
);
GRANT ALL ON "scorm" TO PUBLIC;
GRANT ALL ON "scorm" TO "postgres2";
GRANT ALL ON "scorm" TO "www-data";
GRANT ALL ON "scorm" TO "postgres";

CREATE TABLE scorm_scoes (
  id SERIAL PRIMARY KEY,
  scorm integer NOT NULL default '0',
  manifest varchar(255) NOT NULL default '',
  organization varchar(255) NOT NULL default '',
  parent varchar(255) NOT NULL default '',
  identifier varchar(255) NOT NULL default '',
  launch varchar(255) NOT NULL default '',
  type varchar(5) NOT NULL default '',
  title varchar(255) NOT NULL default '',
  datafromlms text NOT NULL default '',
  next integer NOT NULL default '0',
  previous integer NOT NULL default '0',
);
GRANT ALL ON "scorm_scoes" TO PUBLIC;
GRANT ALL ON "scorm_scoes" TO "postgres2";
GRANT ALL ON "scorm_scoes" TO "www-data";
GRANT ALL ON "scorm_scoes" TO "postgres";

CREATE TABLE scorm_sco_users (
  id SERIAL PRIMARY KEY,
  userid integer NOT NULL default '0',
  scormid integer NOT NULL default '0',
  scoid integer NOT NULL default '0',
  cmi_core_lesson_location varchar(255) NOT NULL default '',
  cmi_core_lesson_status varchar(30) NOT NULL default '',
  cmi_core_exit varchar(30) NOT NULL default '',
  cmi_core_total_time varchar(13) NOT NULL default '00:00:00',
  cmi_core_session_time varchar(13) NOT NULL default '00:00:00',
  cmi_core_score_raw real NOT NULL default '0',
  cmi_suspend_data text NOT NULL default ''
);
GRANT ALL ON "scormusers" TO PUBLIC;
GRANT ALL ON "scorm_sco_users" TO "postgres2";
GRANT ALL ON "scorm_sco_users" TO "www-data";
GRANT ALL ON "scorm_sco_users" TO "postgres";

CREATE SEQUENCE "scorm_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
CREATE SEQUENCE "scorm_sco_users_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
CREATE SEQUENCE "scorm_scoes_id_seq" start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
GRANT ALL ON "scorm_id_seq" TO PUBLIC;
GRANT ALL ON "scorm_id_seq" TO "postgres2";
GRANT ALL ON "scorm_id_seq" TO "www-data";
GRANT ALL ON "scorm_id_seq" TO "postgres";


INSERT INTO log_display VALUES ('resource', 'view', 'resource', 'name');
INSERT INTO log_display VALUES ('resource', 'update', 'resource', 'name');
INSERT INTO log_display VALUES ('resource', 'add', 'resource', 'name');