<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
Cette classe dcrit une section (de ressource)

La connexion  la base de donnes doit tre $db

@author LADJANI said <sladjani@afide.fr>
@since 18/04/2005

@package section
*/
class Section
{

        /**
        * @var integer : Identifiant en base de donnes
        */
        var $id ;

        /**
        * @var string : Libell de la section
        */
        var $libelle ;

        /**
        * @var integer : identifiant du fichier icone
        */
        var $icone ;

        /**
        * Constructeur de la classe Section
        * @param integer : identifiant de l'enregistrement en BD ou string : Libell
        * @param string : Libell de l'icone en base de donnes
        */
        function Section($num_ou_lib, $icone="")
        {
				// On determine le type du paramtre  l'aide d'une expression regulire (on reoit toujours une String en php si c'est une rsultat de BD)
                $une_chaine  = ereg("[^0-9]",$num_ou_lib) ;

                // Deux constructions diffrentes selon le type du paramtre ( refaire le jour o on pourra surcharger les fonctions !!!)
                if(!$une_chaine){
                	
                        $this->id = $num_ou_lib ;
                        $result=get_section($num_ou_lib);
                        $row=pg_fetch_array($result) ;
                        //print_rr($row);
                        $this->libelle = $row[1] ;
                        $this->icone = $row[2] ;

                }
                // Construction  partir d'un nom
                else
                {
                       $this->libelle = $num_ou_lib ;
                       $this->icone = $icone;
                }
                
        }

        /**
        * Fonction qui insre un enregistrement en table capacite et qui retourne l'identifiant de la ligne cre
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cre ou un code erreur ngatif
        */
        function insertToDB()
        {
                // On n'insre une ligne que si l'organisme n'existe pas dj
                if($this->libelle=="")
                {
                        return (-110) ; // libell vide
                }
                // Le libell est correcte
                else
                {
                        //$insertion=set_section(string2Sql($this->libelle),int2Sql($this->icone));
                        $insertion=set_section(set_ams_libelle($this->libelle),int2Sql($this->icone));

                        // On retourne un boolen
                        if($insertion)
                        {
                                return $insertion;
                        }
                        else
                                        return (-1) ; // Problme requte
                }
        }

        /**
        * Fonction qui met  jour l'enregistrement en table ressource_sec
        *

        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */

        function updateToDB()
        {
                // Il faut que l'identifiant soit connu
                if($this->id != 0)
                {
                        //$update=maj_section($this->id,string2Sql($this->libelle),int2Sql($this->icone));
                        $update=maj_section($this->id,set_ams_libelle($this->libelle),int2Sql($this->icone));

                        if($update)
                                return true ;
                        else
                                return -1 ; // erreur base de donnes
                }
                // Identifiant inconnu : mise  jour impossible
                else
                {
                        return -2 ;
                }
        }

        /**
        * Procdure qui supprime l'enregistrement en base
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @return integer : On retourne 1 si l'opration s'est correctement effectue. Autrement on retourne un code erreur
        */
        function deleteToDB(){
            // Il faut que l'identifiant soit connu
            if($this->id != 0){

                // suppression de la grille
                if(del_section($this->id)){
                    return true;
                }
                else
                    return -1;  // erreur base de donnes
            }
            else{
                // Identifiant inconnu : suppression impossible
                return -2;
            }
        }

        function getId() { return $this->id ; }
        function getLibelle() { return $this->libelle ; }
        function getIcone() { return $this->icone ; }
        

}
?>