<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

 /**
  
       @package section
       @modulegroup plpgsql
       @module plpgsql_section
*/



/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/


/**
*   Supprimer une section.  (OLD)
*
*   Supprime la section

*
*   @param integer : numero de la section  supprimer
*   @return integer : 1
*/
function del_section_old($section){


    // suppression du titre de la section
    $del=pg_query("delete from ressource_sec where num_section=$section;");

    return 1;
}

/**
*   Supprimer une section.
*
*   Supprime la section
*
*   @param integer : numero de la section  supprimer
*   @return integer : 1
*/
function del_section($section){

            if(VERSION_BASE>VERSION)
            {
                $sql="select * from contraintes.af_del_section($section)";
				$res=pg_query($sql);
            }
            else
                $res=del_section_old($section);

            return ($res);
}

/**
*   Supprimer une section d'un espace des ressources d'une formation.  (OLD)
*
*   Supprime la section

*
*   @param integer : numero de l'espace
*   @param integer : numero de la section  supprimer
*   @param integer : numero de la formation
*   @return integer : 1
*/
function del_section_ressource_old($formation,$espace,$section){


    // suppression  l'espace
    $del=pg_query("delete from ressource_gest where num_espace=$espace and num_section=$section and num_cal=$formation;");

    return 1;
}

/**
*   Supprimer une section d'un espace des ressources d'une formation.
*
*   Supprime la section
*
*   @param integer : numero de l'espace
*   @param integer : numero de la section  supprimer
*   @param integer : numero de la formation
*   @return integer : 1
*/
function del_section_ressource($formation,$espace,$section){

            if(VERSION_BASE>VERSION)
            {
                print("A IMPLEMENTER");
            }
            else
                $res=del_section_ressource_old($formation,$espace,$section);

            return ($res);
}

/**
*   Obtenir le titre d'une section (OLD)
*
    @deprecated : utiliser get_section($section)
*   @param integer : le numro de la section
*   @return string : le titre de la section
*/
function get_section_titre_old($section){
    $sql="select titre from ressource_sec where num_section=$section";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Obtenir le titre d'une section
*
    @deprecated : utiliser get_section($section)
*   @param integer : le numro de la section
*   @return string : le titre de la section
*/
function get_section_titre($section){
     if(VERSION_BASE>VERSION){
        print("A IMPLEMENTER");
     }
     else
        $res=get_section_titre_old($section);
     return ($res);
}

/**
*   Obtenir le titre d'une section (OLD)
*
*   @param integer : le numro de la section
*   @return string : le titre de la section
*/
function get_section_old($section){
    $sql="select num_section,titre,icone from ressource_sec where num_section=$section";
    return pg_query($sql);
}
/**
*   Obtenir le titre d'une section
*
*   @param integer : le numro de la section
*   @return string : le titre de la section
*/
function get_section($section){
     if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_get_section($section) as (id int4,libelle varchar,icone int4)";
		$res=pg_query($sql);
     }
     else
        $res=get_section_old($section);
     return ($res);
}

///**
//*   Obtenir les fichiers ressources d'une section d'un espace pour une formation (OLD)
//*
//*   @param integer : le numero de section
//*   @param integer : le numero d'espace
//*   @param integer : le numero de formation
//*   @return integer : le resultat de la requete
//*/
//function get_section_ressources_infos_espace_formation_old($section,$espace,$formation){
//    $sql="select * from ressource_gest  where num_cal=$formation and num_espace=$espace and num_section=$section ";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//*   Obtenir les fichiers ressources d'une section d'un espace pour une formation
//*
//*   @param integer : le numero de section
//*   @param integer : le numero d'espace
//*   @param integer : le numero de formation
//*   @return integer : le resultat de la requete
//*/
//function get_section_ressources_infos_espace_formation($section,$espace,$formation){
//    if(VERSION_BASE>VERSION){
//        print("A IMPLEMENTER");
//     }
//     else
//        $res=get_section_ressources_infos_espace_formation_old($section,$espace,$formation);
//     return ($res);
//}

/**
    Verifie si une section existe deja (OLD)

    @param string : le nom de la section
    @return bool : true si existe,false sinon
*/
function check_section_old($libelle){
    $sql="SELECT num_section FROM ressource_sec WHERE titre='$libelle'";
    $res=pg_query($sql);
    if(pg_num_rows($res)==0)
        return false;
    return true;
}
/**
    Verifie si une section existe deja

    @param string : le nom de la section
    @return bool : true si existe,false sinon
*/
function check_section($libelle){
    if(VERSION_BASE>VERSION){
        return false;
     }
     else
        $res=check_section_old($libelle);
     return ($res);
}

/**
    Enregistre une section (OLD)

    @param string : le nom de la section
    @param string : le nom du fichier icone
    @return integer : le numero de l'espace, 0 si erreur
*/
function set_section_old($libelle,$icone){
    $sql="INSERT INTO ressource_sec (titre,icone) VALUES ('$libelle','$icone')" ;
    $ins=pg_query($sql);
    if($ins){
        $oid=pg_getlastoid($ins);
        $res=pg_query("select num_section from ressource_sec where oid=$oid");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}
/**
    Enregistre une section

    @param string : le nom de l'a section
    @param integer : le numero du fichier icone
    @return integer : le numero de l'espace, 0 si erreur
*/
function set_section($libelle,$icone=0){
     if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_set_section('$libelle',$icone)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
     }
     else
        $res=set_section_old($libelle,$icone);
     return ($res);
}

/**
    Mettre  jour une section  (OLD)

    @param integer : le numero de la section
    @param string : le nom de l'a section
    @param string : le nom du fichier icone
    @return integer : le resultat de la requete
*/
function maj_section_old($section,$libelle,$icone){
    $sql="UPDATE ressource_sec SET titre = '$libelle',icone='$icone'  WHERE num_section=$section" ;
    return pg_query($sql);
}
/**
    Mettre  jour une section

    @param integer : le numero d'e la section
    @param string : le nom de la section
    @param string : le nom du fichier icone
    @return integer : le resultat de la requete
*/
function maj_section($section,$libelle,$icone){
    if(VERSION_BASE>VERSION){
        $sql="select * from contraintes.af_maj_section($section,'$libelle',$icone)";
        //echo "sql=$sql<br>";
		$res=pg_query($sql);
     }
     else
        $res=maj_section_old($section,$libelle,$icone);
     return ($res);
}

/**
	Teste si une section est supprimable  (OLD)
	@param integer : numero section
	@return bool : true supprimable, sinon false
*/
function check_section_supprimable_old($section){
	// on regarde si l'espace est utilis
	$req = "select * from ressource_gest where num_section=$section";
	$res = pg_query($req);
	if (pg_numrows($res) == 0)
		return true;
	else
		return false;
}
/**
	Teste si une section est supprimable
	@param integer : numero section
	@return bool : true supprimable, sinon false
*/
function check_section_supprimable($section){
	if(VERSION_BASE>VERSION){
		$res=!fk_finder('section','id',$section);
	}
	else
		$res=check_section_supprimable_old($section);
	return $res;
}

/**

*/
?>