<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoSerie.
 * Un DoSerie sert � g�rer l'avancement des Etapes de type S�rie.
 * Ainsi, les appels aux methodes beginCurrentEtape() et endCurrentEtape() s'appliquent � la S�rie elle meme (commence et termine l'�tape) 
 * et � ses �valuations (commence, termine et charge l'Evaluation suivante).   
 * 
 * @package serie
 */
class DoSerie extends DoListe{ 
	var $nouvelle_tentative;
	
	var $duree_evaluations;
	
	var $blocage_parcours;
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours
	 * @param integer $etape l'�tape Liste
	 * @param object DoEvaluationFactory &$obj_DoEvaluationFactory Fabrique servant � la cr�ation des objets d'avancement des Evaluations de la S�rie
	 */
	function DoSerie($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory){
		messageDebug("DoSerie::DoSerie($formation,$individu,$parcours,$etape,&\$obj_DoEvaluationFactory)");
		parent::DoListe($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory);
		$this->nouvelle_tentative=false;
		
		
		//r�cup�ration du r�sultat de la s�rie
		$res_resultat=get_resultat_etape($formation, $individu, $parcours, $etape);
		if(pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
//			print_rr($row_resultat);
			$id_resultat=$row_resultat[0];
			$debut_resultat=$row_resultat[5];
			$duree_resultat=$row_resultat[6];
			
			if(!empty($id_resultat)){
				$this->resultat=$id_resultat;
				$this->debut=$debut_resultat;
				$this->duree=$duree_resultat;
				
				//si la s�rie est configur�e en mode bloquant
				if(check_serie_bloquante_configuree($etape,$formation,$parcours)){
						$res_bloquant=get_serie_bloquante_configuration($etape,$formation,$parcours);
						$row_bloquant=pg_fetch_row($res_bloquant,0);
		//				print_rr($row_bloquant);
						$seuil=$row_bloquant[3];
						$etape_retour=$row_bloquant[4];
						$nb_tentative=$row_bloquant[5];
						$this->blocage_parcours=sql2Bool($row_bloquant[7]);
						messageDebug("DoSerie::DoSerie(): blocage_parcours=".$this->blocage_parcours);
						//nombre d'essais precedents
						$resessai=get_resultat_etape_tentative($this->resultat);
						$nb_essai_av=pg_num_rows($resessai);
						
						//s'il reste des tentatives
						if($nb_essai_av<$nb_tentative &&!$this->isEnd()){ //$blocage_parcours&&
							$this->nouvelle_tentative=true;
						}
				}
			}
		}
	}
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * D�but de la S�rie et de ses Evaluations.
	 * Initialise l'avancement de l'�tape.
	 * Cr�ation de l'identifiant r�sultat et enregistrement de la date de d�but pour la S�rie.
	 * Si la s�rie est en cours, initalise et commence l'Evaluation courante.
	 * 
	 * @return integer idenfiant r�sultat en base de donn�es
	 */
	function beginCurrentEtape(){
		messageDebug("DoSerie::beginCurrentEtape()");
				
		//si la serie est configure en mode bloquant on verifie qu'il reste bien des tentatives
		if(check_serie_bloquante_configuree($this->getEtape(),$this->getFormation(),$this->getParcours())){
			messageDebug("Serie bloquante");	
			
			//  recup configuration serie bloquante
			$res_bloquant=get_serie_bloquante_configuration($this->getEtape(),$this->getFormation(),$this->getParcours());
			$row_bloquant=pg_fetch_row($res_bloquant,0);
			$nb_tentative=$row_bloquant[5];
				
			//nombre d'essais precedents
			$resessai=get_serie_bloquante_tentative($this->getFormation(), $this->getIndividu(), $this->getParcours(),$this->getEtape() );
			$nb_essai_av=pg_num_rows($resessai);
			
			//s'il reste des tentatives
			if($nb_essai_av>=$nb_tentative){
				//die("DoSerie::beginCurrentEtape(): La srie est configure en mode bloquant et il n'y a plus de tentatives possible.");
				return false;
			}
		}
		
		//la serie est commenc�e
		if(!empty($this->resultat)){
			
			//si la s�rie est termin�e lors du begin, ce n'est pas possible, il y a une erreur
			if(!empty($this->duree)){
				die("Erreur DoSerie::beginCurrentEtape(): l'�tape a d�j� �t� commenc�e et est d�j� termin�e.<br/>");
			}
			//la s�rie n'est pas termin�e , cas normal
			else{
				
				//si la s�rie n'a pas d'�valuation prochaine, on l'affecte
				if(!is_object($this->obj_DoNode)){
					$this->nextEvaluation();
				
					//on recupere le resultat de la s�rie
					$row_resultat=get_resultat($this->resultat);
					//pour affecter sa date de d�but
					$this->debut=$row_resultat[5];
					$this->resultat=$row_resultat[0];
					$this->duree=$row_resultat[6];
				}
			}
		}
		//la s�rie n'est pas commenc�e
		else{
			//on la commence			
			$this->resultat=set_resultat_debut($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape() );
			
			//on passe ensuite � l'�valuation prochaine et si il y en a une
			if($this->nextEvaluation()){
				//on recupere le resultat de la s�rie				
				$row_resultat=get_resultat($this->resultat);
				//pour affecter sa date de d�but
				$this->debut=$row_resultat[5];
			}
			return false;
		}
		return $this->resultat;
	}
	
	/**
	 * Construction des objets associ�s � l'avancement au sein de la Serie.
	 * L'objet d'avancement de l'element courant de la s�rie, de type DoEvaluation, est construit � partir
	 * de l'identifiant Resultat cr�� par la methode beginCurrentEtape().
	 * @return object DoEvaluation  L'objet correspondant � l'�valuation courante de la S�rie
	 */ 
	function &performCurrentEtape(&$obj_EtapeFactory){
		messageDebug("DoSerie::performCurrentEtape()");
		parent::performCurrentEtape(&$obj_EtapeFactory);
		
		//on r�cupere l'avancement de la s�rie
		$row_avancement=$this->getAvancement();

		//si la s�rie est bien commenc�e 
		if(!empty($row_avancement[5])){
			
			//si la serie est configure en mode bloquant on verifie qu'il reste bien des tentatives
			if(check_serie_bloquante_configuree($this->getEtape(),$this->getFormation(),$this->getParcours())){
				messageDebug("Serie bloquante");	
				
				//  recup configuration serie bloquante
				$res_bloquant=get_serie_bloquante_configuration($this->getEtape(),$this->getFormation(),$this->getParcours());
				$row_bloquant=pg_fetch_row($res_bloquant,0);
				$nb_tentative=$row_bloquant[5];
					
				//nombre d'essais precedents
				$resessai=get_serie_bloquante_tentative($this->getFormation(), $this->getIndividu(), $this->getParcours(),$this->getEtape() );
				$nb_essai_av=pg_num_rows($resessai);
				
				//s'il reste des tentatives
				if($nb_essai_av>=$nb_tentative){
					//die("DoSerie::beginCurrentEtape(): La srie est configure en mode bloquant et il n'y a plus de tentatives possible.");
					return false;
				}
			}
			$this->duree_evaluations=sql_interval_to_secondes($row_avancement[8]);
			$chrono_restant=$this->getChronoRestant($row_avancement[5]);
			
			//s'il n'y a plus de chrono pour l'�valuation, on termine la s�rie brutalement (abord).
			if(!$this->isChronoValid($chrono_restant,$row_avancement[5])){
				
				//cela uniquement si la s�rie n'a pas d�ja �t� termin�e (refresh ou plusieur appels � cette m�thode)
				if(empty($this->duree)){
					
					$this->abordCurrentEtape();
				}
			}else{
				//on l'affecte en tant que prochaine evaluation 
				$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			}
		}
		//si elle ne l'est pas
		else{
			//il n'y a pas d'evaluation pour la s�rie			
			unset($this->obj_DoNode);
		}
		return $this->obj_DoNode;
	}



	/**
	 * Termine la S�rie et si besoin termine l'Evaluation courante et charge l'�tape suivante.
	 * Enregistre la date de fin de la s�rie et de l'�valuation si besoin et detruit les attributs de l'objet inutiles.
	 * @param object ResultatSerie $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succ�s ou non de la m�thode.
	 */
	function endCurrentEtape($obj_resultat=null){
		messageDebug("DoSerie::endCurrentEtape($obj_resultat)");
		
		// si pas d'�valuation courante on est donc � la fin de la serie
		if(!is_object($this->obj_DoNode)){ //nb:attention pas de else
			
			//on fini la s�rie
			$res_parent=parent::endCurrentEtape($obj_resultat);	
			// traitement si serie bloquante  NOTE : Voir avec R�mi pour mise en place de l'objet
			
			// recup score serie
			$score_serie=$this->getScoreTotal();
			
			//si la s�rie est configur�e en mode bloquant
			if(check_serie_bloquante_configuree($this->getEtape(),$this->getFormation(),$this->getParcours())){
				messageDebug("Serie bloquante");	
				
				//  recup configuration serie bloquante
				$res_bloquant=get_serie_bloquante_configuration($this->getEtape(),$this->getFormation(),$this->getParcours());
				$row_bloquant=pg_fetch_row($res_bloquant,0);
//				print_rr($row_bloquant);
				$seuil=$row_bloquant[3];
				$etape_retour=$row_bloquant[4];
				$nb_tentative=$row_bloquant[5];
					
				//nombre d'essais precedents
				$resessai=get_resultat_etape_tentative($this->resultat);
				$nb_essai_av=pg_num_rows($resessai);
				
				//s'il reste des tentatives
				if($nb_essai_av+1<$nb_tentative){
					messageDebug("Tentatives restantes(essais:".($nb_essai_av+1)."< dispo:$nb_tentative)");
					
					//enregistre la tentative
					$this->setNouvelleTentative(true);
					
					// si score serie inferieur au seuil
					if($score_serie<$seuil){
						messageDebug("Score inferieur au seuil ($score_serie<$seuil)");	
						
						//on supprime place le curseur  l'tape retour
						$res_retour=get_resultat_etape($this->getFormation(),$this->getIndividu(),$this->getParcours(),$etape_retour);						
						del_resultat_fin(pg_fetch_result($res_retour,0,0));
						messageDebug("RAZ etape $etape_retour");	
//						unset($this->resultat);
					}else{
						messageDebug("Score suprieur au seuil ($score_serie<$seuil)");	
						//on affecte la tentative comme resultat de la s�rie
						set_resultat_meilleure_tentative($this->resultat);
						$this->setNouvelleTentative(false);
					}
				 	
				}
				//derniere tentative
				elseif($nb_essai_av+1==$nb_tentative){
					messageDebug("derniere tentative (essais:".($nb_essai_av+1)."< dispo:$nb_tentative)");	
					//enregistre la tentative
					$this->setNouvelleTentative(true);
					
					//on affecte la tentative comme resultat de la s�rie
					set_resultat_meilleure_tentative($this->resultat);
					
					// si score serie inferieur au seuil
					if($score_serie<$seuil){
						messageDebug("Score inferieur au seuil ($score_serie<$seuil)");	
						
						//on supprime place le curseur  l'tape retour
						$res_retour=get_resultat_etape($this->getFormation(),$this->getIndividu(),$this->getParcours(),$etape_retour);						
						del_resultat_fin(pg_fetch_result($res_retour,0,0));
						messageDebug("RAZ etape $etape_retour");	
						//Si le parcours doit etre bloqu, on supprime supprimme la dure de la srie
						messageDebug("DoSerie::DoSerie(): blocage_parcours=".$this->blocage_parcours);
						if($this->blocage_parcours){
							del_resultat_fin($this->resultat);
						}
//						unset($this->resultat);
					}else{
						messageDebug("Score suprieur au seuil ($score_serie<$seuil)");	
						//rien, on garde le resultat
					}
					$this->setNouvelleTentative(false);
					
				}else{
					//die("DoSerie::beginCurrentEtape(): La srie est configure en mode bloquant et il n'y a plus de tentatives possible.");
					return false;
				}
			}
			return $res_parent;
			
		}
		//si il y a une �valuation suivante ce n'est pas possible: erreur
		else{
			messageDebug("DoSerie::endCurrentEtape(): La serie ne peut etre termin�e: Il y a une �valuation suivante.");
			return false;
		}
	}
		
	function performCurrentDoNode(){
		
//	 	echo "<b>performCurrentDoNode()</b>";
//		print_rr($this);
		$chrono_restant=$this->getChronoRestant();
		$obj_node=$this->obj_DoNode->perform($this->obj_node,$chrono_restant);
		if(is_null($obj_node)){
			//il n'y a pas d'evaluation pour la s�rie			
			unset($this->obj_DoNode);
		}
		return $this->obj_DoNode;
	}	
		
	/**
	 * Termine la S�rie et si besoin termine l'Evaluation courante et charge l'�tape suivante.
	 * Enregistre la date de fin de la s�rie et de l'�valuation si besoin et detruit les attributs de l'objet inutiles.
	 * @param object ResultatSerie $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succ�s ou non de la m�thode.
	 */
	function abordCurrentEtape(){
		messageDebug("DoSerie::abordCurrentEtape()");
		if(!empty($this->resultat)){
			if(!empty($this->duree)){
				$this->duree=set_resultat_fin($this->resultat);
				if(!$this->duree){
					die("Erreur DoEtape::abordCurrentEtape(): L'�tape n'a pas �t� termin�e.<br>");
					return false;
				}else{
					$row_avancement=$this->getAvancement();
					$this->duree_evaluations=sql_interval_to_secondes($row_avancement[8]);
					$row_resultat=get_resultat($this->resultat);
					$this->duree=$row_resultat[6];	
					//la prochaine �valuation est alors vide			
					unset($this->obj_DoNode);
					
					return true;
				}
			}
		}
		else{
			die("Erreur DoEtape::abordCurrentEtape(): Une �tape peut etre abandonn�e seulemenent si elle a �t� commenc�e.<br>");
		}
		
	}
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	/**
	 * Passage � l'Evaluation suivante de la S�rie.
	 * Initalise l'objet d'avancement de l'�valuation suivante ou le met � null si pas d'�tape suivante.
	 * @return boolean TRUE si il y a une evaluation suivante, FALSE sinon.
	 */
	function nextEvaluation(){
		messageDebug("DoSerie::nextEvaluation()");
		//on r�cupere la prochaine �vualuation
		$row_avancement=$this->getAvancement();

		//si in y a une prochaine �valuation
		if(!empty($row_avancement[5])){
			//on l'affecte en tant qu'�valuation a faire			
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			$this->duree_evaluations=sql_interval_to_secondes($row_avancement[8]);
			return true;
		}
		//si la s�rie est finier ou vide
		else{
			//la prochaine �valuation est alors vide			
			unset($this->obj_DoNode);
			return false;
		}
	}
	
	/**
	 * Obtenir l'engistrement de base de donn�es correspondant � l'�tat courant de la S�rie.
	 * @return Array() : Ligne r�sultat de la requete sur la base de donn�es.
	 */
	function getAvancement(){
		messageDebug("DoSerie::getAvancement()");
		//$res=get_resultat_serie_evaluations_duree_totale($this->getResultat());
		return pg_fetch_row(get_resultat_serie_avancement_max($this->getResultat()));
	}
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	
	/**
	 * Obtenir l'objet Serie associ� � cet objet d'avancement.
	 * @return object Serie L'objet Serie associ�. 
	 */
	function getSerie(){
		return parent::getListe();
	}
	
	/**
	 * Obtenir le type (complet) de la S�rie
	 * @return string Le type de S�rie
	 */
	function getType(){
		return parent::getType().'_'.TYPE_LISTE_SERIE;
	}
	
	/**
	 * Obtenir l'objet d'avancement correspondant � l'Evaluation courante de la S�rie 
	 * @return object DoEvaluation L'objet d'avancement de l'Evaluation courante
	 */
	function &getCurrentDoEvaluation(){
		return parent::getCurrentDoNode();
	}
	
	/**
	 * Obtenir la fabrique d'Evaluation utilis�e pour la cr�ation des noeuds de la S�rie
	 * @return object DoEvaluationFactory : la fabrique de DoEvaluation
	 */
	function getCurrentDoEvaluationFactory(){
		return parent::getCurrentDoNodeFactory();
	}
	
	/**
	 * Obtenir la dur�ee des �valuations effectu�es.
	 */
	function getDureeEvaluations(){
		
//TODO	changer le nom??? elle fait pas ce qu'elle dit!  echo "getDureeEvaluations() méthode etrange";
		return get_resultat_serie_score($this->getResultat());
	}	
	
	/**
	 * Calculer et obtenir le status de la serie.
	 * Le status est obtenu � partir des donn�es en base.
	 * L'�tape peut avoir les status suivants:
	 * DO_ETAPE_NONE, DO_ETAPE_BEGIN et DO_ETAPE_END.
	 */
	 function getStatus(){
		$status=DO_ETAPE_NONE;
		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
		if(pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
			$id_resultat=$row_resultat[0];
			$duree_resultat=$row_resultat[6];
		}
		if(!empty($id_resultat)){
			
			$status=DO_ETAPE_BEGIN;
			if( (!empty($duree_resultat)) && (pg_num_rows($this->getEvaluations()) ==
			pg_num_rows($this->getResultatEvaluations($id_resultat))  )  ){
				$status=DO_ETAPE_END;
			}
//			else{
//				echo "pas fini total;".pg_num_rows($this->getEvaluations())."fait :".pg_num_rows($this->getResultatEvaluations($id_resultat)) ."<br>";
//			}
		}
		return $status;	
	}
	
	function getEvaluations(){
		return get_serie_evaluations($this->getEtape());
	}
	
	function getResultatEvaluations($id_resultat){
		return get_resultat_serie_evaluations($id_resultat);
	}
	
	/**
	* Affecte l'attribut nouvelle_tentative avec une valeur logique,
	* duplique les donnes rsultat dans les tables de tentatives
	* et remets a zero la date de fin de resultat de la srie.
	* @param bool : nouvelle valeur pour l'attribut
	*
	*/
	function setNouvelleTentative($val){
		// stockage des resultats de la tentative 
		if($val){
			set_resultat_tentative($this->resultat);	
		}else{
//			unset($this->resultat);
		} 
		$this->nouvelle_tentative=$val;
		
	}
	
	/**
	* Retoune la valeur de l'attribut nouvelle_tentative
	* @return : la valeur de l'attribut
	*/
	function isNouvelleTentative(){
		return $this->nouvelle_tentative;
	}
	
	
	/**
	* ADAPTER
	* @return  isNouvelleTentative()
	*/
	function isTentative(){
		return $this->isNouvelleTentative();
	}
	
	/**
	* Savoir si la sri bloquante est bloque
	* Une srie est bloque lorsqu'elle est configure en mode bloquant, et qu'il n'y a plus de tentatives.
	*/
	function isBlocked(){
		//si la s�rie est configur�e en mode bloquant
		if(check_serie_bloquante_configuree($this->getEtape(),$this->getFormation(),$this->getParcours())){
				$res_bloquant=get_serie_bloquante_configuration($this->getEtape(),$this->getFormation(),$this->getParcours());
				$row_bloquant=pg_fetch_row($res_bloquant,0);
//				print_rr($row_bloquant);
				$seuil=$row_bloquant[3];
				$etape_retour=$row_bloquant[4];
				$nb_tentative=$row_bloquant[5];
				$blocage_parcours=sql2Bool($row_bloquant[7]);
					
				//nombre d'essais precedents
				$resessai=get_resultat_etape_tentative($this->resultat);
				$nb_essai_av=pg_num_rows($resessai);
				
				//s'il reste des tentatives
				if($nb_essai_av>=$nb_tentative){ //$blocage_parcours&&
					return true;
				}
		}
		return false;
	}
	
	/**
	 * Savoir si la correction est disponible.
	 * Une correction est disponible si cel� � �t� configur� tel quel ou si c'est une s�rie non bloquante.
	 * @param integer Identifiant de la formation
	 * @param integer Identifiant du parcours
	 * @return boolean true si la s�rie est bloquante, false sinon.
	*/
	function isCorrectionDisponible($formation=null,$parcours=null){
		
		if(check_serie_bloquante_configuree($this->getEtape(),$this->getFormation(),$this->getParcours())){
			// recup configuration $this->getFormation(),$this->getParcours()
			$res=get_serie_bloquante_configuration($this->getEtape(),$this->getFormation(),$this->getParcours()); //$formation, $parcours);
			$row=pg_fetch_row($res,0);
			$nb=pg_num_rows($res);
			if(sql2Bool($row[6])){ //correction si serie non bloquante ou si s�rie bloquante et correstion disponible
				return true;
			}
			else{
				// on autorise la correction si resultats ok (note individu>=seuil)
				$seuil=$row[3];
				$resultat=$this->getResultat();
				//echo "resultat=$resultat et seuil=$seuil<br>";
				//$score_serie=get_resultat_serie_score($resultat);
				$score_serie=$this->getScoreTotal();
				//echo "score_serie=$score_serie<br>";
				if($score_serie>=$seuil){
					return true;
					
				}
				return false;
			}	
		}
		//correction si serie non bloquante
		else{
			return true;
		}
		
	}
	
	/**
	 * Obtenir les Evaluations de la S�rie
	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	 */
	function getScoreTotal(){
		return get_resultat_serie_score($this->getResultat());
	}
	
	function getNbTentativesRestantes(){
		$res_bloquant=get_serie_bloquante_configuration($this->getEtape(),$this->getFormation(),$this->getParcours());
		$row_bloquant=pg_fetch_row($res_bloquant,0);
		$nb_tentative=$row_bloquant[5];
			
		//nombre d'essais precedents
		$resessai=get_resultat_etape_tentative($this->resultat);
		$nb_essai_av=pg_num_rows($resessai);
		
		return $nb_tentative-$nb_essai_av;
	}
	
	/**
	 * 
	 */
	function isSuccessfull(){
		//si la s�rie est configur�e en mode bloquant
		if(check_serie_bloquante_configuree($this->getEtape(),$this->getFormation(),$this->getParcours())){
			// recup score serie
			$score_serie=$this->getScoreTotal();
			messageDebug("DoSerie::isSuccessfull() Score de la serie :$score_serie");
			$res=get_serie_bloquante_configuration($this->getEtape(),$this->getFormation(),$this->getParcours()); //$formation, $parcours);
			$row=pg_fetch_row($res,0);
			messageDebug("DoSerie::isSuccessfull() Seuil:".$row[3]);
			if($score_serie>=$row[3]){
				return true;
			}else{
				return false;
			}
		}else{
			return true;
		}
	}
}
?>