<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un SerieCorrection.
 * Un SerieCorrection est l'objet � utilis� pour exploiter la correction d'une S�rie.
 * Cet objet de correction est constuit � partir d'un DoSerie, l'objet d'avancement des S�ries.
 * 
 * @package serie
 */
class SerieCorrection extends ListeCorrection{ 
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * 
	 * @param object DoSerie $obj_DoSerie 
	 */
	function SerieCorrection($obj_DoSerie){
		messageDebug("SerieCorrection::SerieCorrection( $obj_DoSerie)");
		parent::ListeCorrection($obj_DoSerie);
		
		//$this->initSerieCorrection();
	}
//	
//	function initSerieCorrection(){
//		$res_resultat=get_resultat_etape($this->obj_DoEtape->getFormation(), $this->obj_DoEtape->getIndividu(), $this->obj_DoEtape->getParcours(), $this->obj_DoEtape->getEtape());
//		if($res_resultat&&pg_num_rows($res_resultat)==1){
//			$row_resultat=pg_fetch_row($res_resultat);
//			$this->resultat=$row_resultat[0];
//			$this->debut=$row_resultat[2];
//			$this->fin=$row_resultat[2];
//		}
//		else{
//			die("Erreur SerieCorrection::SerieCorrection($obj_DoEtape): L'objet d'avancement ne poss�de pas d'identifiant de r�sultat.(Le DoSerie a-t-il bien �t� commenc�?)");
//		}
//	}
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * Obtenir les scores des Evaluations de la S�rie
	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	 */
	 
	function getEvaluationsScores(){
		return get_resultat_serie_evaluations_scores($this->getResultat());
		// Phase de test
		//return get_resultat_serie_evaluations_scores_qcm($this->getResultat());
	}
	
	
	/**
	 * Obtenir les Evaluations de la S�rie
	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	 */
	function getScoreTotal(){
		return get_resultat_serie_score($this->getResultat());
	}	

	function initCurrentEvaluationCorrection($indice=1){
		if(empty($indice)){
			$indice=$this->current_evaluation_correction_indice;
		}else{
			$this->current_evaluation_correction_indice=$indice;
		}
		$res_evaluations=$this->getEvaluations();
//		echo "\$indice=$indice";
		if($indice<=pg_num_rows($res_evaluations)){
			$row=pg_fetch_row($res_evaluations,$indice-1);
//			$this->current_evaluation_correction_indice++;
			$this->current_evaluation_correction_obj= EvaluationCorrectionFactory::createEvaluationCorrection($this,$this->obj_DoEtape->obj_DoNodeFactory->obj_NodeFactory->createEvaluation($row[0],$row[8]));
			 return $this->current_evaluation_correction_obj;
		}else{
			return null;
		}
	}
	
	function getCurrentEvaluationCorrection($indice=0){
		if(func_num_args()==0){
			return $this->current_evaluation_correction_obj;
		}
		else{
			$res_evaluations=$this->getEvaluations();
			if($indice<=pg_num_rows($res_evaluations)){
				$row=pg_fetch_row($res_evaluations,$indice-1);
				//print_rr($row);
	//			$this->current_evaluation_correction_indice++;
				return EvaluationCorrectionFactory::createEvaluationCorrection($this,$this->obj_DoEtape->obj_DoNodeFactory->obj_NodeFactory->createEvaluation($row[0],$row[8]));
			}else{
				return null;
			}
		}
	}
	
	function getEvaluations(){
		return get_serie_evaluations($this->obj_DoEtape->getEtape());
	}
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------
	

}
?>
