<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * @package serie
 * @modulegroup fonctions
 */

/**
 * Obtenir les actions autorises sur une srie.
 * 2: la serie est supprimable
 * 1: elle n'est que modifible 
 * 0: elle n'est ni modifiable ni supprimable
 * 
 * @param integer identifiant de la srie
 * @param integer le code de retour de l'action
 */
function get_serie_actions($serie){
	//initialisation , tout est permis
    $action_serie=2;
    
    // test si la srie est dans un parcours
    $res=get_serie_parcourss($serie);
    if(pg_num_rows($res)>0){
    	//modif uniquement
        $action_serie=1;
        //echo "DANS PARCOURS<br>";
        // test si parcours en formation (inutile)
//        $nbparc=pg_numrows($res);
//        for($i=0;$i<$nbparc;$i++)
//        {
//            $row=pg_fetch_row($res,$i);
//            $tabform=array();
//            $tabform=get_parcours_all_formations($row[0],$tabform);
//            $sz=sizeof($tabform);
//            if($sz>0)
//            {
//                $action_serie=1;
//                break;
//            }
//        }
    }

    // test si la serie est utilise par une serie aleatoire
    if(pg_num_rows(get_serie_series_aleatoires($serie))){
    	//modif uniquement
    	//echo "DANS SERIE ALEATOIRE<br>";
    	$action_serie=1;
    }
    
    //test si la srie  t faite par un stagiaire
    //$res_max=get_serie_avancement_max($serie);
	$res_max=get_etape_resultats($serie);
    if( (pg_num_rows($res_max)>0) && pg_fetch_result($res_max,0,0) ){
    	//rien n'est permis
    	$action_serie=0;
    }
    return $action_serie;
}

/**
	retourne les differents types d'evaluation d'une serie
	@param integer identifiant de la srie
*/
function get_serie_types_evaluation($serie){
	if (VERSION_BASE > VERSION) {
		$sql="select * from contraintes.af_get_serie_distincts_types($serie) as (type int4)";
		$res=pg_query($sql);
	}
	else{
		 $sql="select distinct type_exo from asso_exo_serie where id_serie=$num_serie";
		 $res=pg_query($sql);
	}
	return $res;
}

/**
 * Obtenir les actions autorises sur une evaluation de srie.
 * 2: l'evaluation est supprimable
 * 1: elle n'est que modifible 
 * 0: elle n'est ni modifiable ni supprimable
 * 
 * @param integer identifiant de la srie
 * @param integer identifiant de l'evaluation
 * @param integer le code de retour de l'action
 */
function get_serie_evaluation_actions($serie,$evaluation){
	//initialisation , tout est permis
    $action=2;
    // test si resultat pour cette evaluation de serie
    if(is_serie_evaluation_resultats($serie,$evaluation))
    	$action=0;
    else
    	if(is_evaluation_resultats($evaluation))
    		$action=1;
    return $action;	
    
    
}

/**
	Savoir si une evaluation a des resultats pour une serie
	* @param integer idendifiant de la serie
	* @param integer idendifiant de l'evaluation
	* @return integer: vrai si resultat, faux sinon
*/
function is_serie_evaluation_resultats($serie,$evaluation){
	$res=get_serie_evaluation_resultats($serie,$evaluation);
	if(pg_num_rows($res)>0)
		return true;
	return false;
}
    

?>
