<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/*
 * Created on Apr 27, 2006
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */
 
 
/*-----------------------------------------------------------------------------------------*/
//                         LES FONCTIONS  D'ACCESS AUX FONCTIONS PLPGSQL
/*-----------------------------------------------------------------------------------------*/
/*
                            DOIVENT RETOURNER UNE VARIABLE
*/
/*
CONVENTION DE NOMAGE :
Il faut tablir une correspondance entre le nom de la fonction php et le nom de la fonction
PLPGSQL. Ainsi, on utilisera le meme nom pour les 2 fonctions, a ceci prs que le nom de
 la fonction PLPGSQL est precede de _af_ afin de la distinguer des fonctions systeme.
Exemple:

la fonction php function check_access($droit, $cal, $user) correspond  _af_check_access dans la base

*/
/**
*   Test si la srie donne est alatoire (OLD)
*
*   Retourne 0 si non alatoire et >0 sinon
*
*    @param  integer : numro de srie
*
*   @return integer : entier 0 ou >0
*/
function check_aleatoire_serie_old($serie)
{
            $test_alea="select count(num_serie) from serie_aleatoire where num_serie='$serie'";
            return(pg_query($test_alea));
}

/**
*   Test si la srie donne est alatoire
*
*   Retourne 0 si non alatoire et >0 sinon
*
*    @param  integer : numro de srie
*
*    @return integer : entier 0 ou >0
*/
function check_aleatoire_serie($serie)
{
            if(VERSION_BASE>VERSION)
            {
                        $req="select _af_check_aleatoire_serie($serie)";
                        $res = pg_query($req);
            }
            else
                        $res=check_aleatoire_serie_old($serie);
            return (pg_result($res,0,0));
}


/**
* Obtenir les types d'tapes d'une srie (OLD)
*
* retourne la liste des types d'etapes prsents dans une srie
*
*  @param integer : numro de srie
*  @param integer : >0 si srie aleatoire, 0 sinon
*  @return integer : la liste des types d'etapes
*/
/*function get_types_etapes_serie_old($serie,$aleatoire)
{
            if($aleatoire>0) $table="asso_exo_serie_aleatoire";
            else $table="asso_exo_serie";
            $req="select distinct type_exo from $table where id_serie='$serie'";
            $res = pg_query($req);

            return ($res);
}*/

/**
* Obtenir les types d'tapes d'une srie
*
* retourne la liste des types d'etapes prsents dans une srie
*
*  @param integer : numro de srie
*  @param integer : >0 si srie aleatoire, 0 sinon
*  @return integer : la liste des types d'etapes
*/
/*function get_types_etapes_serie($serie,$aleatoire)
{
            if(VERSION_BASE>VERSION)
            {

                        $req="select * from  _af_get_types_etapes_serie($serie,$aleatoire) as (type_exo char)";
                        $res = pg_query($req);
            }
            else
                        $res=get_types_etapes_serie_old($serie,$aleatoire);
            return ($res);
}*/


/**
	Obtenir les diffrents types d'une srie pour une formation donne (OLD)

	Les informations obtenues sont:
	type_exo

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
*/
function get_serie_type_formation_old($serie,$formation)
{
        $req = "select distinct type_exo from res_serie_exo where id_formation='$formation' and id_serie='$serie'";
        $res = pg_query($req);
        return $res ;
}



/**
	Obtenir les diffrents types d'une srie pour une formation donne

	Les informations obtenues sont:
	type_exo

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
*/
function get_serie_type_formation($serie,$formation)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_type_formation_old($serie,$formation);

    return $res ;
}

/**
	Obtenir les diffrents types d'une srie d'une formation pour un stagiaire donn (OLD)

	Les informations obtenues sont:
	type_exo

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
      @param integer: identifiant en base de la stagiaire
*/
function get_serie_type_stagiaire_formation_old($serie,$formation,$stagiaire)
{
    $req = "select distinct type_exo from res_serie_exo where id_formation='$formation' and id_serie='$serie' and id_stag='$stagiaire'";
    $res = pg_query($req);
    return $res ;
}

/**
	Obtenir les diffrents types d'une srie d'une formation pour un stagiaire donn

	Les informations obtenues sont:
	type_exo

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
      @param integer: identifiant en base de la stagiaire
*/
function get_serie_type_stagiaire_formation($serie,$formation,$stagiaire)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_type_stagiaire_formation_old($serie,$formation,$stagiaire);

    return $res ;
}

/**
	Obtenir la moyenne d'une serie pour une formation donne (OLD)

	Les informations obtenues sont:
	avg(score)

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
*/
function get_serie_moyenne_formation_old($serie,$formation)
{
    $req = "select avg(score) from res_serie where id_serie=$serie and id_formation=$formation and score>=0 and date_fin>0" ;
    $res = pg_query($req);
    return $res ;
}

/**
	Obtenir la moyenne d'une serie pour une formation donne

	Les informations obtenues sont:
	avg(score)

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
*/
function get_serie_moyenne_formation($serie,$formation)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_moyenne_formation_old($serie,$formation);

    return $res ;
}

/**
	Obtenir la moyenne d'une serie d'une formation pour un stagiaire donn (OLD)

	Les informations obtenues sont:
	avg(score)

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
      @param integer: identifiant en base du stagiaire
*/
function get_serie_moyenne_stagiaire_formation_old($serie,$formation,$stagiaire)
{
    $req = "select avg(score) from res_serie where id_serie=$serie and id_formation=$formation and id_stag=$stagiaire and score>=0 and date_fin>0" ;
    $res = pg_query($req);
    return $res ;
}

/**
	Obtenir la moyenne d'une serie d'une formation pour un stagiaire donn

	Les informations obtenues sont:
	avg(score)

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
      @param integer: identifiant en base du stagiaire
*/
function get_serie_moyenne_stagiaire_formation($serie,$formation,$stagiaire)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_moyenne_stagiaire_formation_old($serie,$formation,$stagiaire);

    return $res ;
}

/**
	Obtenir les series aleatoires pour une serie donne et une formation (OLD)

	Les informations obtenues sont:
	num_serie | num_cal | aleatoire | datedeb | datefin

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
      @param integer: identifiant en base du stagiaire
*/
function get_serie_aleatoire_formation_old($serie,$formation)
{
    $req="select * from gestserie where num_serie=$serie and num_cal=$formation and aleatoire='t'";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir les series aleatoires pour une serie donne et une formation

	Les informations obtenues sont:
	num_serie | num_cal | aleatoire | datedeb | datefin

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
      @param integer: identifiant en base du stagiaire
*/
function get_serie_aleatoire_formation($serie,$formation)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_aleatoire_formation_old($serie,$formation);

    return $res ;
}

/**
	Obtenir le mode d'une serie aleatoire pour une serie donne (OLD)

	Les informations obtenues sont:
	mode

      @param integer: identifiant en base de la serie
*/
function get_serie_mode_aleatoire_old($serie)
{
    $req="select distinct mode from serie_aleatoire where num_serie=$serie";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir le mode d'une serie aleatoire pour une serie donne

	Les informations obtenues sont:
	mode

      @param integer: identifiant en base de la serie
*/
function get_serie_mode_aleatoire($serie)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_mode_aleatoire_old($serie);

    return $res ;
}

/**
	Pour savoir si c'est une serie gnr par un test d'autopositionnement (OLD)

	Les informations obtenues sont:
	id_exo | id_serie | ordre | commentaire | bareme | chrono | point | type_exo | num_user | num_cal

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
*/
function get_serie_formation_old($serie,$formation)
{
    $req="select * from asso_exo_serie_aleatoire where id_serie=$serie and num_cal=$formation";
    $res=pg_query($req);
    return $res ;
}

/**
	Pour savoir si c'est une serie gnr par un test d'autopositionnement

	Les informations obtenues sont:
	id_exo | id_serie | ordre | commentaire | bareme | chrono | point | type_exo | num_user | num_cal

      @param integer: identifiant en base de la serie
      @param integer: identifiant en base de la formation
*/
function get_serie_formation($serie,$formation)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_formation_old($serie,$formation);

    return $res ;
}

/**
	Obtenir l'identifiant d'un sondage/src pour une serie donne (OLD)

	Les informations obtenues sont:
	id_exo

      @param integer: identifiant en base de la serie
*/
function get_serie_sondage_old($serie)
{
    $req="select id_exo from asso_exo_serie where id_serie=$serie and (type_exo='s' or type_exo='o')";
    $res=pg_query($req);
    return $res ;
}

/**
	Obtenir l'identifiant d'un sondage/src pour une serie donne

	Les informations obtenues sont:
	id_exo

      @param integer: identifiant en base de la serie
*/
function get_serie_sondage($serie)
{
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_sondage_old($serie);

    return $res ;
}

/**
*   Obtenir le nom d'une srie (OLD)
*
*   @param integer : le numro de la srie
*   @return string : le nom de la srie
*/
function get_serie_nom_old($serie){
    $sql="select titre from serie_exo where id=$serie";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
*   Obtenir le nom d'une srie
*
*   @param integer : le numro de la srie
*   @return string : le nom de la srie
*/
function get_serie_nom($serie){
    if(VERSION_BASE>VERSION)
    {
            print("A implmenter...");
    }
    else
            $res=get_serie_nom_old($serie);

    return $res ;
}

/**
*   Obtenir les exo par type d'une serie aleatoire  (OLD)
*
*   @param integer : le numero de la serie
*   @return integer : le rsultat de la requte
*/
function get_serie_aleatoire_nbexo_par_type_old($serie){
    $sql="select nbexo_par_type from serie_aleatoire where num_serie=$serie";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les exo par type d'une serie aleatoire
*
*   @param integer : le numero de la serie
*   @return integer : le rsultat de la requte
*/
function get_serie_aleatoire_nbexo_par_type($serie){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_aleatoire_nbexo_par_type_old($serie);
    return $res ;
}

///**
//*   Obtenir les formations qui utilisent la serie (OLD)
//*
//*   @param integer : le numro de la serie
//*   @return integer : le rsultat de la requte
//*/
//function get_serie_formations_old($serie){
//$sql="SELECT DISTINCT C.num_cal, C.nom_cal FROM gestparcours G1,gestionparcours G2, calendrier C WHERE num_c_q_e_d=$serie
//        AND type_etape ='B'
//        AND gp_num_parcours=g_num_parcours
//        AND C.num_cal=G2.num_cal
//        ORDER BY C.nom_cal";
//$res=pg_query($sql);
//return $res;
//}
///**
//*   Obtenir les formations qui utilisent la serie
//*
//*   @param integer : le numro de la serie
//*   @return integer : le rsultat de la requte
//*/
//function get_serie_formations($serie){
//     if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_serie_formations_old($serie);
//    return $res ;
//}

/**
*   Mettre  jour le chrono d'une serie (OLD)
*
*   @param integer : le numero de la serie
*   @param integer : la valeur du chrono (en seconde)
*   @return integer : 1
*/
function maj_serie_chrono_old($serie,$chrono){
    $sql="update serie_exo set chrono ='$chrono' where id=$serie";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour le chrono d'une serie
*
*   @param integer : le numero de la serie
*   @param integer : la valeur du chrono (en seconde)
*   @return integer : 1
*/
function maj_serie_chrono($serie,$chrono){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_chrono_old($serie,$chrono);
    return $res ;
}

/**
*   Obtenir les infos d'une serie (OLD)
*	@deprecated voir get_serie($serie)
*   @param integer : le numro de la srie
*   @return integer : le rsultat de la requte
*/
function get_serie_infos_old($serie){
    $sql="select titre,theme,bareme,chrono from serie_exo where id=$serie";
    $res=pg_query($sql);
    return $res;
}
/**
*   Obtenir les infos d'une serie (OLD)
*	@deprecated voir get_serie($serie)
*   @param integer : le numro de la srie
*   @return integer : le rsultat de la requte
*/
function get_serie_infos($serie){
     if(VERSION_BASE>VERSION){
        print(" get_serie_infos A implmenter...");
    }
    else
        $res=get_serie_infos_old($serie);
    return $res ;
}

/**
*   Mettre  jour le chono d'un exo d'une serie (OLD)
*
*   @param integer : le numro de la serie
*   @param integer : la valeur du chrono (en seconde)
*   @param integer : le n d'ordre de l'exo
*   @return integer : 1
*/
function maj_serie_exo_chrono_old($serie,$chrono,$ordre){
    $sql="update asso_exo_serie set chrono='$chrono' where id_serie=$serie and ordre='$ordre'";
    $maj=pg_query($sql);
    return $maj;
}
/**
*   Mettre  jour le chono d'un exo d'une serie
*
*   @param integer : le numro de la serie
*   @param integer : la valeur du chrono (en seconde)
*   @param integer : le n d'ordre de l'exo
*   @return integer : 1
*/
function maj_serie_exo_chrono($serie,$chrono,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_exo_chrono_old($serie,$chrono,$ordre);
    return $res ;
}

/**
*   Obtenir les exos d'une serie (OLD)
*	@deprecated voir get_serie_evaluations
*
*   @param integer : le numero de la serie
*   @return integer : le resultat de la requete
*/
/*function get_serie_exos_old($serie){
    $sql="select * from asso_exo_serie where id_serie=$serie order by ordre";
    $res=pg_query($sql);
    return $res;
}*/

/**
*   Obtenir les exos d'une serie
* 	@deprecated voir get_serie_evaluations
*
*   @param integer : le numero de la serie
*   @return integer : le resultat de la requete
*/
/*function get_serie_exos($serie){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_exos_old($serie);
    return $res ;
}*/

/**
*   Vrifie si une serie a dj des rsultats (OLD)
*
*   @param integer : le numero de la serie
*   @return integer : 1=vrai 0=faux
*/
function check_serie_resultats_old($serie){
    $sql="select distinct id_serie from res_serie where id_serie=$serie
            union all
            select distinct id_serie from res_serie_exo where id_serie=$serie";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return 1;
    return 0;
}
/**
*   Vrifie si une serie a dj des rsultats
*
*   @param integer : le numero de la serie
*   @return integer : 1=vrai 0=faux
*/
function check_serie_resultats($serie){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_serie_resultats_old($serie);
    return $res ;
}

/**
    Mettre  jour le chrono des exos d'une serie (OLD)

    @param integer : le numero de la serie
    @param integer : la valeur du chrono
    @return integer : 1
*/
function maj_serie_exos_chrono_old($serie,$chrono){
    $sql="UPDATE asso_exo_serie SET chrono=$chrono WHERE id_serie=$serie";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre  jour le chrono des exos d'une serie

    @param integer : le numero de la serie
    @param integer : la valeur du chrono
    @return integer : 1
*/
function maj_serie_exos_chrono($serie,$chrono){
    if(VERSION_BASE>VERSION){
        print("[maj_serie_exos_chrono A implmenter...]");
    }
    else
        $res=maj_serie_exos_chrono_old($serie,$chrono);
    return $res ;
}

/**
    Mettre  jour le bareme des exos d'une serie (OLD)

    @param integer : le numero de la serie
    @param integer : le numero de bareme
    @return integer : 1
*/
function maj_serie_exos_bareme_old($serie,$bareme){
    $sql="UPDATE asso_exo_serie SET bareme=$bareme WHERE id_serie=$serie";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre  jour le bareme des exos d'une serie

    @param integer : le numero de la serie
    @param integer : le numero de bareme
    @return integer : 1
*/
function maj_serie_exos_bareme($serie,$bareme){
    if(VERSION_BASE>VERSION){
        print("[maj_serie_exos_baremeA implmenter...]");
    }
    else
        $res=maj_serie_exos_bareme_old($serie,$bareme);
    return $res ;
}

/**
    Vrifie que le titre d'une srie est unique pour un theme (OLD)

	@deprecated : utiliser get_serie($libelle)
    @param string : le titre
    @return integer : 1 si existe,0 sinon
*/
function check_serie_titre_old($libelle){
    $sql="select * from serie_exo where titre='".addslashes($libelle)."' ";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return true;
    return false;
}
/**
    Vrifie que le titre d'une srie est unique pour un theme

	@deprecated : utiliser get_serie($libelle)
    @param integer : le numero du theme
    @param string : le titre
    @return integer : 1 si existe,0 sinon
*/
function check_serie_titre($libelle){
    if(VERSION_BASE>VERSION){
        print("check_serie_titre A implmenter...");
    }
    else
        $res=check_serie_titre_old($libelle);
    return $res ;
}

/**
    Mettre  jour les parametres d'une serie (OLD)

    @param integer : le numero de la serie
    @param string : le titre de la serie
    @param integer : le numero du theme
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : 1
*/
/*function maj_serie_old($serie,$titre,$theme,$bareme,$chrono){

        $sql="UPDATE serie_exo SET titre='$titre', theme=$theme, bareme=$bareme, chrono=$chrono WHERE id=$serie";
        $maj=pg_query($sql);
        return $maj;

}*/

/**
    Mettre  jour les parametres d'une serie

    @param integer : le numero de la serie
    @param string : le titre de la serie
    @param integer : le numero du theme
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : 1
*/
/*function maj_serie($serie,$titre,$theme,$bareme,$chrono){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_old($serie,$titre,$theme,$bareme,$chrono);
    return $res ;
}*/

/**
    Enregistre une serie (OLD)

    @param string : le titre de la serie
    @param integer : le numero du theme
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : 1
*/
/*function set_serie_old($titre,$theme,$bareme,$chrono){
   if(!check_serie_titre($theme,$titre)){
        $sql="INSERT INTO serie_exo (titre,theme,bareme,chrono) VALUES('$titre','$theme','$bareme','$chrono')";
        $ins=pg_query($sql);
        $oid=pg_getlastoid($ins);
        $res=pg_query("SELECT id  FROM serie_exo WHERE OID=$oid;");
        return pg_result($res, 0, 0);
    }
    else
        return 0;
}*/
/**
    Enregistre une serie

    @param string : le titre de la serie
    @param integer : le numero du theme
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : 1
*/
/*function set_serie($titre,$theme,$bareme,$chrono){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=set_serie_old($titre,$theme,$bareme,$chrono);
    return $res ;
}*/

/**
    Obtenir le nombre d'exo d'une serie (OLD)

    @param integer : le numero de serie
    @return integer : le nombre d'exo
*/
function get_serie_nbexo_old($serie){
    $sql="SELECT COUNT(*) FROM asso_exo_serie WHERE id_serie=$serie";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    return $row[0];
}
/**
    Obtenir le nombre d'exo d'une serie

    @param integer : le numero de serie
    @return integer : le nombre d'exo
*/
function get_serie_nbexo($serie){
    if(VERSION_BASE>VERSION){
        print(" get_serie_nbexo A implmenter...");
    }
    else
        $res=get_serie_nbexo_old($serie);
    return $res ;
}

/**
    Supprime une serie (OLD)

    @param integer : le numero de la serie
    @return integer : 1
*/
/*function del_serie_old($serie){
    $sql="delete from asso_exo_serie where id_serie=$serie";
    $del=pg_query($sql);
    $sql="delete from serie_exo where id=$serie";
    $del=pg_query($sql);
    return $del;
}*/
/**
    Supprime une serie (OLD)

    @param integer : le numero de la serie
    @return integer : 1
*/
/*function del_serie($serie){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=del_serie_old($serie);
    return $res ;
}*/



/**
    Teste si une serie est utilise par une serie aleatoire (OLD)

    @param integer : le numero de la serie
    @return integer : 1 si oui, 0 sinon
*/
function check_serie_serie_aleatoire_old($serie){
    $sql="select * from serie_aleatoire where serie=$serie";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return 1;
    return 0;
}
/**
    Teste si une serie est utilise par une serie aleatoire

    @param integer : le numero de la serie
    @return integer : 1 si oui, 0 sinon
*/
function check_serie_serie_aleatoire($serie){
    if(VERSION_BASE>VERSION){
        print("check_serie_serie_aleatoireA implmenter...");
    }
    else
        $res=check_serie_serie_aleatoire_old($serie);
    return $res ;
}

/**
    Mettre  jour l'ordre d'un exo de serie  (OLD)

	@deprecated : utiliser maj_serie_order_exo($serie,$nounel_ordre,$ordre)
    @param integer : le numero de la serie
    @param integer : le nouveau numero d'ordre
    @param integer : l'ordre  modifier
    @return integer : 1
*/
function maj_serie_num_ordre_old($serie,$nouvel_ordre,$ordre){
    $sql="update asso_exo_serie set ordre=$nouvel_ordre where id_serie=$serie AND ordre=$ordre";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre  jour l'ordre d'un exo de serie

	@deprecated : utiliser maj_serie_order_exo($serie,$nounel_ordre,$ordre)
    @param integer : le numero de la serie
    @param integer : le nouveau numero d'ordre
    @param integer : l'ordre  modifier
    @return integer : 1
*/
function maj_serie_num_ordre($serie,$nouvel_ordre,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_num_ordre_old($serie,$nouvel_ordre,$ordre);
    return $res ;
}



/**
    Obtenir les infos des questions de remplir les blancs disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete
*/
function get_serie_exos_blanc_infos_disponibles_old($serie,$theme){
    $sql="SELECT * FROM gest_ftb WHERE theme=$theme AND id NOT IN
                (SELECT id_exo FROM asso_exo_serie WHERE id_serie=$serie AND type_exo='f') ORDER BY text";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les question de remplir les blancs disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete
*/
function get_serie_exos_blanc_infos_disponibles($serie,$theme){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_exos_blanc_infos_disponibles_old($serie,$theme);
    return $res ;
}




/**
    Supprime un exo de la serie en fonction de l'ordre (OLD)

	@deprecated : utiliser del_serie_exo($serie,$ordre)
    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : 1
*/
/*function del_serie_ordre_old($serie,$ordre){
    $sql="DELETE FROM asso_exo_serie WHERE id_serie=$serie AND ordre=$ordre";
    $del=pg_query($sql);
    return $del;
}*/

/**
    Supprime un exo de la serie en fonction de l'ordre

	@deprecated : utiliser del_serie_exo($serie,$ordre)
    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : 1
*/
/*function del_serie_ordre($serie,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=del_serie_ordre_old($serie,$ordre);
    return $res ;
}*/



/**
    Obtenir les infos d'un exo d'une serie (OLD)

    @param integer : le numero de la serie
    @param integer : le numero de l'exo
    @param char : le type de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_exo_infos_old($serie,$exo,$type){
    $sql="SELECT * FROM asso_exo_serie WHERE id_serie=$serie AND id_exo=$exo and type_exo='$type'";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un exo d'une serie

    @param integer : le numero de la serie
    @param integer : le numero de l'exo
    @param char : le type de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_exo_infos($serie,$exo,$type){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_exo_infos_old($serie,$exo,$type);
    return $res ;
}

/**
    Ajouter un exo  une serie (OLD)
	@deprecated voir set_serie_evaluation($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type)
	
    @param integer : le numero de l'exo
    @param integer : le numero de la serie
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
    @return integer : 1
*/
function set_serie_exo_old($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type){
    $sql="insert into asso_exo_serie values('$exo','$serie','$ordre','$commentaire','$bareme','$chrono','$point','$type')";
    $ins=pg_query($sql);
    return $ins;
}
/**
    Ajouter un exo  une serie
	@deprecated voir set_serie_evaluation($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type)
	
	@param integer : le numero de l'exo
    @param integer : le numero de la serie
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
    @return integer : 1
*/
function set_serie_exo($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=set_serie_exo_old($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type);
    return $res ;
}

/**
    Mettre  jour le titre d'une serie (OLD)

    @param integer : le numero de la serie
    @param string : le titre
    @return integer : 1
*/
function maj_serie_titre_old($serie,$titre){
    $sql="update serie_exo set titre='$titre' where id=$serie";
    $maj=pg_query($sql);
    return $maj;
}

/**
    Mettre  jour le titre d'une serie

    @param integer : le numero de la serie
    @param string : le titre
    @return integer : 1
*/
function maj_serie_titre($serie,$titre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_titre_old($serie,$titre);
    return $res ;
}

/**
    Obtenir le numero et le libelle d'une question de qcm d'une serie (OLD)

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @param integer : le resulatat de la requete
*/
function get_serie_qcm_infos_old($serie,$ordre){
    $sql="SELECT DISTINCT qr_num_question, libelle_question FROM question, quest_rep WHERE  num_question=qr_num_question
            AND qr_num_question=(SELECT id_exo FROM asso_exo_serie WHERE ordre=$ordre AND id_serie=$serie)";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir le numero et le libelle d'une question de qcm d'une serie

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @param integer : le resulatat de la requete
*/
function get_serie_qcm_infos($serie,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_qcm_infos_old($serie,$ordre);
    return $res ;
}

/**
    Obtenir le numero et le libelle d'une question de sondage d'une serie (OLD)

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_sondage_infos_old($serie,$ordre){
    $sql="SELECT DISTINCT ps.num_sondage, question FROM question_sondage qs, proposition_sondage ps WHERE qs.num_sondage=ps.num_sondage
            AND ps.num_sondage=(SELECT id_exo FROM asso_exo_serie WHERE ordre=$ordre AND id_serie=$serie)";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir le numero et le libelle d'une question de sondage d'une serie

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_sondage_infos($serie,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_sondage_infos_old($serie,$ordre);
    return $res ;
}

/**
    Obtenir les infos d'un exo blanc d'une serie (OLD)

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_blanc_infos_old($serie,$ordre){
    $sql="SELECT * FROM gest_ftb WHERE  id =(SELECT id_exo FROM asso_exo_serie WHERE ordre=$ordre AND id_serie=$serie)";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un exo blanc d'une serie

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_blanc_infos($serie,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_blanc_infos_old($serie,$ordre);
    return $res ;
}

/**
    Obtenir les infos d'un exo qrc ou src d'une serie (OLD)

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_qrcsrc_infos_old($serie,$ordre){
    $sql="select * from serie_exo where  id =(select id_exo FROM asso_exo_serie WHERE ordre=$ordre AND id_serie=$serie)";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos d'un exo qrc ou src d'une serie 

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : le resultat de la requete
*/
function get_serie_qrcsrc_infos($serie,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_qrcsrc_infos_old($serie,$ordre);
    return $res ;
}

/**
    Obtenir les infos sur les formations qui utilisent la serie donne en parametre (OLD)

    @param integer : le numero de la serie
    @param char : le type de la serie
    @param string : pour croissant ou decroissant
    @return integer : le resultat de la requete
*/
function get_serie_formations_infos_old($serie,$type,$desc){
    $sql="SELECT DISTINCT C.num_cal, C.nom_cal FROM gestparcours G1,gestionparcours G2, calendrier C
                WHERE num_c_q_e_d=$serie  AND type_etape='$type' AND gp_num_parcours=g_num_parcours
                AND C.num_cal=G2.num_cal ORDER BY C.nom_cal $desc";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos sur les formations qui utilisent la serie donne en parametre

    @param integer : le numero de la serie
    @param char : le type de la serie
    @param string : pour croissant ou decroissant
    @return integer : le resultat de la requete
*/
function get_serie_formations_infos($serie,$type,$desc){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_formations_infos_old($serie,$type,$desc);
    return $res ;
}

///**
//    Obtenir les infos sur les groupe qui utilisent la serie donne en paramtre (OLD)
//
//    @param integer : le numero de la serie
//    @param char : le type de la serie
//    @param string : pour croissant ou decroissant
//    @return integer : le resultat de la requete
//*/
//function get_serie_groupes_infos_old($serie,$type,$desc){
//     $sql="SELECT DISTINCT C.id, C.nom FROM gestparcours G1,gestionparcours G2, classe C  WHERE num_c_q_e_d =$serie
//                AND type_etape='$type' AND gp_num_parcours=g_num_parcours AND G2.gp_num_groupe=C.id ORDER BY C.nom $desc";
//     $res=pg_query($sql);
//     return $res;
//}
///**
//    Obtenir les infos sur les groupe qui utilisent la serie donne en paramtre
//
//    @param integer : le numero de la serie
//    @param char : le type de la serie
//    @param string : pour croissant ou decroissant
//    @return integer : le resultat de la requete
//*/
//function get_serie_groupes_infos($serie,$type,$desc){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_serie_groupes_infos_old($serie,$type,$desc);
//    return $res ;
//}

///**
//    Obtenir les infos sur les formations d'un groupe qui utilise la serie donne en paramtre (OLD)
//
//    @param integer : le numero de la serie
//    @param char : le type de la serie
//    @param integer : le numero du groupe
//    @return integer : le resultat de la requete
//*/
//function get_serie_groupe_formations_infos_old($serie,$type,$groupe){
//    $sql="SELECT DISTINCT C.num_cal, C.nom_cal FROM gestparcours G1,gestionparcours G2, calendrier C
//            WHERE num_c_q_e_d=$serie AND type_etape='$type' AND gp_num_groupe=$groupe
//            AND gp_num_parcours=g_num_parcours AND G2.num_cal=C.num_cal ORDER BY C.nom_cal";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//    Obtenir les infos sur les formations d'un groupe qui utilise la serie donne en paramtre
//
//    @param integer : le numero de la serie
//    @param char : le type de la serie
//    @param integer : le numero du groupe
//    @return integer : le resultat de la requete
//*/
//function get_serie_groupe_formations_infos($serie,$type,$groupe){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_serie_groupe_formations_infos_old($serie,$type,$groupe);
//    return $res ;
//}

///**
//    Obtenir les infos sur les filieres des parcours qui utilisent la serie donne en paramtre (OLD)
//
//    @param integer : le numero de la serie
//    @param char : le type de la serie
//    @param string : pour croissant ou decroissant
//    @return integer : le resultat de la requete
//*/
//function get_serie_filieres_infos_old($serie,$type,$desc){
//    $sql="SELECT DISTINCT nom, id, lower(nom) AS ordre FROM gestparcours G1, gestparcours G2, parcours, Filiere
//                  WHERE G1.num_c_q_e_d=$serie AND G1.type_etape='$type' AND G1.g_num_parcours=num_parcours
//                  AND G2.g_num_parcours=num_parcours AND G2.num_etape=1 AND G2.num_c_q_e_d=id
//                  ORDER BY ordre $desc";
//    $res=pg_query($sql);
//    return $res;
//}
///**
//    Obtenir les infos sur les filieres des parcours qui utilisent la serie donne en paramtre
//
//    @param integer : le numero de la serie
//    @param char : le type de la serie
//    @param string : pour croissant ou decroissant
//    @return integer : le resultat de la requete
//*/
//function get_serie_filieres_infos($serie,$type,$desc){
//    if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_serie_filieres_infos_old($serie,$type,$desc);
//    return $res ;
//}

/**
    Obtenir les infos sur les parcours d'une filiere qui utilise la serie donne en paramtre (OLD)

    @param integer : le numero de la serie
    @param char : le type de la serie
    @param integer : le numero de filiere
    @return integer : le resultat de la requete
*/
function get_serie_filiere_parcours_infos_old($serie,$type,$filiere){
     $sql="SELECT DISTINCT nom_parcours FROM gestparcours G1, gestparcours G2, parcours, Filiere
                WHERE G1.num_c_q_e_d=$serie AND G1.type_etape='$type' AND G1.g_num_parcours=num_parcours
                AND G2.g_num_parcours=num_parcours AND G2.num_etape=1 AND G2.num_c_q_e_d=$filiere ORDER BY nom_parcours";
     $res=pg_query($sql);
     return $res;
}
/**
    Obtenir les infos sur les parcours d'une filiere qui utilise la serie donne en paramtre

    @param integer : le numero de la serie
    @param char : le type de la serie
    @param integer : le numero de filiere
    @return integer : le resultat de la requete
*/
function get_serie_filiere_parcours_infos($serie,$type,$filiere){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_filiere_parcours_infos_old($serie,$type,$filiere);
    return $res ;
}

/**
    Obtenir les infos sur les parcours qui utilisent la serie donne en paramtre (OLD)

    @param integer : le numero de la serie
    @param char : le type de la serie
    @param string : pour croissant ou decroissant
    @return integer : le resultat de la requete
*/
function get_serie_parcours_infos_old($serie,$type,$desc){
    $sql="SELECT DISTINCT num_parcours, nom_parcours, lower(nom_parcours) AS ordre FROM gestparcours, parcours
                WHERE num_c_q_e_d=$serie AND type_etape='$type' AND g_num_parcours=num_parcours ORDER BY ordre $desc";
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos sur les parcours qui utilisent la serie donne en paramtre

    @param integer : le numero de la serie
    @param char : le type de la serie
    @param string : pour croissant ou decroissant
    @return integer : le resultat de la requete
*/
function get_serie_parcours_infos($serie,$type,$desc){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_parcours_infos_old($serie,$type,$desc);
    return $res ;
}

///**
//	Obtenir la somme des chronos des exo d'une serie (OLD)
//*	 @param integer : le numero de la serie
//	@return integer : le resultat de la requete
//*/
//function get_serie_somme_chronos_old($serie){
//	$sql="select sum(chrono) from asso_exo_serie where id_serie=$serie";
// 	return (pg_query($sql));
//}
///**
//	Obtenir la somme des chronos des exo d'une serie
//*	 @param integer : le numero de la serie
//	@return integer : le resultat de la requete
//*/
//function get_serie_somme_chronos($serie){
//	 if(VERSION_BASE>VERSION){
//        print("A implmenter...");
//    }
//    else
//        $res=get_serie_somme_chronos_old($serie);
//    return $res ;
//}

/**
	Obtenir le resultat d'une serie pour un individu et une formation denns (OLD)
 *
 *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
 *	@return integer : le resultat de la requete
*/
function get_serie_resultat_old($formation,$user,$serie){
	$sql="select * from res_serie where id_serie=$serie and id_stag=$user and id_formation=$formation";
 	return (pg_query($sql));
}
/**
	Obtenir le resultat d'une serie pour un individu et une formation denns
 *
 *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
 *	@return integer : le resultat de la requete
*/
function get_serie_resultat($formation,$user,$serie){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_resultat_old($formation,$user,$serie);
    return $res ;
}

/**
	Obtenir les exos d'une serie dont le score est gal  zro pour un user et une formation donns (OLD)
 *
  *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
 *	@return integer : le resultat de la requete
*/
function get_serie_exos_echec_old($formation,$user,$serie,$type){
	$sql="select id_exo from asso_exo_serie_aleatoire where id_serie=$serie and num_user=$user and num_cal=$formation and type_exo='$type' and ordre in
			(select ordre_etape from res_serie_exo where id_stag=$user and id_formation=$formation and id_serie=$serie and type_exo='$type' and score=0)";
 	return (pg_query($sql));
}
/**
	Obtenir les exos d'une serie dont le score est gal  zro pour un user et une formation donns
 *
  *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
 *	@return integer : le resultat de la requete
*/
function get_serie_exos_echec($formation,$user,$serie,$type){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_exos_echec_old($formation,$user,$serie,$type);
    return $res ;
}

/**
	Obtenir les exo et ordre pour une serie,un user et une formation donns (OLD)
*
 *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
  *	@param char(1) : le type d'exercice
 *	@return integer : le resultat de la requete
*/
function get_serie_exos_aleatoires_old($formation,$user,$serie,$type=""){
	$sql="select id_exo,ordre from asso_exo_serie_aleatoire where id_serie=$serie and num_user=$user and num_cal=$formation";
 	if(!empty($type))
		$sql .=" and type_exo='$type'";
 	return (pg_query($sql));
}
/**
	Obtenir les exo et ordre pour une serie,un user et une formation donns
*
 *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
  *	@param char(1) : le type d'exercice
 *	@return integer : le resultat de la requete
*/
function get_serie_exos_aleatoires($formation,$user,$serie,$type=""){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_exos_aleatoires_old($formation,$user,$serie,$type);
    return $res ;
}

/**
	Obtenir le score d'un exo de serie pour un individu et une formation donns (OLD)

 *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
*	@param integer : le numero d'etape
 *	@return integer : le resultat de la requete
*/
function get_serie_score_exo_old($formation,$user,$serie,$etape){
	$sql="select score from res_serie_exo where id_serie=$serie and id_formation=$formation and id_stag=$user and ordre_etape=$etape";
 	return (pg_query($sql));
}
/**
	Obtenir le score d'un exo de serie pour un individu et une formation donns

 *	@param integer : le numero de formation
 *	@param integer : le numero d'individu
 *	@param integer : le numero de la serie
*	@param integer : le numero d'etape
 *	@return integer : le resultat de la requete
*/
function get_serie_score_exo($formation,$user,$serie,$etape){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_score_exo_old($formation,$user,$serie,$etape);
    return $res ;
}

/**
	Obtenir le nombre de resultats d'une evaluation pour une serie donne (OLD)

 	@param integer : le numero de la serie
 	@param : integer : le numero d'evaluation
 	@param string : le type d'evaluation
	@return integer : le resultat de la requete
*/
function get_serie_evaluation_nombre_resultats_old($serie,$evaluation,$type){
	$sql="select * from res_serie_exo R,asso_exo_serie A
			where A.id_serie=R.id_serie and A.id_serie=$serie
			and A.type_exo='$type' and ordre=ordre_etape and
			id_exo=$evaluation";
   return (pg_query($sql));
}
/**
	Obtenir le nombre de resultats d'une evaluation pour une serie donne

 	@param integer : le numero de la serie
 	@param : integer : le numero d'evaluation
 	@param string : le type d'evaluation
	@return integer : le resultat de la requete
*/
function get_serie_evaluation_nombre_resultats($serie,$evaluation,$type){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_evaluation_nombre_resultats_old($serie,$evaluation,$type);
    return $res ;
}

/**
	Obtenir le nombre de resultats d'un element d' evaluation pour une serie donne (OLD)

 	@param integer : le numero de la serie
 	@param : integer : le numero d'evaluation
 	@param : integer : le numero d'element
 	@param string : le type d'evaluation
	@return integer : le resultat de la requete
*/
function get_serie_element_evaluation_nombre_resultats_old($serie,$evaluation,$element,$type){
	$sql="select * from res_serie_exo R,asso_exo_serie A
			where A.id_serie=R.id_serie and A.id_serie=$serie and R.reponse=$element
			and A.type_exo='$type' and ordre=ordre_etape and
			id_exo=$evaluation";
   return (pg_query($sql));
}
/**
	Obtenir le nombre de resultats d'un element d'evaluation pour une serie donne

 	@param integer : le numero de la serie
 	@param : integer : le numero d'evaluation
 	@param : integer : le numero d'element
 	@param string : le type d'evaluation
	@return integer : le resultat de la requete
*/
function get_serie_element_evaluation_nombre_resultats($serie,$evaluation,$element,$type){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_element_evaluation_nombre_resultats_old($serie,$evaluation,$element,$type);
    return $res ;
}

/**
	Obtenir les infos d'une serie (OLD)
	
 	@param integer : le numero de la serie
 	@return integer :  le resultat de la requete
*/
/*function get_serie_old($serie){
	$sql="select * from serie_exo where id=$serie";
 	return (pg_query($sql));
}*/
/**
	Obtenir les infos d'une serie

 	@param integer : le numero de la serie
 	@return integer :  le resultat de la requete
*/
/*function get_serie($serie){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_old($serie);
    return $res ;
}*/

/**
    Vrifie que le titre d'une srie est unique pour un theme (OLD)

	@param string : le titre
    @return integer : 1 si existe,0 sinon
*/
function check_serie_old($libelle){
    $sql="select * from serie_exo where titre='$libelle'";
    $res=pg_query($sql);
    if(pg_numrows($res)>0)
        return 1;
    return 0;
}
/**
    Vrifie que le titre d'une srie est unique pour un theme

	@param integer : le numero du theme
    @param string : le titre
    @return integer : 1 si existe,0 sinon
*/
function check_serie($libelle){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=check_serie_old($libelle);
    return $res ;
}

/**
	Obtenir le numero d'ordre max pour une serie (OLD)
	
	@param integer : le numero de la serie
	@return integer : le resultat de la requete
*/
function get_serie_ordre_max_old($serie){
	$sql="SELECT MAX(ordre) FROM asso_exo_serie WHERE id_serie=$serie";
	return pg_query($sql);
}
/**
	Obtenir le numero d'ordre max pour une serie
	
	@param integer : le numero de la serie
	@return integer : le resultat de la requete
*/
function get_serie_ordre_max($serie){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_ordre_max_old($serie);
    return $res ;
}

 /**
	Obtenir le numero d'ordre max pour une serie aleatoire(OLD)
	
	@param integer : le numero de la serie
	@param integer : le numero de formation
	@param integer : le numero d'individu
	@return integer : le resultat de la requete
*/
function get_serie_ordre_max_aleatoire_old($serie,$formation,$individu){
	$sql="SELECT MAX(ordre) FROM asso_exo_serie_aleatoire WHERE id_serie=$serie and num_user=$individu and num_cal=$formation";
	return pg_query($sql);
}
/**
	Obtenir le numero d'ordre max pour une serie
	
	@param integer : le numero de la serie
	@param integer : le numero de formation
	@param integer : le numero d'individu
	@return integer : le resultat de la requete
*/
function get_serie_ordre_max_aleatoire($serie,$formation,$individu){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=get_serie_ordre_max_aleatoire_old($serie,$formation,$individu);
    return $res ;
}

/**
    Ajouter un exo  une serie aleatoire(OLD)

    @param integer : le numero de l'exo
    @param integer : le numero de la serie
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
	@param integer : le numero d'individu
	@param integer : le numero de formation
    @return integer : 1
*/
function set_serie_exo_aleatoire_old($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type,$individu,$formation){
    $sql="insert into asso_exo_serie_aleatoire values($exo,$serie,$ordre,'$commentaire',$bareme,$chrono,$point,'$type',$individu,$formation)";
    $ins=pg_query($sql);
    return $ins;
}
/**
    Ajouter un exo  une serie

    @param integer : le numero de l'exo
    @param integer : le numero de la serie
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
	@param integer : le numero d'individu
	@param integer : le numero de formation
    @return integer : 1
*/
function set_serie_exo_aleatoire($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type,$individu,$formation){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=set_serie_exo_old($exo,$serie,$ordre,$commentaire,$bareme,$chrono,$point,$type,$individu,$formation);
    return $res ;
}

/**
	Mettre  jour l'exo d'une serie (OLD)
	@deprecated voir maj_serie_evaluation($serie,$exo,$ordre,$commentaire,$bareme,$chrono,$point,$type)
	
	@param integer : le numero de l'exo
    @param integer : le numero de la serie
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
	
	@return integer : le resultat de la requete
*/
/*function maj_serie_exo_old($serie,$exo,$ordre,$commentaire,$bareme,$chrono,$point,$type){
	$sql="UPDATE asso_exo_serie SET id_exo=$exo, type_exo='$type', point=$point,
				bareme=$bareme, chrono=$chrono, commentaire=$commentaire 
				WHERE id_serie=$serie AND ordre=$ordre";
	return pg_query($sql);
}*/

/**
	Mettre  jour l'exo d'une serie (OLD)
	@deprecated voir maj_serie_evaluation($serie,$exo,$ordre,$commentaire,$bareme,$chrono,$point,$type)
	
	@param integer : le numero de l'exo
    @param integer : le numero de la serie
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
	
	@return integer : le resultat de la requete
*/
/*function maj_serie_exo($serie,$exo,$ordre,$commentaire,$bareme,$chrono,$point,$type){
	if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_exo_old($serie,$exo,$ordre,$commentaire,$bareme,$chrono,$point,$type);
    return $res ;
}*/

/**
    Supprime un exo de la serie en fonction de l'ordre (OLD)
	@deprecated voir del_serie_evaluation_ordre($serie,$pere)
	
	@param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : 1
*/
/*function del_serie_exo_old($serie,$ordre){
    $sql="DELETE FROM asso_exo_serie WHERE id_serie=$serie AND ordre=$ordre";
    $del=pg_query($sql);
    return $del;
}*/

/**
    Supprime un exo de la serie en fonction de l'ordre
	@deprecated voir del_serie_evaluation_ordre($serie,$pere)
	
	@param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @return integer : 1
*/
/*function del_serie_exo($serie,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=del_serie_exo_old($serie,$ordre);
    return $res ;
}*/

/**
    Mettre  jour l'ordre d'un exo de serie  (OLD)

	@param integer : le numero de la serie
    @param integer : le nouveau numero d'ordre
    @param integer : l'ordre  modifier
    @return integer : 1
*/
function maj_serie_ordre_exo_old($serie,$nouvel_ordre,$ordre){
    $sql="update asso_exo_serie set ordre=$nouvel_ordre where id_serie=$serie AND ordre=$ordre";
    $maj=pg_query($sql);
    return $maj;
}
/**
    Mettre  jour l'ordre d'un exo de serie

	@param integer : le numero de la serie
    @param integer : le nouveau numero d'ordre
    @param integer : l'ordre  modifier
    @return integer : 1
*/
function maj_serie_ordre_exo($serie,$nouvel_ordre,$ordre){
    if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_ordre_exo_old($serie,$nouvel_ordre,$ordre);
    return $res ;
}

/**
	Dcrmente l'ordre des exos d'une serie  (OLD)
	
	@param integer : le numero de la serie
	@param integer : l'ordre de reference
	@return integer : le resultat de la requete
*/
function maj_serie_ordre_exos_decrementation_old($serie,$ordre){
	$sql="UPDATE asso_exo_serie SET ordre=ordre-1 WHERE id_serie=$serie AND ordre>$ordre";
	return pg_query($sql);
}
/**
	Dcrmente l'ordre des exos d'une serie  
	
	@param integer : le numero de la serie
	@param integer : l'ordre de reference
	@return integer : le resultat de la requete
*/
function maj_serie_ordre_exos_decrementation($serie,$ordre){
	 if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_ordre_exos_decrementation_old($serie,$ordre);
    return $res ;
}

/**
	Incrmente l'ordre des exos d'une serie  (OLD)
	
	@param integer : le numero de la serie
	@param integer : l'ordre de reference
	@return integer : le resultat de la requete
*/
function maj_serie_ordre_exos_incrementation_old($serie,$ordre){
	$sql="UPDATE asso_exo_serie SET ordre=ordre +1 WHERE id_serie=$serie AND ordre>=$ordre";
	return pg_query($sql);
}
/**
	Incrmente l'ordre des exos d'une serie  
	
	@param integer : le numero de la serie
	@param integer : l'ordre de reference
	@return integer : le resultat de la requete
*/
function maj_serie_ordre_exos_incrementation($serie,$ordre){
	 if(VERSION_BASE>VERSION){
        print("A implmenter...");
    }
    else
        $res=maj_serie_ordre_exos_incrementation_old($serie,$ordre);
    return $res ;
}

/**
    Supprime une evaluation d'une serie en fonction de l'ordre (OLD)

	@param integer : le numero de la serie
    @param integer : le numero d'odre de l'evaluation
    @return integer : le resultat de la suppression
*/
function del_serie_evaluation_ordre_old($serie,$ordre){
    $sql="DELETE FROM asso_exo_serie WHERE id_serie=$serie AND ordre=$ordre";
    $del=pg_query($sql);
    return $del;
}

/**
    Supprime une evaluation d'une serie en fonction de l'evaluation pre

	@param integer : le numero de la serie
    @param integer : le numero du pere de l'evaluation
    @return integer : le resultat de la suppression
*/
function del_serie_evaluation_ordre($serie,$pere){
    if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_del_serie_evaluation_ordre($serie,$pere)";
		//echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=del_serie_evaluation_ordre_old($serie,$pere);
    return $res ;
}
?>
