<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
      @package serie
      @modulegroup plpgsql
      @module plpgsql_serie
*/

/**
 * Fichier de fonctions dprcies
 */
//include ("$chemin_bo/lib/serie/plpgsql_deprecated_serie.inc");

/**
	Obtenir les infos d'une serie (OLD)

 	@param integer : le numero de la serie
 	@return integer :  le resultat de la requete :(id int4, libelle varchar, bareme int4, chrono int4)
*/
function get_serie_old($serie) {
	$sql = "select id, titre,  bareme, chrono from serie_exo where id=$serie";
	//echo "$sql<br>";
	return (pg_query($sql));
}
/**
	Obtenir les infos d'une serie

 	@param integer : le numero de la serie
 	@return integer :  le resultat de la requete :(id int4, libelle varchar, bareme int4, chrono int4, date_creation timestamp)
*/
function get_serie($serie) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_serie($serie) AS (id int4, libelle varchar, bareme int4, chrono int4, date_creation timestamp)";
//		echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_serie_old($serie);
	return $res;
}

/**
    Enregistre une serie (OLD)

    @param string : le titre de la serie
    @param integer : le numero du theme
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : le resultat de l'insertion
*/
function set_serie_old($titre, $theme, $bareme, $chrono) {
	//if (!check_serie_titre($theme, $titre)) {
		if ($bareme == 'NULL')
			$bareme = -1;
		$sql = "INSERT INTO serie_exo (titre,theme,bareme,chrono) VALUES('$titre',$theme,$bareme,$chrono)";
		$ins = pg_query($sql);
		$oid = pg_getlastoid($ins);
		$res = pg_query("SELECT id  FROM serie_exo WHERE OID=$oid;");
		return pg_fetch_result($res, 0, 0);
	//} else
	//	return null;
}

/**
    Enregistre une serie

    @param string : le titre de la serie
    @param integer : le numero du theme
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : le resultat de l'insertion
*/
function set_serie($titre, $theme, $bareme, $chrono) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_set_serie('$titre',$bareme,$chrono)";
		//echo "req=$sql<br>";
		$res = pg_query($sql);
		// enregistre dans theme_categories
		set_categorie_element_theme(19, $theme, pg_fetch_result($res, 0, 0));

		return pg_fetch_result($res, 0, 0);
	} else
		return set_serie_old($titre, $theme, $bareme, $chrono);
}

/**
    Mettre  jour les parametres d'une serie (OLD)

    @param integer : le numero de la serie
    @param string : le titre de la serie
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : le resultat de la mise  jour
*/
function maj_serie_old($serie, $titre, $bareme, $chrono) {
	if($bareme=="NULL")$bareme=0; //la contrainte NOT NULL oblige a mettre 0
	$sql = "UPDATE serie_exo SET titre='$titre', bareme=$bareme, chrono=$chrono WHERE id=$serie";
	//echo "$sql<br>";
	$maj = pg_query($sql);
	return $maj;

}
/**
    Mettre  jour les parametres d'une serie

    @param integer : le numero de la serie
    @param string : le titre de la serie
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @return integer : le resultat de la mise  jour
*/
function maj_serie($serie, $titre, $bareme, $chrono) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_serie($serie,'$titre',$bareme,$chrono)";
//		echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = maj_serie_old($serie, $titre, $bareme, $chrono);
	return sql2Bool(pg_fetch_result($res,0,0));
}

/**
    Mettre  jour les parametres d'un exo de serie en fonction de l'ordre (OLD)

    @param integer : le numero de la serie
    @param integer : le numero d'ordre de l'exo
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @return integer : le resultat de la mise  jour
*/
function maj_serie_evaluation_ordre_old($serie, $ordre, $commentaire, $bareme, $chrono, $point) {
	$sql = "UPDATE asso_exo_serie SET commentaire='$commentaire', bareme=$bareme, chrono=$chrono, point=$point  WHERE id_serie=$serie AND ordre=$ordre";
	//echo $sql;
	$maj = pg_query($sql);
	return $maj;
}

/**
    Mettre  jour les parametres d'un exo de serie en fonction de l'ordre

    @param integer : le numero de la serie
    @param integer : le numero du pere de l'exo
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @return integer : le resultat de la mise  jour
*/
function maj_serie_evaluation_ordre($serie, $ordre, $commentaire, $bareme, $chrono, $point) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_serie_evaluation_ordre($serie,$ordre,'$commentaire',$bareme,$chrono,$point)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = maj_serie_evaluation_ordre_old($serie, $ordre, $commentaire, $bareme, $chrono, $point);
	return $res;
}

/**
    Supprime une serie (OLD)

    @param integer : le numero de la serie
    @return integer : le resultat de la suppression
*/
function del_serie_old($serie) {
	$sql = "delete from asso_exo_serie where id_serie=$serie";
	$del = pg_query($sql);
	$sql = "delete from serie_exo where id=$serie";
	$del = pg_query($sql);
	return $del;
}

/**
    Supprime une serie 

    @param integer : le numero de la serie
    @return integer :  le resultat de la suppression
*/
function del_serie($serie) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_etape($serie)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = del_serie_old($serie);
	return $res;
}

/**
    Supprime une serie (OLD)

    @param integer : le numero de la serie
    @return integer : le resultat de la suppression
*/
function del_serie_evaluation_old($serie, $evaluation) {
	$sql = "select ordre from asso_exo_serie where id_serie=$serie and id_exo=$evaluation";
	$sel = pg_query($sql);
	$ordre=pg_fetch_result($sel,0,0);
	$sql = "delete from asso_exo_serie where id_serie=$serie and id_exo=$evaluation";
	$del = pg_query($sql);
	$sql = "update asso_exo_serie set ordre=ordre-1 where id_serie=$serie and ordre>$ordre";
	$upd = pg_query($sql);
	return $del;
}

/**
    Supprime une serie 

    @param integer : le numero de la serie
    @return integer :  le resultat de la suppression
*/
function del_serie_evaluation($serie, $evaluation) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_del_serie_evaluation($serie, $evaluation)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = del_serie_evaluation_old($serie, $evaluation);
	return $res;
}

/**
    Ajouter une evaluation  une serie (OLD)

    @param integer : le numero de l'evaluation
    @param integer : le numero de la serie
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'evaluation
    @return integer : le resultat de l'insertion
*/
function set_serie_evaluation_old($evaluation, $serie, $ordre, $commentaire, $bareme, $chrono, $point, $type) {
	$sql = "insert  into asso_exo_serie (id_exo, id_serie, ordre, commentaire, bareme, chrono, point, type_exo) values($evaluation,$serie,$ordre,'$commentaire',$bareme,$chrono,$point,'$type')";
	//echo $sql . "<br>";
	$ins = pg_query($sql);
	return $evaluation;
}
/**
   Ajouter une evaluation  une serie 

    @param integer : le numero de l'evaluation
    @param integer : le numero de la serie
    @param integer : l'evaluation pere
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'evaluation 
    @return integer : le numero de l'evaluation insre
*/
function set_serie_evaluation($evaluation, $serie, $ordre, $commentaire, $bareme, $chrono, $point, $type) {
	if (VERSION_BASE > VERSION) {
		/*
		if ($type == 1 || $type == 2) {
			$evaluations = get_question_reponse_element_evaluations($evaluation);
			if (pg_num_rows($evaluations) > 1) {
				print ("Erreur: la question est associe  plusieurs question_reponses, ce qui n'est pas permis pour la version actuelle de la plate-forme");
			}
			$evaluation = pg_fetch_result($evaluations, 0, 0);
		}
		*/
		$sql = "SELECT * FROM contraintes.af_set_serie_evaluation($evaluation,$serie,$ordre,'$commentaire',$bareme,$chrono,$point)";
		//echo "$sql<br>";
		$res = pg_query($sql);
		return pg_fetch_result($res, 0, 0);
	} else
		return set_serie_evaluation_old($evaluation, $serie, $ordre, $commentaire, $bareme, $chrono, $point, $type);
}

/**
*   Obtenir les evaluations d'une serie (OLD)
*
*   @param integer : le numero de la serie
*   @return integer : le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 ) 
*/
function get_serie_evaluations_old($serie) {
	//$sql = "select id_exo, id_serie, ordre, commentaire, bareme, chrono, point, type_exo from asso_exo_serie where id_serie=$serie order by ordre";
	$sql="SELECT * FROM _af_get_serie_evaluations($serie)AS (id int2, libelle varchar, serie int2, pere int2, commentaire varchar, bareme int2, chrono int2, points int2, type char(1) )";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
*   Obtenir les evaluations d'une serie. 
*
*   @param integer $serie le numero de la serie
*   @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
*/
function get_serie_evaluations($serie) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_serie_evaluations($serie) AS (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_serie_evaluations_old($serie);
	return $res;
}

/**
*   Obtenir les infos d'une evaluation (d'un type) d'une serie (OLD)
*
*   @param integer : le numero de la serie
*  	@param integer : le numero de l'evaluation
* 	@param integer : le numero du type
*   @return integer : le resultat de la requete :(evaluation int4, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
*/
function get_serie_evaluation_old($serie, $evaluation, $type) {
	$sql = "SELECT id_exo, id_serie, ordre, commentaire, bareme, chrono, point, type_exo FROM asso_exo_serie WHERE id_serie=$serie AND id_exo=$evaluation and type_exo='$type'";
	//echo "$sql<br>";
	$res = pg_query($sql);
	return $res;
}

/**
*   Obtenir les infos d'une evaluation (d'un type) d'une serie
*
*   @param integer : le numero de la serie
*  	@param integer : le numero de l'evaluation
* 	@param integer : le numero du type 
*   @return integer : le resultat de la requete : (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
*/
function get_serie_evaluation($serie, $evaluation, $type=0) {
	if (VERSION_BASE > VERSION) {
//		if ($type == 1 || $type == 2) {
//			$evaluations = get_question_reponse_element_evaluations($evaluation);
//			if (pg_num_rows($evaluations) > 1) {
//				print ("Erreur: la question est associe  plusieurs question_reponses, ce qui n'est pas permis pour la version actuelle de la plate-forme");
//			}
//			$evaluation = pg_fetch_result($evaluations, 0, 0);
//		}
		$sql = "SELECT * FROM contraintes.af_get_serie_evaluation($serie, $evaluation) AS (evaluation int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )";
//		$sql = "SELECT * FROM contraintes.af_get_serie_evaluations($serie) AS (id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
//				WHERE id =$evaluation";
//		echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_serie_evaluation_old($serie, $evaluation, $type);
	return $res;
}

/**
	Mettre  jour l'evaluation d'une serie (OLD)
	
	@param integer : le numero de la serie
	@param integer : le numero de l'exo
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
	
	@return integer : le resultat de la requete
*/
function maj_serie_evaluation_old($serie, $evaluation, $ordre, $commentaire, $bareme, $chrono, $point, $type) {
	$sql = "UPDATE asso_exo_serie SET id_exo=$evaluation, type_exo='$type', point=$point,
						bareme=$bareme, chrono=$chrono, commentaire='$commentaire' 
						WHERE id_serie=$serie AND ordre=$ordre";
	//echo "$sql<br>";				
	return pg_query($sql);
}

/**
	Mettre  jour l'evaluation d'une serie 
	
	@param integer : le numero de la serie
	@param integer : le numero de l'exo
    @param integer : le numero d'ordre
    @param string : le commentaire
    @param integer : le numero de bareme
    @param integer : la valeur du chrono
    @param integer : la valeur pour point
    @param char : le type de l'exo
	
	@return integer : le resultat de la requete
*/
function maj_serie_evaluation($serie, $evaluation, $pere, $commentaire, $bareme, $chrono, $point, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_maj_serie_evaluation($serie,$evaluation,$pere,'$commentaire',$bareme,$chrono,$point)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = maj_serie_evaluation_old($serie, $evaluation, $pere, $commentaire, $bareme, $chrono, $point, $type);
	return $res;
}

/**
	Obtenir la somme des points des exo d'une serie (OLD)
*	 @param integer : le numero de la serie
	@return integer : le resultat de la requete
*/
function get_serie_somme_points_old($serie) {
	$sql = "select sum(point) from asso_exo_serie where id_serie=$serie";
	return (pg_query($sql));
}
/**
	Obtenir la somme des points des exo d'une serie
*	 @param integer : le numero de la serie
	@return integer : le resultat de la requete
*/
function get_serie_somme_points($serie) {
	if (VERSION_BASE > VERSION) {
		$sql = "SELECT * FROM contraintes.af_get_serie_somme_points($serie)";
		//echo "$sql<br>";
		$res = pg_query($sql);
	} else
		$res = get_serie_somme_points_old($serie);
	return $res;
}

/**
 *  Obtenir les evaluations d'un theme (tout types confondus) qui sont disponibles pour une serie (OLD)
 * (cad qui ne sont pas deja dans la serie)
 * @param integer : le numero de la serie
 * @param integer : le numero du theme des evaluations
 * @return integer :le resultat de la requete :(id int4, libelle varchar,  type int4)
 */
function get_serie_evaluations_disponibles_theme_old($serie, $theme) {
	$sql = "	SELECT DISTINCT id, lower(libelle) as min_libelle, type
						FROM (
						select distinct num_question as id, libelle_question as libelle, 'q' as type from quest_rep,question where theme=$theme and qr_num_question=num_question 
						UNION
						select id,text as min_libelle, 'f'  as type from gest_ftb where theme=$theme
						UNION
						SELECT DISTINCT qs.num_sondage  as id, question AS libelle, 's'  as type FROM proposition_sondage ps, question_sondage qs
		                WHERE theme=$theme AND ps.num_sondage=qs.num_sondage
						UNION		
						select id,titre as libelle , 'm'  as type from serie_exo where id in (select id_test from test where type_test='m') and theme=$theme 
						UNION
						select id,titre as libelle ,'o'  as type from serie_exo where id in (select id_test from test where type_test='o') and theme=$theme 
						) AS all_eval
						GROUP BY type, id, min_libelle
						HAVING id not in (select id_exo from asso_exo_serie where id_serie=$serie and type_exo=type)
						order by type, min_libelle";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
 *  Obtenir les evaluations d'un theme (tout types confondus) qui sont disponibles pour une serie
 * (cad qui ne sont pas deja dans la serie)
 * @param integer : le numero de la serie
 * @param integer : le numero du theme des evaluations
 * @return integer :le resultat de la requete :(id int4, libelle varchar,  type int4)
 */
function get_serie_evaluations_disponibles_theme($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_serie_evaluations_disponibles_theme($serie,$theme) AS (id int4, libelle text,  type int4) ";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	} else
		return get_serie_evaluations_disponibles_theme_old($serie, $theme);
}

/**
 *  Obtenir les evaluations d'un theme et d'un type qui sont disponibles pour une serie
 * (cad qui ne sont pas deja dans la serie)
 * @param integer : le numero de la serie
 * @param integer : le numero du theme des evaluations
 * @param integer : le type d'evaluations dsir
 * @return integer :le resultat de la requete :(id int4, libelle varchar,  type int4)
 */
function get_serie_questions_evaluations_disponibles_theme_type($serie, $theme, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_serie_questions_evaluations_disponibles_theme_type($serie,$theme, $type) AS (id int4, libelle varchar,  type int4, min_lib text) ";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	} else
		print ("La fonction get_serie_questions_evaluations_disponibles_theme_type($serie,$theme,$type)  n'existe pas pour la version " .
		VERSION);
}

/**
 *  Obtenir les evaluations d'un theme et d'un type qui sont disponibles pour une serie
 * (cad qui ne sont pas deja dans la serie)
 * @param integer : le numero de la serie
 * @param integer : le numero du theme des evaluations
 * @param integer : le type d'evaluations dsir
 * @return integer :le resultat de la requete :(id int4, libelle varchar,  type int4)
 */
function get_serie_evaluations_disponibles_theme_type($serie, $theme, $type) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_serie_evaluations_disponibles_theme_type($serie,$theme, $type) AS (id int4, libelle text,  type int4) ";
		
		//echo "<br>sql=$sql<br>";
		return pg_query($sql);
	} else
		print ("La fonction get_serie_evaluations_disponibles_theme_type($serie,$theme,$type)  n'existe pas pour la version " .
		VERSION);
}

/**
 *  Obtenir les evaluations d'un theme et d'une categorie qui sont disponibles pour une serie
 * (cad qui ne sont pas deja dans la serie)
 * @param integer : le numero de la serie
 * @param integer : le numero du theme des evaluations
 * @param integer : la categorie d'evaluations dsire
 * @return integer :le resultat de la requete :(id int4, libelle varchar,  type int4)
 */
function get_serie_evaluations_disponibles_theme_categorie($serie, $theme, $categorie) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_serie_evaluations_disponibles_theme_categorie($serie,$theme, $categorie) AS (id int4, libelle text,  type int4) ";
		//echo "sql=$sql<br>";
		return pg_query($sql);
	} else
		print ("La fonction get_serie_evaluations_disponibles_theme($serie,$theme,$categorie)  n'existe pas pour la version " .
		VERSION);
}

/**
    Obtenir les question de qcm disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_qcm_disponibles_old($serie, $theme) {
	$sql = "select distinct num_question,lower(libelle_question) as min_libelle, 'q' from quest_rep,question where theme=$theme and qr_num_question=num_question and
		            num_question not in (select id_exo from asso_exo_serie where id_serie=$serie and type_exo='q') order by min_libelle";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les question de qcm disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_qcm_disponibles($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		return get_serie_evaluations_disponibles_theme_type($serie, $theme, 1);
	} else
		$res = get_serie_exos_qcm_disponibles_old($serie, $theme);
	return $res;
}

/**
    Obtenir les qcms disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_question_qcm_disponibles_old($serie, $theme) {
	$sql = "select distinct num_question,lower(libelle_question) as min_libelle, 'q' from quest_rep,question where theme=$theme and qr_num_question=num_question and
		            num_question not in (select id_exo from asso_exo_serie where id_serie=$serie and type_exo='q') order by min_libelle";
	//echo $sql;
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les qcms disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_question_qcm_disponibles($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		return get_serie_questions_evaluations_disponibles_theme_type($serie, $theme, 1);
		
	} else
		$res = get_serie_exos_question_qcm_disponibles_old($serie, $theme);
	return $res;
}

/**
    Obtenir les remplir les blancs disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_ftb_disponibles_old($serie, $theme) {
	$sql = "select id,lower(text) as min_text, 'f' from gest_ftb where theme=$theme and id not in
		            (select id_exo from asso_exo_serie where id_serie=$serie and type_exo='f') order by min_text";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les remplir les blancs disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_ftb_disponibles($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		return get_serie_evaluations_disponibles_theme_type($serie, $theme, 3);
	} else
		$res = get_serie_exos_ftb_disponibles_old($serie, $theme);
	return $res;
}

/**
    Obtenir les sondages disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_sondage_disponibles_old($serie, $theme) {
	$sql = "SELECT DISTINCT qs.num_sondage, LOWER(question) AS min_question, 's' FROM proposition_sondage ps, question_sondage qs
		                WHERE theme=$theme AND ps.num_sondage=qs.num_sondage AND ps.num_sondage NOT IN
		                (SELECT id_exo FROM asso_exo_serie WHERE id_serie=$serie AND type_exo='s') ORDER BY min_question";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les sondages disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_sondage_disponibles($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		return get_serie_evaluations_disponibles_theme_type($serie, $theme, 2);
		
	} else
		$res = get_serie_exos_sondage_disponibles_old($serie, $theme);
	return $res;
}

/**
    Obtenir les question de sondage disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_question_sondage_disponibles_old($serie, $theme) {
	$sql = "SELECT DISTINCT qs.num_sondage, LOWER(question) AS min_question, 's' FROM proposition_sondage ps, question_sondage qs
		                WHERE theme=$theme AND ps.num_sondage=qs.num_sondage AND ps.num_sondage NOT IN
		                (SELECT id_exo FROM asso_exo_serie WHERE id_serie=$serie AND type_exo='s') ORDER BY min_question";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les question de sondage disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_question_sondage_disponibles($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		return get_serie_questions_evaluations_disponibles_theme_type($serie, $theme, 2);
	} else
		$res = get_serie_exos_question_sondage_disponibles_old($serie, $theme);
	return $res;
}
/**
    Obtenir les exo qrc disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_qrc_disponibles_old($serie, $theme) {
	$sql = "select id,lower(titre) as min_titre , 'm' from serie_exo where id in (select id_test from test where type_test='m') and theme=$theme and id not in
		            (select id_exo from asso_exo_serie where id_serie=$serie and type_exo='m') order by min_titre";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les exo qrc disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_qrc_disponibles($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		return get_serie_evaluations_disponibles_theme_type($serie, $theme, 4);
	} else
		$res = get_serie_exos_qrc_disponibles_old($serie, $theme);
	return $res;
}

/**
    Obtenir les exo src disponibles pour une serie en fontion du theme (OLD)

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_src_disponibles_old($serie, $theme) {
	$sql = "select id,lower(titre) as min_titre ,'o' from serie_exo where id in (select id_test from test where type_test='o') and theme=$theme and id not in
		            (select id_exo from asso_exo_serie where id_serie=$serie and type_exo='o') order by min_titre";
	$res = pg_query($sql);
	return $res;
}
/**
    Obtenir les exo src disponibles pour une serie en fontion du theme

    @param integer : le numero de la serie
    @param integer : le numero du theme
    @return integer : le resultat de la requete(id int4, libelle varchar,  type int4)
*/
function get_serie_exos_src_disponibles($serie, $theme) {
	if (VERSION_BASE > VERSION) {
		return get_serie_evaluations_disponibles_theme_type($serie, $theme, 5);
	} else
		return get_serie_exos_src_disponibles_old($serie, $theme);
}

/**
	Obtenir les thmes d'une srie
	@param integer : le numro de la serie
	@return integer : le resultat de la requete  (id int4, libelle varchar)
*/
function get_serie_themes_old($serie) {
	$sql = "select theme, nom_theme from serie_exo, themedir where id=$serie AND theme=num_themedir";
	//echo "$sql<br>";
	return (pg_query($sql));
}

/**
	Obtenir les thmes d'une srie
	@param integer : le numro de la serie
	@return integer : le resultat de la requete  (id int4, libelle varchar)
*/
function get_serie_themes($serie) {
	if (VERSION_BASE > VERSION) {
		return get_categorie_element_themes(19, $serie);
	} else
		return get_serie_themes_old($serie);
}

/**
 * Obtenir l'indice d'une nouvelle valuation d'une srie
 * @param integer : le numero de serie
 * @return integer : le numero de la derniere valuation de la srie
 */
function get_serie_last_evaluation_old($serie) {
	$sql = "SELECT MAX(ordre) FROM asso_exo_serie WHERE id_serie=$serie";
	$res = pg_query($sql);
	return pg_fetch_result($res, 0, 0) + 1;
}

/**
 * Obtenir le numero de la derniere valuation d'une srie
 * @param integer : le numero de serie
 * @return integer : le numero de la derniere valuation de la srie
 */
function get_serie_last_evaluation($serie) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_gen_get_last_element('contraintes.serie_evaluations', 'evaluation',' AND serie=$serie') ";
		//echo $sql."<br>";
		$res = pg_query($sql);
		if(pg_num_rows($res)==1){
			return pg_fetch_result($res, 0, 0);
		} 
		else{
			 return null;	
		}
	} else
		return get_serie_last_evaluation_old($serie);

}

/**
 * Fonction pour la modification de l'ordre des exos d'une srie
 * @param integer : numero de la srie
 * @param integer: numero de l'evaluation qui est dplace (source)
 * @param integer: numero de l'evaluation qui est  la place de la source (destination)
 * @param bool: 'TRUE' si on insert avant(par dfaut) ou 'FALSE' pour inserer apres
 * @param integer: type de l'evaluation qui est dplace (source)
 * @param integer: type de l'evaluation qui est  la place de la source (destination)
 * @return bool: t si l'opration s'est bien passe, f sinon.
 */
function maj_serie_evaluation_ordre_evaluation_old($serie, $etape_src, $etape_dest,  $insere_avant='TRUE',$type_src, $type_dest) {
	//echo "$serie, $etape_src, $etape_dest, $type_src, $type_dest";
	
	pg_query('begin');
	//recupere l'ordre de la source
	$req1="SELECT ordre FROM asso_exo_serie WHERE  id_serie=$serie AND id_exo=$etape_src AND type_exo='$type_src'";
	$res1=pg_query($req1);
	//echo "src?$req1<br>";
	$ordre_src=pg_fetch_result($res1,0,0);
	
	//recupere l'ordre de la destination
	$req2="SELECT ordre FROM asso_exo_serie WHERE  id_serie=$serie AND id_exo=$etape_dest AND type_exo='$type_dest'";
	//echo "dst?$req2<br>";
	$res2=pg_query($req2);
	$ordre_dest=pg_fetch_result($res2,0,0);
	
		
	if(empty($ordre_src)||empty($ordre_dest)){
		return 'f';
	}

	//on fait descendre l'evaluation
	//if($ordre_src<$ordre_dest){
	if($insere_avant=='FALSE'){
			
			//met l'ordre des autres evaluations
			$req3 = "UPDATE asso_exo_serie SET ordre=ordre-1 WHERE id_serie=$serie AND ordre<=$ordre_dest AND ordre>$ordre_src";
			$res3=pg_query($req3);	
			
			//deplace l'evaluation
			$req4 = "UPDATE asso_exo_serie SET ordre=$ordre_dest WHERE id_serie=$serie AND id_exo=$etape_src AND type_exo='$type_src'";
			$res4=pg_query($req4);	
	}
	//on fait monter l'evaluation
	//elseif($ordre_src>$ordre_dest){
	elseif($insere_avant=='TRUE'){
			//met l'ordre des autres evaluations
			$req3 = "UPDATE asso_exo_serie SET ordre=ordre+1 WHERE id_serie=$serie AND ordre>=$ordre_dest AND ordre<$ordre_src";
			$res3=pg_query($req3);	
			
			//deplace l'evaluation
			$req4 = "UPDATE asso_exo_serie SET ordre=$ordre_dest WHERE id_serie=$serie AND id_exo=$etape_src AND type_exo='$type_src'";
			$res4=pg_query($req4);	
	}
	//echo $req3."<br>";
	//echo $req4."<br>";
	
	if($res1&&$res2&&$res3&&$res4){
		pg_query('commit');
		return "t";
	}
	else{
		pg_query('rollback');
		echo "operation annule";
		 return "f";
	}
}

/**
 * Fonction pour la modification de l'ordre des exos d'une srie
 * 
 * @param integer : numero de la srie
 * @param integer: numero de l'evaluation qui est dplace (source)
 * @param integer: numero de l'evaluation qui est  la place de la source (destination)
 * @param bool: 'TRUE' si on insert avant(par dfaut) ou 'FALSE' pour inserer apres
 * @return bool: t si l'opration s'est bien passe, f sinon.
 */
function maj_serie_evaluation_ordre_evaluation($serie, $etape_src, $etape_dest, $insere_avant='TRUE', $type_src="", $type_dest="") {
	if (VERSION_BASE > VERSION) {

		$sql = "select * FROM contraintes.af_maj_serie_evaluation_ordre($serie, $etape_src, $etape_dest,$insere_avant)";
		//echo "$sql<br>";
		$res = pg_query($sql);
		return pg_fetch_result($res, 0, 0)=='t';
	} else
		return  maj_serie_evaluation_ordre_evaluation_old($serie, $etape_src, $etape_dest, $insere_avant, $type_src, $type_dest);
}

/**
    Obtenir les sries alatoires qui utilisent une srie.(OLD)

    @param integer : le numero de la serie
    @return integer : le rsultat de la requete
*/
function get_serie_series_aleatoires_old($serie) {
	$sql = "select DISTINCT S.id, S.titre, 'C' from serie_aleatoire SA, serie_exo S where serie=$serie and S.id=SA.num_serie";
	return pg_query($sql);
}

/**
    Obtenir les sries alatoires qui utilisent une srie.

    @param integer : le numero de la serie
    @return integer : le rsultat de la requete
*/
function get_serie_series_aleatoires($serie) {
	if (VERSION_BASE > VERSION) {
		$sql = "select * from contraintes.af_get_serie_series_aleatoires($serie) AS (id int4, libelle varchar, type int4) ";
		//echo $sql."<br>";
		$res = pg_query($sql);
	} else
		$res = get_serie_series_aleatoires_old($serie);
	return $res;
}

/**
* Obtenir les types d'tapes d'une srie (OLD)
* retourne la liste des types d'etapes prsents dans une srie
*
*  @param integer : numro de srie
*  @param string : 'TRUE' si srie aleatoire, 'FALSE' sinon
*  @return integer : la liste des types d'etapes
*/
function get_serie_types_evaluations_type_old($serie, $aleatoire) {
	if ($aleatoire == 'TRUE')
		$table = "asso_exo_serie_aleatoire";
	else
		$table = "asso_exo_serie";
	$req = "select distinct type_exo from $table where id_serie=$serie";
	$res = pg_query($req);

	return ($res);
}

/**
* Obtenir les types d'tapes d'une srie
* retourne la liste des types d'etapes prsents dans une srie
*
*  @param integer : numro de srie
*  @param string : 'TRUE' si srie aleatoire, 'FALSE' sinon
*  @return integer : resultat de la requete (id int4, libelle  varchar, code varchar,nb integer))
*/
function get_serie_types_evaluations_type($serie, $aleatoire) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from  contraintes.af_get_serie_types_evaluations_type($serie,$aleatoire) as (id int4, libelle  varchar, code varchar,nb integer, couleur char(6))";
//		echo "$req<br>";	
		$res = pg_query($req);
	} else
		$res = get_serie_types_evaluations_type_old($serie, $aleatoire);
	return $res;
}

/**
* Obtenir les types d'tapes d'une srie aleatoire multiserie ou multitheme
* retourne la liste des types d'etapes prsents dans une srie
*
*  @param integer : numro de srie
*  @param string : 'TRUE' si srie aleatoire, 'FALSE' sinon
*  @return integer : resultat de la requete (id int4, libelle  varchar, code varchar,nb integer))
*/
function get_serie_aleatoire_types_evaluations_type($serie,$formation,$parcours,$individu) {
	if (VERSION_BASE > VERSION) {
		$req = "select * from  contraintes.af_get_serie_aleatoire_types_evaluations_type($serie,$formation,$parcours,$individu) as (id int4, libelle  varchar, code varchar,nb integer, couleur char(6))";
//		echo "$req<br>";	
		$res = pg_query($req);
	} else
		$res = get_serie_types_evaluations_type_old($serie, $aleatoire);
	return $res;
}

/**
    Obtenir les parcours d'une serie (OLD)

    @param integer : le numero de la serie
    @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4, duree bool)
*/
function get_serie_parcourss_old($serie,$desc=""){
	if($desc=='DESC')$ordre=" DESC";
    else $ordre="";
    $sql="	select distinct G1.g_num_parcours, nom_parcours, G2.num_c_q_e_d, affiche_fo ,lower(nom_parcours)from gestparcours G1,gestparcours G2, parcours 
			where G1.num_c_q_e_d=$serie 
			and (G1.type_etape='B' OR G1.type_etape='C')
			AND G1.g_num_parcours=num_parcours
			AND G2.g_num_parcours=num_parcours
			AND G2.num_etape='1'
			ORDER BY lower(nom_parcours)  $ordre";
			
	//echo "$sql<br>";			
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les parcours d'une serie

    @param integer : le numero de la serie
    @param string : pour croissant (ASC, par dfaut) ou decroissant(DESC)
    @return integer : le resultat de la requete (id int4, libelle varchar, filiere int4, duree bool)
*/
function get_serie_parcourss($serie, $desc=""){
    if(VERSION_BASE>VERSION){
        return get_etape_parcourss($serie,$desc);
    }
    else
        $res=get_serie_parcourss_old($serie,$desc);
    return $res ;
}

/**
	Obtenir les commentaires pour une serie (OLD)
	@param integer : numero serie
	@return : resultat requete
*/
function get_serie_commentaires_old($serie){
	$sql=" select * from commentaire where num_qstaire=$serie";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}
/**
	Obtenir les commentaires pour une serie 
	@param integer : numero serie
	@return : resultat requete
*/
function get_serie_commentaires($serie){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_serie_commentaires($serie) as (etape int4,min int4,max int4,commentaire text)";
		$res=pg_query($sql); 
	}
	else
		$res=get_serie_commentaires_old($serie);
	return $res;
}

/**
	Obtenir la somme des chronos des exo d'une serie (OLD)
	@param integer : le numero de la serie
	@return integer : la dure totale des chrono en secondes
*/
function get_serie_somme_chronos_old($serie){
	$sql="select sum(chrono) from asso_exo_serie where id_serie=$serie";
 	return (pg_query($sql));
}
/**
	Obtenir la somme des chronos des valuations d'une serie
	@param integer : le numero de la serie
	@return integer : la dure totale des chrono en secondes
*/
function get_serie_somme_chronos($serie){
	 if(VERSION_BASE>VERSION){
		$sql="SELECT * FROM contraintes.af_get_serie_somme_chronos($serie)";
//		echo "$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=get_serie_somme_chronos_old($serie);
    return $res ;
}

/**
 * Donne l'avancement maximum d'une serie.
 * 
 * @param integer : l'identifiant de la serie
 * @return integer : le resultat de la requete (formation int4, utilisateur int4, pere int4, serie int4, type int4 )
 */
function get_serie_avancement_max_old($serie){
	//on verifie la table res_serie_exo car la table res_serie n'est remplie que lorsque tous les exos de la srie sont faits
	$sql="	SELECT DISTINCT id_formation, gu_num_gest_gr, id_stag, g_num_parcours, ordre_etape, id_serie, type_exo
			FROM res_serie_exo, gestionutil, gestionnaire
			WHERE id_serie=$serie
			AND gu_num_user=id_stag
			AND g_num_cal=id_formation
			AND g_num_gest_g=gu_num_gest_gr
			GROUP BY id_formation, gu_num_gest_gr,g_num_parcours, id_stag, ordre_etape, id_serie, type_exo
			HAVING ordre_etape=MAX(ordre_etape)";
 	return (pg_query($sql));
}

/**
 * Donne l'avancement maximum d'une serie.
 * 
 * @param integer : l'identifiant de la serie
 * @return integer : le resultat de la requete (formation int4, individu int4,parcours int4, pere int4, serie int4 )
 */
function get_serie_avancement_max($serie){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_serie_avancement_max($serie) as (formation int4, individu int4,parcours int4, pere int4, serie int4 )";
		//echo $sql;
		$res=pg_query($sql); 
    }
    else
        $res=get_serie_avancement_max_old($serie);
    return $res ;	
}


/**
    Obtenir les infos sur les filieres des parcours qui utilisent la serie donne en paramtre (OLD)

    @param integer : le numero de la serie
    @param string : pour croissant ou decroissant
    @param char : le type de la serie
    @return integer : le resultat de la requete (id int4, libelle  varchar, pere int4, parcours int4)
*/
function get_serie_filieres_old($serie,$desc,$type){
    $sql="SELECT DISTINCT  id, nom, id_pere ,num_parcours,lower(nom) AS ordre FROM gestparcours G1, gestparcours G2, parcours, Filiere
                  WHERE G1.num_c_q_e_d=$serie AND G1.type_etape='$type' AND G1.g_num_parcours=num_parcours
                  AND G2.g_num_parcours=num_parcours AND G2.num_etape=1 AND G2.num_c_q_e_d=id
                  ORDER BY ordre $desc";
	//echo "$sql<br>";                 
    $res=pg_query($sql);
    return $res;
}
/**
    Obtenir les infos sur les filieres des parcours qui utilisent la serie donne en paramtre

   	@param integer : le numero de la serie
    @param string : pour croissant ou decroissant
    @param char : le type de la serie
    @return integer : le resultat de la requete (id int4, libelle  varchar, pere int4, parcours int4)
*/
function get_serie_filieres($serie,$desc, $type=""){
    if(VERSION_BASE>VERSION){
    	return get_etape_filieres($serie,$desc);
    }
    else
        $res=get_serie_filieres_old($serie,$desc,$type);
    return $res ;
}

/**
*   Obtenir les formations qui utilisent la serie (OLD)
*
*   @param integer : le numro de la serie
*   @return integer : le rsultat de la requte (id int4, libelle varchar)
*/
function get_serie_formations_old($serie, $desc=""){
	if($desc=='DESC')$ordre="DESC";
	else $ordre="";
	$sql="SELECT DISTINCT C.num_cal, C.nom_cal FROM gestparcours G1,gestionparcours G2, calendrier C WHERE num_c_q_e_d=$serie
        AND type_etape ='B'
        AND gp_num_parcours=g_num_parcours
        AND C.num_cal=G2.num_cal
        ORDER BY C.nom_cal $ordre";
    //echo "$sql<br>";   
	$res=pg_query($sql);
return $res;
}

/**
*   Obtenir les formations qui utilisent la serie
*
*   @param integer : le numro de la serie
*   @return integer : le rsultat de la requte (id int4, libelle varchar)
*/
function get_serie_formations($serie,$desc){
     if(VERSION_BASE>VERSION){
        return get_etape_formations($serie,$desc);
    }
    else
        return get_serie_formations_old($serie,$desc);
}

/**
    Obtenir les infos sur les groupe qui utilisent la serie donne en paramtre (OLD)

    @param integer : le numero de la serie
    @param string : 'ASC' pour croissant(par dfaut) ou 'DESC' pour decroissant 
    @return integer : le resultat de la requete (id int4, libelle varchar)
*/
function get_serie_classes_old($serie,$desc){
     $sql="SELECT DISTINCT C.id, C.nom FROM gestparcours G1,gestionnaire G2, classe C  WHERE num_c_q_e_d =$serie
                AND type_etape='B' AND G1.g_num_parcours=G2.g_num_parcours AND G2.g_num_gest_g=C.id 
				ORDER BY C.nom $desc";
     $res=pg_query($sql);
     //echo "$sql<br>";
     return $res;
}
/**
    Obtenir les infos sur les groupe qui utilisent la serie donne en paramtre

    @param integer : le numero de la serie
    @param string : 'ASC' pour croissant(par dfaut) ou 'DESC' pour decroissant 
    @return integer : le resultat de la requete (id int4, libelle varchar)
*/
function get_serie_classes($serie,$desc){
    if(VERSION_BASE>VERSION){
        return get_etape_classes($serie,$desc);
    }
    else
        $res=get_serie_classes_old($serie,$desc);
    return $res ;
}

/**
    Obtenir les infos sur les formations d'un groupe qui utilise la serie donne en paramtre (OLD)

    @param integer : le numero de la serie
    @param integer : le numero de la classe
    @param string : 'ASC' pour croissant(par dfaut) ou 'DESC' pour decroissant 
    @return integer : le resultat de la requete (id int4, libelle varchar)
*/
function get_serie_formations_classe_old($serie,$classe, $desc="ASC"){
    $sql="SELECT DISTINCT C.num_cal, C.nom_cal FROM gestparcours G1,gestionparcours G2, calendrier C
            WHERE num_c_q_e_d=$serie AND type_etape='B' AND gp_num_groupe=$classe
            AND gp_num_parcours=g_num_parcours AND G2.num_cal=C.num_cal ORDER BY C.nom_cal $desc";
    //echo "$sql<br>";        
    $res=pg_query($sql);
    return $res;
}

/**
    Obtenir les infos sur les formations d'un groupe qui utilise la serie donne en paramtre (OLD)

    @param integer : le numero de la serie
    @param integer : le numero de la classe
    @param string : 'ASC' pour croissant(par dfaut) ou 'DESC' pour decroissant 
    @return integer : le resultat de la requete (id int4, libelle varchar
*/
function get_serie_formations_classe($serie,$classe, $desc=""){
    if(VERSION_BASE>VERSION){
		return get_etape_formations_classe($serie,$classe, $desc="");
    }
    else
        $res=get_serie_formations_classe_old($serie,$classe, $desc);
    return $res ;
}

/**
 * Donne l'avancement d'une serie.
 * 
 * @param integer : l'identifiant de la serie
 * @return integer : le resultat de la requete (formation int4, stagiaire int4, parcours int4, serie int4, evaluation int4,  type int4 )
 */
function get_serie_avancement_old($serie){
	//on verifie la table res_serie_exo car la table res_serie n'est remplie que lorsque tous les exos de la srie sont faits
	$sql="	SELECT DICTINCT id_formation, id_stag,g_num_parcours,id_serie,  ordre_etape, type_exo
			FROM res_serie_exo, gestionutil, gestionnaire,
			WHERE id_serie=$serie
			AND gu_num_user=id_stag
			AND g_num_cal=id_formation
			AND g_num_gest_g=gu_num_gest_gr
			ORDER BY id_serie, ordre_etape, id_formation,gu_num_gest_gr, g_num_parcours, id_stag ";
	//echo $sql;			
 	return (pg_query($sql));
}

/**
 * Donne l'avancement d'une serie.
 * 
 * @param integer : l'identifiant de la serie
 * @return integer : le resultat de la requete (formation int4 stagiaire int4, parcours int4, serie int4, evaluation int4 )
 */
function get_serie_avancement($serie){
	if(VERSION_BASE>VERSION){
        $sql="SELECT * FROM contraintes.af_get_serie_avancement($serie) AS (formation int4,  stagiaire int4, parcours int4, serie int4, evaluation int4)";
    	return (pg_query($sql));
    }
    else
       return get_serie_avancement_old($serie);
}

/**
 * Obtenir les individus, et leur formations, qui ont fait une srie.(OLD)
 * 
 * @param integer : l'identifiant de la serie
 * @return integer : le resultat de la requete (formation int4, utilisateur int4, nom_prenom varchar, serie int4, libelle_serie varchar )
 */
function get_serie_individus_old($serie){
	//on verifie la table res_serie_exo car la table res_serie n'est remplie que lorsque tous les exos de la srie sont faits
	$sql="	SELECT DISTINCT id_formation, id_stag, nom || prenom,  id_serie, titre
			FROM res_serie_exo, utilisateurs, serie_exo
			WHERE id_serie=$serie
			AND id_stag=num_user
			AND id=id_serie";
	//echo $sql;			
 	return (pg_query($sql));
}

/**
 * Obtenir les individus, et leur formations, qui ont fait une srie.
 * 
 * @param integer : l'identifiant de la serie
 * @return integer : le resultat de la requete (formation int4, utilisateur int4, nom_prenom varchar, serie int4, libelle_serie varchar )
 */
function get_serie_individus($serie){
	if(VERSION_BASE>VERSION){
		$sql="select * from contraintes.af_get_serie_individus($serie) 
			as (formation int4,nom_formation varchar,individu int4,nom varchar,prenom varchar,parcours int4,titre varchar,etape int4)";
		//echo "sql=$sql<br>";
		$res=pg_query($sql);
    }
    else
        $res=get_serie_individus_old($serie);
    return $res ;	
}

/**
   * Savoir si une serie est aleatoire
   * @param integer : l'identifiant de la serie
   * @return bool :  vrai si aleatoire ,faux sinon
*/
function is_serie_aleatoire($serie){
	if(VERSION_BASE>VERSION){
		 $sql="select * from contraintes.af_is_serie_aleatoire($serie)";
		 $res=pg_fetch_result(pg_query($sql),0,0);
	}
	else
		$res=is_serie_aleatoire_old($serie);
	return $res;

}

/**
   Obtenir l'indice d'une evaluation de serie
   @param integer : le numero de la serie
*  	@param integer : le numero de l'evaluation

*   @return integer : le numero d'indice de l'evaluation ds la serie
   
*/
function get_serie_evaluation_indice($serie,$evaluation){
	$sql="select * from contraintes.af_get_serie_evaluation_indice($serie,$evaluation)";
	$res=pg_query($sql);
	return pg_fetch_result($res,0,0);
}

/**
	Modifier le titre d'une serie
	@param integer : serie
	@param string : titre
	@return boolean
*/
function maj_serie_libelle($serie,$libelle){
	$sql="select * from contraintes.af_maj_etape_libelle($serie,'$libelle')";
	//echo "sql=$sql<br>";
	return pg_query($sql);
}

/**
   Obtenir les resultat pour une evaluation de serie
   @param integer : id serie
   @param integer : id evaluation
   @return res req
*/
function get_serie_evaluation_resultats($serie,$evaluation){
	
		  $sql="select * from contraintes.af_get_serie_evaluation_resultats($serie,$evaluation) as (id int8,evaluation int4,date_creation timestamp,date_fin timestamp)";
		  //echo "sql=$sql<br>";
		  return pg_query($sql);
	
}




?>