<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoSerieAleatoire.
 * Un DoSerieAleatoire sert � g�rer l'avancement des Etapes de type S�rieAleatoire.
 * Ainsi, les appels aux methodes beginCurrentEtape() et endCurrentEtape() s'appliquent � la S�rie elle meme (commence et termine l'�tape) 
 * et � ses �valuations (commence, termine et charge l'Evaluation suivante).   
 * 
 * @package serie_aleatoire
 */
class DoSerieAleatoire extends DoSerie{ 
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours
	 * @param integer $etape l'�tape Liste
	 * @param object DoEvaluationFactory &$obj_DoEvaluationFactory Fabrique servant � la cr�ation des objets d'avancement des Evaluations de la S�rie
	 */
	function DoSerieAleatoire($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory){
		messageDebug("DoSerieAleatoire::DoSerieAleatoire($formation,$individu,$parcours,$etape,&\$obj_DoEvaluationFactory)");
		parent::DoSerie($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory);
	}
	
//-----------------------------------------------------
//			METHODES PUBLIQUES
//-----------------------------------------------------
	/**
	 * D�but de la S�rie et de ses Evaluations.
	 * Initialise l'avancement de l'�tape.
	 * Cr�ation de l'identifiant r�sultat et enregistrement de la date de d�but pour la S�rie.
	 * Si la s�rie est en cours, initalise et commence l'Evaluation courante.
	 * 
	 * @return integer idenfiant r�sultat en base de donn�es
	 */
	function beginCurrentEtape(){
		messageDebug("DoSerieAleatoire::beginCurrentEtape()");
		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
		if(pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
			$id_resultat=$row_resultat[0];
			$fin_resultat=$row_resultat[6];
		}
		if(!empty($id_resultat)){                          
			$this->resultat=$id_resultat;
			if(!empty($fin_resultat)){
				die("Erreur DoSerieAleatoire::beginCurrentEtape(): l'�tape a d�j� �t� commenc�e et est d�j� termin�e.<br/>");
			}else{
				if(!is_object($this->obj_DoNode)){
					$this->nextEvaluation();
				}
				$row_resultat=get_resultat($this->resultat);
				$this->debut=$row_resultat[5];
//				return $this->obj_DoNode->begin();
			}
		}else{
			// remplissage de la table serie_aleatoire_evaluations
			$this->obj_node=EtapeFactory::createEtape($this)   ;
			if(!$this->obj_node->setEvaluations($this->getFormation(), $this->getParcours(),parent::getIndividu() )){
				die("Erreur DoSerieAleatoire::beginCurrentEtape(): les evaluations pour la serie n'ont pu etre generees");
			}
			$this->resultat=set_resultat_debut($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape() );
			if($this->nextEvaluation()){
				$row_resultat=get_resultat($this->resultat);
				
				$this->debut=$row_resultat[5];
//				return $this->obj_DoNode->begin();
			}
			return false;
		}
		return $this->resultat;
	}
	
	/*
		function &performCurrentEtape(&$obj_EtapeFactory){
		messageDebug("DoSerieAleatoire::performCurrentEtape()");
		parent::performCurrentEtape(&$obj_EtapeFactory);
		$row_avancement=$this->getAvancement();
		if(!empty($row_avancement[5])){
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			$this->obj_DoNode->perform();
		}
		else{
			unset($this->obj_DoNode);
		}
		return $this->obj_DoNode;
	}
	 */
/*	
	/**
	 * Construction des objets associ�s � l'avancement au sein de la Serie.
	 * L'objet d'avancement de l'element courant de la s�rie, de type DoEvaluation, est construit � partir
	 * de l'identifiant Resultat cr�� par la methode beginCurrentEtape().
	 * @return object DoEvaluation  L'objet correspondant � l'�valuation courante de la S�rie
	 */ 
/*	function &performCurrentEtape(&$obj_EtapeFactory){
		messageDebug("DoSerieAleatoire::performCurrentEtape()");
		parent::performCurrentEtape(&$obj_EtapeFactory);
		$row_avancement=$this->getAvancement();
		if(!empty($row_avancement[5])){
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			$this->obj_DoNode->perform();
		}
		else{
			unset($this->obj_DoNode);
		}
		return $this->obj_DoNode;
	}
*/
	/**
	 * Termine la S�rie et si besoin termine l'Evaluation courante et charge l'�tape suivante.
	 * Enregistre la date de fin de la s�rie et de l'�valuation si besoin et detruit les attributs de l'objet inutiles.
	 * @param object ResultatSerie $obj_resultat : Resultat associ� � l'objet associ� � l'avancement.
	 * @return boolean TRUE ou FALSE suivant le succ�s ou non de la m�thode.
	 */
//	function endCurrentEtape($obj_resultat=null){
//		messageDebug("DoSerieAleatoire::endCurrentEtape($obj_resultat)");
//		
//		if(is_object($this->obj_DoNode)){
//			if($this->obj_DoNode->isBegin()){
//				if($this->obj_DoNode->isEnd()){
//					$this->nextEtape();
//				}else{
//					$res_node=$this->obj_DoNode->end($obj_resultat);
//					if($res_node){ 
//						unset($this->obj_DoNode);
//						$this->nextEvaluation();
//					}
//				}
//			}else{
//				die("DoSerieAleatoire::endCurrentEtape(): L'�valuation courante ne peut etre termin�e car elle n'a pas �t� commenc�e.</b><br/>");
//				return false;
//			}
//		}
//		
//		if(!is_object($this->obj_DoNode)){ //nb:attention pas de else
//			$res_parent=DoEtapeRenewable::endCurrentEtape($obj_resultat);	
//			return $res_parent;
//		}else{
//			messageDebug("DoSerieAleatoire::endCurrentEtape(): La serie ne peut etre termin�e: Il y a une �valuation suivante.");
//			return false;
//		}
//		
//	}            
//		
//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	/**
	 * Passage � l'Evaluation suivante de la S�rie.
	 * Initalise l'objet d'avancement de l'�tape suivante ou le met � null si pas d'�tape suivante.
	 * @return boolean TRUE si il y a une evaluation suivante, FALSE sinon.
	 */
	/*
	function nextEvaluation(){
		$row_avancement=$this->getAvancement();
		if(!empty($row_avancement[5])){
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			return true;
		}
		else{
			unset($this->obj_DoNode);
			return false;
		}
	}
	*/
	
	/**
	 * Obtenir l'engistrement de base de donn�es correspondant � l'�tat courant de la S�rie.
	 * @return Array() : Ligne r�sultat de la requete sur la base de donn�es.
	 */
	 /*
	function getAvancement(){
		return pg_fetch_row(get_resultat_serie_aleatoire_avancement_max($this->getResultat()));
	}
	*/
//-----------------------------------------------------
//			ACCESSEURS
//-----------------------------------------------------

	
	
	/**
	 * Calculer et obtenir le status de la serie.
	 * Le status est obtenu � partir des donn�es en base.
	 * L'�tape peut avoir les status suivants:
	 * DO_ETAPE_NONE, DO_ETAPE_BEGIN et DO_ETAPE_END.
	 */
//	 function getStatus(){
//		//echo "coucou<br>";
//		$status=DO_ETAPE_NONE;
//		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
//		if(pg_num_rows($res_resultat)==1){
//			$row_resultat=pg_fetch_row($res_resultat);
//			$id_resultat=$row_resultat[0];
//			$duree_resultat=$row_resultat[6];
//			
//		}
//		if(!empty($id_resultat)){
//			//echo "par la<br>";
//			$status=DO_ETAPE_BEGIN;
//			if( (!empty($duree_resultat)) && (pg_num_rows(get_serie_aleatoire_evaluations($this->getFormation(),$this->getParcours(),parent::getIndividu(), $this->getEtape())) ==
//			pg_num_rows(get_resultat_serie_evaluations($id_resultat))  )  ){
//			//echo "par ici<br>";	
//				$status=DO_ETAPE_END;
//			}
//		}
//		return $status;	
//	}
		
	function getEvaluations(){
		return get_serie_aleatoire_evaluations($this->getFormation(),$this->getParcours(),$this->getIndividu(),$this->getEtape());
	}
	
	function getResultatEvaluations($id_resultat){
		return get_resultat_serie_evaluations($id_resultat);
	}
	
	/**
	 * Obtenir l'objet Serie associ� � cet objet d'avancement.
	 * @return object Serie L'objet Serie associ�. 
	 */
	function getSerie(){
		return parent::getListe();
	}
	
	/**
	 * Obtenir le type (complet) de la S�rie
	 * @return string Le type de S�rie
	 */
	function getType(){
		return parent::getType().'_'.TYPE_LISTE_SERIE;
	}
	
	/**
	 * Obtenir l'objet d'avancement correspondant � l'Evaluation courante de la S�rie 
	 * @return object DoEvaluation L'objet d'avancement de l'Evaluation courante
	 */
	function &getCurrentDoEvaluation(){
		return parent::getCurrentDoNode();
	}
	
	/**
	 * Obtenir la fabrique d'Evaluation utilis�e pour la cr�ation des noeuds de la S�rie
	 * @return object DoEvaluationFactory : la fabrique de DoEvaluation
	 */
	function getCurrentDoEvaluationFactory(){
		return parent::getCurrentDoNodeFactory();
	}
	
	/**
	 * Obtenir les scores des Evaluations de la S�rie
	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	 */
	function getEvaluationsScores(){
		return get_resultat_serie_aleatoire_evaluations_scores($this->getResultat());
	}
	
	/**
	 * Obtenir les Evaluations de la S�rie
	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	 */
	function getScoreTotal(){
		//return 8;
		return get_resultat_serie_aleatoire_score($this->getResultat());
	}	
}

?>