<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * D�finition d'un DoSerieAleatoireMultiserie.
 * Un DoSerieAleatoire sert � g�rer l'avancement des Etapes de type S�rie Aleatoire Multiserie.
 * Ainsi, les appels aux methodes beginCurrentEtape() et endCurrentEtape() s'appliquent � la S�rie elle meme (commence et termine l'�tape) 
 * et � ses �valuations (commence, termine et charge l'Evaluation suivante).   
 * 
 * @package serie_aleatoire
 */
class DoSerieAleatoireMultiserie extends DoSerieAleatoire{ 
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs h�rit�s.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours
	 * @param integer $etape l'�tape Liste
	 * @param object DoEvaluationFactory &$obj_DoEvaluationFactory Fabrique servant � la cr�ation des objets d'avancement des Evaluations de la S�rie
	 */
	function DoSerieAleatoireMultiserie($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory){
		messageDebug("DoSerieAleatoireMultiserie::DoSerieAleatoireMultiserie($formation,$individu,$parcours,$etape,&\$obj_DoEvaluationFactory)");
		parent::DoSerieAleatoire($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory);
//		print_rr($this);
	}
	
	//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	/**
	 * Passage � l'Evaluation suivante de la S�rie.
	 * Initalise l'objet d'avancement de l'�tape suivante ou le met � null si pas d'�tape suivante.
	 * @return boolean TRUE si il y a une evaluation suivante, FALSE sinon.
	 */
	function nextEvaluation(){
		$row_avancement=$this->getAvancement();
		//print_rr($row_avancement);die();
		if(!empty($row_avancement[5])){
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			return true;
		}
		else{
			unset($this->obj_DoNode);
			return false;
		}
	}
	
	/**
	 * Obtenir l'engistrement de base de donn�es correspondant � l'�tat courant de la S�rie.
	 * @return Array() : Ligne r�sultat de la requete sur la base de donn�es.
	 */
	function getAvancement(){
		return pg_fetch_row(get_resultat_serie_aleatoire_avancement_max($this->getResultat()));
	}
	
	/**
	 * Calculer et obtenir le status de la serie.
	 * Le status est obtenu � partir des donn�es en base.
	 * L'�tape peut avoir les status suivants:
	 * DO_ETAPE_NONE, DO_ETAPE_BEGIN et DO_ETAPE_END.
	 */
	 /*
	 function getStatus(){
		//echo "coucou<br>";
		$status=DO_ETAPE_NONE;
		$res_resultat=get_resultat_etape($this->getFormation(), parent::getIndividu(), $this->getParcours(), $this->getEtape());
		if(pg_num_rows($res_resultat)==1){
			$row_resultat=pg_fetch_row($res_resultat);
			$id_resultat=$row_resultat[0];
			$duree_resultat=$row_resultat[6];
			
		}
		if(!empty($id_resultat)){
			
			$status=DO_ETAPE_BEGIN;
			if( (!empty($duree_resultat)) && (pg_num_rows(get_serie_aleatoire_evaluations($this->getFormation(),$this->getParcours(),parent::getIndividu(), $this->getEtape())) ==
			pg_num_rows(get_resultat_serie_evaluations($id_resultat))  )  ){
				
				$status=DO_ETAPE_END;
			}
		}
		return $status;	
	}
	*/

	
}

?>