<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Dfinition d'un DoSerieAleatoireMultitheme.
 * Un DoSerieAleatoire sert  grer l'avancement des Etapes de type Srie Aleatoire Multitheme.
 * Ainsi, les appels aux methodes beginCurrentEtape() et endCurrentEtape() s'appliquent  la Srie elle meme (commence et termine l'tape) 
 * et  ses valuations (commence, termine et charge l'Evaluation suivante).   
 * 
 * @package serie_aleatoire
 */
class DoSerieAleatoireMultitheme extends DoSerieAleatoire{ 
	
	/**
	 * Constructeur
	 * 
	 * Creation de l'objet et initialisation
	 * de ses attributs hrits.
	 * 
	 * @param integer $formation la formation de l'individu
	 * @param integer $individu l'individu qui effectue la formation
	 * @param integer $parcours le parcours
	 * @param integer $etape l'tape Liste
	 * @param object DoEvaluationFactory &$obj_DoEvaluationFactory Fabrique servant  la cration des objets d'avancement des Evaluations de la Srie
	 */
	function DoSerieAleatoireMultitheme($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory){
		messageDebug("DoSerie::DoSerie($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory)");
		parent::DoSerieAleatoire($formation,$individu,$parcours,$etape,&$obj_DoEvaluationFactory);
	}
	
	//-----------------------------------------------------
//			METHODES PRIVEES
//-----------------------------------------------------
	/**
	 * Passage  l'Evaluation suivante de la Srie.
	 * Initalise l'objet d'avancement de l'tape suivante ou le met  null si pas d'tape suivante.
	 * @return boolean TRUE si il y a une evaluation suivante, FALSE sinon.
	 */
	function nextEvaluation(){
		$row_avancement=$this->getAvancement();
		if(!empty($row_avancement[5])){
			$this->obj_DoNode=&$this->obj_DoNodeFactory->createDoEvaluation($this->getResultat(),$row_avancement[5],$row_avancement[6],$row_avancement[7]);
			return true;
		}
		else{
			unset($this->obj_DoNode);
			return false;
		}
	}
	
	/**
	 * Obtenir l'engistrement de base de donnes correspondant  l'tat courant de la Srie.
	 * @return Array() : Ligne rsultat de la requete sur la base de donnes.
	 */
	function getAvancement(){
		return pg_fetch_row(get_resultat_serie_aleatoire_avancement_max($this->getResultat()));
	}
	
}

?>