<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class SerieAleatoire extends Serie{
var $formation	;	
var $parcours ;
var $individu	;			
	function SerieAleatoire($id, $formation,$parcours,$individu,$libelle="Etape SerieAleatoire", $date_creation="27.11.2006",$bareme=0,$chrono=0){
		if(func_num_args()==8){
			  //echo"parent::Serie($id, $libelle, $date_creation,$bareme,$chrono<br>";
			parent::Serie($id, $libelle, $date_creation,$bareme,$chrono);
		}
		else {
			   	die("SerieAleatoire:A completer");
		}
		$this->initSerieAleatoire($formation,$parcours,$individu);
	}
	
	function initSerieAleatoire($formation,$parcours,$individu){
		$this->formation=$formation;
		$this->parcours=$parcours;
		$this->individu=$individu;
	}
	
	
	 /**
	 * Obtenir les Evaluations de la Srie aleatoire
	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	 */
	function getEvaluations(){
		return get_serie_aleatoire_evaluations($this->formation,$this->parcours,$this->individu,$this->id);
	}
	
	function getObjEvaluation($indice){
		$res=$this->getEvaluations();
		$row_evaluation=pg_fetch_row($res,$indice -1);
	 	return EvaluationFactory::createEvaluation($row_evaluation[0],$row_evaluation[4]);
	}
	
	/**
	* Remplir la table serie_aleatoire_evaluation (Note : pour une serie aleatoire multiserie)
	*/
	function setEvaluations(){
		//echo "form=$formation et parc=$parcours et indiv=$individu et etape=$this->id";
		//die("form=$formation et parc=$parcours et indiv=$individu et etape=$this->id");
		//return set_serie_aleatoire_multiserie($this->id,$this->formation,$this->parcours,$this->individu);
	}
	
	/**
	
	*/
	function getPoints($evaluation){
		return 1;
	}
	
	/**
	 * Obtenir les types des Evaluations de la Srie.
	 * Retourne les identifiants, liblls et le nombre d'Evaluation de chacuns de types.
	 * @return integer : resultat de la requete (id int4, libelle  varchar, code varchar,nb integer))
	 */	
	function getEvaluationsTypes(){
		return get_serie_aleatoire_types_evaluations_type($this->id,$this->formation,$this->parcours,$this->individu);
	}
	
	/**
	 * Obtenir le bareme d'une Evaluation pour la Srie aleatoire.
	 * @param integer $evaluation L'identifiant de l'Evaluation
	 * @return integer: null. 
	 */
	function getBaremeEvaluation($evaluation){
		
		return null;
	}
	
	/**
	 * Obtenir l'objet correspondant au bareme d'une Evaluation pour la Srie.
	 * @param integer $evaluation L'identifiant de l'Evaluation
	 * @return Object: l'identifiant du bareme. 
	 */
	function getObjBaremeEvaluation($evaluation){
	
		if(empty($this->bareme)){
			$bareme_evaluation=$this->getBaremeEvaluation($evaluation);
			if(empty($bareme_evaluation)){
				return null;
			}
			else{
				return pg_fetch_object(get_bareme($bareme_evaluation));
			}
		}else{
			//print_rr($this->getObjBareme());
			return $this->getObjBareme();
		}
	}
}    
?>
