<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class SerieAleatoireMultiserie extends SerieAleatoire{
		
	function SerieAleatoireMultiserie($id, $formation,$parcours,$individu,$libelle="Etape SerieAleatoire", $date_creation="27.11.2006",$bareme,$chrono){
		 if(func_num_args()==8){
			parent::SerieAleatoire($id, $formation,$parcours,$individu,$libelle,$date_creation,$bareme,$chrono);
		 }
		 else{
			parent::SerieAleatoire($id, $formation,$parcours,$individu,$libelle, $date_creation);
		 }
			
		
	}
	
	function getChronoTotal()
    {
    	if(!empty($this->chrono)) return $this->chrono;
    	
    	if(is_null($this->chrono)){
    		$result=get_serie_aleatoire_multiserie_somme_chronos($this->formation,$this->parcours,$this->individu,$this->id);
//            echo "\$result=$result";
            $temps= (pg_fetch_result($result,0,0)) ;
//            echo "\$temps=$temps";
            if(!empty($temps))
            	return $temps;
    	}	
            switch($this->chrono)
            {
                    // Pas de chrono
                    case '-1' :
                   		return -1 ;

                    // Chrono global, on retourne la valeur de $this->chrono
                    default :
                            return $this->chrono ;
            }
    }
	
	function getObjEvaluation($indice){
		$res=$this->getEvaluations();
		$row_evaluation=pg_fetch_row($res,$indice -1);
	 	return EvaluationFactory::createEvaluation($row_evaluation[0],$row_evaluation[8]);
	}
	
	/**
	 * Obtenir le nombre de points attribu�s � une �valuataion pour la S�rie.
	 * @param integer $evaluation L'identifiant de l'Evaluation
	 * @return integer le nombre de points attribu�s
	 */
	function getPoints($evaluation){
		$res= get_serie_aleatoire_multiserie_evaluation($this->formation,$this->parcours,$this->individu,$this->id,$evaluation);
		return pg_fetch_result($res,0,7);
	}
	
	function getChronoEvaluation($evaluation){
		$res= get_serie_aleatoire_multiserie_evaluation($this->formation,$this->parcours,$this->individu,$this->id,$evaluation);
		return pg_fetch_result($res,0,6);
	}

	function getBaremeEvaluation($evaluation){
		$res= get_serie_aleatoire_multiserie_evaluation($this->formation,$this->parcours,$this->individu,$this->id,$evaluation);
		return pg_fetch_result($res,0,5);
	}
	
	function getCommentaire($evaluation){
		$res= get_serie_aleatoire_multiserie_evaluation($this->formation,$this->parcours,$this->individu,$this->id,$evaluation);
		return pg_fetch_result($res,0,4);
	}
			
	 /**
	 * Obtenir les Evaluations de la S�rie aleatoire
	 * @return integer Le resultat de la requete :(id int4, libelle varchar, serie int4, pere int4, commentaire varchar, bareme int4, chrono int4, points int4, type int4 )
	 */
	function getEvaluations(){
		return get_serie_aleatoire_multiserie_evaluations($this->formation,$this->parcours,$this->individu,$this->id);
	}
	
	/**
	* Remplir la table serie_aleatoire_evaluation (Note : pour une serie aleatoire multiserie)
	*/
	function setEvaluations(){
		//echo "form=$formation et parc=$parcours et indiv=$individu et etape=$this->id";
		//die("form=$formation et parc=$parcours et indiv=$individu et etape=$this->id");
		return set_serie_aleatoire_multiserie_evaluations($this->id,$this->formation,$this->parcours,$this->individu);
	}
}
?>
