<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
Fichier de dfinition de la classe Serie_aleatoire

La connexion  la base de donnes doit tre $db

@author CHABOISSIER Jonathan <jc@afide.fr>
@since 07/07/2004

@package serie_aleatoire
*/
class Serie_aleatoire extends Serie
{



        /**
        * Constructeur de la classe Serie
        *
        * On peut construire de deux faons. Soit on utilise le paramtre identifiant l'enregistrement en base de donnes, soit on passe
        * toutes les informations ncssaires.
        * @param integer : identifiant de la srie s'il elle existe en base de donnes (doit tre le seul argument valu si on veut construire un objet  partir
        * de l'enregistrement en BD
        * @param string : Titre de la srie
        * @param integer : identifiant du thme en base de donnes
        * @param integer : identifiant du barme en base de donnes, ou -1 (pas de barme) ou 0 (chrono barme)
        * @param integer : identifiant du chonomtre en base de donnes, ou -1 (pas de chrono) ou 0 (chrono individuel)
        *
        */

        function Serie_aleatoire($serie="", $titre="", $theme="", $le_bareme="", $le_chrono="",$num_user="",$num_cal="",$mode_aleatoire="")
        {
                // echo "Class Serie : constructeur<br>" ;

                // constructeur  partir d'un identifiant d'enregistrement en base de donnes (seul le numero doit tre pass)
                if($serie!="" && $titre=="")
                {
                        // Requete sur base de donnes
                        $result = pg_query("SELECT * FROM serie_exo WHERE id=$serie") ;
                        $row=pg_fetch_array($result) ;


                        // Affectations aux attributs de l'objet
                        $this->id_serie = $serie ;
                        $this->titre_serie = $row["titre"] ;
                        $this->num_theme = $row["theme"] ;
                        $this->num_bareme = $row["bareme"] ;
                        $this->chrono = $row["chrono"] ;

                        // Construction du tableau sesExercices
                        $this->sesExercices = array() ;

                        $requete = "SELECT id_exo, type_exo FROM asso_exo_serie_aleatoire
                                                WHERE id_serie=$this->id_serie
                                                ORDER BY ordre" ;

                        $result = pg_query($requete) ;

                        while($row = pg_fetch_array($result))
                        {
                                // ATTENTION : ne pas oublier de mettre  jour ce constructeur le jour o sera crer la classe Remplir les blancs, et de nouveaux type d'exercice (drag and drop ?)
                                
                                switch($row["type_exo"])
                                {
                                        case 's' :
                                        case 'o' :
                                                $this->sesExercices[] = new Sondage($row["id_exo"]) ;
                                                break ;
                                        case 'q' :
                                        case 'm' :
                                                $this->sesExercices[] = new Qcm($row["id_exo"]) ;
                                                break ;
                                        case 'f' :
                                                // Faire le classe correspondant aux remplir les blancs
                                                // $this->sesExercices[] = new Remplir_blancs($row["id_exo"]) ;
                                                $this->sesExercices[] = false ;
                                                break ;
                                        // Type inconnu > erreur
                                        default :
                                                die("ERREUR BASE DE DONNEES<br>Construction d'une srie ($this->id_serie, $this->titre_serie) : type inconnu \"".$row["type_exo"]."\"<br>") ;
                                                break ;
                                }
                        }
                }
                // constructeur avec des paramtres pour l'affectation des attributs
                else
                {
                        // Faut-il verifier la cohrence des donnes envoyes ?
                        $this->id_serie = $serie ;
                        $this->titre_serie = $titre ;
                        $this->num_theme = $theme ;
                        $this->num_bareme = $le_bareme ;
                        $this->chrono = $le_chrono ;

                        // $this->sesExos = array() ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin Serie()


        /**
        * Fonction qui insre un enregistrement en table
        * On retourne l'identifiant de la ligne cre. Si l'insertion a chou, on retourne 0
        * @return integer : identifiant de l'enregistrement cr
        */
        function insertToDB()
        {
                // echo "Class Serie : insertToDB()<br>Attention : l'ajout des exercices doit tre fait avec la mthode ajoutExercice()<br>" ;

                // On vrifie que les attributs ont bien des valeurs
                if( !empty($this->num_theme) &&  !empty($this->titre_serie) && ( !empty($this->num_bareme)||$this->num_bareme==0))
                {
                       
                        // Verification de l'unicit du titre
                        $requete = "SELECT id FROM serie_exo
                                                WHERE titre = '".addslashes($this->titre_serie)."'" ;
                        $result = pg_query($requete) ;

                        // S'il n'y a aucune srie de mme nom :
                        /*
                        if(pg_num_rows($result)==0)
                        {
                        */
                                // Insertion dans serie_exo
                                $insert = "INSERT INTO serie_exo (titre,theme,chrono,bareme)
                                                        VALUES ('".addslashes($this->titre_serie)."', '$this->num_theme', '$this->chrono', '$this->num_bareme')" ;
                                // echo $insert."<br>" ;
                                $result = pg_query($insert) ;

                                $oid = pg_last_oid($result) ;
                                $result = pg_query("SELECT id FROM serie_exo WHERE oid=$oid");
                                $this->id_serie = pg_result($result,0,0) ;
                                return($this->id_serie) ;
                        /*
                        }
                        else
                        {
                                echo "Srie du mme nom dj existante en base de donnes<br>" ;
                                return false ;
                        }
                        */
                }
                else
                {
                        echo "Problme attributs de srie : <br>Theme = $this->num_theme - Titre = $this->titre_serie - Chrono = $this->chrono - Bareme =$this->num_bareme<br>" ;
                        return false ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin insertToDB()

        /**
        * Fonction qui met  jour l'enregistrement en table
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        */

        function updateToDB()
        {
               // echo "Class Serie : updateToDB()<br>" ;
                if(($this->num_theme) && ($this->titre_serie!="") && (!empty($this->chrono)||$this->chrono==0) && (!empty($this->num_bareme)||$this->num_bareme==0))
                {
                        $insert = "UPDATE serie_exo SET titre='".addslashes($this->titre_serie)."', theme=$this->num_theme, bareme=$this->num_bareme,
                                chrono=$this->chrono
                                WHERE id = $this->id_serie" ;
                        pg_query($insert) ;
                }
                else
                        echo "Problme attributs de srie<br>" ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin updateToDB()


        /**
        * Fonction qui retourne un exercice de la srie
        * @param integer : indice de l'exercice dans le tableau sesExercices (de 0  nbExercices -1). Si on ne met rien, on retourne le tableau entier
        * Enfin, si l'indice est incohrent on retourne faux (pour utilisation dans une boucle while)
        * @return Exercice : Exercice au rang $indice+1
        */
        function getExercice($indice="")
        {
                // Si $indice n'est pas valu alors on retourne le tableau entier
                if(!isset($indice))
                {
                        return $this->sesExercices ;
                }
                // Sinon on analyse la valeur $indice
                else
                {
                        // Est-ce que $indice est cohrent ?
                        if($indice>=0 && $indice < count($this->sesExercices) )
                                return ($this->sesExercices[$indice]) ;
                        else
                                return false ;
                }
        }
        // ------------------------------------------------------------------------------------------------------------------- fin getExercice($indice)

        /**
        * Donne le nombre d'exercices d'un type donn ou non d'une srie
        * Selon le paramtre pass, on donne le nombre d'exercice d'un type prcis. Pour avoir le nombre total d'exercices, on ne passe aucun
        * paramtre.
        * @param char : Type d'exercice  compter (q=qcm, s=sondage, f=filletheblank, etc.). Si ce paramtre est vide, on compte tous les exercices.
        * @return integer : Nombre d'exercices de la srie
        */
        function getNbExercices()
        {
                return count($this->sesExercices) ;
        }

        /**
        * Procdure qui ajoute un exercice  la srie
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : numro de l'exercice  ajouter
        * @param char : type de l'exercice (f = filltheblank, q =qcm, s=sondage, etc.)
        * @param integer : nombre de point de l'exercice
        * @param integer : numro du barme (-1 = aucun barme et 0 = barme individuel)
        * @param integer : numro du chrono (-1 = aucun chrono et 0 = barme chrono)
        * @param string : Commentaire pour la correction de l'exercice
        */

        function ajoutExercice($id_exo, $type_exo, $point=1, $bareme=0, $chrono=0, $commentaire="")
        {
                // echo "Class Serie : ajoutExercice()<br>";
                if($this->id_serie)
                {
                        // Insertion d'un exercice  la srie
                        $result = pg_query("SELECT MAX(ordre) FROM asso_exo_serie WHERE id_serie=$this->id_serie") ;
                        // On determine l'ordre du nouvel exercice
                        $ordre = 1 + pg_result($result,0,0) ;

                        $insert = "INSERT INTO asso_exo_serie (id_serie, id_exo, type_exo, ordre, point, bareme, chrono, commentaire)
                        VALUES ($this->id_serie, $id_exo, '$type_exo', $ordre, $point, $bareme, $chrono, '".addslashes($commentaire)."')" ;

                        //echo $insert ;

                        pg_query($insert) ;

                        // Mise  jour du tableau
                        switch($type_exo)
                        {
                                case 's' :
                                case 'o' :
                                        $this->sesExercices[] = new Sondage($id_exo) ;
                                        break ;
                                case 'q' :
                                case 'm' :
                                        $this->sesExercices[] = new Qcm($id_exo) ;
                                        break ;
                                case 'f' :
                                        // Faire le classe correspondant aux remplir les blancs
                                        // $this->sesExercices[] = new Remplir_blancs($id_exo) ;
                                        $this->sesExercices[] = false ;
                                        break ;
                                // Type inconnu > erreur
                                default :
                                        die("ERREUR BASE DE DONNEES<br>Construction d'une srie ($this->id_serie, $this->titre_serie) : type inconnu \"$type_exo\"<br>") ;
                                        break ;
                        }

                        // echo pg_num_rows(pg_query("select id_exo from asso_exo_serie where id_serie=$this->id_serie")) ;
                }
                else
                        echo "Erreur numro de srie inconnu<br>";
        }
        // ------------------------------------------------------------------------------------------------------------------- fin ajoutExercice($id_exo, $type_exo, ...)

        /**
        * Procdure qui ajoute un exercice  la srie gnre dynamiquement
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : numro de l'exercice  ajouter
        * @param char : type de l'exercice (f = filltheblank, q =qcm, s=sondage, etc.)
        * @param integer : nombre de point de l'exercice
        * @param integer : numro du barme (-1 = aucun barme et 0 = barme individuel)
        * @param integer : numro du chrono (-1 = aucun chrono et 0 = barme chrono)
        * @param string : Commentaire pour la correction de l'exercice
        *@param user : numro du user
        *@param calendrier : numero de la formation
        */

        function ajoutExerciceAleatoire($id_exo, $type_exo, $point=1, $bareme=0, $chrono=0, $commentaire="",$user,$formation)
        {
                // echo "Class Serie : ajoutExercice()<br>";
                if($this->id_serie)
                {
                        // Insertion d'un exercice  la srie
                        $result = pg_query("SELECT MAX(ordre) FROM asso_exo_serie_aleatoire WHERE id_serie=$this->id_serie and num_user=$user and num_cal=$formation") ;
                        // On determine l'ordre du nouvel exercice
                        $ordre = 1 + pg_result($result,0,0) ;

                        $insert = "INSERT INTO asso_exo_serie_aleatoire (id_serie, id_exo, type_exo, ordre, point, bareme, chrono, commentaire,num_user,num_cal)
                        VALUES ($this->id_serie, $id_exo, '$type_exo', $ordre, $point, $bareme, $chrono, '".addslashes($commentaire)."',$user,$formation)" ;

                        //echo $insert ;

                        pg_query($insert) ;

                        // Mise  jour du tableau
                        switch($type_exo)
                        {
                                case 's' :
                                case 'o' :
                                        $this->sesExercices[] = new Sondage($id_exo) ;
                                        break ;
                                case 'q' :
                                case 'm' :
                                        $this->sesExercices[] = new Qcm($id_exo) ;
                                        break ;
                                case 'f' :
                                        // Faire le classe correspondant aux remplir les blancs
                                        // $this->sesExercices[] = new Remplir_blancs($id_exo) ;
                                        $this->sesExercices[] = false ;
                                        break ;
                                // Type inconnu > erreur
                                default :
                                        die("ERREUR BASE DE DONNEES<br>Construction d'une srie ($this->id_serie, $this->titre_serie) : type inconnu \"$type_exo\"<br>") ;
                                        break ;
                        }

                        // echo pg_num_rows(pg_query("select id_exo from asso_exo_serie where id_serie=$this->id_serie")) ;
                }
                else
                        echo "Erreur numro de srie inconnu<br>";
        }
        // ------------------------------------------------------------------------------------------------------------------- fin ajoutExercice($id_exo, $type_exo, ...)


        /**
        * Procdure qui modifie un exercice de la srie (celui est au rang $ordre)
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : numro du nouvel exercice
        * @param char : type du nouvel exercice exercice
        * @param integer : indice de l'exercice dans le tableau sesExercices (de 0  nbExercices - 1)
        * @param integer : nombre de point de l'exercice
        * @param integer : numro du barme (-1 = aucun barme et 0 = barme individuel)
        * @param integer : numro du chrono (-1 = aucun chrono et 0 = barme chrono)
        * @param string : Commentaire pour la correction de l'exercice
        */
        function modifExercice($id_exo, $type_exo, $indice, $point=1, $bareme=0, $chrono=0, $commentaire="")
        {
                if($this->id_serie)
                {
                        $update = "UPDATE asso_exo_serie SET id_exo=$id_exo, type_exo='$type_exo', point=$point,
                        bareme=$bareme, chrono=$chrono, commentaire='".addslashes($commentaire)."'
                        WHERE id_serie=$this->id_serie AND ordre=".($indice+1) ;

                        pg_query($update) ;

                        // Mise  jour du tableau
                        switch($type_exo)
                        {
                                case 's' :
                                case 'o' :
                                        $this->sesExercices[$indice] = new Sondage($id_exo) ;
                                        break ;
                                case 'q' :
                                case 'm' :
                                        $this->sesExercices[$indice] = new Qcm($id_exo) ;
                                        break ;
                                case 'f' :
                                        // Faire le classe correspondant aux remplir les blancs
                                        // $this->sesExercices[$indice] = new Remplir_blancs($id_exo) ;
                                        $this->sesExercices[$indice] = false ;
                                        break ;
                                // Type inconnu > erreur
                                default :
                                        die("ERREUR BASE DE DONNEES<br>Construction d'une srie ($this->id_serie, $this->titre_serie) : type inconnu \"$type_exo\"<br>") ;
                                        break ;
                        }
                }
                else
                        echo "Erreur numro de srie inconnu<br>";
        }
        // ------------------------------------------------------------------------------------------------------------------- fin modifExercice($id_exo, $type_exo, ...)

        // Faire mthode inverseExercice($indice1, $indice2)


          /**
        * Procdure qui retire un exercice de la srie (celui est au rang $ordre)
        * Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        * @param integer : indice de l'exercice dans le tableau sesExercices (de 0  nbExercices - 1)
        */

        function retireExercice($ordre)
        {
            if($this->id_serie && $ordre){

                        // Premiere tape : on rcupere l'identifiant de la question avant de l'effacer
                        $sql="SELECT id_exo FROM asso_exo_serie WHERE id_serie=$this->id_serie AND ordre=$ordre";
                        $result=pg_query($sql);
                        $row=pg_fetch_row($result,0);
                        $id_exo=$row[0];

                        // Deuxieme tape : on efface une association correspondant  l'ordre ds la table asso_exo_serie
                        $sql="DELETE FROM asso_exo_serie WHERE id_serie=$this->id_serie AND ordre=$ordre";
                        $del=pg_query($sql);

                        // Troisieme tape : on efface une association correspondant  l'identifiant de la question test_quest_rep
                        $sql="DELETE FROM test_quest_rep WHERE id_question=$id_exo AND id_test=$this->id_serie";
                        $del=pg_query($sql);

                        // quatrieme tape : on rtabli l'ordre des exercices
                        $sql="UPDATE asso_exo_serie SET ordre=ordre-1 WHERE id_serie=$this->id_serie AND ordre>$ordre";
                        $update=pg_query($sql);
            }
            else
                        echo "Erreur paramtre retireExercice()<br>";
        }

        // ------------------------------------------------------------------------------------------------------------------- fin retireExercice($ordre)


        /**
        *   Fonction qui insere un exercice au rang $ordre
        *   Cette fonction ne peut tre utilise que si l'objet possde un identifiant.
        *   @param integer : Numro de l'exo
        *   @param integer : rang de l'exo
        */
        function insereExercice($id_exo,$type_exo,$ordre,$point=1,$bareme=0,$chrono=0,$commentaire=""){
            if($this->id_serie && $ordre){
                // premire tape : on dcale les exos en augmentant l'ordre de 1
                $sql="update asso_exo_serie set ordre=ordre+1 where id_serie=$this->id_serie and ordre>=$ordre";
                $maj=pg_query($sql);
                // insertion
                $sql="insert into asso_exo_serie(id_serie,id_exo,type_exo,ordre,point,bareme,chrono,commentaire)
                        values($this->id_serie,$id_exo,'$type_exo',$ordre,$point,$bareme,$chrono,'".addslashes($commentaire)."')";
                $ins=pg_query($sql);
                // Mise  jour du tableau
                switch($type_exo){
                    case 's' :
                    case 'o' :
                        $this->sesExercices[]=new Sondage($id_exo);
                    break;
                    case 'q' :
                    case 'm' :
                        $this->sesExercices[]=new Qcm($id_exo);
                    break;
                    case 'f' :
                        $this->sesExercices[]=false;
                    break;
                    default :
                        die("Erreur base de donnes<br>Contruction d'une srie ($this->id_serie,$this->titre_serie) : type inconnu \"$type_exo\"<br>");
                    break;
                }
            }
            else
                echo "Erreur paramtre insereExercice()<br>";

        }


        /**
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet
        *
        * Fonction qui retourne une chane de caractre contenant des informations sur l'objet.
        * Si on ne passe aucun paramtre, la chane retourne contient le nom. Par contre, si le paramtre est dfini,
        * il est utilis comme format de retour. Cet fonction peut servir d'accesseur sur les attributs de la classe.
        * @param string : Chaine de caractre contenant des balises l o il faut remplacer par les valeurs des attributs de l'objet.
        * Balises disponibles : [titre_serie], [id_serie], [num_theme], [num_bareme], [chrono]
        * @return string : On retourne la chane de caractres cre  partir du format
        */

        function toString($format="")
        {
                // Aucun paramtre, on retourne le titre de la srie
                if($format=="")
                        return $this->titre_serie ;

                // Ce tableau contient tous les pattern et les nouvelles valeurs
                $tab_replace = array("\[titre_serie\]"=>"$this->titre_serie","\[id_serie\]"=>"$this->id_serie",
                        "\[num_theme\]"=>"$this->num_theme",
                        "\[num_bareme\]"=>"$this->num_bareme",
                        "\[chrono\]"=>"$this->chrono") ;

                while($tab=each($tab_replace))
                        $format = ereg_replace($tab[0],$tab[1],$format) ;

                return $format ;
        }
        // ------------------------------------------------------------------------------------------------------------------- fin toString($format)

        function getChrono() { return $this->chrono ; }

        /**
        * Fonction qui retourne le nombre total de secondes de la srie (global ou individuel)
        *
        * Cette fonction calcule le nombre total de seconde. Si il n'y a pas de chrono, on retourne 0, si c'est un chrono global, on donne sa valeur
        * et si ce sont des chrono individuels, on calcule leur somme. ATTENTION : cette fonction ne permet pas de savoir  coup sur s'il n'y a pas
        * de chrono et surtout pas si c'est un chrono global ou individuel.
        * @return integer : Nombre total de secondes de la srie (0=pas de chrono ou chrono valu  0)
        */
        function getChronoTotal()
        {
                switch($this->chrono)
                {
                        // Pas de chrono, on retourne 0
                        case -1 :
                                $retour = 0 ;
                                break ;

                        // Chrono individuel, on doit calculer la somme des chrono dans asso_exo_serie
                        case 0 :
                                $requete = "SELECT SUM(chrono) FROM asso_exo_serie WHERE id_serie=$this->id_serie" ;
                                $result = pg_query($requete) ;
                                $retour = pg_result($result,0,0) ;
                                break ;

                        // Chrono global, on retourne la valeur de $this->chrono
                        default :
                                $retour = $this->chrono ;
                                break ;
                }
                return $retour ;
        }

        /**
        *
        * @return integer :
        */
        function getScoreMax()
        {
                echo "score max<br>" ;
                $requete = "SELECT SUM(point) FROM asso_exo_serie WHERE id_serie=$this->id_serie" ;
                $result = pg_query($requete) ;
                $score = pg_result($result,0,0) ;
                echo "Score = $score<br>" ;
                return $score ;
        }

        function getNumBareme() { return $this->num_bareme ; }

        function getNumTheme() { return $this->num_theme ; }

}
?>